/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.QueryUtils;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.FixedLengthPlainDocument;
import com.sas.query.models.Table;
import com.sas.query.visuals.QueryComponentInterface;
import com.sas.workspace.WAdminResource;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class TablePropertyView
extends JPanel
implements QueryComponentInterface {
    protected Table m_table;
    protected JTextField m_nameText;
    protected JTextField m_underlyingTableText;
    private WAdminResource bundle = WAdminResource.getBundle(TablePropertyView.class);

    TablePropertyView(Table table) {
        this.m_table = table;
        this._initialize();
        this._layoutWidgets();
        this._setState();
    }

    public void setTable(Table table) {
        this.doDataExchange(true);
        this.m_table = table;
        this.doDataExchange(false);
        if (this.m_table == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void closing() {
    }

    public boolean validateInput() {
        return true;
    }

    public void doDataExchange(boolean bSaveToModel) {
        if (this.m_table == null) {
            return;
        }
        if (bSaveToModel) {
            String strCorrelationName = this.m_nameText.getText();
            if (strCorrelationName != null) {
                strCorrelationName = strCorrelationName.trim();
            }
            if (strCorrelationName != null && strCorrelationName.length() == 0) {
                strCorrelationName = null;
            }
            if (!QueryUtils.equals((String)strCorrelationName, (String)this.m_table.getCorrelationName())) {
                this.m_table.setCorrelationName(strCorrelationName);
            }
        } else {
            this.m_nameText.setText(this.m_table.getCorrelationName());
            this.m_underlyingTableText.setText(this.m_table.getDataSourceTable().getQualifiedName());
        }
    }

    protected void _initialize() {
        int maxStrLength = this._getSqlProperties().getMaxTableNameLength();
        this.m_nameText = new JTextField();
        this.m_nameText.setDocument((Document)new FixedLengthPlainDocument(maxStrLength));
        this.m_nameText.setColumns(28);
        this.m_underlyingTableText = new JTextField();
        this.m_underlyingTableText.setEditable(false);
        if (this.m_table == null) {
            this.setEnabled(false);
        }
    }

    protected SqlProperties _getSqlProperties() {
        return this.m_table.getSqlProperties();
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        JLabel label = new JLabel(this.bundle.getString("Table.Label.CorrelationName.txt"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 2, 0, 8);
        gridBagLayout.setConstraints(label, gbc);
        this.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_nameText, gbc);
        this.add(this.m_nameText);
        label = new JLabel(this.bundle.getString("Table.Label.UnderlyingTable.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 2, 0, 8);
        gridBagLayout.setConstraints(label, gbc);
        this.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_underlyingTableText, gbc);
        this.add(this.m_underlyingTableText);
        JPanel dummy = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gridBagLayout.setConstraints(dummy, gbc);
        this.add(dummy);
    }

    protected void _setState() {
    }
}

