/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.query.QueryException;
import com.sas.query.wa.SqlPanel;
import com.sas.query.wa.WAQuery;
import com.sas.query.wa.WAdminDataSource;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;

public class SqlSourceTab
extends WAPropertyTab {
    protected WAQuery m_query;
    protected SqlPanel m_sqlPanel;
    private cPanelListener m_PanelListener = new cPanelListener();

    public SqlSourceTab(CMetadata obj) {
        this.setHelpProduct("wdb");
        this.setHelpTopic("sql_tab");
        try {
            WAdminDataSource wads = new WAdminDataSource();
            this.m_query = new WAQuery(wads, obj);
        }
        catch (QueryException e) {
            this.m_query = null;
            Workspace.getDefaultLogger().error((Object)("Error creating sql tab: " + e.getMessage()));
        }
        this.m_sqlPanel = null;
        this.setLayout(new BorderLayout());
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_query.loadSelect();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_sqlPanel == null) {
            this.m_sqlPanel = new SqlPanel(this.m_query);
            this.m_sqlPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add("Center", (Component)((Object)this.m_sqlPanel));
            this.m_sqlPanel.revalidate();
            this.listenForDataChangesTo(this.m_sqlPanel);
        }
        if (this.m_query != null) {
            this.m_query.reloadModelFromMetadata();
        }
        this.m_sqlPanel.firePropertyChanges();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_query != null) {
            this.m_query.saveModelToMetadata(true, true, true, true);
        }
        this.m_sqlPanel.setDataChanged(false);
    }

    public boolean validateData() {
        return this.m_query != null && this.m_query.isValidSql();
    }

    protected void listenForDataChangesTo(SqlPanel pnl) {
        pnl.addPropertyChangeListener("DataChanged", this.m_PanelListener);
    }

    private class cPanelListener
    implements PropertyChangeListener {
        private cPanelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (SqlSourceTab.this.isListeningForChanges()) {
                if (((Boolean)e.getNewValue()).booleanValue()) {
                    SqlSourceTab.this.setDataChanged(true);
                } else {
                    SqlSourceTab.this.setDataChanged(false);
                }
            }
        }
    }
}

