/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionList;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.DataItem;
import com.sas.query.models.DataItemList;
import com.sas.query.models.Expression;
import com.sas.query.models.FixedLengthPlainDocument;
import com.sas.query.models.OrderItem;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.parser.Parser;
import com.sas.query.visuals.CheckBoxPanel;
import com.sas.query.visuals.FormatDialog;
import com.sas.query.visuals.QueryComponentInterface;
import com.sas.query.visuals.SqlTextHelperConstants;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.WindowUtil;
import com.sas.query.wa.SqlTextPanel;
import com.sas.query.wa.SqlTextPanelPlus;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;

public class DataItemPropertyView
extends StandardView
implements QueryComponentInterface,
SqlTextHelperConstants {
    protected boolean m_bSortBy = false;
    protected DataItemList m_parentList;
    protected DataItem m_dataItem;
    protected boolean m_bShowFormats;
    protected boolean m_haveHadAlias = false;
    protected int m_maxAliasNameLen;
    protected JTextField m_nameText;
    protected SqlTextPanel m_expressionText;
    protected JCheckBox m_sortCheckbox;
    protected JComboBox m_sortDirectionChoice;
    protected JComboBox m_sortOrderChoice;
    protected JComboBox m_aggregationChoice;
    protected CheckBoxPanel m_sortCheckBoxPanel;
    protected JLabel m_namelabel;
    protected TitledBorder m_sasTitleBorder;
    protected JLabel m_labelLabel;
    protected JTextField m_labelText;
    protected JLabel m_formatLabel;
    protected JTextField m_formatText;
    protected JButton m_formatButton;
    protected JLabel m_informatLabel;
    protected JTextField m_informatText;
    protected JButton m_informatButton;
    protected String m_strGroupTag;
    protected String m_strDefaultTag;
    protected String m_strAscendingTag;
    protected String m_strDescendingTag;
    private WAdminResource bundle = WAdminResource.getBundle(DataItemPropertyView.class);

    public DataItemPropertyView(Query query, DataItemList parentList, DataItem dataItem) {
        super(query);
        this.m_parentList = parentList;
        this.m_dataItem = dataItem;
        this.m_bShowFormats = this.m_query.getSqlProperties().supportsFormats();
        this._initialize();
        this._layoutWidgets();
        this._setState();
    }

    public void setDataItem(DataItem dataItem) {
        this.doDataExchange(true);
        this.m_dataItem = dataItem;
        this.doDataExchange(false);
        if (this.m_dataItem == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void closing() {
    }

    public boolean validateInput() {
        boolean returnValue = true;
        Expression expression = this.m_expressionText.getExpression();
        int dataType = 0;
        if (this.m_aggregationChoice.getSelectedItem() instanceof Function) {
            dataType = ((Function)this.m_aggregationChoice.getSelectedItem()).getReturnType();
        }
        boolean bFormatCorrect = this.m_formatText == null ? true : expression.isFormatOfCorrectType(this.m_formatText.getText(), dataType);
        boolean bInformatCorrect = this.m_informatText == null ? true : expression.isFormatOfCorrectType(this.m_informatText.getText(), dataType);
        String message = null;
        if (!bFormatCorrect && !bInformatCorrect) {
            message = this.bundle.messageString("DataItemPropView.Message.BadFormats.txt");
        } else if (!bFormatCorrect) {
            message = this.bundle.messageString("DataItemPropView.Message.BadFormat.txt");
        } else if (!bInformatCorrect) {
            message = this.bundle.messageString("DataItemPropView.Message.BadInformat.txt");
        }
        if (message != null) {
            Object[] warningOptions = new Object[]{this.bundle.getString("Standard.ButtonLabel.Continue.txt"), this.bundle.getString("Standard.ButtonLabel.Edit.txt")};
            int nChoice = JOptionPane.showOptionDialog(null, message, this.bundle.messageString("DataItemPropView.Title.BadFormat.txt"), 2, 2, null, warningOptions, warningOptions[0]);
            if (nChoice != 0) {
                returnValue = false;
                if (!bFormatCorrect) {
                    this.m_formatText.requestFocus();
                    this.m_formatText.selectAll();
                } else {
                    this.m_informatText.requestFocus();
                    this.m_informatText.selectAll();
                }
            }
        }
        return returnValue;
    }

    public void setReturnState(boolean bValue) {
    }

    protected void _moveResultItemToDesiredPosition(DataItem item) {
        int desiredPosition = this.m_parentList.getIthPositionForResultItem(item.getResultItem());
        int actualPosition = this.m_query.getPositionForResultItem(item.getResultItem());
        if (actualPosition != desiredPosition) {
            this.m_query.moveResultItem(actualPosition, desiredPosition);
        }
    }

    public void doDataExchange(boolean bSaveToModel) {
        if (this.m_dataItem == null) {
            return;
        }
        if (bSaveToModel) {
            this.m_dataItem.result();
            this._moveResultItemToDesiredPosition(this.m_dataItem);
            this.firePropertyChanges();
            String strAlias = this.m_nameText.getText().trim();
            if (strAlias != null && strAlias.length() == 0) {
                strAlias = null;
            }
            if (strAlias != null) {
                this.m_dataItem.setAlias(strAlias);
            } else if (this.m_dataItem.getAlias() != null) {
                this.m_dataItem.setAlias(null);
            }
            if (this.m_bShowFormats && this.m_dataItem.getResultItem() != null) {
                String strInformat;
                String strFormat;
                String strLabel = QueryUtils.stripAndDouble((String)this.m_labelText.getText(), (char)'\'', (String)"'");
                if (strLabel != null && strLabel.length() == 0) {
                    strLabel = null;
                }
                if (!QueryUtils.equals((String)strLabel, (String)this.m_dataItem.getLabel())) {
                    this.m_dataItem.setLabel(strLabel);
                }
                if ((strFormat = this.m_formatText.getText()) != null && strFormat.length() == 0) {
                    strFormat = null;
                }
                if (!QueryUtils.equals((String)strFormat, (String)this.m_dataItem.getFormat())) {
                    this.m_dataItem.setFormat(strFormat);
                }
                if ((strInformat = this.m_informatText.getText()) != null && strInformat.length() == 0) {
                    strInformat = null;
                }
                if (!QueryUtils.equals((String)strInformat, (String)this.m_dataItem.getInformat())) {
                    this.m_dataItem.setInformat(strInformat);
                }
            }
            this.m_bSortBy = this.m_sortCheckbox.isSelected();
            if (this.m_bSortBy) {
                int newPosition = this.m_sortOrderChoice.getSelectedIndex();
                if (this.m_sortDirectionChoice.getSelectedItem().equals(this.m_strAscendingTag)) {
                    this.m_dataItem.order(1, newPosition);
                } else if (this.m_sortDirectionChoice.getSelectedItem().equals(this.m_strDescendingTag)) {
                    this.m_dataItem.order(2, newPosition);
                } else if (this.m_sortDirectionChoice.getSelectedItem().equals(this.m_strDefaultTag)) {
                    this.m_dataItem.order(0, newPosition);
                }
            } else {
                this.m_dataItem.deleteOrderItem();
            }
            Object selectedObject = this.m_aggregationChoice.getSelectedItem();
            if (selectedObject != this.m_strGroupTag) {
                this.m_dataItem.deleteGroupItem();
                if (selectedObject instanceof Function) {
                    this.m_dataItem.setAggregation((Function)selectedObject);
                } else {
                    this.m_dataItem.deleteAggregation();
                }
            } else {
                this.m_dataItem.deleteAggregation();
                this.m_dataItem.group();
            }
            if (this.m_expressionText.getExpression() != this.m_dataItem.getExpression()) {
                String text = this.m_expressionText.getText();
                String temp = text.toUpperCase().trim();
                if (temp.indexOf("SELECT ") == 0) {
                    text = "(" + text + ")";
                }
                Parser parser = new Parser();
                parser.parseDataItem(this.m_query, this.m_dataItem, text, this.m_query.getMessageHandler());
                Expression exp = this.m_dataItem.getExpression();
                if (exp.isAggregation() || exp.hasAggregation()) {
                    this.m_dataItem.deleteGroupItem();
                    if (exp.hasAggregation() && this.m_aggregationChoice.getSelectedIndex() > 1) {
                        this.m_query.getMessageHandler().addWarning(this.bundle.getString("DataItemPropertyView.noNestingAggregateFunctions.txt"));
                    }
                } else {
                    selectedObject = this.m_aggregationChoice.getSelectedItem();
                    if (selectedObject != this.m_strGroupTag) {
                        this.m_dataItem.deleteGroupItem();
                        if (selectedObject instanceof Function) {
                            this.m_dataItem.setAggregation((Function)selectedObject);
                        } else {
                            this.m_dataItem.deleteAggregation();
                        }
                    }
                }
            }
            if (!this.m_haveHadAlias || this.m_dataItem.getAlias() != null && this.m_dataItem.getAlias().equals(this.m_dataItem.getGeneratedUniqueAlias())) {
                this.m_dataItem.setAlias(this.m_dataItem.generateUniqueAlias());
            }
        } else {
            String aliasText = this.m_dataItem.getAlias();
            if (aliasText == null) {
                aliasText = "";
            }
            this.m_nameText.setText(aliasText);
            if (aliasText.length() > 0) {
                this.m_haveHadAlias = true;
            }
            if (this.m_bShowFormats) {
                String labelText = this.m_dataItem.getLabel();
                if (labelText != null) {
                    labelText = QueryUtils.unDoubleQuotes((String)labelText, (char)'\'');
                }
                this.m_labelText.setText(labelText);
                this.m_formatText.setText(this.m_dataItem.getFormat());
                this.m_informatText.setText(this.m_dataItem.getInformat());
            }
            this.m_expressionText.setExpression(this.m_dataItem.getExpression());
            this.m_sortCheckbox.setSelected(this.m_bSortBy);
            OrderItem orderItem = this.m_dataItem.getOrderItem();
            if (orderItem != null) {
                if (orderItem.getSortingDirection() == 1) {
                    this.m_sortDirectionChoice.setSelectedItem(this.m_strAscendingTag);
                } else if (orderItem.getSortingDirection() == 2) {
                    this.m_sortDirectionChoice.setSelectedItem(this.m_strDescendingTag);
                } else if (orderItem.getSortingDirection() == 0) {
                    this.m_sortDirectionChoice.setSelectedItem(this.m_strDefaultTag);
                }
                this.m_sortOrderChoice.setSelectedIndex(this.m_query.getPositionForOrderItem(orderItem));
            }
            if (this.m_dataItem.isAggregation()) {
                this.m_aggregationChoice.setSelectedItem(this.m_dataItem.getAggregation());
                this.m_expressionText.setExpression(this.m_dataItem.getExpression().deleteAggregation());
            } else if (this.m_dataItem.getGroupItem() != null) {
                this.m_aggregationChoice.setSelectedItem(this.m_strGroupTag);
            }
        }
    }

    protected void _initialize() {
        int maxStrLength;
        String[] m_priorityNames = new String[]{this.bundle.getString("Common.First.txt"), this.bundle.getString("Common.Second.txt"), this.bundle.getString("Common.Third.txt"), this.bundle.getString("Common.Fourth.txt"), this.bundle.getString("Common.Fifth.txt"), this.bundle.getString("Common.Sixth.txt"), this.bundle.getString("Common.Seventh.txt"), this.bundle.getString("Common.Eight.txt"), this.bundle.getString("Common.Ninth.txt"), this.bundle.getString("Common.Tenth.txt"), this.bundle.getString("Common.Eleventh.txt"), this.bundle.getString("Common.Twelfth.txt"), this.bundle.getString("Common.Thirteenth.txt"), this.bundle.getString("Common.Fourteenth.txt"), this.bundle.getString("Common.Fifteenth.txt"), this.bundle.getString("Common.Sixteenth.txt")};
        this.m_strGroupTag = this.bundle.getString("Common.groupinBrackets.txt");
        this.m_strDefaultTag = this.bundle.getString("Common.defaultinBrackets.txt");
        this.m_strAscendingTag = this.bundle.getString("Common.Ascending.txt");
        this.m_strDescendingTag = this.bundle.getString("Common.Descending.txt");
        this.m_bSortBy = this.m_dataItem != null && this.m_dataItem.getOrderItem() != null;
        this.m_maxAliasNameLen = maxStrLength = this._getSqlProperties().getMaxColumnNameLength();
        this.m_nameText = new JTextField();
        this.m_nameText.setDocument((Document)new FixedLengthPlainDocument(maxStrLength));
        this.m_nameText.setColumns(22);
        if (this.m_bShowFormats) {
            this.m_labelText = new JTextField();
            this.m_labelText.setColumns(22);
            this.m_formatText = new JTextField();
            this.m_formatText.setColumns(22);
            this.m_informatText = new JTextField();
            this.m_informatText.setColumns(22);
            ImageIcon dotIcon = this.bundle.getImageIcon("dotsIconFile.image");
            this.m_formatButton = new JButton(dotIcon);
            this.m_formatButton.setMargin(new Insets(0, 0, 0, 0));
            this.m_formatButton.setFocusPainted(false);
            this.m_formatButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    FormatDialog formatDialog = new FormatDialog(DataItemPropertyView.this.m_query, WindowUtil.getParentFrame((Component)((Object)DataItemPropertyView.this)), true, 1, DataItemPropertyView.this.m_dataItem.getExpression().getDataType());
                    formatDialog.setFormat(DataItemPropertyView.this.m_formatText.getText());
                    formatDialog.setModal(true);
                    formatDialog.pack();
                    formatDialog.setSize(500, 260);
                    WindowUtil.center((Window)formatDialog);
                    formatDialog.setVisible(true);
                    if (formatDialog.getReturnValue() == 1) {
                        DataItemPropertyView.this.m_formatText.setText(formatDialog.getFormat());
                    }
                }
            });
            this.m_informatButton = new JButton(dotIcon);
            this.m_informatButton.setMargin(new Insets(0, 0, 0, 0));
            this.m_informatButton.setFocusPainted(false);
            this.m_informatButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    FormatDialog formatDialog = new FormatDialog(DataItemPropertyView.this.m_query, WindowUtil.getParentFrame((Component)((Object)DataItemPropertyView.this)), true, 2, DataItemPropertyView.this.m_dataItem.getExpression().getDataType());
                    formatDialog.setFormat(DataItemPropertyView.this.m_informatText.getText());
                    formatDialog.setModal(true);
                    formatDialog.pack();
                    formatDialog.setSize(500, 260);
                    WindowUtil.center((Window)formatDialog);
                    formatDialog.setVisible(true);
                    if (formatDialog.getReturnValue() == 1) {
                        DataItemPropertyView.this.m_informatText.setText(formatDialog.getFormat());
                    }
                }
            });
            this.m_labelLabel = new JLabel(this.bundle.getString("DataItem.Label.Label.txt"));
            this.m_formatLabel = new JLabel(this.bundle.getString("DataItem.Label.Format.txt"));
            this.m_informatLabel = new JLabel(this.bundle.getString("DataItem.Label.Informat.txt"));
        }
        this.m_expressionText = new SqlTextPanelPlus(2);
        this.m_expressionText.setBehavior(1024);
        this.m_expressionText.getHelper().addPropertyChangeListener((PropertyChangeListener)new HelperListener());
        this.m_expressionText.setQuery(this.m_query);
        this.m_expressionText.setBehavior(16);
        this.m_sortCheckBoxPanel = new CheckBoxPanel(this.bundle.getString("DataItem.Label.OrderBy.txt"), this.m_bSortBy);
        this.m_sortCheckbox = this.m_sortCheckBoxPanel.getCheckBox();
        this.m_sortCheckbox.addItemListener(new SortHandler());
        this.m_sortDirectionChoice = new JComboBox();
        this.m_sortDirectionChoice.addItem(this.m_strDefaultTag);
        this.m_sortDirectionChoice.addItem(this.m_strAscendingTag);
        this.m_sortDirectionChoice.addItem(this.m_strDescendingTag);
        this.m_sortOrderChoice = new JComboBox();
        int orderCount = this.m_query.getOrderItemCount();
        if (orderCount == this.m_query.getResultItemCount()) {
            --orderCount;
        } else if (this.m_bSortBy) {
            --orderCount;
        }
        for (int index = 0; index <= orderCount; ++index) {
            if (index > m_priorityNames.length - 1) {
                this.m_sortOrderChoice.addItem(index + "");
                continue;
            }
            this.m_sortOrderChoice.addItem(m_priorityNames[index]);
        }
        FunctionList functionList = this.m_query.getDataSourceFunctions();
        functionList = functionList.getSubsetByFunctionType(1);
        if (this.m_dataItem != null && this.m_dataItem.getExpression().getDataType() != 32768) {
            FunctionList countstar = functionList.getSubsetByName("COUNT*");
            Function funCountStar = null;
            if (countstar.size() > 0) {
                funCountStar = countstar.elementAt(0);
            }
            functionList = functionList.getSubsetByPrimaryParmType(this.m_dataItem.getExpression().getDataType());
            if (funCountStar != null && this.m_dataItem.getExpression().getDataType() != 0) {
                functionList.addElement(funCountStar);
            }
            functionList.sortByName();
        }
        this.m_aggregationChoice = new JComboBox();
        this.m_aggregationChoice.addItem(" ");
        this.m_aggregationChoice.addItem(this.m_strGroupTag);
        for (int index = 0; index < functionList.size(); ++index) {
            this.m_aggregationChoice.addItem(functionList.elementAt(index));
        }
        this.m_aggregationChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedObject = DataItemPropertyView.this.m_aggregationChoice.getSelectedItem();
                if (selectedObject instanceof Function) {
                    if (((Function)selectedObject).getName().equalsIgnoreCase("COUNT*")) {
                        DataItemPropertyView.this.m_expressionText.setExpression((Expression)new UnparsedExpression(""));
                        DataItemPropertyView.this.m_expressionText.setText("");
                        DataItemPropertyView.this.m_expressionText.setEnabled(false);
                    } else {
                        DataItemPropertyView.this.m_expressionText.setEnabled(true);
                    }
                }
            }
        });
    }

    protected SqlProperties _getSqlProperties() {
        return this.m_query.getSqlProperties();
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        this.m_namelabel = new JLabel(this.bundle.getString("DataItem.Label.Name.txt"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 4, 0, 0);
        gridBagLayout.setConstraints(this.m_namelabel, gbc);
        this.add(this.m_namelabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 8, 0, 0);
        gridBagLayout.setConstraints(this.m_nameText, gbc);
        this.add(this.m_nameText);
        if (this.m_bShowFormats) {
            JPanel sasPanel = new JPanel();
            this.m_sasTitleBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.bundle.getString("DataItem.Label.SASAttributes.txt"));
            CompoundBorder border = BorderFactory.createCompoundBorder(this.m_sasTitleBorder, BorderFactory.createEmptyBorder(0, 8, 8, 8));
            sasPanel.setBorder(border);
            GridBagLayout panelLayout = new GridBagLayout();
            sasPanel.setLayout(panelLayout);
            int sasPanelY = 0;
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = sasPanelY;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(8, 0, 0, 0);
            panelLayout.setConstraints(this.m_labelLabel, gbc);
            sasPanel.add(this.m_labelLabel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = sasPanelY++;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(6, 24, 0, 0);
            panelLayout.setConstraints(this.m_labelText, gbc);
            sasPanel.add(this.m_labelText);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = sasPanelY;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(8, 0, 0, 0);
            panelLayout.setConstraints(this.m_formatLabel, gbc);
            sasPanel.add(this.m_formatLabel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = sasPanelY;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(6, 24, 0, 0);
            panelLayout.setConstraints(this.m_formatText, gbc);
            sasPanel.add(this.m_formatText);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = sasPanelY++;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = new Insets(6, 8, 0, 0);
            panelLayout.setConstraints(this.m_formatButton, gbc);
            sasPanel.add(this.m_formatButton);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = sasPanelY;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(8, 0, 0, 0);
            panelLayout.setConstraints(this.m_informatLabel, gbc);
            sasPanel.add(this.m_informatLabel);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = sasPanelY;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(6, 24, 0, 0);
            panelLayout.setConstraints(this.m_informatText, gbc);
            sasPanel.add(this.m_informatText);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = sasPanelY++;
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.insets = new Insets(6, 8, 0, 0);
            panelLayout.setConstraints(this.m_informatButton, gbc);
            sasPanel.add(this.m_informatButton);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(6, 2, 0, 0);
            gridBagLayout.setConstraints(sasPanel, gbc);
            this.add(sasPanel);
        }
        JLabel label = new JLabel(this.bundle.getString("DataItem.Label.Aggregation.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 4, 0, 0);
        gridBagLayout.setConstraints(label, gbc);
        this.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(6, 8, 0, 0);
        gridBagLayout.setConstraints(this.m_aggregationChoice, gbc);
        this.add(this.m_aggregationChoice);
        JPanel borderPanel = new JPanel();
        TitledBorder titleBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.bundle.getString("DataItem.Label.Expression.txt"));
        CompoundBorder border = BorderFactory.createCompoundBorder(titleBorder, BorderFactory.createEmptyBorder(8, 8, 8, 8));
        borderPanel.setBorder(border);
        borderPanel.setLayout(new BorderLayout(12, 10));
        borderPanel.add("Center", this.m_expressionText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 2, 0, 0);
        gridBagLayout.setConstraints(borderPanel, gbc);
        this.add(borderPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 2, 0);
        gridBagLayout.setConstraints((Component)this.m_sortCheckBoxPanel, gbc);
        this.add((Component)this.m_sortCheckBoxPanel);
        borderPanel = this.m_sortCheckBoxPanel.getInteriorPanel();
        border = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 8, 8, 8));
        this.m_sortCheckBoxPanel.setBorder((Border)border);
        GridBagLayout sortLayout = new GridBagLayout();
        borderPanel.setLayout(sortLayout);
        label = new JLabel(this.bundle.getString("DataItem.Label.Direction.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(6, 0, 0, 0);
        sortLayout.setConstraints(label, gbc);
        borderPanel.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 8, 0, 0);
        sortLayout.setConstraints(this.m_sortDirectionChoice, gbc);
        borderPanel.add(this.m_sortDirectionChoice);
        label = new JLabel(this.bundle.getString("DataItem.Label.Priority.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(6, 0, 2, 0);
        sortLayout.setConstraints(label, gbc);
        borderPanel.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(6, 8, 6, 0);
        sortLayout.setConstraints(this.m_sortOrderChoice, gbc);
        borderPanel.add(this.m_sortOrderChoice);
    }

    protected void _setState() {
        if (this.m_bShowFormats) {
            this.m_labelLabel.setEnabled(true);
            this.m_labelText.setEnabled(true);
            this.m_formatLabel.setEnabled(true);
            this.m_formatText.setEnabled(true);
            this.m_formatButton.setEnabled(true);
            this.m_informatLabel.setEnabled(true);
            this.m_informatText.setEnabled(true);
            this.m_informatButton.setEnabled(true);
        }
    }

    protected class HelperListener
    implements PropertyChangeListener {
        protected HelperListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("HelperExpressionChanged")) {
                // empty if block
            }
        }
    }

    class SortHandler
    implements ItemListener {
        SortHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            DataItemPropertyView.this.m_bSortBy = DataItemPropertyView.this.m_sortCheckbox.isSelected();
            DataItemPropertyView.this.doLayout();
            DataItemPropertyView.this._setState();
        }
    }
}

