/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.wa;

import com.sas.query.Query;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionList;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.ColumnList;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.DataItem;
import com.sas.query.models.DataItemList;
import com.sas.query.models.Expression;
import com.sas.query.models.GroupItem;
import com.sas.query.models.GroupItemList;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.OrderItem;
import com.sas.query.models.OrderItemList;
import com.sas.query.models.PropertyChangeConstants;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.models.Table;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.visuals.ButtonBar;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.PopMenuItem;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.QueryComponentInterface;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.WindowUtil;
import com.sas.query.wa.DataItemPropertyView;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DataItemListView
extends StandardView
implements Runnable {
    private WAdminResource bundle = WAdminResource.getBundle(DataItemListView.class);
    protected DataItemList m_dataItems;
    protected boolean m_bSettingValue = false;
    protected JTable m_tableView;
    protected DataItemTableModel m_tableModel;
    protected JScrollPane m_scrollpane;
    protected JButton m_insertButton;
    protected JButton m_editButton;
    protected JButton m_deleteButton;
    protected JButton m_moveUpButton;
    protected JButton m_moveDownButton;
    protected JComboBox m_sortPriorityChoice = null;
    protected JComboBox m_sortDirectionChoice = null;
    protected ImageIcon m_ascendingIcon;
    protected ImageIcon m_descendingIcon;
    protected ImageIcon m_blankIcon;
    protected String[] m_labels;
    protected int[] m_minSize;
    protected String[] m_priorityNames;
    protected int COL_IN_RESULTS = 0;
    protected int COL_AGGREGATE = 1;
    protected int COL_DATA_ITEM = 2;
    protected int COL_SORT_DIRECTION = 3;
    protected int COL_SORT_PRIORITY = 4;
    protected static final long NO_OPTIONS = 0L;
    protected static final long NO_EDIT_BUTTON = 1L;
    protected static final long NO_INSERT_BUTTON = 2L;
    protected static final long NO_DELETE_BUTTON = 4L;
    protected static final long NO_MOVEMENT_BUTTONS = 8L;
    protected static final long NO_AGGREGATE_COLUMN = 16L;
    protected static final long NO_IN_RESULTS_COLUMN = 32L;
    protected long m_optionFlags = 0L;

    public DataItemListView(Query query) {
        this(query, 0L);
    }

    public DataItemList getCurrentDataItems() {
        return this.m_dataItems;
    }

    public DataItemListView(Query query, long optionFlags) {
        super(query);
        JScrollPane bbarScrollPane;
        this.m_optionFlags = optionFlags;
        this.m_dataItems = new DataItemList();
        this.m_priorityNames = new String[16];
        this.m_priorityNames[0] = this.bundle.getString("Common.First.txt");
        this.m_priorityNames[1] = this.bundle.getString("Common.Second.txt");
        this.m_priorityNames[2] = this.bundle.getString("Common.Third.txt");
        this.m_priorityNames[3] = this.bundle.getString("Common.Fourth.txt");
        this.m_priorityNames[4] = this.bundle.getString("Common.Fifth.txt");
        this.m_priorityNames[5] = this.bundle.getString("Common.Sixth.txt");
        this.m_priorityNames[6] = this.bundle.getString("Common.Seventh.txt");
        this.m_priorityNames[7] = this.bundle.getString("Common.Eight.txt");
        this.m_priorityNames[8] = this.bundle.getString("Common.Ninth.txt");
        this.m_priorityNames[9] = this.bundle.getString("Common.Tenth.txt");
        this.m_priorityNames[10] = this.bundle.getString("Common.Eleventh.txt");
        this.m_priorityNames[11] = this.bundle.getString("Common.Twelfth.txt");
        this.m_priorityNames[12] = this.bundle.getString("Common.Thirteenth.txt");
        this.m_priorityNames[13] = this.bundle.getString("Common.Fourteenth.txt");
        this.m_priorityNames[14] = this.bundle.getString("Common.Fifteenth.txt");
        this.m_priorityNames[15] = this.bundle.getString("Common.Sixteenth.txt");
        if (query.getPrimaryQuery() == null) {
            if ((this.m_optionFlags & 0x10L) == 0L && (this.m_optionFlags & 0x20L) == 0L) {
                this.m_labels = new String[]{"", "", "", "", ""};
                this.m_labels[2] = this.bundle.getString("DataItemListView.Header.Name.txt");
                this.m_labels[4] = this.bundle.getString("DataItemListView.Header.SortPriority.txt");
                this.m_minSize = new int[]{25, 115, 20, 34, 80};
            } else if ((this.m_optionFlags & 0x20L) != 0L) {
                this.m_labels = new String[]{"", "", "", ""};
                this.m_labels[1] = this.bundle.getString("DataItemListView.Header.Name.txt");
                this.m_labels[3] = this.bundle.getString("DataItemListView.Header.SortPriority.txt");
                this.m_minSize = new int[]{115, 20, 34, 80};
                this.COL_IN_RESULTS = -1;
                this.COL_AGGREGATE = 0;
                this.COL_DATA_ITEM = 1;
                this.COL_SORT_DIRECTION = 2;
                this.COL_SORT_PRIORITY = 3;
            } else {
                this.m_labels = new String[]{"", "", "", ""};
                this.m_labels[1] = this.bundle.getString("DataItemListView.Header.Name.txt");
                this.m_labels[3] = this.bundle.getString("DataItemListView.Header.SortPriority.txt");
                this.m_minSize = new int[]{25, 20, 34, 80};
                this.COL_AGGREGATE = -1;
                this.COL_DATA_ITEM = 1;
                this.COL_SORT_DIRECTION = 2;
                this.COL_SORT_PRIORITY = 3;
            }
        } else if ((this.m_optionFlags & 0x10L) == 0L) {
            this.m_labels = new String[]{"", "", ""};
            this.m_labels[2] = this.bundle.getString("DataItemListView.Header.Name.txt");
            this.m_minSize = new int[]{20, 115, 20};
            this.COL_SORT_DIRECTION = -1;
            this.COL_SORT_PRIORITY = -1;
        } else {
            this.m_labels = new String[]{"", ""};
            this.m_labels[1] = this.bundle.getString("DataItemListView.Header.Name.txt");
            this.m_minSize = new int[]{20, 100};
            this.COL_AGGREGATE = -1;
            this.COL_DATA_ITEM = 1;
            this.COL_SORT_DIRECTION = -1;
            this.COL_SORT_PRIORITY = -1;
        }
        this.m_tableModel = new DataItemTableModel(query);
        this.m_tableView = new JTable(this.m_tableModel){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                try {
                    super.valueChanged(e);
                    DataItemListView.this._setState();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                return DataItemListView.this.generateToolTipText(e);
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.m_tableView);
        ((DataItemTableModel)this.m_tableView.getModel()).refresh();
        this.m_tableView.setSelectionMode(0);
        MouseInputAdapter mouseListener = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selectedRow = DataItemListView.this.m_tableView.rowAtPoint(e.getPoint());
                if (e.getClickCount() == 1) {
                    if ((e.getModifiers() & 4) != 0) {
                        if (selectedRow != -1) {
                            DataItemListView.this.m_tableView.setRowSelectionInterval(selectedRow, selectedRow);
                            DataItemListView.this.displayPopmenu(e);
                        } else {
                            DataItemListView.this.displayPopmenuInsertOnly(e);
                        }
                    }
                }
            }
        };
        this.m_tableView.addMouseListener(mouseListener);
        query.addPropertyListener((ModelChangeListener)this, 324);
        for (int index = 0; index < this.m_minSize.length; ++index) {
            this.m_tableView.getColumnModel().getColumn(index).setMinWidth(this.m_minSize[index]);
            this.m_tableView.getColumnModel().getColumn(index).setPreferredWidth(this.m_minSize[index]);
            if (index != this.COL_IN_RESULTS && index != this.COL_SORT_DIRECTION) continue;
            this.m_tableView.getColumnModel().getColumn(index).setMaxWidth(this.m_minSize[index]);
        }
        this.m_tableView.setAutoResizeMode(0);
        TableCellEditor editor = this.m_tableView.getColumnModel().getColumn(this.COL_DATA_ITEM).getCellEditor();
        if (editor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(0);
        }
        if (this.COL_IN_RESULTS != -1 && (editor = this.m_tableView.getColumnModel().getColumn(this.COL_IN_RESULTS).getCellEditor()) instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(1);
        }
        if (this.COL_AGGREGATE != -1) {
            this.m_tableView.getColumnModel().getColumn(this.COL_AGGREGATE).setCellEditor(new AggregateCellEditor());
            JLabel aggLabel = new JLabel(this.bundle.getImageIcon("aggregateIconFile.image"));
            aggLabel.setOpaque(true);
            aggLabel.setBorder(BorderFactory.createBevelBorder(0));
            aggLabel.setToolTipText(this.bundle.getString("DataItemListView.Tip.Aggregate.txt"));
            this.m_tableView.getColumnModel().getColumn(this.COL_AGGREGATE).setHeaderRenderer(new JComponentCellRenderer());
            this.m_tableView.getColumnModel().getColumn(this.COL_AGGREGATE).setHeaderValue(aggLabel);
            this.m_tableView.getTableHeader().revalidate();
        }
        if (this.COL_IN_RESULTS != -1) {
            JLabel resultsLabel = new JLabel(this.bundle.getImageIcon("dataSetIconFile.image"));
            resultsLabel.setOpaque(true);
            resultsLabel.setBorder(BorderFactory.createBevelBorder(0));
            resultsLabel.setToolTipText(this.bundle.getString("DataItemListView.Tip.Results.txt"));
            this.m_tableView.getColumnModel().getColumn(this.COL_IN_RESULTS).setHeaderRenderer(new JComponentCellRenderer());
            this.m_tableView.getColumnModel().getColumn(this.COL_IN_RESULTS).setHeaderValue(resultsLabel);
            this.m_tableView.getTableHeader().revalidate();
        }
        if (this.COL_SORT_DIRECTION != -1) {
            JLabel sortDirLabel = new JLabel(this.bundle.getImageIcon("sortHeaderIconFile.image"));
            sortDirLabel.setOpaque(true);
            sortDirLabel.setBorder(BorderFactory.createBevelBorder(0));
            sortDirLabel.setToolTipText(this.bundle.getString("DataItemListView.Tip.Direction.txt"));
            this.m_tableView.getColumnModel().getColumn(this.COL_SORT_DIRECTION).setHeaderRenderer(new JComponentCellRenderer());
            this.m_tableView.getColumnModel().getColumn(this.COL_SORT_DIRECTION).setHeaderValue(sortDirLabel);
            this.m_tableView.getTableHeader().revalidate();
        }
        if (this.COL_SORT_PRIORITY != -1) {
            JLabel sortPriorityLabel = new JLabel(this.m_labels[this.COL_SORT_PRIORITY], 0);
            sortPriorityLabel.setOpaque(true);
            sortPriorityLabel.setBorder(BorderFactory.createBevelBorder(0));
            sortPriorityLabel.setToolTipText(this.bundle.getString("DataItemListView.Tip.SortOrder.txt"));
            this.m_tableView.getColumnModel().getColumn(this.COL_SORT_PRIORITY).setHeaderRenderer(new JComponentCellRenderer());
            this.m_tableView.getColumnModel().getColumn(this.COL_SORT_PRIORITY).setHeaderValue(sortPriorityLabel);
            this.m_tableView.getTableHeader().revalidate();
        }
        if (this.COL_DATA_ITEM != -1) {
            JLabel dataItemLabel = new JLabel(this.m_labels[this.COL_DATA_ITEM], 0);
            dataItemLabel.setOpaque(true);
            dataItemLabel.setBorder(BorderFactory.createBevelBorder(0));
            dataItemLabel.setToolTipText(this.bundle.getString("DataItemListView.Tip.Name.txt"));
            this.m_tableView.getColumnModel().getColumn(this.COL_DATA_ITEM).setHeaderRenderer(new JComponentCellRenderer());
            this.m_tableView.getColumnModel().getColumn(this.COL_DATA_ITEM).setHeaderValue(dataItemLabel);
            this.m_tableView.getTableHeader().revalidate();
        }
        this.m_sortDirectionChoice = new JComboBox();
        this.m_sortDirectionChoice.setBackground(SystemColor.window);
        this.m_blankIcon = this.bundle.getImageIcon("blankIconFile.image");
        this.m_ascendingIcon = this.bundle.getImageIcon("ascendingIconFile.image");
        this.m_descendingIcon = this.bundle.getImageIcon("descendingIconFile.image");
        this.m_sortDirectionChoice.addItem(this.m_blankIcon);
        this.m_sortDirectionChoice.addItem(this.m_ascendingIcon);
        this.m_sortDirectionChoice.addItem(this.m_descendingIcon);
        if (this.COL_SORT_DIRECTION != -1) {
            this.m_tableView.getColumnModel().getColumn(this.COL_SORT_DIRECTION).setCellEditor(new DefaultCellEditor(this.m_sortDirectionChoice));
        }
        this.m_sortPriorityChoice = new JComboBox();
        if (this.COL_SORT_PRIORITY != -1) {
            this.m_tableView.getColumnModel().getColumn(this.COL_SORT_PRIORITY).setCellEditor(new PriorityCellEditor(this.m_sortPriorityChoice));
        }
        this.m_scrollpane = new JScrollPane(this.m_tableView){

            @Override
            public void reshape(int x, int y, int w, int h) {
                super.reshape(x, y, w, h);
                DataItemListView.this.snapColumnsToSize();
            }

            @Override
            public void setSize(Dimension d) {
                super.setSize(d);
                DataItemListView.this.snapColumnsToSize();
            }

            @Override
            public void setSize(int x, int y) {
                super.setSize(x, y);
                DataItemListView.this.snapColumnsToSize();
            }
        };
        this.m_scrollpane.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    if ((e.getModifiers() & 4) != 0) {
                        DataItemListView.this.displayPopmenuInsertOnly(e);
                    }
                }
            }
        });
        this.m_scrollpane.getVerticalScrollBar().addComponentListener(new VertScrollBarListener());
        if ((this.m_optionFlags & 2L) == 0L) {
            this.m_insertButton = new JButton(this.bundle.getString("Standard.ButtonLabel.Insert....txt"));
            this.m_insertButton.addActionListener(new InsertButtonHandler());
            this.m_insertButton.setToolTipText(this.bundle.getString("DataItemListView.Tip.Insert.txt"));
        }
        if ((this.m_optionFlags & 1L) == 0L) {
            this.m_editButton = new JButton(this.bundle.getString("Standard.ButtonLabel.Edit....txt"));
            this.m_editButton.addActionListener(new EditButtonHandler());
            this.m_editButton.setToolTipText(this.bundle.getString("DataItemListView.Tip.Edit.txt"));
        }
        if ((this.m_optionFlags & 4L) == 0L) {
            this.m_deleteButton = new JButton(this.bundle.getString("Standard.ButtonLabel.Delete.txt"));
            this.m_deleteButton.addActionListener(new DeleteButtonHandler());
            this.m_deleteButton.setToolTipText(this.bundle.getString("DataItemListView.Tip.Delete.txt"));
        }
        if ((this.m_optionFlags & 8L) == 0L) {
            this.m_moveUpButton = new JButton(this.bundle.getString("Standard.ButtonLabel.MoveUp.txt"));
            this.m_moveUpButton.setMargin(new Insets(2, 2, 2, 2));
            this.m_moveUpButton.addActionListener(new MoveButtonHandler("Up"));
            this.m_moveUpButton.setToolTipText(this.bundle.getString("DataItemListView.Tip.MoveUp.txt"));
            this.m_moveDownButton = new JButton(this.bundle.getString("Standard.ButtonLabel.MoveDown.txt"));
            this.m_moveDownButton.setMargin(new Insets(2, 2, 2, 2));
            this.m_moveDownButton.addActionListener(new MoveButtonHandler("Down"));
            this.m_moveDownButton.setToolTipText(this.bundle.getString("DataItemListView.Tip.MoveDown.txt"));
        }
        Vector<Serializable> buttons = new Vector<Serializable>();
        if (this.m_insertButton != null) {
            buttons.addElement(this.m_insertButton);
            buttons.addElement(new Integer(6));
        }
        if (this.m_editButton != null) {
            buttons.addElement(this.m_editButton);
            buttons.addElement(new Integer(6));
        }
        if (this.m_deleteButton != null) {
            buttons.addElement(this.m_deleteButton);
            buttons.addElement(new Integer(6));
        }
        buttons.addElement(new Integer(12));
        if (this.m_moveUpButton != null) {
            buttons.addElement(this.m_moveUpButton);
            buttons.addElement(new Integer(6));
            buttons.addElement(this.m_moveDownButton);
            buttons.addElement(new Integer(6));
        }
        if ((this.m_optionFlags & 8L) != 0L) {
            ButtonBar bbar = new ButtonBar(3, buttons, new Insets(0, 4, 0, 4), true);
            bbarScrollPane = new JScrollPane((Component)bbar, 21, 31);
            bbarScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        } else {
            ButtonBar bbar = new ButtonBar(3, buttons, new Insets(0, 10, 0, 20), true);
            bbarScrollPane = new JScrollPane((Component)bbar, 20, 31);
            bbarScrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        this.setLayout(new BorderLayout());
        this.add(this.m_scrollpane);
        this.add(bbarScrollPane, "East");
        try {
            this.m_tableView.setRowSelectionInterval(0, 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._setState();
        this.setMinimumSize(new Dimension(0, 0));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow), BorderFactory.createEmptyBorder(12, 12, 12, 6)));
        this.m_query.enableHelpKey((Component)((Object)this), "Panel.DataItemListView");
    }

    public JButton getEditButton() {
        return this.m_editButton;
    }

    public JButton getInsertButton() {
        return this.m_insertButton;
    }

    public JButton getDeleteButton() {
        return this.m_deleteButton;
    }

    private String generateToolTipText(MouseEvent e) {
        int row = this.m_tableView.rowAtPoint(e.getPoint());
        int col = this.m_tableView.columnAtPoint(e.getPoint());
        if (row >= this.m_dataItems.size()) {
            return null;
        }
        col = this.m_tableView.convertColumnIndexToModel(col);
        DataItem item = this.m_dataItems.elementAt(row);
        Object cell = this.m_tableView.getValueAt(row, col);
        if (cell == null) {
            return null;
        }
        if (col == this.COL_AGGREGATE) {
            if (item.getAggregation() != null) {
                return item.getAggregation().getFunctionDescription();
            }
            if (item.getGroupItem() != null) {
                return this.bundle.getString("DataItemListView.Tip.Group.txt");
            }
            return null;
        }
        if (col == this.COL_IN_RESULTS) {
            if (!((Boolean)cell).booleanValue()) {
                return this.bundle.getString("DataItemListView.Tip.notInResultSet.txt");
            }
            return this.bundle.getString("DataItemListView.Tip.isInResultSet.txt");
        }
        if (col == this.COL_DATA_ITEM) {
            Expression exp = item.getExpression();
            if (exp instanceof ColumnExpression) {
                ColumnExpression colExp = (ColumnExpression)exp;
                String colLabel = colExp.getColumn().getLabel();
                if (colLabel != null && colLabel != colExp.getColumn().getName()) {
                    return colLabel;
                }
                return this.bundle.messageString("DataItemListView.TipColInTable.fmt.txt", (Object)colExp.getColumn().getName(), (Object)colExp.getColumn().getParent().getName());
            }
            if (exp instanceof CompoundExpression && item.isAggregation()) {
                CompoundExpression compExp = (CompoundExpression)exp;
                if (compExp.getCurrentFunction().getPrimaryParameterIndex() >= 0) {
                    Expression insides = compExp.getParameter(compExp.getCurrentFunction().getPrimaryParameterIndex());
                    if (insides instanceof ColumnExpression) {
                        ColumnExpression aggedCol = (ColumnExpression)insides;
                        String aggColLabel = aggedCol.getColumn().getLabel();
                        if (aggColLabel != null && aggColLabel != aggedCol.getColumn().getName()) {
                            return this.bundle.messageString("DataItemListView.TipFunctionAppliedTo.fmt.txt", (Object)compExp.getCurrentFunction().getName(), (Object)aggColLabel);
                        }
                        return this.bundle.messageString("DataItemListView.TipFunctionAppliedToColInParent.fmt.txt", (Object)compExp.getCurrentFunction().getName(), (Object)aggedCol.getColumn().getName(), (Object)aggedCol.getColumn().getParent().getName());
                    }
                    return null;
                }
                return null;
            }
            return exp.toString();
        }
        if (col == this.COL_SORT_DIRECTION) {
            if (item.getOrderItem() == null) {
                return this.bundle.getString("DataItemListView.Tip.SortNone.txt");
            }
            if (item.getOrderItem().getSortingDirection() == 1) {
                return this.bundle.getString("DataItemListView.Tip.SortAsc.txt");
            }
            if (item.getOrderItem().getSortingDirection() == 2) {
                return this.bundle.getString("DataItemListView.Tip.SortDesc.txt");
            }
            if (item.getOrderItem().getSortingDirection() == 0) {
                return this.bundle.getString("DataItemListView.Tip.SortAsc.txt");
            }
            return null;
        }
        if (col == this.COL_SORT_PRIORITY) {
            if (item.getOrderItem() == null) {
                return null;
            }
            int index = this.m_query.getPositionForOrderItem(item.getOrderItem());
            if (index == 0) {
                return this.bundle.getString("DataItemListView.Tip.SortPriorityFirst.txt");
            }
            if (index == 1) {
                return this.bundle.getString("DataItemListView.Tip.SortPrioritySecond.txt");
            }
            if (index == 2) {
                return this.bundle.getString("DataItemListView.Tip.SortPriorityThird.txt");
            }
            return this.bundle.getString("DataItemListView.Tip.SortPriority.txt");
        }
        return null;
    }

    @Override
    public void run() {
        this.snapColumnsToSize();
    }

    private void cancelEdits() {
        if (this.m_tableView.isEditing()) {
            this.m_tableView.editingCanceled(new ChangeEvent(this.m_tableView));
        }
    }

    private void snapColumnsToSize() {
        int spaceForViewport;
        JScrollBar vertScrollBar;
        AbstractBorder outerB;
        int alreadyTaken = 0;
        for (int index = 0; index < this.m_minSize.length; ++index) {
            alreadyTaken += this.m_tableView.getColumnModel().getColumn(index).getWidth();
            alreadyTaken += this.m_tableView.getIntercellSpacing().width;
        }
        Dimension d = this.m_scrollpane.getSize();
        int borderEats = 0;
        AbstractBorder innerB = (AbstractBorder)this.m_scrollpane.getViewportBorder();
        if (innerB != null) {
            borderEats += innerB.getBorderInsets((Component)this.m_scrollpane.getViewport()).left + innerB.getBorderInsets((Component)this.m_scrollpane.getViewport()).right;
        }
        if ((outerB = (AbstractBorder)this.m_scrollpane.getBorder()) != null) {
            borderEats += outerB.getBorderInsets((Component)this.m_scrollpane).left + outerB.getBorderInsets((Component)this.m_scrollpane).right;
        }
        if ((vertScrollBar = this.m_scrollpane.getVerticalScrollBar()) != null && vertScrollBar.isVisible()) {
            borderEats += vertScrollBar.getWidth();
        }
        if (alreadyTaken < (spaceForViewport = d.width - borderEats)) {
            int dataItemWidth = this.m_tableView.getColumnModel().getColumn(this.COL_DATA_ITEM).getWidth();
            this.m_tableView.getColumnModel().getColumn(this.COL_DATA_ITEM).setPreferredWidth(dataItemWidth + (spaceForViewport - alreadyTaken));
        } else {
            int dataItemWidth = this.m_tableView.getColumnModel().getColumn(this.COL_DATA_ITEM).getWidth();
            int possibleShrinkage = dataItemWidth - this.m_minSize[this.COL_DATA_ITEM];
            if (possibleShrinkage >= alreadyTaken - spaceForViewport) {
                this.m_tableView.getColumnModel().getColumn(this.COL_DATA_ITEM).setPreferredWidth(dataItemWidth -= alreadyTaken - spaceForViewport);
            }
        }
        this.m_tableView.revalidate();
        this.m_scrollpane.repaint();
    }

    public void closing() {
        this.m_query.removePropertyListener((ModelChangeListener)this);
    }

    public void modelChangeCallback(ModelChangeEvent event) {
        ((DataItemTableModel)this.m_tableView.getModel()).refresh();
        if (event.isStructureChange()) {
            this._setState();
        }
    }

    public void onInsert() {
        this.busyOn();
        int curRow = this.m_tableView.getSelectedRow();
        try {
            UnparsedExpression expression = new UnparsedExpression(this.bundle.getString("Common.uninitializedinBrackets.txt"));
            this.cancelEdits();
            DataItem item = null;
            item = this.m_tableModel.addNewItem((Expression)expression, 0);
            if (this.m_query.hasAggregatedRI()) {
                item.setGroupItem(new GroupItem(this.m_query, (Expression)expression));
            }
            if (this.failureHasOccurred()) {
                return;
            }
            DataItemPropertyView propertyPanel = new DataItemPropertyView(this.m_query, this.m_dataItems, item);
            QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame((Component)((Object)this)), this.m_query, (QueryComponentInterface)propertyPanel, "DataItem.Title.txt");
            editDialog.setModal(true);
            editDialog.pack();
            WindowUtil.centerOverWindow((Window)editDialog, (Component)((Object)this));
            editDialog.setVisible(true);
            if (editDialog.getReturnValue() == 2) {
                this.m_tableModel.removeItem(item);
                this.endQueryChange();
            } else if (item.isAggregation()) {
                this.m_tableModel._autoGroup();
            }
            propertyPanel.closing();
        }
        catch (Throwable t) {
            this.busyOff();
            this.m_query.getMessageHandler().addInternalError(t);
        }
        this.busyOff();
        TableModelEvent event = new TableModelEvent(this.m_tableModel);
        this.m_tableModel.fireTableChanged(event);
        this._setState();
        this.firePropertyChanges();
        if (curRow > -1) {
            this.m_tableView.setRowSelectionInterval(curRow, curRow);
        }
    }

    public void onEdit() {
        this.busyOn();
        int curRow = this.m_tableView.getSelectedRow();
        DataItemPropertyView propertyPanel = null;
        try {
            DataItem item = this.getSelectedItem();
            boolean bStartedAsAggregate = item.isAggregation();
            this.cancelEdits();
            propertyPanel = new DataItemPropertyView(this.m_query, this.m_dataItems, item);
            QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame((Component)((Object)this)), this.m_query, (QueryComponentInterface)propertyPanel, "DataItem.Title.txt");
            editDialog.setModal(true);
            editDialog.pack();
            WindowUtil.centerOverWindow((Window)editDialog, (Component)((Object)this));
            editDialog.setVisible(true);
            if (editDialog.getReturnValue() == 1 && !bStartedAsAggregate && item.isAggregation()) {
                this.m_tableModel._autoGroup();
            }
        }
        catch (Throwable t) {
            this.busyOff();
            this.m_query.getMessageHandler().addInternalError(t);
        }
        this.busyOff();
        TableModelEvent event = new TableModelEvent(this.m_tableModel);
        this.m_tableModel.fireTableChanged(event);
        if (propertyPanel != null) {
            propertyPanel.closing();
        }
        this._setState();
        this.firePropertyChanges();
        MessageUtil.displayMessages((MessageHandler)this.m_query.getMessageHandler());
        this.m_tableView.setRowSelectionInterval(curRow, curRow);
    }

    public void onDelete() {
        this.busyOn();
        int curRow = this.m_tableView.getSelectedRow();
        try {
            this.cancelEdits();
            DataItem item = this.getSelectedItem();
            if (item != null) {
                item.deleteFromQuery();
                this.m_tableModel.removeRow(this.m_tableView.getSelectedRow());
            }
            this._setState();
        }
        catch (Throwable t) {
            this.busyOff();
            this.m_query.getMessageHandler().addInternalError(t);
        }
        this.busyOff();
        this.firePropertyChanges();
        if (this.m_tableView.getModel().getRowCount() > 0) {
            if (this.m_tableView.getModel().getRowCount() <= curRow && this.m_tableView.getModel().getRowCount() > 0) {
                this.m_tableView.setRowSelectionInterval(curRow - 1, curRow - 1);
            } else {
                this.m_tableView.setRowSelectionInterval(curRow, curRow);
            }
        }
    }

    public void onMoveFirst() {
        int index = this.m_tableView.getSelectedRow();
        int rowToMakeVisible = 0;
        this.cancelEdits();
        this.m_tableModel.moveRowToFirst(index);
        rowToMakeVisible = 0;
        this.firePropertyChanges();
        this.m_tableView.setRowSelectionInterval(0, 0);
        this.m_tableView.scrollRectToVisible(this.m_tableView.getCellRect(rowToMakeVisible, this.COL_DATA_ITEM, true));
    }

    public void onMoveLast() {
        int index = this.m_tableView.getSelectedRow();
        int rowToMakeVisible = 0;
        int numRI = this.m_tableModel.getRowCount();
        this.cancelEdits();
        this.m_tableModel.moveRowToLast(index);
        rowToMakeVisible = numRI - 1;
        this.firePropertyChanges();
        this.m_tableView.setRowSelectionInterval(numRI - 1, numRI - 1);
        this.m_tableView.scrollRectToVisible(this.m_tableView.getCellRect(rowToMakeVisible, this.COL_DATA_ITEM, true));
    }

    public void valueChanged(ListSelectionEvent e) {
        this._setState();
    }

    protected void _setState() {
        boolean bCanMoveDown;
        boolean bCanMoveUp;
        int nSelected = this.m_tableView.getSelectedRow();
        if (nSelected == -1 && this.m_tableView.getRowCount() > 0) {
            this.m_tableView.setRowSelectionInterval(0, 0);
            nSelected = this.m_tableView.getSelectedRow();
        }
        if (this.m_tableView.getRowCount() == 0 || nSelected > this.m_tableView.getRowCount() - 1) {
            nSelected = -1;
        }
        int cDataItems = this.m_dataItems.size();
        if (nSelected == -1) {
            bCanMoveUp = false;
            bCanMoveDown = false;
        } else if (nSelected == 0) {
            bCanMoveUp = false;
            bCanMoveDown = cDataItems > 1;
        } else {
            bCanMoveUp = true;
            boolean bl = bCanMoveDown = nSelected + 1 < cDataItems;
        }
        if (this.m_moveUpButton != null) {
            this.m_moveUpButton.setEnabled(bCanMoveUp);
        }
        if (this.m_moveDownButton != null) {
            this.m_moveDownButton.setEnabled(bCanMoveDown);
        }
        if (nSelected == -1) {
            if (this.m_editButton != null) {
                this.m_editButton.setEnabled(false);
            }
            if (this.m_deleteButton != null) {
                this.m_deleteButton.setEnabled(false);
            }
        } else {
            if (this.m_editButton != null) {
                this.m_editButton.setEnabled(true);
            }
            if (this.m_deleteButton != null) {
                this.m_deleteButton.setEnabled(true);
            }
        }
    }

    protected void displayPopmenuInsertOnly(MouseEvent event) {
        JPopupMenu popmenu = null;
        this.cancelEdits();
        popmenu = new JPopupMenu();
        popmenu.add((JMenuItem)new PopMenuItem(this.bundle.getString("Standard.ButtonLabel.Insert....txt"), "onInsert", (Object)this));
        if (popmenu.getSubElements().length != 0) {
            JComponent source = (JComponent)event.getSource();
            source.add(popmenu);
            popmenu.show(source, event.getX(), event.getY());
        }
    }

    protected void displayPopmenu(MouseEvent event) {
        JPopupMenu popmenu = null;
        this.cancelEdits();
        popmenu = new JPopupMenu();
        popmenu.add((JMenuItem)new PopMenuItem(this.bundle.getString("Standard.ButtonLabel.Insert....txt"), "onInsert", (Object)this));
        popmenu.add((JMenuItem)new PopMenuItem(this.bundle.getString("Standard.ButtonLabel.Edit....txt"), "onEdit", (Object)this));
        popmenu.add((JMenuItem)new PopMenuItem(this.bundle.getString("Standard.ButtonLabel.Delete.txt"), "onDelete", (Object)this));
        popmenu.addSeparator();
        popmenu.add((JMenuItem)new PopMenuItem(this.bundle.getString("Standard.ButtonLabel.MoveFirst.txt"), "onMoveFirst", (Object)this));
        popmenu.add((JMenuItem)new PopMenuItem(this.bundle.getString("Standard.ButtonLabel.MoveLast.txt"), "onMoveLast", (Object)this));
        if (popmenu.getSubElements().length != 0) {
            JComponent source = (JComponent)event.getSource();
            source.add(popmenu);
            popmenu.show(source, event.getX(), event.getY());
        }
    }

    protected DataItem getSelectedItem() {
        DataItem item = null;
        int index = this.m_tableView.getSelectedRow();
        if (this.m_dataItems.size() < index + 1) {
            return item;
        }
        if (index != -1) {
            item = this.m_dataItems.elementAt(index);
        }
        return item;
    }

    protected void _refillPriorityChoice(int row) {
        block9: {
            int orderCount;
            int currentListLength;
            block8: {
                if (this.m_sortPriorityChoice == null) {
                    return;
                }
                currentListLength = this.m_sortPriorityChoice.getItemCount();
                if (currentListLength == 0) {
                    this.m_sortPriorityChoice.addItem(this.bundle.getString("Common.noSortinBrackets.txt"));
                    currentListLength = 1;
                }
                orderCount = this.m_query.getOrderItemCount();
                DataItem selectedItem = this.m_dataItems.elementAt(row);
                if (selectedItem != null) {
                    OrderItem me = selectedItem.getOrderItem();
                    if (me == null) {
                        ++orderCount;
                    }
                } else {
                    ++orderCount;
                }
                if (++orderCount <= currentListLength) break block8;
                for (int index = currentListLength; index < orderCount; ++index) {
                    if (index > this.m_priorityNames.length - 1) {
                        this.m_sortPriorityChoice.addItem(index + "");
                        continue;
                    }
                    this.m_sortPriorityChoice.addItem(this.m_priorityNames[index - 1]);
                }
                break block9;
            }
            if (orderCount >= currentListLength) break block9;
            for (int index = currentListLength - 1; index > orderCount - 1; --index) {
                this.m_sortPriorityChoice.removeItemAt(index);
            }
        }
    }

    protected class JComponentCellRenderer
    implements TableCellRenderer {
        protected JComponentCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JComponent)value;
        }
    }

    protected class VertScrollBarListener
    implements ComponentListener {
        protected VertScrollBarListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            DataItemListView.this.snapColumnsToSize();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            DataItemListView.this.snapColumnsToSize();
        }
    }

    protected class MoveButtonHandler
    implements ActionListener {
        String m_strAction;

        MoveButtonHandler(String action) {
            this.m_strAction = action;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.m_strAction.equals("First")) {
                DataItemListView.this.onMoveFirst();
                return;
            }
            if (this.m_strAction.equals("Last")) {
                DataItemListView.this.onMoveLast();
                return;
            }
            int index = DataItemListView.this.m_tableView.getSelectedRow();
            int rowToMakeVisible = 0;
            int numRI = DataItemListView.this.m_tableModel.getRowCount();
            int curRow = index;
            DataItemListView.this.cancelEdits();
            if (this.m_strAction.equals("Up")) {
                DataItemListView.this.m_tableModel.moveRowUp(index);
                curRow = index - 1;
                rowToMakeVisible = index - 1;
                if (rowToMakeVisible > 0) {
                    --rowToMakeVisible;
                }
            } else if (this.m_strAction.equals("Down")) {
                DataItemListView.this.m_tableModel.moveRowDown(index);
                curRow = index + 1;
                rowToMakeVisible = index + 1;
                if (rowToMakeVisible < numRI - 1) {
                    ++rowToMakeVisible;
                }
            }
            DataItemListView.this.firePropertyChanges();
            DataItemListView.this.m_tableView.setRowSelectionInterval(curRow, curRow);
            DataItemListView.this.m_tableView.scrollRectToVisible(DataItemListView.this.m_tableView.getCellRect(rowToMakeVisible, DataItemListView.this.COL_DATA_ITEM, true));
        }
    }

    protected class DeleteButtonHandler
    implements ActionListener {
        DeleteButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int curRow = DataItemListView.this.m_tableView.getSelectedRow();
            DataItemListView.this.onDelete();
            DataItemListView.this._setState();
            DataItemListView.this.firePropertyChanges();
            if (DataItemListView.this.m_tableView.getModel().getRowCount() <= curRow && DataItemListView.this.m_tableView.getModel().getRowCount() > 0) {
                DataItemListView.this.m_tableView.setRowSelectionInterval(curRow - 1, curRow - 1);
            }
        }
    }

    protected class EditButtonHandler
    implements ActionListener {
        EditButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DataItemListView.this.onEdit();
            DataItemListView.this.firePropertyChanges();
        }
    }

    protected class InsertButtonHandler
    implements ActionListener {
        InsertButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DataItemListView.this.onInsert();
            DataItemListView.this.firePropertyChanges();
        }
    }

    class PriorityCellEditor
    extends DefaultCellEditor {
        PriorityCellEditor() {
            super(new JComboBox());
        }

        public PriorityCellEditor(JComboBox x) {
            super(x);
            this.setClickCountToStart(1);
        }

        @Override
        public int getClickCountToStart() {
            return 1;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox comboBox = (JComboBox)this.getComponent();
            comboBox.setMaximumRowCount(5);
            if (comboBox != null) {
                DataItemListView.this._refillPriorityChoice(row);
            }
            String currentValue = (String)table.getValueAt(row, column);
            boolean setComboValue = false;
            for (int i = 0; i < DataItemListView.this.m_sortPriorityChoice.getModel().getSize(); ++i) {
                if (!DataItemListView.this.m_sortPriorityChoice.getModel().getElementAt(i).toString().equals(currentValue)) continue;
                comboBox.setSelectedIndex(i);
                setComboValue = true;
                break;
            }
            if (!setComboValue && DataItemListView.this.m_sortPriorityChoice.getModel().getSize() > 0) {
                comboBox.setSelectedIndex(0);
            }
            return comboBox;
        }
    }

    protected class AggregateCellEditor
    extends DefaultCellEditor {
        AggregateCellEditor() {
            super(new JComboBox());
        }

        protected AggregateCellEditor(JComboBox x) {
            super(x);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            DataItem item = DataItemListView.this.m_dataItems.elementAt(row);
            JComboBox comboBox = (JComboBox)this.getComponent();
            if (comboBox != null) {
                comboBox.setMaximumRowCount(5);
                if (comboBox.getItemCount() > 0) {
                    comboBox.removeAllItems();
                }
                WindowUtil.fixupJComboBox((JComboBox)comboBox);
                FunctionList functionList = DataItemListView.this.m_query.getDataSourceFunctions();
                functionList = functionList.getSubsetByFunctionType(1);
                if (item.getExpression().getDataType() != 32768) {
                    functionList = functionList.getSubsetByPrimaryParmType(item.getExpression().getDataType());
                }
                comboBox.addItem(" ");
                comboBox.addItem(DataItemListView.this.bundle.getString("Common.groupinBrackets.txt"));
                for (int index = 0; index < functionList.size(); ++index) {
                    comboBox.addItem(functionList.elementAt(index));
                }
                comboBox.addActionListener(new ComboHandler(item));
            }
            if (value.toString().trim().length() == 0 || value.equals(DataItemListView.this.bundle.getString("Common.groupinBrackets.txt"))) {
                comboBox.setSelectedItem(value);
            } else {
                comboBox.setSelectedItem(item.getAggregation());
            }
            return comboBox;
        }

        protected class ComboHandler
        implements ActionListener {
            DataItem m_item;

            ComboHandler(DataItem item) {
                this.m_item = item;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        }
    }

    private class DataItemTableModel
    extends AbstractTableModel
    implements PropertyChangeConstants,
    ModelChangeListener {
        private DataItemTableModel(Query query) {
            DataItemListView.this.m_query.addPropertyListener((ModelChangeListener)this, 8, 2);
        }

        private void moveRowUp(int rowIndex) {
            DataItem item = DataItemListView.this.m_dataItems.elementAt(rowIndex);
            DataItemListView.this.m_dataItems.removeElementAt(rowIndex);
            DataItemListView.this.m_dataItems.insertElementAt(item, rowIndex - 1);
            this._moveResultItemToDesiredPosition(item);
        }

        private void moveRowDown(int rowIndex) {
            DataItem item = DataItemListView.this.m_dataItems.elementAt(rowIndex);
            DataItemListView.this.m_dataItems.removeElementAt(rowIndex);
            DataItemListView.this.m_dataItems.insertElementAt(item, rowIndex + 1);
            this._moveResultItemToDesiredPosition(item);
        }

        private void moveRowToFirst(int rowIndex) {
            DataItem item = DataItemListView.this.m_dataItems.elementAt(rowIndex);
            DataItemListView.this.m_dataItems.removeElementAt(rowIndex);
            DataItemListView.this.m_dataItems.insertElementAt(item, 0);
            this._moveResultItemToDesiredPosition(item);
        }

        private void moveRowToLast(int rowIndex) {
            DataItem item = DataItemListView.this.m_dataItems.elementAt(rowIndex);
            DataItemListView.this.m_dataItems.removeElementAt(rowIndex);
            DataItemListView.this.m_dataItems.addElement(item);
            this._moveResultItemToDesiredPosition(item);
        }

        private void removeRow(int rowIndex) {
            DataItemListView.this.m_dataItems.removeElementAt(rowIndex);
            TableModelEvent event = new TableModelEvent(this);
            this.fireTableChanged(event);
        }

        protected DataItem addNewItem(Expression expression) {
            return this.addNewItem(expression, DataItemListView.this.m_dataItems.size());
        }

        private DataItem addNewItem(Expression expression, int index) {
            DataItem returnValue = new DataItem(DataItemListView.this.m_query, expression);
            DataItemListView.this.m_dataItems.insertElementAt(returnValue, index);
            TableModelEvent event = new TableModelEvent(this);
            this.fireTableChanged(event);
            return returnValue;
        }

        private void removeItem(DataItem item) {
            for (int index = 0; index < DataItemListView.this.m_dataItems.size(); ++index) {
                if (DataItemListView.this.m_dataItems.elementAt(index) != item) continue;
                DataItemListView.this.m_dataItems.removeElementAt(index);
                break;
            }
            TableModelEvent event = new TableModelEvent(this);
            this.fireTableChanged(event);
        }

        @Override
        public int getColumnCount() {
            return DataItemListView.this.m_labels.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return DataItemListView.this.m_labels[columnIndex];
        }

        public Class getColumnClass(int c) {
            if (this.getValueAt(0, c) != null) {
                return this.getValueAt(0, c).getClass();
            }
            return super.getColumnClass(c);
        }

        @Override
        public int getRowCount() {
            return DataItemListView.this.m_dataItems.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= DataItemListView.this.m_dataItems.size()) {
                return null;
            }
            DataItem item = DataItemListView.this.m_dataItems.elementAt(row);
            if (col == DataItemListView.this.COL_IN_RESULTS) {
                String expr = item.getExpression().getDisplayString().trim();
                return new Boolean(expr.length() > 0);
            }
            if (col == DataItemListView.this.COL_AGGREGATE) {
                if (item.getExpression().isAggregation()) {
                    return item.getAggregation().getFunctionName();
                }
                if (item.getGroupItem() != null) {
                    return DataItemListView.this.bundle.getString("Common.groupinBrackets.txt");
                }
                return "";
            }
            if (col == DataItemListView.this.COL_DATA_ITEM) {
                return item.getDisplayString();
            }
            if (col == DataItemListView.this.COL_SORT_DIRECTION) {
                OrderItem orderItem = item.getOrderItem();
                if (orderItem != null) {
                    if (orderItem.getSortingDirection() == 0) {
                        return DataItemListView.this.m_ascendingIcon;
                    }
                    if (orderItem.getSortingDirection() == 1) {
                        return DataItemListView.this.m_ascendingIcon;
                    }
                    if (orderItem.getSortingDirection() == 2) {
                        return DataItemListView.this.m_descendingIcon;
                    }
                }
                return DataItemListView.this.m_blankIcon;
            }
            if (col == DataItemListView.this.COL_SORT_PRIORITY) {
                OrderItem orderItem = item.getOrderItem();
                if (orderItem == null) {
                    return "";
                }
                int index = DataItemListView.this.m_query.getPositionForOrderItem(orderItem);
                if (index > DataItemListView.this.m_priorityNames.length - 1) {
                    return index + 1 + "";
                }
                return DataItemListView.this.m_priorityNames[index];
            }
            return DataItemListView.this.bundle.getString("Common.nullinBrackets.txt");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (row >= DataItemListView.this.m_dataItems.size()) {
                return false;
            }
            boolean bEditable = true;
            if (col == DataItemListView.this.COL_IN_RESULTS) {
                bEditable = false;
            }
            return bEditable;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (DataItemListView.this.m_bSettingValue) {
                return;
            }
            DataItemListView.this.m_bSettingValue = true;
            if (row >= DataItemListView.this.m_dataItems.size()) {
                return;
            }
            DataItem item = DataItemListView.this.m_dataItems.elementAt(row);
            if (col == DataItemListView.this.COL_IN_RESULTS) {
                boolean inResults = (Boolean)value;
                if (item.getResultItem() != null && !inResults) {
                    item.deleteResultItem();
                } else if (inResults) {
                    item.result();
                    this._moveResultItemToDesiredPosition(item);
                }
                item.setAlias(item.generateUniqueAlias());
            } else if (col == DataItemListView.this.COL_AGGREGATE) {
                String groupstring = DataItemListView.this.bundle.getString("Common.groupinBrackets.txt");
                if (!value.equals(groupstring)) {
                    item.deleteGroupItem();
                    if (value instanceof Function) {
                        item.setAggregation((Function)value);
                        this._autoGroup();
                    } else {
                        item.deleteAggregation();
                    }
                } else {
                    item.deleteAggregation();
                    item.group();
                }
                item.setAlias(item.generateUniqueAlias());
                boolean bFormatCorrect = item.getExpression().isFormatOfCorrectType(item.getFormat(), 0);
                boolean bInformatCorrect = item.getExpression().isFormatOfCorrectType(item.getInformat(), 0);
                if (!bFormatCorrect) {
                    item.setFormat(null);
                }
                if (!bInformatCorrect) {
                    item.setInformat(null);
                }
            } else if (col == DataItemListView.this.COL_DATA_ITEM) {
                String tmpAlias;
                if (value != null && value instanceof String && (value = ((String)value).trim()) != null && ((String)value).length() == 0) {
                    value = null;
                }
                if ((tmpAlias = item.getAlias()) == null) {
                    tmpAlias = item.getDisplayString();
                }
                if (!tmpAlias.equals(value)) {
                    item.setAlias((String)value);
                }
            } else if (col == DataItemListView.this.COL_SORT_DIRECTION) {
                if (value.equals(DataItemListView.this.m_ascendingIcon)) {
                    item.order(1, -1);
                } else if (value.equals(DataItemListView.this.m_descendingIcon)) {
                    item.order(2, -1);
                } else {
                    item.deleteOrderItem();
                }
                item.setAlias(item.generateUniqueAlias());
            } else if (col == DataItemListView.this.COL_SORT_PRIORITY) {
                int sortPriorityIndex = -1;
                for (int index = 0; index < DataItemListView.this.m_priorityNames.length; ++index) {
                    if (!DataItemListView.this.m_priorityNames[index].equals(value)) continue;
                    sortPriorityIndex = index;
                    break;
                }
                if (sortPriorityIndex == -1) {
                    try {
                        int tmp = Integer.parseInt(value.toString());
                        sortPriorityIndex = tmp - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (sortPriorityIndex == -1) {
                    if (value != null) {
                        item.deleteOrderItem();
                    }
                } else {
                    item.order(-1, sortPriorityIndex);
                }
                item.setAlias(item.generateUniqueAlias());
            }
            DataItemListView.this.m_bSettingValue = false;
            DataItemListView.this.displayMessages();
            this.fireTableCellUpdated(row, col);
            DataItemListView.this.firePropertyChanges();
            DataItemListView.this.m_query.isValidSql();
            DataItemListView.this.displayMessages();
        }

        protected void _autoGroup() {
            int index;
            GroupItemList groupList = DataItemListView.this.m_query.getGroupItems();
            int cAggregateColumns = 0;
            int size = DataItemListView.this.m_dataItems.size();
            for (index = 0; index < size && cAggregateColumns < 2; ++index) {
                if (!DataItemListView.this.m_dataItems.elementAt(index).isAggregation()) continue;
                ++cAggregateColumns;
            }
            if (cAggregateColumns < 2 && groupList.size() == 0) {
                size = DataItemListView.this.m_dataItems.size();
                for (index = 0; index < size; ++index) {
                    if (DataItemListView.this.m_dataItems.elementAt(index).isAggregation()) continue;
                    DataItem item = DataItemListView.this.m_dataItems.elementAt(index);
                    item.group();
                    item.setAlias(item.generateUniqueAlias());
                }
            }
        }

        protected void _moveDataItemToDesiredPosition(DataItem item) {
            int desiredPosition = DataItemListView.this.m_dataItems.getIthPositionForResultItem(item.getResultItem());
            int actualPosition = DataItemListView.this.m_query.getPositionForResultItem(item.getResultItem());
            if (actualPosition != desiredPosition) {
                if (desiredPosition < actualPosition) {
                    DataItemListView.this.m_dataItems.insertElementAt(item, desiredPosition);
                    DataItemListView.this.m_dataItems.removeElementAt(actualPosition + 1);
                } else if (actualPosition < desiredPosition) {
                    DataItemListView.this.m_dataItems.removeElementAt(actualPosition);
                    DataItemListView.this.m_dataItems.insertElementAt(item, desiredPosition);
                }
            }
        }

        protected void _moveResultItemToDesiredPosition(DataItem item) {
            int desiredPosition = DataItemListView.this.m_dataItems.getIthPositionForResultItem(item.getResultItem());
            int actualPosition = DataItemListView.this.m_query.getPositionForResultItem(item.getResultItem());
            if (actualPosition != desiredPosition) {
                DataItemListView.this.m_query.moveResultItem(actualPosition, desiredPosition);
            }
        }

        public void refresh() {
            DataItem dataItem;
            int dataIndex;
            boolean itemAdded;
            int index;
            OrderItem item;
            ResultItemList resultItems = DataItemListView.this.m_query.getResultItems();
            OrderItemList orderItems = DataItemListView.this.m_query.getOrderItems();
            GroupItemList groupItems = DataItemListView.this.m_query.getGroupItems();
            for (int dataIndex2 = 0; dataIndex2 < DataItemListView.this.m_dataItems.size(); ++dataIndex2) {
                DataItem dataItem2 = DataItemListView.this.m_dataItems.elementAt(dataIndex2);
                if (dataItem2.getResultItem() != null && DataItemListView.this.m_query.getPositionForResultItem(dataItem2.getResultItem()) < 0) {
                    dataItem2.setResultItem(null);
                }
                if (dataItem2.getOrderItem() != null && DataItemListView.this.m_query.getPositionForOrderItem(dataItem2.getOrderItem()) < 0) {
                    dataItem2.setOrderItem(null);
                }
                if (dataItem2.getGroupItem() == null || DataItemListView.this.m_query.getPositionForGroupItem(dataItem2.getGroupItem()) >= 0) continue;
                dataItem2.setGroupItem(null);
            }
            boolean bFinishedMovingItems = false;
            while (!bFinishedMovingItems) {
                bFinishedMovingItems = true;
                for (int index2 = 0; index2 < resultItems.size(); ++index2) {
                    int actualPosition;
                    item = resultItems.elementAt(index2);
                    int desiredPosition = this._getPositionForIthResultItem(index2);
                    if (desiredPosition == (actualPosition = this._getPositionForResultItem((ResultItem)item)) && actualPosition != -1) continue;
                    if (actualPosition != -1) {
                        this._moveDataItemToDesiredPosition(DataItemListView.this.m_dataItems.elementAt(desiredPosition));
                        continue;
                    }
                    if (desiredPosition != -1) {
                        DataItemListView.this.m_dataItems.insertElementAt(new DataItem(DataItemListView.this.m_query, (ResultItem)item), desiredPosition);
                        continue;
                    }
                    DataItemListView.this.m_dataItems.addElement(new DataItem(DataItemListView.this.m_query, (ResultItem)item));
                }
            }
            for (index = 0; index < orderItems.size(); ++index) {
                item = orderItems.elementAt(index);
                itemAdded = false;
                for (dataIndex = 0; dataIndex < DataItemListView.this.m_dataItems.size(); ++dataIndex) {
                    dataItem = DataItemListView.this.m_dataItems.elementAt(dataIndex);
                    if (item.equals(dataItem.getOrderItem())) {
                        itemAdded = true;
                        break;
                    }
                    if (item.getResultItem() == null || dataItem.getResultItem() != item.getResultItem()) continue;
                    dataItem.setOrderItem(item);
                    itemAdded = true;
                    break;
                }
                if (itemAdded) continue;
                DataItemListView.this.m_dataItems.addElement(new DataItem(DataItemListView.this.m_query, item));
            }
            for (index = 0; index < groupItems.size(); ++index) {
                item = groupItems.elementAt(index);
                itemAdded = false;
                for (dataIndex = 0; dataIndex < DataItemListView.this.m_dataItems.size(); ++dataIndex) {
                    dataItem = DataItemListView.this.m_dataItems.elementAt(dataIndex);
                    if (item.equals(dataItem.getGroupItem())) {
                        itemAdded = true;
                        break;
                    }
                    if (item.getResultItem() == null || dataItem.getResultItem() != item.getResultItem()) continue;
                    dataItem.setGroupItem((GroupItem)item);
                    itemAdded = true;
                    break;
                }
                if (itemAdded) continue;
                DataItemListView.this.m_dataItems.addElement(new DataItem(DataItemListView.this.m_query, (GroupItem)item));
            }
            TableModelEvent event = new TableModelEvent(this);
            this.fireTableChanged(event);
            DataItemListView.this.firePropertyChanges();
        }

        protected int _getPositionForResultItem(ResultItem itemToFind) {
            for (int dataIndex = 0; dataIndex < DataItemListView.this.m_dataItems.size(); ++dataIndex) {
                DataItem dataItem = DataItemListView.this.m_dataItems.elementAt(dataIndex);
                if (dataItem.getResultItem() == null || dataItem.getResultItem() != itemToFind) continue;
                return dataIndex;
            }
            return -1;
        }

        protected int _getPositionForIthResultItem(int resultItemIndex) {
            int cResultItems = -1;
            for (int dataIndex = 0; dataIndex < DataItemListView.this.m_dataItems.size(); ++dataIndex) {
                DataItem dataItem = DataItemListView.this.m_dataItems.elementAt(dataIndex);
                if (dataItem.getResultItem() != null) {
                    ++cResultItems;
                }
                if (cResultItems != resultItemIndex) continue;
                return dataIndex;
            }
            return -1;
        }

        public void modelChangeCallback(ModelChangeEvent event) {
            if (event.isStructureChange()) {
                if (event.didThisStructureAreaChange(65535)) {
                    DataItemListView.this.m_dataItems.removeAllElements();
                    this.refresh();
                    return;
                }
                Table tableToDelete = (Table)event.getObject(8, 2);
                block0: for (int index = DataItemListView.this.m_dataItems.size() - 1; index >= 0; --index) {
                    Expression expression = DataItemListView.this.m_dataItems.elementAt(index).getExpression();
                    ColumnList columnList = null;
                    if (expression != null) {
                        columnList = expression.getReferencedColumns();
                    }
                    for (int colIndex = 0; columnList != null && colIndex < columnList.size(); ++colIndex) {
                        if (columnList.elementAt(colIndex).getParent() != tableToDelete) continue;
                        DataItemListView.this.m_dataItems.removeElementAt(index);
                        continue block0;
                    }
                }
                TableModelEvent tableEvent = new TableModelEvent(this);
                this.fireTableChanged(tableEvent);
            }
            if (event.isDataChange()) {
                // empty if block
            }
        }
    }
}

