/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.datasource.xa.XAResourcePreferenceHolder;
import com.atomikos.datasource.xa.event.XAResourceDetectedEvent;
import com.atomikos.datasource.xa.jdbc.JdbcTransactionalResource;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.event.Event;
import com.atomikos.jdbc.internal.AbstractDataSourceBean;
import com.atomikos.jdbc.internal.AtomikosSQLException;
import com.atomikos.jdbc.internal.AtomikosXAPooledConnection;
import com.atomikos.jdbc.internal.InitConnectionCallback;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.publish.EventPublisher;
import com.atomikos.util.ClassLoadingHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class AtomikosDataSourceBean
extends AbstractDataSourceBean
implements DataSource {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosDataSourceBean.class);
    private static final long serialVersionUID = 1L;
    private Properties xaProperties = new Properties();
    private Set<String> xaPropertyNamesToHide = new HashSet<String>();
    private String xaDataSourceClassName;
    private transient XADataSource xaDataSource;
    private final XAResourcePreferenceHolder xaResourcePreferenceHolder = new XAResourcePreferenceHolder();
    private boolean localTransactionMode = true;
    private boolean recycleActiveConnectionsInTransaction;

    protected String printXaProperties() {
        return PropertyUtils.printProperties((Properties)this.xaProperties, this.xaPropertyNamesToHide);
    }

    public Properties getXaProperties() {
        return this.xaProperties;
    }

    public void setXaProperties(Properties xaProperties) {
        this.xaProperties = xaProperties;
    }

    public String getXaDataSourceClassName() {
        return this.xaDataSourceClassName;
    }

    public void setXaDataSourceClassName(String xaDataSourceClassName) {
        this.xaDataSourceClassName = xaDataSourceClassName;
    }

    public XADataSource getXaDataSource() {
        return this.xaDataSource;
    }

    public void setXaDataSource(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    @Override
    public boolean getLocalTransactionMode() {
        return this.localTransactionMode;
    }

    public void setLocalTransactionMode(boolean localTransactionMode) {
        this.localTransactionMode = localTransactionMode;
    }

    @Override
    protected ConnectionFactory<Connection> doInit() throws Exception {
        if (this.xaDataSource == null) {
            if (this.xaDataSourceClassName == null) {
                this.throwAtomikosSQLException("Property 'xaDataSourceClassName' cannot be null");
            }
            if (this.xaProperties == null) {
                this.throwAtomikosSQLException("Property 'xaProperties' cannot be null");
            }
        }
        LOGGER.logInfo(this + ": initializing with [ xaDataSourceClassName=" + this.xaDataSourceClassName + ", uniqueResourceName=" + this.getUniqueResourceName() + ", maxPoolSize=" + this.getMaxPoolSize() + ", minPoolSize=" + this.getMinPoolSize() + ", borrowConnectionTimeout=" + this.getBorrowConnectionTimeout() + ", maxIdleTime=" + this.getMaxIdleTime() + ", reapTimeout=" + this.getReapTimeout() + ", maintenanceInterval=" + this.getMaintenanceInterval() + ", initConnectionSql=" + this.getInitConnectionSql() + ", testQuery=" + this.getTestQuery() + ", xaProperties=" + this.printXaProperties() + ", loginTimeout=" + this.getLoginTimeout() + ", maxLifetime=" + this.getMaxLifetime() + ", startNewXaBranchFlags=" + this.getStartNewXaBranchFlags() + ", propagateJtaTimeoutToXaResource=" + this.getPropagateJtaTimeoutToXaResource() + ", joinExistingXaBranchFlags=" + this.getJoinExistingXaBranchFlags() + ", resumeExistingXaBranchFlags=" + this.getResumeExistingXaBranchFlags() + ", suspendExistingXaBranchFlags=" + this.getSuspendExistingXaBranchFlags() + ", endExistingXaBranchFlags=" + this.getEndExistingXaBranchFlags() + ", useDriverBasedConnectionValidation=" + this.getUseDriverBasedConnectionValidation() + ", concurrentConnectionValidation=" + this.getConcurrentConnectionValidation() + ", supportsTmJoin=" + this.getSupportsTmJoin() + ", networkTimeout=" + this.getNetworkTimeout() + ", connectionValidationInterval=" + this.getConnectionValidationInterval() + ", recycleActiveConnectionsInTransaction=" + this.getRecycleActiveConnectionsInTransaction() + ", localTransactionMode=" + this.getLocalTransactionMode() + "]");
        if (this.xaDataSource == null) {
            try {
                Class xadsClass = ClassLoadingHelper.loadClass((String)this.getXaDataSourceClassName());
                this.xaDataSource = (XADataSource)xadsClass.newInstance();
            }
            catch (ClassNotFoundException nf) {
                AtomikosSQLException.throwAtomikosSQLException("The class '" + this.getXaDataSourceClassName() + "' specified by property 'xaDataSourceClassName' could not be found in the classpath. Please make sure the spelling is correct, and that the required jar(s) are in the classpath.", nf);
            }
            catch (ClassCastException cce) {
                AtomikosSQLException.throwAtomikosSQLException("The class '" + this.getXaDataSourceClassName() + "' specified by property 'xaDataSourceClassName' does not implement the required interface javax.jdbc.XADataSource. Please make sure the spelling is correct, and check your JDBC driver vendor's documentation.");
            }
            this.xaDataSource.setLoginTimeout(this.getLoginTimeout());
            this.xaDataSource.setLogWriter(this.getLogWriter());
            PropertyUtils.setProperties((Object)this.xaDataSource, (Map)this.xaProperties);
        }
        this.xaResourcePreferenceHolder.supportsTmJoin = this.getSupportsTmJoin();
        JdbcTransactionalResource tr = new JdbcTransactionalResource(this.getUniqueResourceName(), this.xaDataSource, this.xaResourcePreferenceHolder);
        AtomikosXAConnectionFactory cf = new AtomikosXAConnectionFactory(this.xaDataSource, tr, this, this);
        Configuration.addResource((RecoverableResource)tr);
        EventPublisher.INSTANCE.publish((Event)new XAResourceDetectedEvent(this.xaDataSourceClassName, this.xaProperties, this.xaPropertyNamesToHide, XAResourceDetectedEvent.ResourceType.JDBC, this.getUniqueResourceName()));
        return cf;
    }

    @Override
    protected void doClose() {
        RecoverableResource res = Configuration.getResource((String)this.getUniqueResourceName());
        if (res != null) {
            Configuration.removeResource((String)this.getUniqueResourceName());
            res.close();
        }
    }

    @Override
    protected boolean isAssignableFromWrappedVendorClass(Class<?> iface) {
        boolean ret = false;
        if (this.xaDataSource != null) {
            ret = iface.isAssignableFrom(this.xaDataSource.getClass());
        }
        return ret;
    }

    public Set<String> getXaPropertyNamesToHide() {
        return this.xaPropertyNamesToHide;
    }

    @Override
    protected Object unwrapVendorInstance() {
        return this.xaDataSource;
    }

    public void setXaPropertyNamesToHide(Set<String> xaPropertyNamesToHide) {
        this.xaPropertyNamesToHide.addAll(xaPropertyNamesToHide);
    }

    public int getStartNewXaBranchFlags() {
        return this.xaResourcePreferenceHolder.startNewXaBranchFlags;
    }

    public void setStartNewXaBranchFlags(int vendorSpecificFlags) {
        this.xaResourcePreferenceHolder.startNewXaBranchFlags = vendorSpecificFlags;
    }

    public boolean getPropagateJtaTimeoutToXaResource() {
        return this.xaResourcePreferenceHolder.propagateJtaTimeoutToXaResource;
    }

    public void setPropagateJtaTimeoutToXaResource(boolean value) {
        this.xaResourcePreferenceHolder.propagateJtaTimeoutToXaResource = value;
    }

    public int getJoinExistingXaBranchFlags() {
        return this.xaResourcePreferenceHolder.joinExistingXaBranchFlags;
    }

    public void setJoinExistingXaBranchFlags(int vendorSpecificFlags) {
        this.xaResourcePreferenceHolder.joinExistingXaBranchFlags = vendorSpecificFlags;
    }

    public int getResumeExistingXaBranchFlags() {
        return this.xaResourcePreferenceHolder.resumeExistingXaBranchFlags;
    }

    public void setResumeExistingXaBranchFlags(int vendorSpecificFlags) {
        this.xaResourcePreferenceHolder.resumeExistingXaBranchFlags = vendorSpecificFlags;
    }

    public int getSuspendExistingXaBranchFlags() {
        return this.xaResourcePreferenceHolder.suspendExistingXaBranchFlags;
    }

    public void setSuspendExistingXaBranchFlags(int vendorSpecificFlags) {
        this.xaResourcePreferenceHolder.suspendExistingXaBranchFlags = vendorSpecificFlags;
    }

    public int getEndExistingXaBranchFlags() {
        return this.xaResourcePreferenceHolder.endExistingXaBranchFlags;
    }

    public void setEndExistingXaBranchFlags(int vendorSpecificFlags) {
        this.xaResourcePreferenceHolder.endExistingXaBranchFlags = vendorSpecificFlags;
    }

    public boolean getSupportsTmJoin() {
        return this.xaResourcePreferenceHolder.supportsTmJoin;
    }

    public void setSupportsTmJoin(boolean value) {
        this.xaResourcePreferenceHolder.supportsTmJoin = value;
    }

    public void setRecycleActiveConnectionsInTransaction(boolean value) {
        this.recycleActiveConnectionsInTransaction = value;
    }

    public boolean getRecycleActiveConnectionsInTransaction() {
        return this.recycleActiveConnectionsInTransaction;
    }

    public boolean getIgnoreJtaTransactions() {
        return false;
    }

    private class AtomikosXAConnectionFactory
    implements ConnectionFactory<Connection> {
        private final Logger LOGGER = LoggerFactory.createLogger(AtomikosXAConnectionFactory.class);
        private final JdbcTransactionalResource jdbcTransactionalResource;
        private final XADataSource xaDataSource;
        private final ConnectionPoolProperties props;
        private final InitConnectionCallback initConnectionCallback;

        private AtomikosXAConnectionFactory(XADataSource xaDataSource, JdbcTransactionalResource jdbcTransactionalResource, ConnectionPoolProperties props, InitConnectionCallback initConnectionCallback) {
            this.xaDataSource = xaDataSource;
            this.jdbcTransactionalResource = jdbcTransactionalResource;
            this.props = props;
            this.initConnectionCallback = initConnectionCallback;
        }

        public XPooledConnection<Connection> createPooledConnection() throws CreateConnectionException {
            try {
                XAConnection xaConnection = this.xaDataSource.getXAConnection();
                return new AtomikosXAPooledConnection(xaConnection, this.jdbcTransactionalResource, this.props, this.initConnectionCallback, AtomikosDataSourceBean.this.recycleActiveConnectionsInTransaction);
            }
            catch (SQLException e) {
                String msg = "XAConnectionFactory: failed to create pooled connection - DBMS down or unreachable?";
                this.LOGGER.logWarning(msg, (Throwable)e);
                throw new CreateConnectionException(msg, (Exception)e);
            }
        }
    }
}

