/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.rest;

import MITI.mimb.driver.impl.remote.HttpUtil;
import MITI.sf.client.axis.gen.OEMLicenseToken;
import MITI.sf.client.rest.MimbRestUtil;
import MITI.util.XmlUtil;
import MITI.util.XmlVersion;
import MITI.util.rest.RestUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Service {
    private static final XmlVersion XML_VERSION = XmlVersion.XML_11;
    private URL url;

    public Service(URL uRL) {
        this.url = uRL;
    }

    protected static StringBuffer createXml() {
        return new StringBuffer(XML_VERSION.getDecl());
    }

    protected static String escapeXml(String string) {
        return XmlUtil.escapeXml(string, XML_VERSION);
    }

    protected Element callXml(String string, RestUtil.Parameter ... parameterArray) throws RemoteException {
        return this.callXml(string, (OEMLicenseToken)null, parameterArray);
    }

    protected Element callXml(String string, OEMLicenseToken oEMLicenseToken, RestUtil.Parameter ... parameterArray) throws RemoteException {
        ArrayList<RestUtil.Parameter> arrayList = new ArrayList<RestUtil.Parameter>();
        if (oEMLicenseToken != null) {
            arrayList.add(new RestUtil.Parameter("oemPartnerToken", oEMLicenseToken.getOemPartnerToken()));
            arrayList.add(new RestUtil.Parameter("temporaryLicenseToken", oEMLicenseToken.getTemporaryLicenseToken()));
        }
        arrayList.add(new RestUtil.Parameter("XmlRequest", string));
        arrayList.addAll(Arrays.asList(parameterArray));
        Document document = RestUtil.callRestXmlApi(this.url, arrayList);
        if (document != null) {
            Element element = document.getDocumentElement();
            if (XmlUtil.isElementNode(element, null, "Fault")) {
                MimbRestUtil.parseFaultResponse(element);
            }
            return element;
        }
        return null;
    }

    protected void callXml(File file, String string, OEMLicenseToken oEMLicenseToken, RestUtil.Parameter ... parameterArray) throws RemoteException {
        ArrayList<RestUtil.Parameter> arrayList = new ArrayList<RestUtil.Parameter>();
        if (oEMLicenseToken != null) {
            arrayList.add(new RestUtil.Parameter("oemPartnerToken", oEMLicenseToken.getOemPartnerToken()));
            arrayList.add(new RestUtil.Parameter("temporaryLicenseToken", oEMLicenseToken.getTemporaryLicenseToken()));
        }
        arrayList.add(new RestUtil.Parameter("XmlRequest", string));
        arrayList.addAll(Arrays.asList(parameterArray));
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = HttpUtil.openConnection((URL)this.url, (boolean)false);
            InputStream inputStream = RestUtil.callRestApi(httpURLConnection, arrayList);
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }
}

