/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.rest;

import MITI.sf.client.axis.gen.BridgeListType;
import MITI.sf.client.axis.gen.BridgeParameterType;
import MITI.sf.client.axis.gen.BridgeParameterValue;
import MITI.sf.client.axis.gen.BridgeRunConfigurationType;
import MITI.sf.client.axis.gen.BridgeSpecificationType;
import MITI.sf.client.axis.gen.BridgeType;
import MITI.sf.client.axis.gen.BridgeTypeDisplayName;
import MITI.sf.client.axis.gen.BrowseType;
import MITI.sf.client.axis.gen.CreateProcessRequest;
import MITI.sf.client.axis.gen.DataProfilingObject;
import MITI.sf.client.axis.gen.DataProfilingOptions;
import MITI.sf.client.axis.gen.DirectionType;
import MITI.sf.client.axis.gen.GetBridgeInformationRequest;
import MITI.sf.client.axis.gen.GetBridgeInformationResponse;
import MITI.sf.client.axis.gen.GetBridgeInformationResponseBridgeParameter;
import MITI.sf.client.axis.gen.GetBridgeInformationResponseBridgeParameterPossibleValue;
import MITI.sf.client.axis.gen.GetBridgeListResponse;
import MITI.sf.client.axis.gen.GetBridgeSpecsRequest;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponse;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridge;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeBridge;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodology;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeTool;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeToolInterface;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeVendor;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusRequest;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusResponse;
import MITI.sf.client.axis.gen.LogType;
import MITI.sf.client.axis.gen.MIMB;
import MITI.sf.client.axis.gen.MessageLevel;
import MITI.sf.client.axis.gen.MessageType;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.MimbErrorResponse;
import MITI.sf.client.axis.gen.MimbExecutionState;
import MITI.sf.client.axis.gen.OEMLicenseToken;
import MITI.sf.client.axis.gen.OpenModeType;
import MITI.sf.client.axis.gen.RunMimbDataProfilingRequest;
import MITI.sf.client.axis.gen.RunMimbExtendedRequest;
import MITI.sf.client.axis.gen.RunMimbResponse;
import MITI.sf.client.axis.gen.RunMimbType;
import MITI.sf.client.axis.gen.SaveBridgeParametersRequestType;
import MITI.sf.client.axis.gen.SaveBridgeParametersResponse;
import MITI.sf.client.axis.gen.StartBrowseRequest;
import MITI.sf.client.axis.gen.StartMimbDataProfilingRequest;
import MITI.sf.client.axis.gen.StartMimbExtendedRequest;
import MITI.sf.client.axis.gen.StartMimbRequest;
import MITI.sf.client.axis.gen.StartMimbResponse;
import MITI.sf.client.axis.gen.StartTestRequest;
import MITI.sf.client.axis.gen.StopMimbExecutionRequest;
import MITI.sf.client.axis.gen.StopMimbExecutionResponse;
import MITI.sf.client.axis.gen.TestType;
import MITI.sf.client.axis.gen.TypeType;
import MITI.sf.client.axis.gen.VaultParameterType;
import MITI.sf.client.rest.Service;
import MITI.util.DateUtil;
import MITI.util.XmlUtil;
import MITI.util.rest.RestUtil;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Element;

public class MimbRest
extends Service
implements MIMB {
    public MimbRest(URL uRL) {
        super(uRL);
    }

    public static void appendBridgeListRequest(StringBuffer stringBuffer, BridgeListType bridgeListType) {
        stringBuffer.append("<GetBridgeListRequest");
        stringBuffer.append(" direction=\"" + bridgeListType.getDirection().toString() + "\"");
        if (bridgeListType.getLanguage() != null) {
            stringBuffer.append(" language=\"" + MimbRest.escapeXml(bridgeListType.getLanguage()) + "\"");
        }
        if (bridgeListType.getUserIdentity() != null) {
            stringBuffer.append(" userIdentity=\"" + MimbRest.escapeXml(bridgeListType.getUserIdentity()) + "\"");
        }
        stringBuffer.append(" specification=\"" + bridgeListType.getSpecification() + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\"/>");
    }

    private String createBridgeListRequestXml(BridgeListType bridgeListType) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendBridgeListRequest(stringBuffer, bridgeListType);
        return stringBuffer.toString();
    }

    private static BridgeTypeDisplayName parseBridgeTypeDisplayName(Element element) {
        BridgeTypeDisplayName bridgeTypeDisplayName = new BridgeTypeDisplayName();
        if (element != null) {
            bridgeTypeDisplayName.setBridgeDisplayName(element.getAttribute("bridgeDisplayName"));
            bridgeTypeDisplayName.setLastUsed(Boolean.parseBoolean(element.getAttribute("lastUsed")));
        }
        return bridgeTypeDisplayName;
    }

    private static BridgeSpecificationType parseBridgeSpecificationType(Element element) {
        BridgeSpecificationType bridgeSpecificationType = new BridgeSpecificationType();
        if (element != null) {
            bridgeSpecificationType.setIsMultiModel(Boolean.parseBoolean(element.getAttribute("isMultiModel")));
            bridgeSpecificationType.setMethodology(element.getAttribute("methodology"));
            bridgeSpecificationType.setProductCompany(element.getAttribute("productCompany"));
            bridgeSpecificationType.setProductName(element.getAttribute("productName"));
            bridgeSpecificationType.setProductVersion(element.getAttribute("productVersion"));
            bridgeSpecificationType.setProductWeb(element.getAttribute("productWeb"));
            bridgeSpecificationType.setVersion(element.getAttribute("version"));
        }
        return bridgeSpecificationType;
    }

    private static void parseBridgeListType(BridgeListType bridgeListType, Element element) {
        bridgeListType.setDirection(DirectionType.fromString(element.getAttribute("direction")));
        bridgeListType.setSpecification(Boolean.parseBoolean(element.getAttribute("specification")));
        bridgeListType.setUserIdentity(element.getAttribute("userIdentity"));
        bridgeListType.setLanguage(element.getAttribute("language"));
    }

    private static void parseBridgeListResponse(Element element, GetBridgeListResponse getBridgeListResponse) {
        MimbRest.parseBridgeListType(getBridgeListResponse, element);
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, null, "Bridge");
        ArrayList<BridgeType> arrayList2 = new ArrayList<BridgeType>();
        for (Element element2 : arrayList) {
            BridgeType bridgeType = new BridgeType();
            bridgeType.setBridgeIdentifier(element2.getAttribute("bridgeIdentifier"));
            bridgeType.setDirection(DirectionType.fromString(element2.getAttribute("direction")));
            arrayList2.add(bridgeType);
            Element element3 = XmlUtil.getFirstElement(element2, null, "DisplayName");
            bridgeType.setDisplayName(MimbRest.parseBridgeTypeDisplayName(element3));
            Element element4 = XmlUtil.getFirstElement(element2, null, "Specification");
            bridgeType.setSpecification(MimbRest.parseBridgeSpecificationType(element4));
        }
        getBridgeListResponse.setBridge(arrayList2.toArray(new BridgeType[arrayList2.size()]));
    }

    @Override
    public GetBridgeListResponse getBridgeList(BridgeListType bridgeListType, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        String string = this.createBridgeListRequestXml(bridgeListType);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "GetBridgeListResponse")) {
            GetBridgeListResponse getBridgeListResponse = new GetBridgeListResponse();
            MimbRest.parseBridgeListResponse(element, getBridgeListResponse);
            return getBridgeListResponse;
        }
        return null;
    }

    public static void appendBridgeSpecsRequest(StringBuffer stringBuffer, GetBridgeSpecsRequest getBridgeSpecsRequest) {
        stringBuffer.append("<GetBridgeSpecsRequest");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        String string = getBridgeSpecsRequest.getBridgeIdentifier();
        if (string != null && !string.isEmpty()) {
            stringBuffer.append(" bridgeIdentifier=\"" + MimbRest.escapeXml(string) + "\"");
            stringBuffer.append(" direction=\"" + getBridgeSpecsRequest.getDirection().toString() + "\"");
        }
        stringBuffer.append(" xsi:nil=\"true\"/>");
    }

    private String createBridgeSpecsRequestXml(GetBridgeSpecsRequest getBridgeSpecsRequest) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendBridgeSpecsRequest(stringBuffer, getBridgeSpecsRequest);
        return stringBuffer.toString();
    }

    private static void parseGetBridgeSpecsResponse(Element element, GetBridgeSpecsResponse getBridgeSpecsResponse) {
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, null, "ModelBridge");
        GetBridgeSpecsResponseModelBridge[] getBridgeSpecsResponseModelBridgeArray = new GetBridgeSpecsResponseModelBridge[arrayList.size()];
        int n = 0;
        for (Element element2 : arrayList) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            GetBridgeSpecsResponseModelBridge getBridgeSpecsResponseModelBridge = new GetBridgeSpecsResponseModelBridge();
            Element element3 = XmlUtil.getFirstElement(element2, null, "Bridge");
            if (element3 != null) {
                object5 = new GetBridgeSpecsResponseModelBridgeBridge();
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setDirection(DirectionType.fromString(element3.getAttribute("direction")));
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setDisplayName(element3.getAttribute("displayName"));
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setId(element3.getAttribute("id"));
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setIsAlias(Boolean.parseBoolean(element3.getAttribute("isAlias")));
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setIsEnabled(Boolean.parseBoolean(element3.getAttribute("isEnabled")));
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setIsIncrementallyHarvestable(Boolean.parseBoolean(element3.getAttribute("isIncrementallyHarvestable")));
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setIsDataProfile(Boolean.parseBoolean(element3.getAttribute("isDataProfile")));
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setIsMimbOemEnabled(Boolean.parseBoolean(element3.getAttribute("isMimbOemEnabled")));
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setIsRepositoryBrowsable(Boolean.parseBoolean(element3.getAttribute("isRepositoryBrowsable")));
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setIsRepositoryMultiModel(Boolean.parseBoolean(element3.getAttribute("isRepositoryMultiModel")));
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setIsToolRequired(Boolean.parseBoolean(element3.getAttribute("isToolRequired")));
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setIsWindowsOnly(Boolean.parseBoolean(element3.getAttribute("isWindowsOnly")));
                ((GetBridgeSpecsResponseModelBridgeBridge)object5).setPartnershipLevel(element3.getAttribute("partnershipLevel"));
                getBridgeSpecsResponseModelBridge.setBridge((GetBridgeSpecsResponseModelBridgeBridge)object5);
            }
            if ((object5 = XmlUtil.getFirstElement(element2, null, "Vendor")) != null) {
                object4 = new GetBridgeSpecsResponseModelBridgeVendor();
                ((GetBridgeSpecsResponseModelBridgeVendor)object4).setId(object5.getAttribute("id"));
                ((GetBridgeSpecsResponseModelBridgeVendor)object4).setName(object5.getAttribute("name"));
                ((GetBridgeSpecsResponseModelBridgeVendor)object4).setWeb(object5.getAttribute("web"));
                getBridgeSpecsResponseModelBridge.setVendor((GetBridgeSpecsResponseModelBridgeVendor)object4);
            }
            if ((object4 = XmlUtil.getFirstElement(element2, null, "Tool")) != null) {
                object3 = new GetBridgeSpecsResponseModelBridgeTool();
                ((GetBridgeSpecsResponseModelBridgeTool)object3).setName(object4.getAttribute("name"));
                ((GetBridgeSpecsResponseModelBridgeTool)object3).setPreviousName(object4.getAttribute("previousName"));
                ((GetBridgeSpecsResponseModelBridgeTool)object3).setVersions(object4.getAttribute("versions"));
                ((GetBridgeSpecsResponseModelBridgeTool)object3).setWeb(object4.getAttribute("web"));
                getBridgeSpecsResponseModelBridge.setTool((GetBridgeSpecsResponseModelBridgeTool)object3);
            }
            if ((object3 = XmlUtil.getFirstElement(element2, null, "Methodology")) != null) {
                object2 = new GetBridgeSpecsResponseModelBridgeMethodology();
                ((GetBridgeSpecsResponseModelBridgeMethodology)object2).setSummary(object3.getAttribute("summary"));
                ((GetBridgeSpecsResponseModelBridgeMethodology)object2).setToolCategory(object3.getAttribute("toolCategory"));
                object = XmlUtil.getFirstElement((Element)object3, null, "MetadataCoverage");
                if (object != null) {
                    Object object6;
                    Object object7;
                    GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage();
                    getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setRepository(object.getAttribute("repository"));
                    getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setSummary(object.getAttribute("summary"));
                    Element element4 = XmlUtil.getFirstElement((Element)object, null, "DataStore");
                    if (element4 != null) {
                        object7 = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore();
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore)object7).setDimensionalModel(element4.getAttribute("dimensionalModel"));
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore)object7).setExpressionParsing(element4.getAttribute("expressionParser"));
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore)object7).setLogicalDataModel(element4.getAttribute("logicalDataModel"));
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore)object7).setObjectModel(element4.getAttribute("objectModel"));
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore)object7).setPhysicalDataModel(element4.getAttribute("physicalDataModel"));
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore)object7).setRecordModel(element4.getAttribute("recordModel"));
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore)object7).setHierarchicalModel(element4.getAttribute("hierarchicalModel"));
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore)object7).setXmlSchemas(element4.getAttribute("xmlSchemas"));
                        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setDataStore((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore)object7);
                    }
                    if ((object7 = XmlUtil.getFirstElement((Element)object, null, "DataIntegrationProcess")) != null) {
                        object6 = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess();
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess)object6).setExpressionConversion(object7.getAttribute("expressionConversion"));
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess)object6).setExpressionParsing(object7.getAttribute("expressionParser"));
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess)object6).setSourceTargetDataStore(object7.getAttribute("sourceTargetDataStore"));
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess)object6).setTransformationLineage(object7.getAttribute("transformationLineage"));
                        ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess)object6).setType(object7.getAttribute("type"));
                        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setDataIntegrationProcess((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess)object6);
                    }
                    if ((object6 = XmlUtil.getFirstElement((Element)object, null, "BusinessIntelligenceProcess")) != null) {
                        Object object8;
                        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess();
                        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess.setModelGraphicalLayout(object6.getAttribute("modelGraphicalLayout"));
                        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess.setType(object6.getAttribute("type"));
                        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setBusinessIntelligenceProcess(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess);
                        Element element5 = XmlUtil.getFirstElement((Element)object6, null, "Design");
                        if (element5 != null) {
                            object8 = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign();
                            ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign)object8).setDimensionalTarget(element5.getAttribute("dimensionalTarget"));
                            ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign)object8).setExpressionConversion(element5.getAttribute("expressionConversion"));
                            ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign)object8).setExpressionParsing(element5.getAttribute("expressionParsing"));
                            ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign)object8).setOlapSource(element5.getAttribute("olapSource"));
                            ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign)object8).setRdbmsSource(element5.getAttribute("rdbmsSource"));
                            ((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign)object8).setTransformationLineage(element5.getAttribute("lineageTransformation"));
                            getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess.setDesign((GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign)object8);
                        }
                        if ((object8 = XmlUtil.getFirstElement((Element)object6, null, "Report")) != null) {
                            GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport();
                            getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport.setDimensionalSource(object8.getAttribute("dimensionalSource"));
                            getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport.setExpressionParsing(object8.getAttribute("expressionParsing"));
                            getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport.setRelationalSource(object8.getAttribute("relationalSource"));
                            getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport.setReportStructure(object8.getAttribute("reportStructure"));
                            getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess.setReport(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport);
                        }
                    }
                    ((GetBridgeSpecsResponseModelBridgeMethodology)object2).setMetadataCoverage(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage);
                }
                getBridgeSpecsResponseModelBridge.setMethodology((GetBridgeSpecsResponseModelBridgeMethodology)object2);
            }
            if ((object2 = XmlUtil.getFirstElement(element2, null, "ToolInterface")) != null) {
                object = new GetBridgeSpecsResponseModelBridgeToolInterface();
                ((GetBridgeSpecsResponseModelBridgeToolInterface)object).setApi(object2.getAttribute("api"));
                ((GetBridgeSpecsResponseModelBridgeToolInterface)object).setFile(object2.getAttribute("file"));
                ((GetBridgeSpecsResponseModelBridgeToolInterface)object).setSummary(object2.getAttribute("summary"));
                getBridgeSpecsResponseModelBridge.setToolInterface((GetBridgeSpecsResponseModelBridgeToolInterface)object);
            }
            getBridgeSpecsResponseModelBridgeArray[n++] = getBridgeSpecsResponseModelBridge;
        }
        getBridgeSpecsResponse.setModelBridge(getBridgeSpecsResponseModelBridgeArray);
    }

    @Override
    public GetBridgeSpecsResponse getBridgeSpecs(GetBridgeSpecsRequest getBridgeSpecsRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        String string = this.createBridgeSpecsRequestXml(getBridgeSpecsRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "GetBridgeSpecsResponse")) {
            GetBridgeSpecsResponse getBridgeSpecsResponse = new GetBridgeSpecsResponse();
            MimbRest.parseGetBridgeSpecsResponse(element, getBridgeSpecsResponse);
            return getBridgeSpecsResponse;
        }
        return null;
    }

    public static void appendBridgeInformationRequest(StringBuffer stringBuffer, GetBridgeInformationRequest getBridgeInformationRequest) {
        stringBuffer.append("<GetBridgeInformationRequest");
        stringBuffer.append(" bridgeIdentifier=\"" + MimbRest.escapeXml(getBridgeInformationRequest.getBridgeIdentifier()) + "\"");
        if (getBridgeInformationRequest.getBridgeDisplayName() != null) {
            stringBuffer.append(" bridgeDisplayName=\"" + MimbRest.escapeXml(getBridgeInformationRequest.getBridgeDisplayName()) + "\"");
        }
        stringBuffer.append(" direction=\"" + getBridgeInformationRequest.getDirection().toString() + "\"");
        if (getBridgeInformationRequest.getLanguage() != null) {
            stringBuffer.append(" language=\"" + MimbRest.escapeXml(getBridgeInformationRequest.getLanguage()) + "\"");
        }
        if (getBridgeInformationRequest.getUserIdentity() != null) {
            stringBuffer.append(" userIdentity=\"" + MimbRest.escapeXml(getBridgeInformationRequest.getUserIdentity()) + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\"/>");
    }

    private String createBridgeInformationRequestXml(GetBridgeInformationRequest getBridgeInformationRequest) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendBridgeInformationRequest(stringBuffer, getBridgeInformationRequest);
        return stringBuffer.toString();
    }

    private static void parseBridgeInformationResponse(Element element, GetBridgeInformationResponse getBridgeInformationResponse) {
        Element element2 = XmlUtil.getFirstElement(element, null, "Specification");
        getBridgeInformationResponse.setBridgeIdentifier(element.getAttribute("bridgeIdentifier"));
        getBridgeInformationResponse.setDirection(DirectionType.fromString(element.getAttribute("direction")));
        getBridgeInformationResponse.setUserIdentity(element.getAttribute("userIdentity"));
        getBridgeInformationResponse.setLanguage(element.getAttribute("language"));
        getBridgeInformationResponse.setBridgeDisplayName(element.getAttribute("bridgeDisplayName"));
        getBridgeInformationResponse.setDescription(element.getAttribute("description"));
        getBridgeInformationResponse.setSpecification(MimbRest.parseBridgeSpecificationType(element2));
        ArrayList<GetBridgeInformationResponseBridgeParameter> arrayList = new ArrayList<GetBridgeInformationResponseBridgeParameter>();
        ArrayList<Element> arrayList2 = XmlUtil.getChildElements(element, null, "BridgeParameter");
        for (Element element3 : arrayList2) {
            GetBridgeInformationResponseBridgeParameter getBridgeInformationResponseBridgeParameter = MimbRest.parseBridgeParameter(element3);
            arrayList.add(getBridgeInformationResponseBridgeParameter);
        }
        getBridgeInformationResponse.setBridgeParameter(arrayList.toArray(new GetBridgeInformationResponseBridgeParameter[arrayList.size()]));
    }

    private static GetBridgeInformationResponseBridgeParameter parseBridgeParameter(Element element) {
        BridgeParameterValue[] bridgeParameterValueArray;
        Object object;
        GetBridgeInformationResponseBridgeParameter getBridgeInformationResponseBridgeParameter = new GetBridgeInformationResponseBridgeParameter();
        getBridgeInformationResponseBridgeParameter.setBridgeParameterIdentifier(element.getAttribute("bridgeParameterIdentifier"));
        getBridgeInformationResponseBridgeParameter.setDisplayName(element.getAttribute("displayName"));
        getBridgeInformationResponseBridgeParameter.setType(TypeType.fromString(element.getAttribute("type")));
        getBridgeInformationResponseBridgeParameter.setMandatory(Boolean.parseBoolean(element.getAttribute("mandatory")));
        getBridgeInformationResponseBridgeParameter.setDescription(element.getAttribute("description"));
        if (getBridgeInformationResponseBridgeParameter.getType() == TypeType.FILE || getBridgeInformationResponseBridgeParameter.getType() == TypeType.DIRECTORY) {
            getBridgeInformationResponseBridgeParameter.setTransferable(Boolean.parseBoolean(element.getAttribute("transferable")));
            getBridgeInformationResponseBridgeParameter.setOpenMode(OpenModeType.fromString(element.getAttribute("openMode")));
        }
        Element element2 = XmlUtil.getFirstElement(element, null, "DefaultValue");
        getBridgeInformationResponseBridgeParameter.setDefaultValue(new BridgeParameterValue(XmlUtil.getNonNullElementValue(element2)));
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, null, "FileExtension");
        String[] stringArray = new String[arrayList.size()];
        int n = 0;
        for (Element getBridgeInformationResponseBridgeParameterPossibleValueArray2 : arrayList) {
            stringArray[n++] = XmlUtil.getNonNullElementValue(getBridgeInformationResponseBridgeParameterPossibleValueArray2);
        }
        getBridgeInformationResponseBridgeParameter.setFileExtension(stringArray);
        ArrayList<Element> arrayList2 = XmlUtil.getChildElements(element, null, "PossibleValue");
        GetBridgeInformationResponseBridgeParameterPossibleValue[] getBridgeInformationResponseBridgeParameterPossibleValueArray = new GetBridgeInformationResponseBridgeParameterPossibleValue[arrayList2.size()];
        n = 0;
        Object object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            object = (Element)object2.next();
            bridgeParameterValueArray = new GetBridgeInformationResponseBridgeParameterPossibleValue();
            bridgeParameterValueArray.set_value(XmlUtil.getNonNullElementValue((Element)object));
            bridgeParameterValueArray.setIdentifier(object.getAttribute("identifier"));
            getBridgeInformationResponseBridgeParameterPossibleValueArray[n++] = bridgeParameterValueArray;
        }
        getBridgeInformationResponseBridgeParameter.setPossibleValue(getBridgeInformationResponseBridgeParameterPossibleValueArray);
        object2 = XmlUtil.getFirstElement(element, null, "SavedValue");
        if (object2 != null) {
            getBridgeInformationResponseBridgeParameter.setSavedValue(new BridgeParameterValue(XmlUtil.getNonNullElementValue((Element)object2)));
        }
        object = XmlUtil.getChildElements(element, null, "HistoricalValue");
        bridgeParameterValueArray = new BridgeParameterValue[object.size()];
        n = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            bridgeParameterValueArray[n++] = new BridgeParameterValue(XmlUtil.getNonNullElementValue(element3));
        }
        getBridgeInformationResponseBridgeParameter.setHistoricalValue(bridgeParameterValueArray);
        return getBridgeInformationResponseBridgeParameter;
    }

    @Override
    public GetBridgeInformationResponse getBridgeInformation(GetBridgeInformationRequest getBridgeInformationRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        String string = this.createBridgeInformationRequestXml(getBridgeInformationRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "GetBridgeInformationResponse")) {
            GetBridgeInformationResponse getBridgeInformationResponse = new GetBridgeInformationResponse();
            MimbRest.parseBridgeInformationResponse(element, getBridgeInformationResponse);
            return getBridgeInformationResponse;
        }
        return null;
    }

    @Override
    public SaveBridgeParametersResponse saveBridgeParameters(SaveBridgeParametersRequestType saveBridgeParametersRequestType, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        return null;
    }

    private String createBrowseRequestXml(BrowseType browseType) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendBrowseRequest(stringBuffer, browseType);
        return stringBuffer.toString();
    }

    @Override
    public RunMimbResponse browse(BrowseType browseType, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        String string = this.createBrowseRequestXml(browseType);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "RunMimbResponse")) {
            RunMimbResponse runMimbResponse = new RunMimbResponse();
            MimbRest.parseRunMimbResponse(element, runMimbResponse);
            return runMimbResponse;
        }
        return null;
    }

    public static void appendTestRequest(StringBuffer stringBuffer, TestType testType) {
        stringBuffer.append("<TestMimbRequest");
        MimbRest.appendBridgeRunConfigType(stringBuffer, testType);
        stringBuffer.append(" direction=\"" + testType.getDirection().toString() + "\"");
        if (testType.getLogLevel() != null) {
            stringBuffer.append(" logLevel=\"" + testType.getLogLevel() + "\"");
        }
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xsi:type=\"TestType\">");
        MimbRest.appendVaultParameter(stringBuffer, testType.getVaultParameter());
        MimbRest.appendBridgeParameters(stringBuffer, testType.getBridgeParameter());
        stringBuffer.append("</TestMimbRequest>");
    }

    private String createTestRequestXml(TestType testType) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendTestRequest(stringBuffer, testType);
        return stringBuffer.toString();
    }

    @Override
    public RunMimbResponse test(TestType testType, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        String string = this.createTestRequestXml(testType);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "RunMimbResponse")) {
            RunMimbResponse runMimbResponse = new RunMimbResponse();
            MimbRest.parseRunMimbResponse(element, runMimbResponse);
            return runMimbResponse;
        }
        return null;
    }

    private String createRunMimbRequestXml(RunMimbType runMimbType) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendRunMimbRequest(stringBuffer, runMimbType);
        return stringBuffer.toString();
    }

    private static void parseRunMimbResponse(Element element, RunMimbResponse runMimbResponse) {
        Element element2 = XmlUtil.getFirstElement(element, null, "Log");
        if (element2 != null) {
            LogType logType = new LogType();
            MimbRest.parseLog(element2, logType);
            runMimbResponse.setLog(logType);
        }
    }

    @Override
    public RunMimbResponse runMimb(RunMimbType runMimbType, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        String string = this.createRunMimbRequestXml(runMimbType);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "RunMimbResponse")) {
            RunMimbResponse runMimbResponse = new RunMimbResponse();
            MimbRest.parseRunMimbResponse(element, runMimbResponse);
            return runMimbResponse;
        }
        return null;
    }

    @Override
    public RunMimbResponse runMimbExtended(RunMimbExtendedRequest runMimbExtendedRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        return null;
    }

    public static void appendCreateProcessRequest(StringBuffer stringBuffer, CreateProcessRequest createProcessRequest) {
        stringBuffer.append("<CreateProcessRequest");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\"/>");
    }

    private String createCreateProcessRequestXml(CreateProcessRequest createProcessRequest) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendCreateProcessRequest(stringBuffer, createProcessRequest);
        return stringBuffer.toString();
    }

    @Override
    public StartMimbResponse createProcess(CreateProcessRequest createProcessRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault {
        String string = this.createCreateProcessRequestXml(createProcessRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "StartMimbResponse")) {
            StartMimbResponse startMimbResponse = new StartMimbResponse();
            MimbRest.parseStartMimbResponse(element, startMimbResponse);
            return startMimbResponse;
        }
        return null;
    }

    private static void appendBridgeRunConfigType(StringBuffer stringBuffer, BridgeRunConfigurationType bridgeRunConfigurationType) {
        stringBuffer.append(" bridgeIdentifier=\"" + MimbRest.escapeXml(bridgeRunConfigurationType.getBridgeIdentifier()) + "\"");
        if (bridgeRunConfigurationType.getBridgeDisplayName() != null) {
            stringBuffer.append(" bridgeDisplayName=\"" + MimbRest.escapeXml(bridgeRunConfigurationType.getBridgeDisplayName()) + "\"");
        }
        if (bridgeRunConfigurationType.getUserIdentity() != null) {
            stringBuffer.append(" userIdentity=\"" + MimbRest.escapeXml(bridgeRunConfigurationType.getUserIdentity()) + "\"");
        }
        if (bridgeRunConfigurationType.getDisableLog() != null) {
            stringBuffer.append(" disableLog=\"" + bridgeRunConfigurationType.getDisableLog() + "\"");
        }
    }

    public static void appendRunMimbRequest(StringBuffer stringBuffer, RunMimbType runMimbType) {
        stringBuffer.append("<RunMimbRequest");
        if (runMimbType.getLanguage() != null) {
            stringBuffer.append(" language=\"" + MimbRest.escapeXml(runMimbType.getLanguage()) + "\"");
        }
        if (runMimbType.getLogLevel() != null) {
            stringBuffer.append(" logLevel=\"" + runMimbType.getLogLevel() + "\"");
        }
        if (runMimbType.getResetCache() != null) {
            stringBuffer.append(" resetCache=\"" + (Object)((Object)runMimbType.getResetCache()) + "\"");
        }
        stringBuffer.append(" validationLevel=\"" + runMimbType.getValidationLevel().toString() + "\"");
        if (runMimbType.getUserIdentity() != null) {
            stringBuffer.append(" userIdentity=\"" + MimbRest.escapeXml(runMimbType.getUserIdentity()) + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\">");
        stringBuffer.append("<Import");
        BridgeRunConfigurationType bridgeRunConfigurationType = runMimbType.get_import();
        MimbRest.appendBridgeRunConfigType(stringBuffer, bridgeRunConfigurationType);
        stringBuffer.append(">");
        MimbRest.appendVaultParameter(stringBuffer, bridgeRunConfigurationType.getVaultParameter());
        MimbRest.appendBridgeParameters(stringBuffer, bridgeRunConfigurationType.getBridgeParameter());
        stringBuffer.append("</Import>");
        stringBuffer.append("<Export");
        BridgeRunConfigurationType bridgeRunConfigurationType2 = runMimbType.getExport();
        MimbRest.appendBridgeRunConfigType(stringBuffer, bridgeRunConfigurationType2);
        stringBuffer.append(">");
        MimbRest.appendVaultParameter(stringBuffer, bridgeRunConfigurationType2.getVaultParameter());
        MimbRest.appendBridgeParameters(stringBuffer, bridgeRunConfigurationType2.getBridgeParameter());
        stringBuffer.append("</Export>");
        stringBuffer.append("</RunMimbRequest>");
    }

    public static void appendStartTestRequest(StringBuffer stringBuffer, StartTestRequest startTestRequest) {
        stringBuffer.append("<StartTestRequest");
        if (startTestRequest.getReuseMimbProcessId() != null) {
            stringBuffer.append(" reuseMimbProcessId=\"" + MimbRest.escapeXml(startTestRequest.getReuseMimbProcessId()) + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\">");
        TestType testType = startTestRequest.getTestMimbRequest();
        MimbRest.appendTestRequest(stringBuffer, testType);
        stringBuffer.append("</StartTestRequest>");
    }

    private String createStartTestRequestXml(StartTestRequest startTestRequest) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendStartTestRequest(stringBuffer, startTestRequest);
        return stringBuffer.toString();
    }

    private static void parseStartMimbResponse(Element element, StartMimbResponse startMimbResponse) {
        startMimbResponse.setLogFileHandle(element.getAttribute("logFileHandle"));
        startMimbResponse.setMimbProcessId(element.getAttribute("mimbProcessId"));
    }

    @Override
    public StartMimbResponse startTest(StartTestRequest startTestRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        String string = this.createStartTestRequestXml(startTestRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "StartMimbResponse")) {
            StartMimbResponse startMimbResponse = new StartMimbResponse();
            MimbRest.parseStartMimbResponse(element, startMimbResponse);
            return startMimbResponse;
        }
        return null;
    }

    private static void appendVaultParameter(StringBuffer stringBuffer, VaultParameterType vaultParameterType) {
        if (vaultParameterType != null) {
            stringBuffer.append("<SecretVault");
            for (Map.Entry<String, String> entry : vaultParameterType.getValues().entrySet()) {
                stringBuffer.append(" " + entry.getKey() + "=\"" + MimbRest.escapeXml(entry.getValue()) + "\"");
            }
            stringBuffer.append(">");
            stringBuffer.append("</SecretVault>");
        }
    }

    private static void appendBridgeParameters(StringBuffer stringBuffer, BridgeParameterType[] bridgeParameterTypeArray) {
        for (BridgeParameterType bridgeParameterType : bridgeParameterTypeArray) {
            stringBuffer.append("<BridgeParameter");
            stringBuffer.append(" bridgeParameterIdentifier=\"" + MimbRest.escapeXml(bridgeParameterType.getBridgeParameterIdentifier()) + "\"");
            if (bridgeParameterType.getClientSpecifiedText() != null) {
                stringBuffer.append(" clientSpecifiedText=\"" + MimbRest.escapeXml(bridgeParameterType.getClientSpecifiedText()) + "\"");
            }
            stringBuffer.append(">");
            stringBuffer.append(MimbRest.escapeXml(bridgeParameterType.get_value()));
            stringBuffer.append("</BridgeParameter>");
        }
    }

    public static void appendBrowseRequest(StringBuffer stringBuffer, BrowseType browseType) {
        stringBuffer.append("<BrowseRequest");
        MimbRest.appendBridgeRunConfigType(stringBuffer, browseType);
        stringBuffer.append(" browseParameterIdentifier=\"" + MimbRest.escapeXml(browseType.getBrowseParameterIdentifier()) + "\"");
        stringBuffer.append(" direction=\"" + browseType.getDirection().toString() + "\"");
        stringBuffer.append(" file=\"" + MimbRest.escapeXml(browseType.getFile()) + "\"");
        if (browseType.getLogLevel() != null) {
            stringBuffer.append(" logLevel=\"" + browseType.getLogLevel() + "\"");
        }
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xsi:type=\"BrowseType\">");
        MimbRest.appendVaultParameter(stringBuffer, browseType.getVaultParameter());
        MimbRest.appendBridgeParameters(stringBuffer, browseType.getBridgeParameter());
        stringBuffer.append("</BrowseRequest>");
    }

    public static void appendStartBrowseRequest(StringBuffer stringBuffer, StartBrowseRequest startBrowseRequest) {
        stringBuffer.append("<StartBrowseRequest");
        if (startBrowseRequest.getReuseMimbProcessId() != null) {
            stringBuffer.append(" reuseMimbProcessId=\"" + MimbRest.escapeXml(startBrowseRequest.getReuseMimbProcessId()) + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\">");
        BrowseType browseType = startBrowseRequest.getBrowseRequest();
        MimbRest.appendBrowseRequest(stringBuffer, browseType);
        stringBuffer.append("</StartBrowseRequest>");
    }

    private String createStartBrowseRequestXml(StartBrowseRequest startBrowseRequest) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendStartBrowseRequest(stringBuffer, startBrowseRequest);
        return stringBuffer.toString();
    }

    @Override
    public StartMimbResponse startBrowse(StartBrowseRequest startBrowseRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        String string = this.createStartBrowseRequestXml(startBrowseRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "StartMimbResponse")) {
            StartMimbResponse startMimbResponse = new StartMimbResponse();
            MimbRest.parseStartMimbResponse(element, startMimbResponse);
            return startMimbResponse;
        }
        return null;
    }

    public static void appendStartMimbRequest(StringBuffer stringBuffer, StartMimbRequest startMimbRequest) {
        stringBuffer.append("<StartMimbRequest");
        if (startMimbRequest.getReuseMimbProcessId() != null) {
            stringBuffer.append(" reuseMimbProcessId=\"" + MimbRest.escapeXml(startMimbRequest.getReuseMimbProcessId()) + "\"");
        }
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\">");
        RunMimbType runMimbType = startMimbRequest.getRunMimbRequest();
        MimbRest.appendRunMimbRequest(stringBuffer, runMimbType);
        stringBuffer.append("</StartMimbRequest>");
    }

    private String createStartMimbRequestXml(StartMimbRequest startMimbRequest) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendStartMimbRequest(stringBuffer, startMimbRequest);
        return stringBuffer.toString();
    }

    @Override
    public StartMimbResponse startMimb(StartMimbRequest startMimbRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        String string = this.createStartMimbRequestXml(startMimbRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "StartMimbResponse")) {
            StartMimbResponse startMimbResponse = new StartMimbResponse();
            MimbRest.parseStartMimbResponse(element, startMimbResponse);
            return startMimbResponse;
        }
        return null;
    }

    @Override
    public StartMimbResponse startMimbExtended(StartMimbExtendedRequest startMimbExtendedRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        return null;
    }

    public static void appendMimbExecutionStatusRequest(StringBuffer stringBuffer, GetMimbExecutionStatusRequest getMimbExecutionStatusRequest) {
        stringBuffer.append("<GetMimbExecutionStatusRequest");
        stringBuffer.append(" maxLogLines=\"" + getMimbExecutionStatusRequest.getMaxLogLines() + "\"");
        stringBuffer.append(" mimbProcessId=\"" + MimbRest.escapeXml(getMimbExecutionStatusRequest.getMimbProcessId()) + "\"");
        stringBuffer.append(" waitForSecondsIfRunning=\"" + getMimbExecutionStatusRequest.getWaitForSecondsIfRunning() + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\">");
        stringBuffer.append("</GetMimbExecutionStatusRequest>");
    }

    private String createMimbExecutionStatusRequestXml(GetMimbExecutionStatusRequest getMimbExecutionStatusRequest) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendMimbExecutionStatusRequest(stringBuffer, getMimbExecutionStatusRequest);
        return stringBuffer.toString();
    }

    private static void parseMimbExecutionStatusResponse(Element element, GetMimbExecutionStatusResponse getMimbExecutionStatusResponse) {
        getMimbExecutionStatusResponse.setIsRunning(Boolean.parseBoolean(element.getAttribute("isRunning")));
        getMimbExecutionStatusResponse.setIsSuccessful(Boolean.parseBoolean(element.getAttribute("isSuccessful")));
        Element element2 = XmlUtil.getFirstElement(element, null, "Log");
        if (element2 != null) {
            LogType logType = new LogType();
            MimbRest.parseLog(element2, logType);
            getMimbExecutionStatusResponse.setLog(logType);
        }
    }

    @Override
    public GetMimbExecutionStatusResponse getMimbExecutionStatus(GetMimbExecutionStatusRequest getMimbExecutionStatusRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault {
        String string = this.createMimbExecutionStatusRequestXml(getMimbExecutionStatusRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "GetMimbExecutionStatusResponse")) {
            GetMimbExecutionStatusResponse getMimbExecutionStatusResponse = new GetMimbExecutionStatusResponse();
            MimbRest.parseMimbExecutionStatusResponse(element, getMimbExecutionStatusResponse);
            return getMimbExecutionStatusResponse;
        }
        return null;
    }

    private static void appendStopMimbRequest(StringBuffer stringBuffer, StopMimbExecutionRequest stopMimbExecutionRequest) {
        stringBuffer.append("<StopMimbExecutionRequest");
        stringBuffer.append(" mimbProcessId=\"" + MimbRest.escapeXml(stopMimbExecutionRequest.getMimbProcessId()) + "\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\">");
        stringBuffer.append("</StopMimbExecutionRequest>");
    }

    private String createStopMimbRequestXml(StopMimbExecutionRequest stopMimbExecutionRequest) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendStopMimbRequest(stringBuffer, stopMimbExecutionRequest);
        return stringBuffer.toString();
    }

    private static void parseStopMimbExecutionResponse(Element element, StopMimbExecutionResponse stopMimbExecutionResponse) {
        stopMimbExecutionResponse.setStatus(MimbExecutionState.fromString(element.getAttribute("status")));
    }

    @Override
    public StopMimbExecutionResponse stopMimbExecution(StopMimbExecutionRequest stopMimbExecutionRequest) throws RemoteException, MimbAgentFault {
        String string = this.createStopMimbRequestXml(stopMimbExecutionRequest);
        Element element = this.callXml(string, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "StopMimbExecutionResponse")) {
            StopMimbExecutionResponse stopMimbExecutionResponse = new StopMimbExecutionResponse();
            MimbRest.parseStopMimbExecutionResponse(element, stopMimbExecutionResponse);
            return stopMimbExecutionResponse;
        }
        return null;
    }

    @Override
    public StartMimbResponse startMimbDataProfiling(StartMimbDataProfilingRequest startMimbDataProfilingRequest, OEMLicenseToken oEMLicenseToken) throws RemoteException, MimbAgentFault, MimbErrorResponse {
        String string = this.createStartMimbDataProfilingRequestXml(startMimbDataProfilingRequest);
        Element element = this.callXml(string, oEMLicenseToken, new RestUtil.Parameter[0]);
        if (XmlUtil.isElementNode(element, null, "StartMimbResponse")) {
            StartMimbResponse startMimbResponse = new StartMimbResponse();
            MimbRest.parseStartMimbResponse(element, startMimbResponse);
            return startMimbResponse;
        }
        return null;
    }

    private String createStartMimbDataProfilingRequestXml(StartMimbDataProfilingRequest startMimbDataProfilingRequest) {
        StringBuffer stringBuffer = MimbRest.createXml();
        MimbRest.appendStartMimbDataProfilingRequest(stringBuffer, startMimbDataProfilingRequest);
        return stringBuffer.toString();
    }

    private static void appendStartMimbDataProfilingRequest(StringBuffer stringBuffer, StartMimbDataProfilingRequest startMimbDataProfilingRequest) {
        stringBuffer.append("<StartMimbDataProfilingRequest");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns=\"http://metaintegration.com/MIMB/Integration/5\">");
        RunMimbDataProfilingRequest runMimbDataProfilingRequest = startMimbDataProfilingRequest.getRunRequest();
        if (runMimbDataProfilingRequest != null) {
            MimbRest.appendRunMimbDataProfilingRequest(stringBuffer, runMimbDataProfilingRequest);
        }
        stringBuffer.append("</StartMimbDataProfilingRequest>");
    }

    private static void appendRunMimbDataProfilingRequest(StringBuffer stringBuffer, RunMimbDataProfilingRequest runMimbDataProfilingRequest) {
        DataProfilingOptions dataProfilingOptions;
        stringBuffer.append("<RunMimbDataProfilingRequest");
        if (runMimbDataProfilingRequest.getLanguage() != null) {
            stringBuffer.append(" language=\"" + MimbRest.escapeXml(runMimbDataProfilingRequest.getLanguage()) + "\"");
        }
        if (runMimbDataProfilingRequest.getLogLevel() != null) {
            stringBuffer.append(" logLevel=\"" + runMimbDataProfilingRequest.getLogLevel() + "\"");
        }
        if (runMimbDataProfilingRequest.getUserIdentity() != null) {
            stringBuffer.append(" userIdentity=\"" + MimbRest.escapeXml(runMimbDataProfilingRequest.getUserIdentity()) + "\"");
        }
        stringBuffer.append(" >");
        BridgeRunConfigurationType bridgeRunConfigurationType = runMimbDataProfilingRequest.getImportBridgeConfiguration();
        if (bridgeRunConfigurationType != null) {
            stringBuffer.append("<Import");
            MimbRest.appendBridgeRunConfigType(stringBuffer, bridgeRunConfigurationType);
            stringBuffer.append(">");
            MimbRest.appendVaultParameter(stringBuffer, bridgeRunConfigurationType.getVaultParameter());
            MimbRest.appendBridgeParameters(stringBuffer, bridgeRunConfigurationType.getBridgeParameter());
            stringBuffer.append("</Import>");
        }
        if ((dataProfilingOptions = runMimbDataProfilingRequest.getDataProfilingOptions()) != null) {
            stringBuffer.append("<DataProfilingOptions>");
            MimbRest.appendDataProfilingOptions(stringBuffer, dataProfilingOptions);
            stringBuffer.append("</DataProfilingOptions>");
        }
        stringBuffer.append("</RunMimbDataProfilingRequest>");
    }

    private static void appendDataProfilingOptions(StringBuffer stringBuffer, DataProfilingOptions dataProfilingOptions) {
        stringBuffer.append("<OutputDirectory>");
        stringBuffer.append(MimbRest.escapeXml(dataProfilingOptions.getOutputDirectory()));
        stringBuffer.append("</OutputDirectory>");
        stringBuffer.append("<DataSampling ");
        stringBuffer.append("enabled=\"").append(dataProfilingOptions.isDataSamplingEnabled() ? "true" : "false").append("\" ");
        stringBuffer.append("rowLimit=\"").append(dataProfilingOptions.getSamplingRowLimit()).append("\" ");
        stringBuffer.append("/>");
        stringBuffer.append("<DataProfiling ");
        stringBuffer.append("enabled=\"").append(dataProfilingOptions.isDataProfilingEnabled() ? "true" : "false").append("\" ");
        stringBuffer.append("rowLimit=\"").append(dataProfilingOptions.getProfilingRowLimit()).append("\" ");
        stringBuffer.append("/>");
        stringBuffer.append("<OperationalMetadata ");
        stringBuffer.append("enabled=\"").append(dataProfilingOptions.isOperationalMetadataEnabled() ? "true" : "false").append("\" ");
        stringBuffer.append("/>");
        for (DataProfilingObject dataProfilingObject : dataProfilingOptions.getObjects()) {
            stringBuffer.append("<Object ");
            stringBuffer.append("internalId=\"").append(MimbRest.escapeXml(dataProfilingObject.getInternalId())).append("\" ");
            stringBuffer.append("externalId=\"").append(MimbRest.escapeXml(dataProfilingObject.getExternalId())).append("\" ");
            if (dataProfilingObject.getType() != null && !dataProfilingObject.getType().isEmpty()) {
                stringBuffer.append("type=\"").append(MimbRest.escapeXml(dataProfilingObject.getType())).append("\" ");
            }
            if (dataProfilingObject.getPattern() != null && !dataProfilingObject.getPattern().isEmpty()) {
                stringBuffer.append("pattern=\"").append(MimbRest.escapeXml(dataProfilingObject.getPattern())).append("\" ");
            }
            if (dataProfilingObject.getLastModifiedTime() > 0L) {
                stringBuffer.append("lastModifiedTime=\"").append(dataProfilingObject.getLastModifiedTime()).append("\" ");
            }
            if (dataProfilingObject.getQuery() != null && !dataProfilingObject.getQuery().isEmpty()) {
                stringBuffer.append("query=\"").append(MimbRest.escapeXml(dataProfilingObject.getQuery())).append("\" ");
            }
            if (dataProfilingObject.getDqQuery() != null && !dataProfilingObject.getDqQuery().isEmpty()) {
                stringBuffer.append("dqQuery=\"").append(MimbRest.escapeXml(dataProfilingObject.getDqQuery())).append("\" ");
            }
            stringBuffer.append("/>");
        }
    }

    private static void parseLog(Element element, LogType logType) {
        logType.setHasMoreLines(Boolean.parseBoolean(element.getAttribute("hasMoreLines")));
        ArrayList<Element> arrayList = XmlUtil.getChildElements(element, null, "Message");
        MessageType[] messageTypeArray = new MessageType[arrayList.size()];
        int n = 0;
        for (Element element2 : arrayList) {
            MessageType messageType = new MessageType();
            Calendar calendar = DateUtil.getUtcCalendar();
            calendar.setTime(DateUtil.parseUtcDate(element2.getAttribute("timestamp")));
            messageType.setTimestamp(calendar);
            messageType.setThreadId(element2.getAttribute("threadId"));
            messageType.setType(MessageLevel.fromString(element2.getAttribute("type")));
            String string = XmlUtil.getNonNullElementValue(element2);
            messageType.set_value(string);
            messageType.setCode(element2.getAttribute("code"));
            messageType.setStackTrace(element2.getAttribute("stackTrace"));
            messageTypeArray[n++] = messageType;
        }
        logType.setMessage(messageTypeArray);
    }
}

