/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.mimb;

import MITI.messages.MimbAxis.SFCL;
import MITI.mimb.bridge.Bridge;
import MITI.mimb.bridge.BridgeId;
import MITI.mimb.bridge.BridgeSpecification;
import MITI.mimb.driver.BridgeConfiguration;
import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.MimbSession;
import MITI.mimb.driver.MimbStatus;
import MITI.mimb.driver.RequestOptions;
import MITI.mimb.driver.ValidationLevel;
import MITI.mimb.log.MimbLog;
import MITI.sf.client.axis.AbstractMimbClient;
import MITI.sf.client.axis.Log;
import MITI.sf.client.axis.MimbClient;
import MITI.sf.client.axis.MimbUtil;
import MITI.sf.client.axis.gen.BridgeListType;
import MITI.sf.client.axis.gen.BridgeParameterType;
import MITI.sf.client.axis.gen.BridgeRunConfigurationType;
import MITI.sf.client.axis.gen.BrowseType;
import MITI.sf.client.axis.gen.DataProfilingOptions;
import MITI.sf.client.axis.gen.DirectionType;
import MITI.sf.client.axis.gen.GetBridgeInformationRequest;
import MITI.sf.client.axis.gen.GetBridgeInformationResponse;
import MITI.sf.client.axis.gen.GetBridgeListResponse;
import MITI.sf.client.axis.gen.GetBridgeSpecsRequest;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponse;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusRequest;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusResponse;
import MITI.sf.client.axis.gen.LogType;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.MimbErrorResponse;
import MITI.sf.client.axis.gen.OEMLicenseToken;
import MITI.sf.client.axis.gen.OpenModeType;
import MITI.sf.client.axis.gen.ResetCacheType;
import MITI.sf.client.axis.gen.RunMimbType;
import MITI.sf.client.axis.gen.StartBrowseRequest;
import MITI.sf.client.axis.gen.StartMimbRequest;
import MITI.sf.client.axis.gen.StartMimbResponse;
import MITI.sf.client.axis.gen.StartTestRequest;
import MITI.sf.client.axis.gen.StopMimbExecutionRequest;
import MITI.sf.client.axis.gen.TestType;
import MITI.sf.client.axis.gen.TypeType;
import MITI.sf.client.axis.gen.ValidationLevelType;
import MITI.sf.client.axis.gen.VaultParameterType;
import MITI.sf.client.mimb.DataProfilingProcess;
import MITI.sf.client.mimb.MimbDriver;
import MITI.sf.client.mimb.MimbDriverLogAdapter;
import MITI.sf.client.mimb.MimbDriverUtil;
import MITI.sf.client.mimb.MimbProcess;
import MITI.sf.client.mimb.MimbProcessMonitor;
import MITI.sf.client.mimb.Process;
import MITI.sf.client.mimb.RemoteFileProcessor;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RemoteMimbDriver
extends MimbDriver {
    private AbstractMimbClient mimbClient;
    private boolean isMimbServerLocal;
    private boolean compressData = false;
    private OEMLicenseToken oemLicenseToken = null;
    private String userIdentity = null;
    private Map<String, MimbDriverLogAdapter> sessionLogs = new HashMap<String, MimbDriverLogAdapter>();
    private MITI.mimb.driver.MimbDriver internalDriver;

    public RemoteMimbDriver(String string, String string2) throws IOException {
        this(string, RemoteMimbDriver.isLocalUrl(string), false, string2);
    }

    public RemoteMimbDriver(String string, String string2, String string3) throws IOException {
        this(string, RemoteMimbDriver.isLocalUrl(string), false, string2, string3);
    }

    public RemoteMimbDriver(String string, boolean bl, boolean bl2, String string2) throws IOException {
        this(string, bl, bl2, string2, null);
    }

    public RemoteMimbDriver(String string, boolean bl, boolean bl2, String string2, String string3) throws IOException {
        this(new MimbClient(string), bl, bl2, string2, string3);
    }

    public RemoteMimbDriver(AbstractMimbClient abstractMimbClient, boolean bl, boolean bl2, String string, String string2) throws IOException {
        this.mimbClient = abstractMimbClient;
        if (string != null) {
            this.oemLicenseToken = MimbUtil.getOemLicenseToken(abstractMimbClient, string);
        }
        this.isMimbServerLocal = bl;
        this.compressData = bl2;
        this.userIdentity = string2;
        try {
            this.internalDriver = MITI.mimb.driver.MimbDriver.createRemoteDriver((String)abstractMimbClient.getMimbUrl(), (String)string);
        }
        catch (DriverError driverError) {
            // empty catch block
        }
    }

    private RequestOptions getInternalOptions() {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setLang(this.getLanguage());
        requestOptions.setValidationLevel(ValidationLevel.BASIC);
        return requestOptions;
    }

    private static boolean isLocalUrl(String string) {
        return (string = string.toLowerCase()).startsWith("http://localhost:") || string.startsWith("https://localhost:") || string.startsWith("http://127.0.0.1:") || string.startsWith("https://127.0.0.1:");
    }

    public String toString() {
        return "Remote MIMB at: " + this.mimbClient.getMimbUrl();
    }

    @Override
    public boolean executeImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map3, Map<String, String> map4, boolean bl2, ResetCacheType resetCacheType, ValidationLevelType validationLevelType, Log log, int n) throws RemoteException, IOException {
        if (this.internalDriver != null) {
            boolean bl3 = false;
            try {
                BridgeConfiguration bridgeConfiguration = MimbDriverUtil.prepareBridgeConfig(string, BridgeId.Direction.IMPORT, getBridgeInformationResponse, map, map2, bl);
                BridgeConfiguration bridgeConfiguration2 = MimbDriverUtil.prepareBridgeConfig(string2, BridgeId.Direction.EXPORT, getBridgeInformationResponse2, map3, map4, bl2);
                MimbDriverLogAdapter mimbDriverLogAdapter = new MimbDriverLogAdapter(log, n);
                RequestOptions requestOptions = this.getInternalOptions();
                requestOptions.setValidationLevel(ValidationLevel.getByName((String)validationLevelType.getValue()));
                bl3 = this.internalDriver.run(bridgeConfiguration, bridgeConfiguration2, requestOptions, (MimbLog)mimbDriverLogAdapter);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return bl3;
        }
        try {
            String string3 = null;
            if (getBridgeInformationResponse != null) {
                string3 = getBridgeInformationResponse.getBridgeDisplayName();
            }
            String string4 = null;
            if (getBridgeInformationResponse2 != null) {
                string4 = getBridgeInformationResponse2.getBridgeDisplayName();
            }
            ArrayList<RemoteFileProcessor> arrayList = null;
            if (bl && !this.isMimbServerLocal) {
                arrayList = new ArrayList<RemoteFileProcessor>();
            }
            VaultParameterType vaultParameterType = this.prepareVaultParameters(map);
            BridgeParameterType[] bridgeParameterTypeArray = this.prepareBridgeParameters(string, DirectionType.IMPORT, getBridgeInformationResponse, map2, arrayList, this.compressData);
            ArrayList<RemoteFileProcessor> arrayList2 = null;
            if (bl2 && !this.isMimbServerLocal) {
                arrayList2 = new ArrayList<RemoteFileProcessor>();
            }
            VaultParameterType vaultParameterType2 = this.prepareVaultParameters(map3);
            BridgeParameterType[] bridgeParameterTypeArray2 = this.prepareBridgeParameters(string2, DirectionType.EXPORT, getBridgeInformationResponse2, map4, arrayList2, this.compressData);
            this.preProcessFiles(arrayList);
            this.preProcessFiles(arrayList2);
            boolean bl4 = this.executeMimb(validationLevelType, string, string3, vaultParameterType, bridgeParameterTypeArray, string2, string4, vaultParameterType2, bridgeParameterTypeArray2, resetCacheType, log, n, 10, this.getWaitTimeout());
            this.postProcessFiles(arrayList, bl4);
            this.postProcessFiles(arrayList2, bl4);
            return bl4;
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean browse(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, boolean bl, String string3, Log log, int n) throws RemoteException, IOException {
        if (this.internalDriver != null) {
            boolean bl2 = false;
            try {
                BridgeId.Direction direction = directionType == DirectionType.IMPORT ? BridgeId.Direction.IMPORT : BridgeId.Direction.EXPORT;
                BridgeConfiguration bridgeConfiguration = MimbDriverUtil.prepareBridgeConfig(string, direction, getBridgeInformationResponse, null, map, bl);
                MimbDriverLogAdapter mimbDriverLogAdapter = new MimbDriverLogAdapter(log, n);
                RequestOptions requestOptions = this.getInternalOptions();
                requestOptions.setValidationLevel(ValidationLevel.BASIC);
                File file = new File(string3);
                bl2 = this.internalDriver.browse(bridgeConfiguration, string2, file, requestOptions, (MimbLog)mimbDriverLogAdapter);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return bl2;
        }
        try {
            Object object;
            ArrayList<RemoteFileProcessor> arrayList = null;
            BridgeParameterType bridgeParameterType = null;
            if (bl && !this.isMimbServerLocal) {
                arrayList = new ArrayList<RemoteFileProcessor>();
                bridgeParameterType = new BridgeParameterType();
                bridgeParameterType.set_value(string3);
                object = new RemoteFileProcessor(OpenModeType.WRITE, TypeType.FILE, bridgeParameterType, false);
                arrayList.add((RemoteFileProcessor)object);
            }
            object = this.prepareBridgeParameters(string, directionType, getBridgeInformationResponse, map, arrayList, false);
            this.preProcessFiles(arrayList);
            if (bridgeParameterType != null) {
                string3 = bridgeParameterType.get_value();
            }
            boolean bl3 = this.browseMimb(this.mimbClient, string, directionType, null, (BridgeParameterType[])object, string2, string3, log, n, 10, this.getWaitTimeout(), this.oemLicenseToken);
            this.postProcessFiles(arrayList, bl3);
            return bl3;
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean browse(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, String string2, boolean bl, File file, Log log, int n) throws RemoteException, IOException {
        if (this.internalDriver != null) {
            boolean bl2 = false;
            try {
                BridgeId.Direction direction = directionType == DirectionType.IMPORT ? BridgeId.Direction.IMPORT : BridgeId.Direction.EXPORT;
                BridgeConfiguration bridgeConfiguration = MimbDriverUtil.prepareBridgeConfig(string, direction, getBridgeInformationResponse, map, map2, bl);
                MimbDriverLogAdapter mimbDriverLogAdapter = new MimbDriverLogAdapter(log, n);
                RequestOptions requestOptions = this.getInternalOptions();
                requestOptions.setValidationLevel(ValidationLevel.BASIC);
                bl2 = this.internalDriver.browse(bridgeConfiguration, string2, file, requestOptions, (MimbLog)mimbDriverLogAdapter);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return bl2;
        }
        try {
            Object object;
            ArrayList<RemoteFileProcessor> arrayList = null;
            BridgeParameterType bridgeParameterType = null;
            if (!this.isMimbServerLocal) {
                arrayList = new ArrayList<RemoteFileProcessor>();
                bridgeParameterType = new BridgeParameterType();
                bridgeParameterType.set_value(file.getAbsolutePath());
                object = new RemoteFileProcessor(OpenModeType.WRITE, TypeType.FILE, bridgeParameterType, false);
                arrayList.add((RemoteFileProcessor)object);
            }
            object = this.prepareVaultParameters(map);
            BridgeParameterType[] bridgeParameterTypeArray = this.prepareBridgeParameters(string, directionType, getBridgeInformationResponse, map2, bl ? arrayList : null, false);
            this.preProcessFiles(arrayList);
            String string3 = file.getAbsolutePath();
            if (bridgeParameterType != null) {
                string3 = bridgeParameterType.get_value();
            }
            boolean bl3 = this.browseMimb(this.mimbClient, string, directionType, (VaultParameterType)object, bridgeParameterTypeArray, string2, string3, log, n, 10, this.getWaitTimeout(), this.oemLicenseToken);
            this.postProcessFiles(arrayList, bl3);
            return bl3;
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean test(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, Log log, int n) throws RemoteException, IOException {
        if (this.internalDriver != null) {
            boolean bl2 = false;
            try {
                BridgeId.Direction direction = directionType == DirectionType.IMPORT ? BridgeId.Direction.IMPORT : BridgeId.Direction.EXPORT;
                BridgeConfiguration bridgeConfiguration = MimbDriverUtil.prepareBridgeConfig(string, direction, getBridgeInformationResponse, map, map2, bl);
                MimbDriverLogAdapter mimbDriverLogAdapter = new MimbDriverLogAdapter(log, n);
                RequestOptions requestOptions = this.getInternalOptions();
                bl2 = this.internalDriver.test(bridgeConfiguration, requestOptions, (MimbLog)mimbDriverLogAdapter);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return bl2;
        }
        try {
            ArrayList<RemoteFileProcessor> arrayList = null;
            if (bl && !this.isMimbServerLocal) {
                arrayList = new ArrayList<RemoteFileProcessor>();
            }
            VaultParameterType vaultParameterType = this.prepareVaultParameters(map);
            BridgeParameterType[] bridgeParameterTypeArray = this.prepareBridgeParameters(string, directionType, getBridgeInformationResponse, map2, arrayList, false);
            this.preProcessFiles(arrayList);
            boolean bl3 = this.testMimb(string, directionType, vaultParameterType, bridgeParameterTypeArray, log, n, 10, this.getWaitTimeout());
            this.postProcessFiles(arrayList, bl3);
            return bl3;
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public GetBridgeInformationResponse getBridgeInfo(String string, DirectionType directionType) throws MimbAgentFault, MimbErrorResponse, RemoteException {
        if (this.internalDriver != null) {
            GetBridgeInformationResponse getBridgeInformationResponse = null;
            try {
                BridgeId.Direction direction = directionType == DirectionType.IMPORT ? BridgeId.Direction.IMPORT : BridgeId.Direction.EXPORT;
                BridgeId bridgeId = new BridgeId(string, direction);
                RequestOptions requestOptions = this.getInternalOptions();
                Bridge bridge = this.internalDriver.getBridge(bridgeId, requestOptions);
                getBridgeInformationResponse = MimbDriverUtil.convertBridgeInfo(bridge);
                getBridgeInformationResponse.setLanguage(this.getLanguage());
                getBridgeInformationResponse.setUserIdentity(this.userIdentity);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return getBridgeInformationResponse;
        }
        return this.mimbClient.getMimb().getBridgeInformation(new GetBridgeInformationRequest(string, directionType, null, this.getLanguage(), null), this.oemLicenseToken);
    }

    @Override
    public GetBridgeListResponse getBridgeList(DirectionType directionType) throws MimbAgentFault, MimbErrorResponse, RemoteException {
        if (this.internalDriver != null) {
            GetBridgeListResponse getBridgeListResponse = null;
            try {
                BridgeId.Direction direction = directionType == DirectionType.IMPORT ? BridgeId.Direction.IMPORT : BridgeId.Direction.EXPORT;
                RequestOptions requestOptions = this.getInternalOptions();
                Collection collection = this.internalDriver.getBridgeList(direction, requestOptions);
                getBridgeListResponse = MimbDriverUtil.convert(collection);
                getBridgeListResponse.setDirection(directionType);
                getBridgeListResponse.setLanguage(this.getLanguage());
                getBridgeListResponse.setUserIdentity(this.userIdentity);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return getBridgeListResponse;
        }
        try {
            return this.mimbClient.getMimb().getBridgeList(new BridgeListType(directionType, Boolean.FALSE, null, this.getLanguage()), this.oemLicenseToken);
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public GetBridgeSpecsResponse getBridgeSpecs() throws MimbAgentFault, MimbErrorResponse, RemoteException {
        if (this.internalDriver != null) {
            // empty if block
        }
        try {
            return this.mimbClient.getMimb().getBridgeSpecs(new GetBridgeSpecsRequest(), this.oemLicenseToken);
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public GetBridgeSpecsResponse getBridgeSpecs(String string, DirectionType directionType) throws MimbAgentFault, MimbErrorResponse, RemoteException {
        if (this.internalDriver != null) {
            GetBridgeSpecsResponse getBridgeSpecsResponse = null;
            try {
                BridgeId.Direction direction = directionType == DirectionType.IMPORT ? BridgeId.Direction.IMPORT : BridgeId.Direction.EXPORT;
                BridgeId bridgeId = new BridgeId(string, direction);
                RequestOptions requestOptions = this.getInternalOptions();
                BridgeSpecification bridgeSpecification = this.internalDriver.getBridgeSpecification(bridgeId, requestOptions);
                getBridgeSpecsResponse = MimbDriverUtil.convert(bridgeSpecification);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return getBridgeSpecsResponse;
        }
        try {
            return this.mimbClient.getMimb().getBridgeSpecs(new GetBridgeSpecsRequest(string, directionType), this.oemLicenseToken);
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public void deinit() {
        this.mimbClient.deinit();
    }

    private void preProcessFiles(Collection<RemoteFileProcessor> collection) throws RemoteException, IOException {
        if (collection != null) {
            for (RemoteFileProcessor remoteFileProcessor : collection) {
                remoteFileProcessor.preprocess(this.mimbClient);
            }
        }
    }

    private void postProcessFiles(Collection<RemoteFileProcessor> collection, boolean bl) throws RemoteException, IOException {
        if (collection != null) {
            for (RemoteFileProcessor remoteFileProcessor : collection) {
                remoteFileProcessor.postprocess(this.mimbClient, bl, this.oemLicenseToken);
            }
        }
    }

    public String startImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, ValidationLevelType validationLevelType) throws RemoteException, IOException {
        return this.startImportExport(string, getBridgeInformationResponse, null, map, string2, getBridgeInformationResponse2, null, map2, ResetCacheType.KEEP, this.compressData, validationLevelType, 0);
    }

    public String startImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, ResetCacheType resetCacheType, boolean bl, ValidationLevelType validationLevelType) throws RemoteException, IOException {
        return this.startImportExport(string, getBridgeInformationResponse, null, map, string2, getBridgeInformationResponse2, null, map2, resetCacheType, bl, validationLevelType, 0);
    }

    public String startImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map3, Map<String, String> map4, ResetCacheType resetCacheType, boolean bl, ValidationLevelType validationLevelType) throws RemoteException, IOException {
        return this.startImportExport(string, getBridgeInformationResponse, map, map2, string2, getBridgeInformationResponse2, map3, map4, resetCacheType, bl, validationLevelType, 0);
    }

    public String startImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map3, Map<String, String> map4, ResetCacheType resetCacheType, boolean bl, ValidationLevelType validationLevelType, int n) throws RemoteException, IOException {
        if (this.internalDriver != null) {
            MimbSession mimbSession = null;
            try {
                BridgeConfiguration bridgeConfiguration = MimbDriverUtil.prepareBridgeConfig(string, BridgeId.Direction.IMPORT, getBridgeInformationResponse, map, map2, false);
                BridgeConfiguration bridgeConfiguration2 = MimbDriverUtil.prepareBridgeConfig(string2, BridgeId.Direction.EXPORT, getBridgeInformationResponse2, map3, map4, false);
                MimbDriverLogAdapter mimbDriverLogAdapter = new MimbDriverLogAdapter(null, n);
                RequestOptions requestOptions = this.getInternalOptions();
                requestOptions.setValidationLevel(ValidationLevel.getByName((String)validationLevelType.getValue()));
                mimbSession = this.internalDriver.startRun(bridgeConfiguration, bridgeConfiguration2, requestOptions, (MimbLog)mimbDriverLogAdapter);
                this.sessionLogs.put(mimbSession.getSessionId(), mimbDriverLogAdapter);
                MimbProcessMonitor mimbProcessMonitor = new MimbProcessMonitor(this, this.internalDriver, mimbSession, 2, this.getWaitTimeout());
                mimbProcessMonitor.start();
                return mimbSession.getSessionId();
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
                return null;
            }
        }
        try {
            String string3 = null;
            if (getBridgeInformationResponse != null) {
                string3 = getBridgeInformationResponse.getBridgeDisplayName();
            }
            String string4 = null;
            if (getBridgeInformationResponse2 != null) {
                string4 = getBridgeInformationResponse2.getBridgeDisplayName();
            }
            VaultParameterType vaultParameterType = this.prepareVaultParameters(map);
            BridgeParameterType[] bridgeParameterTypeArray = this.prepareBridgeParameters(string, DirectionType.IMPORT, getBridgeInformationResponse, map2, null, bl);
            VaultParameterType vaultParameterType2 = this.prepareVaultParameters(map3);
            BridgeParameterType[] bridgeParameterTypeArray2 = this.prepareBridgeParameters(string2, DirectionType.EXPORT, getBridgeInformationResponse2, map4, null, bl);
            StartMimbResponse startMimbResponse = this.startMimb(validationLevelType, n, string, string3, vaultParameterType, bridgeParameterTypeArray, string2, string4, vaultParameterType2, bridgeParameterTypeArray2, resetCacheType);
            return startMimbResponse.getMimbProcessId();
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    @Override
    public GetMimbExecutionStatusResponse getMimbExecutionStatus(String string, int n, int n2) throws RemoteException {
        if (this.internalDriver != null) {
            GetMimbExecutionStatusResponse getMimbExecutionStatusResponse = null;
            MimbSession mimbSession = new MimbSession(string);
            MimbStatus mimbStatus = null;
            try {
                mimbStatus = this.internalDriver.getStatus(mimbSession);
                getMimbExecutionStatusResponse = MimbDriverUtil.convert(mimbStatus);
                MimbDriverLogAdapter mimbDriverLogAdapter = this.sessionLogs.get(string);
                if (mimbDriverLogAdapter != null) {
                    LogType logType = mimbDriverLogAdapter.getLogEvents(n);
                    getMimbExecutionStatusResponse.setLog(logType);
                }
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return getMimbExecutionStatusResponse;
        }
        try {
            GetMimbExecutionStatusRequest getMimbExecutionStatusRequest = new GetMimbExecutionStatusRequest();
            getMimbExecutionStatusRequest.setMimbProcessId(string);
            getMimbExecutionStatusRequest.setWaitForSecondsIfRunning(n2);
            getMimbExecutionStatusRequest.setMaxLogLines(n);
            return this.mimbClient.getMimb().getMimbExecutionStatus(getMimbExecutionStatusRequest, this.oemLicenseToken);
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
            throw new IllegalStateException();
        }
    }

    public void stopMimbExecution(String string) throws RemoteException {
        if (this.internalDriver != null) {
            MimbSession mimbSession = new MimbSession(string);
            try {
                this.internalDriver.stop(mimbSession);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
        }
        try {
            this.mimbClient.getMimb().stopMimbExecution(new StopMimbExecutionRequest(string));
        }
        catch (RemoteException remoteException) {
            AbstractMimbClient.processRemoteException(remoteException);
        }
    }

    private boolean executeMimb(ValidationLevelType validationLevelType, String string, String string2, VaultParameterType vaultParameterType, BridgeParameterType[] bridgeParameterTypeArray, String string3, String string4, VaultParameterType vaultParameterType2, BridgeParameterType[] bridgeParameterTypeArray2, ResetCacheType resetCacheType, Log log, int n, int n2, int n3) throws MimbErrorResponse, RemoteException {
        StartMimbResponse startMimbResponse = this.startMimb(validationLevelType, n, string, string2, vaultParameterType, bridgeParameterTypeArray, string3, string4, vaultParameterType2, bridgeParameterTypeArray2, resetCacheType);
        MimbProcess mimbProcess = new MimbProcess(this.mimbClient, this.oemLicenseToken);
        mimbProcess.start(startMimbResponse.getMimbProcessId());
        boolean bl = this.waitForMimbProcessCompletion(mimbProcess, log, n2, n3);
        return bl;
    }

    private StartMimbResponse startMimb(ValidationLevelType validationLevelType, int n, String string, String string2, VaultParameterType vaultParameterType, BridgeParameterType[] bridgeParameterTypeArray, String string3, String string4, VaultParameterType vaultParameterType2, BridgeParameterType[] bridgeParameterTypeArray2, ResetCacheType resetCacheType) throws MimbErrorResponse, RemoteException {
        RunMimbType runMimbType = new RunMimbType();
        runMimbType.setValidationLevel(validationLevelType);
        if (this.userIdentity != null) {
            runMimbType.setUserIdentity(this.userIdentity);
        }
        runMimbType.setLogLevel(n);
        runMimbType.setLanguage(this.getLanguage());
        runMimbType.setResetCache(resetCacheType);
        BridgeRunConfigurationType bridgeRunConfigurationType = new BridgeRunConfigurationType();
        BridgeRunConfigurationType bridgeRunConfigurationType2 = new BridgeRunConfigurationType();
        this.initBridgeConfig(bridgeRunConfigurationType, string, string2, vaultParameterType, bridgeParameterTypeArray);
        runMimbType.set_import(bridgeRunConfigurationType);
        this.initBridgeConfig(bridgeRunConfigurationType2, string3, string4, vaultParameterType2, bridgeParameterTypeArray2);
        runMimbType.setExport(bridgeRunConfigurationType2);
        StartMimbResponse startMimbResponse = this.mimbClient.getMimb().startMimb(new StartMimbRequest(runMimbType, null), this.oemLicenseToken);
        return startMimbResponse;
    }

    private void initBridgeConfig(BridgeRunConfigurationType bridgeRunConfigurationType, String string, String string2, VaultParameterType vaultParameterType, BridgeParameterType[] bridgeParameterTypeArray) {
        bridgeRunConfigurationType.setBridgeIdentifier(string);
        if (string2 != null) {
            bridgeRunConfigurationType.setBridgeDisplayName(string2);
        }
        if ("MIMB Intermediate Step".equals(string2)) {
            bridgeRunConfigurationType.setDisableLog(true);
        }
        bridgeRunConfigurationType.setVaultParameter(vaultParameterType);
        bridgeRunConfigurationType.setBridgeParameter(bridgeParameterTypeArray);
    }

    private boolean browseMimb(AbstractMimbClient abstractMimbClient, String string, DirectionType directionType, VaultParameterType vaultParameterType, BridgeParameterType[] bridgeParameterTypeArray, String string2, String string3, Log log, int n, int n2, int n3, OEMLicenseToken oEMLicenseToken) throws MimbErrorResponse, RemoteException {
        BrowseType browseType = new BrowseType();
        browseType.setLogLevel(n);
        browseType.setBridgeIdentifier(string);
        browseType.setDirection(directionType);
        browseType.setVaultParameter(vaultParameterType);
        browseType.setBridgeParameter(bridgeParameterTypeArray);
        browseType.setBrowseParameterIdentifier(string2);
        browseType.setDisableLog(false);
        browseType.setFile(string3);
        browseType.setLogLevel(n);
        StartMimbResponse startMimbResponse = abstractMimbClient.getMimb().startBrowse(new StartBrowseRequest(browseType, null), oEMLicenseToken);
        MimbProcess mimbProcess = new MimbProcess(this.mimbClient, oEMLicenseToken);
        mimbProcess.start(startMimbResponse.getMimbProcessId());
        boolean bl = this.waitForMimbProcessCompletion(mimbProcess, log, n2, n3);
        return bl;
    }

    private boolean waitForMimbProcessCompletion(MimbProcess mimbProcess, Log log, int n, int n2) throws MimbErrorResponse, RemoteException {
        return this.checkProcessCompletion(mimbProcess, log, n, n2);
    }

    private boolean testMimb(String string, DirectionType directionType, VaultParameterType vaultParameterType, BridgeParameterType[] bridgeParameterTypeArray, Log log, int n, int n2, int n3) throws MimbErrorResponse, RemoteException {
        TestType testType = new TestType();
        testType.setBridgeIdentifier(string);
        testType.setDirection(directionType);
        testType.setVaultParameter(vaultParameterType);
        testType.setBridgeParameter(bridgeParameterTypeArray);
        testType.setDisableLog(Boolean.FALSE);
        StartMimbResponse startMimbResponse = this.mimbClient.getMimb().startTest(new StartTestRequest(testType, null), this.oemLicenseToken);
        MimbProcess mimbProcess = new MimbProcess(this.mimbClient, this.oemLicenseToken);
        mimbProcess.start(startMimbResponse.getMimbProcessId());
        boolean bl = this.waitForMimbProcessCompletion(mimbProcess, log, n2, n3);
        return bl;
    }

    @Deprecated
    public boolean updateSemanticTypes(Log log, File file) throws RemoteException {
        return false;
    }

    @Deprecated
    public boolean upgrade(Log log, File file) throws IOException {
        return false;
    }

    @Deprecated
    public DataProfilingProcess startDataProfiling(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, boolean bl2, int n, DataProfilingOptions dataProfilingOptions, File file, Log log) throws RemoteException, IOException {
        return null;
    }

    @Deprecated
    public File getDataProfilingFile(DataProfilingProcess dataProfilingProcess, Log log) throws RemoteException, IOException {
        return null;
    }

    private <E> E checkProcessCompletion(Process<E> process, Log log, int n, int n2) throws MimbErrorResponse, RemoteException {
        long l = System.currentTimeMillis();
        while (true) {
            E e;
            process.check(log, n);
            if (process.isRunning()) {
                if (this.getEnvironment() != null && this.getEnvironment().isAbortRequested()) {
                    SFCL.DBG_ABORT_REQUESTED.log(new Object[0]);
                    process.stop();
                } else if (n2 > 0 && System.currentTimeMillis() - l > (long)n2 * 1000L) {
                    process.stop();
                }
            }
            if ((e = process.getResult()) != null) {
                return e;
            }
            if (!process.isRunning()) {
                return process.getResult();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

