/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.mimb;

import MITI.mimb.bridge.Bridge;
import MITI.mimb.bridge.BridgeId;
import MITI.mimb.bridge.BridgeInfo;
import MITI.mimb.bridge.BridgeParameter;
import MITI.mimb.bridge.BridgeParameterValue;
import MITI.mimb.bridge.BridgeSpecification;
import MITI.mimb.driver.BridgeConfiguration;
import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.MimbStatus;
import MITI.sf.client.axis.gen.BridgeSpecificationType;
import MITI.sf.client.axis.gen.BridgeType;
import MITI.sf.client.axis.gen.BridgeTypeDisplayName;
import MITI.sf.client.axis.gen.DirectionType;
import MITI.sf.client.axis.gen.GetBridgeInformationResponse;
import MITI.sf.client.axis.gen.GetBridgeInformationResponseBridgeParameter;
import MITI.sf.client.axis.gen.GetBridgeInformationResponseBridgeParameterPossibleValue;
import MITI.sf.client.axis.gen.GetBridgeListResponse;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponse;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridge;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeBridge;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodology;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeTool;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeToolInterface;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeVendor;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusResponse;
import MITI.sf.client.axis.gen.MimbErrorResponse;
import MITI.sf.client.axis.gen.OpenModeType;
import MITI.sf.client.axis.gen.TypeType;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class MimbDriverUtil {
    public static GetBridgeSpecsResponse convert(BridgeSpecification bridgeSpecification) {
        GetBridgeSpecsResponseModelBridge getBridgeSpecsResponseModelBridge;
        GetBridgeSpecsResponse getBridgeSpecsResponse = new GetBridgeSpecsResponse();
        GetBridgeSpecsResponseModelBridge[] getBridgeSpecsResponseModelBridgeArray = new GetBridgeSpecsResponseModelBridge[1];
        getBridgeSpecsResponse.setModelBridge(getBridgeSpecsResponseModelBridgeArray);
        getBridgeSpecsResponseModelBridgeArray[0] = getBridgeSpecsResponseModelBridge = new GetBridgeSpecsResponseModelBridge();
        GetBridgeSpecsResponseModelBridgeBridge getBridgeSpecsResponseModelBridgeBridge = new GetBridgeSpecsResponseModelBridgeBridge();
        getBridgeSpecsResponseModelBridge.setBridge(getBridgeSpecsResponseModelBridgeBridge);
        getBridgeSpecsResponseModelBridgeBridge.setDirection(MimbDriverUtil.convert(bridgeSpecification.getBridgeId().getDirection()));
        getBridgeSpecsResponseModelBridgeBridge.setDisplayName(bridgeSpecification.getDisplayName());
        getBridgeSpecsResponseModelBridgeBridge.setId(bridgeSpecification.getBridgeId().getId());
        getBridgeSpecsResponseModelBridgeBridge.setIsAlias(bridgeSpecification.isAlias());
        getBridgeSpecsResponseModelBridgeBridge.setIsDataProfile(bridgeSpecification.isDataProfile());
        getBridgeSpecsResponseModelBridgeBridge.setIsEnabled(bridgeSpecification.isEnabled());
        getBridgeSpecsResponseModelBridgeBridge.setIsIncrementallyHarvestable(bridgeSpecification.isIncrementallyHarvestable());
        getBridgeSpecsResponseModelBridgeBridge.setIsMimbOemEnabled(bridgeSpecification.isMimbOemEnabled());
        getBridgeSpecsResponseModelBridgeBridge.setIsRepositoryBrowsable(bridgeSpecification.isRepositoryBrowsable());
        getBridgeSpecsResponseModelBridgeBridge.setIsRepositoryMultiModel(bridgeSpecification.isRepositoryMultiModel());
        getBridgeSpecsResponseModelBridgeBridge.setIsToolRequired(bridgeSpecification.isToolRequired());
        getBridgeSpecsResponseModelBridgeBridge.setIsWindowsOnly(bridgeSpecification.isWindowsOnly());
        getBridgeSpecsResponseModelBridgeBridge.setPartnershipLevel(bridgeSpecification.getPartnershipLevel());
        GetBridgeSpecsResponseModelBridgeMethodology getBridgeSpecsResponseModelBridgeMethodology = MimbDriverUtil.convert(bridgeSpecification.getMethodology());
        getBridgeSpecsResponseModelBridge.setMethodology(getBridgeSpecsResponseModelBridgeMethodology);
        GetBridgeSpecsResponseModelBridgeTool getBridgeSpecsResponseModelBridgeTool = MimbDriverUtil.convert(bridgeSpecification.getTool());
        getBridgeSpecsResponseModelBridge.setTool(getBridgeSpecsResponseModelBridgeTool);
        GetBridgeSpecsResponseModelBridgeToolInterface getBridgeSpecsResponseModelBridgeToolInterface = MimbDriverUtil.convert(bridgeSpecification.getToolInterface());
        getBridgeSpecsResponseModelBridge.setToolInterface(getBridgeSpecsResponseModelBridgeToolInterface);
        GetBridgeSpecsResponseModelBridgeVendor getBridgeSpecsResponseModelBridgeVendor = MimbDriverUtil.convert(bridgeSpecification.getVendor());
        getBridgeSpecsResponseModelBridge.setVendor(getBridgeSpecsResponseModelBridgeVendor);
        return getBridgeSpecsResponse;
    }

    public static GetBridgeSpecsResponseModelBridgeMethodology convert(BridgeSpecification.Methodology methodology) {
        GetBridgeSpecsResponseModelBridgeMethodology getBridgeSpecsResponseModelBridgeMethodology = new GetBridgeSpecsResponseModelBridgeMethodology();
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage = MimbDriverUtil.convertCoverage(methodology);
        getBridgeSpecsResponseModelBridgeMethodology.setMetadataCoverage(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage);
        getBridgeSpecsResponseModelBridgeMethodology.setSummary(methodology.getSummary());
        getBridgeSpecsResponseModelBridgeMethodology.setToolCategory(methodology.getToolCategory());
        return getBridgeSpecsResponseModelBridgeMethodology;
    }

    public static GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage convertCoverage(Object object) {
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage();
        return getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage;
    }

    public static GetBridgeSpecsResponseModelBridgeTool convert(BridgeSpecification.Tool tool) {
        GetBridgeSpecsResponseModelBridgeTool getBridgeSpecsResponseModelBridgeTool = new GetBridgeSpecsResponseModelBridgeTool();
        getBridgeSpecsResponseModelBridgeTool.setName(tool.getName());
        getBridgeSpecsResponseModelBridgeTool.setPreviousName(tool.getPreviousName());
        getBridgeSpecsResponseModelBridgeTool.setVersions(tool.getVersions());
        getBridgeSpecsResponseModelBridgeTool.setWeb(tool.getWeb());
        return getBridgeSpecsResponseModelBridgeTool;
    }

    public static GetBridgeSpecsResponseModelBridgeToolInterface convert(BridgeSpecification.ToolInterface toolInterface) {
        GetBridgeSpecsResponseModelBridgeToolInterface getBridgeSpecsResponseModelBridgeToolInterface = new GetBridgeSpecsResponseModelBridgeToolInterface();
        getBridgeSpecsResponseModelBridgeToolInterface.setApi(toolInterface.getApi());
        getBridgeSpecsResponseModelBridgeToolInterface.setFile(toolInterface.getFile());
        getBridgeSpecsResponseModelBridgeToolInterface.setSummary(toolInterface.getSummary());
        return getBridgeSpecsResponseModelBridgeToolInterface;
    }

    public static GetBridgeSpecsResponseModelBridgeVendor convert(BridgeSpecification.Vendor vendor) {
        GetBridgeSpecsResponseModelBridgeVendor getBridgeSpecsResponseModelBridgeVendor = new GetBridgeSpecsResponseModelBridgeVendor();
        getBridgeSpecsResponseModelBridgeVendor.setId(vendor.getId());
        getBridgeSpecsResponseModelBridgeVendor.setName(vendor.getName());
        getBridgeSpecsResponseModelBridgeVendor.setWeb(vendor.getWeb());
        return getBridgeSpecsResponseModelBridgeVendor;
    }

    public static DirectionType convert(BridgeId.Direction direction) {
        DirectionType directionType = direction == BridgeId.Direction.IMPORT ? DirectionType.IMPORT : DirectionType.EXPORT;
        return directionType;
    }

    public static void handleDriverError(DriverError driverError) throws MimbErrorResponse {
        MimbErrorResponse mimbErrorResponse = new MimbErrorResponse(driverError.getMessage(), driverError);
        mimbErrorResponse.setErrorCode(driverError.getMessage());
        throw mimbErrorResponse;
    }

    public static GetBridgeListResponse convert(Collection<Bridge> collection) {
        GetBridgeListResponse getBridgeListResponse = new GetBridgeListResponse();
        BridgeType[] bridgeTypeArray = new BridgeType[collection.size()];
        getBridgeListResponse.setBridge(bridgeTypeArray);
        int n = 0;
        boolean bl = false;
        for (Bridge bridge : collection) {
            BridgeType bridgeType = MimbDriverUtil.convert(bridge);
            bridgeTypeArray[n++] = bridgeType;
            if (bridgeType.getSpecification() == null) continue;
            bl = true;
        }
        getBridgeListResponse.setSpecification(bl);
        return getBridgeListResponse;
    }

    public static BridgeType convert(Bridge bridge) {
        BridgeType bridgeType = new BridgeType();
        bridgeType.setBridgeIdentifier(bridge.getBridgeId().getId());
        bridgeType.setDirection(MimbDriverUtil.convert(bridge.getBridgeId().getDirection()));
        BridgeTypeDisplayName bridgeTypeDisplayName = new BridgeTypeDisplayName();
        bridgeTypeDisplayName.setBridgeDisplayName(bridge.getDisplayName());
        bridgeType.setDisplayName(bridgeTypeDisplayName);
        if (bridge.getInfo() != null) {
            BridgeSpecificationType bridgeSpecificationType = MimbDriverUtil.convert(bridge.getInfo());
            bridgeType.setSpecification(bridgeSpecificationType);
        }
        if (bridge.getBridgeParameters() != null) {
            // empty if block
        }
        return bridgeType;
    }

    private static BridgeSpecificationType convert(BridgeInfo bridgeInfo) {
        BridgeSpecificationType bridgeSpecificationType = new BridgeSpecificationType();
        bridgeSpecificationType.setProductName(bridgeInfo.getProductName());
        bridgeSpecificationType.setProductCompany(bridgeInfo.getProductCompany());
        bridgeSpecificationType.setProductVersion(bridgeInfo.getProductVersion());
        bridgeSpecificationType.setProductWeb(bridgeInfo.getProductWeb());
        bridgeSpecificationType.setVersion(bridgeInfo.getVersion());
        bridgeSpecificationType.setMethodology(bridgeInfo.getMethodology());
        bridgeSpecificationType.setIsMultiModel(bridgeInfo.isMultiModel());
        return bridgeSpecificationType;
    }

    public static GetBridgeInformationResponse convertBridgeInfo(Bridge bridge) {
        Object object;
        GetBridgeInformationResponse getBridgeInformationResponse = new GetBridgeInformationResponse();
        getBridgeInformationResponse.setDirection(MimbDriverUtil.convert(bridge.getBridgeId().getDirection()));
        getBridgeInformationResponse.setBridgeIdentifier(bridge.getBridgeId().getId());
        getBridgeInformationResponse.setBridgeDisplayName(bridge.getDisplayName());
        getBridgeInformationResponse.setDescription(bridge.getDescription());
        if (bridge.getInfo() != null) {
            object = MimbDriverUtil.convert(bridge.getInfo());
            getBridgeInformationResponse.setSpecification((BridgeSpecificationType)object);
        }
        if ((object = bridge.getBridgeParameters()) != null) {
            GetBridgeInformationResponseBridgeParameter[] getBridgeInformationResponseBridgeParameterArray = new GetBridgeInformationResponseBridgeParameter[object.size()];
            int n = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                BridgeParameter bridgeParameter = (BridgeParameter)iterator.next();
                GetBridgeInformationResponseBridgeParameter getBridgeInformationResponseBridgeParameter = MimbDriverUtil.convert(bridgeParameter);
                getBridgeInformationResponseBridgeParameterArray[n++] = getBridgeInformationResponseBridgeParameter;
            }
            getBridgeInformationResponse.setBridgeParameter(getBridgeInformationResponseBridgeParameterArray);
        }
        return getBridgeInformationResponse;
    }

    private static GetBridgeInformationResponseBridgeParameter convert(BridgeParameter bridgeParameter) {
        Object object;
        GetBridgeInformationResponseBridgeParameter getBridgeInformationResponseBridgeParameter = new GetBridgeInformationResponseBridgeParameter();
        getBridgeInformationResponseBridgeParameter.setBridgeParameterIdentifier(bridgeParameter.getBridgeParameterIdentifier());
        getBridgeInformationResponseBridgeParameter.setDisplayName(bridgeParameter.getDisplayName());
        getBridgeInformationResponseBridgeParameter.setDescription(bridgeParameter.getDescription());
        getBridgeInformationResponseBridgeParameter.setDefaultValue(MimbDriverUtil.convert(bridgeParameter.getDefaultValue()));
        Collection collection = bridgeParameter.getFileExtensions();
        if (collection != null) {
            object = new String[collection.size()];
            object = collection.toArray((T[])object);
            getBridgeInformationResponseBridgeParameter.setFileExtension((String[])object);
        }
        getBridgeInformationResponseBridgeParameter.setMandatory(bridgeParameter.isMandatory());
        getBridgeInformationResponseBridgeParameter.setOpenMode(MimbDriverUtil.convert(bridgeParameter.getOpenMode()));
        getBridgeInformationResponseBridgeParameter.setTransferable(bridgeParameter.isTransferable());
        object = bridgeParameter.getPossibleValues();
        if (object != null) {
            int n = 0;
            GetBridgeInformationResponseBridgeParameterPossibleValue[] getBridgeInformationResponseBridgeParameterPossibleValueArray = new GetBridgeInformationResponseBridgeParameterPossibleValue[object.size()];
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                BridgeParameterValue bridgeParameterValue = (BridgeParameterValue)iterator.next();
                GetBridgeInformationResponseBridgeParameterPossibleValue getBridgeInformationResponseBridgeParameterPossibleValue = MimbDriverUtil.convertPossibleValue(bridgeParameterValue);
                getBridgeInformationResponseBridgeParameterPossibleValueArray[n++] = getBridgeInformationResponseBridgeParameterPossibleValue;
            }
            getBridgeInformationResponseBridgeParameter.setPossibleValue(getBridgeInformationResponseBridgeParameterPossibleValueArray);
        }
        getBridgeInformationResponseBridgeParameter.setType(MimbDriverUtil.convert(bridgeParameter.getType()));
        return getBridgeInformationResponseBridgeParameter;
    }

    private static TypeType convert(BridgeParameter.ParameterType parameterType) {
        TypeType typeType = TypeType.STRING;
        if (parameterType == BridgeParameter.ParameterType.BOOLEAN) {
            typeType = TypeType.BOOLEAN;
        } else if (parameterType == BridgeParameter.ParameterType.DATE) {
            typeType = TypeType.DATE;
        } else if (parameterType == BridgeParameter.ParameterType.DIRECTORY) {
            typeType = TypeType.DIRECTORY;
        } else if (parameterType == BridgeParameter.ParameterType.ENUMERATED) {
            typeType = TypeType.ENUMERATED;
        } else if (parameterType == BridgeParameter.ParameterType.FILE) {
            typeType = TypeType.FILE;
        } else if (parameterType == BridgeParameter.ParameterType.NUMERIC) {
            typeType = TypeType.NUMERIC;
        } else if (parameterType == BridgeParameter.ParameterType.PASSWORD) {
            typeType = TypeType.PASSWORD;
        } else if (parameterType == BridgeParameter.ParameterType.REPOSITORY_MODEL) {
            typeType = TypeType.REPOSITORY_MODEL;
        } else if (parameterType == BridgeParameter.ParameterType.REPOSITORY_SUBSET) {
            typeType = TypeType.REPOSITORY_SUBSET;
        }
        return typeType;
    }

    private static OpenModeType convert(BridgeParameter.OpenMode openMode) {
        OpenModeType openModeType = OpenModeType.DEFAULT;
        if (openMode == BridgeParameter.OpenMode.READ) {
            openModeType = OpenModeType.READ;
        } else if (openMode == BridgeParameter.OpenMode.WRITE) {
            openModeType = OpenModeType.WRITE;
        } else if (openMode == BridgeParameter.OpenMode.READWRITE) {
            openModeType = OpenModeType.READWRITE;
        }
        return openModeType;
    }

    private static GetBridgeInformationResponseBridgeParameterPossibleValue convertPossibleValue(BridgeParameterValue bridgeParameterValue) {
        GetBridgeInformationResponseBridgeParameterPossibleValue getBridgeInformationResponseBridgeParameterPossibleValue = new GetBridgeInformationResponseBridgeParameterPossibleValue();
        getBridgeInformationResponseBridgeParameterPossibleValue.setIdentifier(bridgeParameterValue.getId());
        getBridgeInformationResponseBridgeParameterPossibleValue.set_value(bridgeParameterValue.getValue());
        return getBridgeInformationResponseBridgeParameterPossibleValue;
    }

    private static MITI.sf.client.axis.gen.BridgeParameterValue convert(BridgeParameterValue bridgeParameterValue) {
        MITI.sf.client.axis.gen.BridgeParameterValue bridgeParameterValue2 = new MITI.sf.client.axis.gen.BridgeParameterValue();
        bridgeParameterValue2.set_value(bridgeParameterValue.getValue());
        return bridgeParameterValue2;
    }

    public static GetMimbExecutionStatusResponse convert(MimbStatus mimbStatus) {
        GetMimbExecutionStatusResponse getMimbExecutionStatusResponse = new GetMimbExecutionStatusResponse();
        if (mimbStatus == MimbStatus.ERROR) {
            getMimbExecutionStatusResponse.setIsRunning(false);
            getMimbExecutionStatusResponse.setIsSuccessful(false);
        } else if (mimbStatus == MimbStatus.SUCCESS) {
            getMimbExecutionStatusResponse.setIsRunning(false);
            getMimbExecutionStatusResponse.setIsSuccessful(true);
        } else if (mimbStatus == MimbStatus.INVALID || mimbStatus == MimbStatus.RUNNING) {
            getMimbExecutionStatusResponse.setIsRunning(true);
        }
        return getMimbExecutionStatusResponse;
    }

    public static BridgeConfiguration prepareBridgeConfig(String string, BridgeId.Direction direction, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl) {
        BridgeId bridgeId = new BridgeId(string, direction);
        BridgeConfiguration bridgeConfiguration = new BridgeConfiguration(bridgeId);
        String string2 = getBridgeInformationResponse != null ? getBridgeInformationResponse.getBridgeDisplayName() : null;
        bridgeConfiguration.setBridgeOptions(map2);
        bridgeConfiguration.setAreFilesLocal(bl);
        bridgeConfiguration.setBridgeDisplayName(string2);
        return bridgeConfiguration;
    }
}

