/*
 * Decompiled with CFR 0.152.
 */
package MITI.sf.client.mimb;

import MITI.MIRException;
import MITI.bridges.dataquality.DataQualityUtil;
import MITI.bridges.javabridgeinterface.BridgeSpecification;
import MITI.bridges.javabridgeinterface.DataQualityObjectId;
import MITI.bridges.javabridgeinterface.DataQualityOptions;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.javabridgeinterface.Parameters;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MimbAxis.SFCL;
import MITI.mimb.bridge.Bridge;
import MITI.mimb.bridge.BridgeId;
import MITI.mimb.driver.BridgeConfiguration;
import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.MimbSession;
import MITI.mimb.driver.MimbStatus;
import MITI.mimb.driver.RequestOptions;
import MITI.mimb.driver.ValidationLevel;
import MITI.mimb.executable.MimbExecutable;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.BrowseRequest;
import MITI.mimb.executable.requests.GenericOperationRequest;
import MITI.mimb.executable.requests.GetBridgeInformationRequest;
import MITI.mimb.executable.requests.GetBridgeListRequest;
import MITI.mimb.executable.requests.GetBridgeSpecsRequest;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.executable.requests.RunMimbExtendedRequest;
import MITI.mimb.executable.requests.TestRequest;
import MITI.mimb.executable.responses.BridgeInformationResponse;
import MITI.mimb.executable.responses.BridgeListResponse;
import MITI.mimb.executable.responses.BridgeSpecsResponse;
import MITI.mimb.executable.responses.ErrorResponse;
import MITI.mimb.executable.responses.Response;
import MITI.mimb.executable.responses.RunMimbResponse;
import MITI.mimb.log.MimbLog;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.sf.client.axis.Log;
import MITI.sf.client.axis.gen.BridgeParameterValue;
import MITI.sf.client.axis.gen.BridgeSpecificationType;
import MITI.sf.client.axis.gen.BridgeType;
import MITI.sf.client.axis.gen.BridgeTypeDisplayName;
import MITI.sf.client.axis.gen.DataProfilingObject;
import MITI.sf.client.axis.gen.DataProfilingOptions;
import MITI.sf.client.axis.gen.DirectionType;
import MITI.sf.client.axis.gen.GetBridgeInformationResponse;
import MITI.sf.client.axis.gen.GetBridgeInformationResponseBridgeParameter;
import MITI.sf.client.axis.gen.GetBridgeInformationResponseBridgeParameterPossibleValue;
import MITI.sf.client.axis.gen.GetBridgeListResponse;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponse;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridge;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeBridge;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodology;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeTool;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeToolInterface;
import MITI.sf.client.axis.gen.GetBridgeSpecsResponseModelBridgeVendor;
import MITI.sf.client.axis.gen.GetMimbExecutionStatusResponse;
import MITI.sf.client.axis.gen.LogType;
import MITI.sf.client.axis.gen.MessageLevel;
import MITI.sf.client.axis.gen.MessageType;
import MITI.sf.client.axis.gen.MimbAgentFault;
import MITI.sf.client.axis.gen.MimbErrorResponse;
import MITI.sf.client.axis.gen.OpenModeType;
import MITI.sf.client.axis.gen.ResetCacheType;
import MITI.sf.client.axis.gen.TypeType;
import MITI.sf.client.axis.gen.ValidationLevelType;
import MITI.sf.client.mimb.MimbAxisLogEventHandler;
import MITI.sf.client.mimb.MimbDriver;
import MITI.sf.client.mimb.MimbDriverLogAdapter;
import MITI.sf.client.mimb.MimbDriverUtil;
import MITI.sf.client.mimb.MimbProcessMonitor;
import MITI.util.log.BufferedLogEventHandler;
import MITI.util.log.LogEvent;
import MITI.util.log.LogEventHandler;
import MITI.util.log.MIRLogger;
import MITI.util.text.BridgeSpecificationLiteral;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class LocalMimbDriver
extends MimbDriver {
    public static final String MIMB_ERROR_RESPONSE = "MimbErrorResponse";
    private String oemPartnerToken = null;
    private String userIdentity = null;
    private File mimbHomeDir = null;
    private HashMap<String, LocalMimbThread> mimbThreads = new HashMap();
    private MITI.mimb.driver.MimbDriver internalDriver;

    public LocalMimbDriver(String string, String string2) {
        this(string, string2, null);
    }

    public LocalMimbDriver(String string, String string2, String string3) {
        this.oemPartnerToken = string2;
        this.userIdentity = string3;
        this.mimbHomeDir = new File(string);
        try {
            this.internalDriver = MITI.mimb.driver.MimbDriver.createLocalDriver((File)this.mimbHomeDir, (String)string2);
        }
        catch (DriverError driverError) {
            // empty catch block
        }
    }

    private RequestOptions getInternalOptions() {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setLang(this.getLanguage());
        requestOptions.setValidationLevel(ValidationLevel.BASIC);
        return requestOptions;
    }

    public String toString() {
        return "Local MIMB at: " + this.mimbHomeDir.getPath();
    }

    public String startImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, boolean bl, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map2, boolean bl2, ResetCacheType resetCacheType, ValidationLevelType validationLevelType, Log log, int n) throws RemoteException, IOException, SAXException {
        if (this.internalDriver != null) {
            MimbSession mimbSession = null;
            try {
                BridgeConfiguration bridgeConfiguration = MimbDriverUtil.prepareBridgeConfig(string, BridgeId.Direction.IMPORT, getBridgeInformationResponse, null, map, bl);
                BridgeConfiguration bridgeConfiguration2 = MimbDriverUtil.prepareBridgeConfig(string2, BridgeId.Direction.EXPORT, getBridgeInformationResponse2, null, map2, bl2);
                MimbDriverLogAdapter mimbDriverLogAdapter = new MimbDriverLogAdapter(log, n);
                RequestOptions requestOptions = this.getInternalOptions();
                requestOptions.setValidationLevel(ValidationLevel.getByName((String)validationLevelType.getValue()));
                mimbSession = this.internalDriver.startRun(bridgeConfiguration, bridgeConfiguration2, requestOptions, (MimbLog)mimbDriverLogAdapter);
                MimbProcessMonitor mimbProcessMonitor = new MimbProcessMonitor(this, this.internalDriver, mimbSession, 2, this.getWaitTimeout());
                mimbProcessMonitor.start();
                return mimbSession.getSessionId();
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
                return null;
            }
        }
        LocalMimbThread localMimbThread = this.startMimb(string, getBridgeInformationResponse, null, map, bl, string2, getBridgeInformationResponse2, null, map2, bl2, resetCacheType, validationLevelType, log, n);
        return localMimbThread.getName();
    }

    public String startDataProfiling(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, DataProfilingOptions dataProfilingOptions, File file, Log log, int n) throws RemoteException, IOException {
        Object object;
        DataProfilingObject dataProfilingObject2;
        String string2 = null;
        if (getBridgeInformationResponse != null) {
            string2 = getBridgeInformationResponse.getBridgeDisplayName();
        }
        MimbOptions mimbOptions = this.prepareUserOptions(string, DirectionType.IMPORT, getBridgeInformationResponse, map2);
        DataQualityOptions dataQualityOptions = new DataQualityOptions();
        dataQualityOptions.setDataProfilingEnabled(dataProfilingOptions.isDataProfilingEnabled());
        dataQualityOptions.setDataSamplingEnabled(dataProfilingOptions.isDataSamplingEnabled());
        dataQualityOptions.setOutputDir(file);
        dataQualityOptions.setProfilingRowLimit(dataProfilingOptions.getProfilingRowLimit());
        dataQualityOptions.setSamplingRowLimit(dataProfilingOptions.getSamplingRowLimit());
        dataQualityOptions.setOperationalMetadataEnabled(dataProfilingOptions.isOperationalMetadataEnabled());
        ArrayList<DataQualityObjectId> arrayList = new ArrayList<DataQualityObjectId>();
        for (DataProfilingObject dataProfilingObject2 : dataProfilingOptions.getObjects()) {
            object = new DataQualityObjectId();
            ((DataQualityObjectId)object).setLastUpdateTime(dataProfilingObject2.getLastModifiedTime());
            ((DataQualityObjectId)object).setPattern(dataProfilingObject2.getPattern());
            ((DataQualityObjectId)object).setQuery(dataProfilingObject2.getQuery());
            ((DataQualityObjectId)object).setType(dataProfilingObject2.getType());
            ((DataQualityObjectId)object).setMmObjectId(dataProfilingObject2.getInternalId());
            String string3 = dataProfilingObject2.getExternalId();
            ((DataQualityObjectId)object).setMimbObjectId(string3.split("\u2028"));
            arrayList.add((DataQualityObjectId)object);
        }
        dataQualityOptions.setObjectIds(arrayList);
        BridgeRunRequest bridgeRunRequest = new BridgeRunRequest();
        bridgeRunRequest.setBridgeId(string);
        bridgeRunRequest.setBridgeDisplayName(string2);
        bridgeRunRequest.setDisableLog(false);
        bridgeRunRequest.setLanguage(this.getLanguage());
        if (this.userIdentity != null) {
            bridgeRunRequest.setUserIdentity(this.userIdentity);
        }
        bridgeRunRequest.setUserOptions(mimbOptions);
        bridgeRunRequest.setVaultOptions(map);
        dataProfilingObject2 = new GenericOperationRequest();
        dataProfilingObject2.setImportRequest(bridgeRunRequest);
        dataProfilingObject2.setLanguage(this.getLanguage());
        dataProfilingObject2.setOptions(dataQualityOptions);
        if (this.userIdentity != null) {
            dataProfilingObject2.setUserIdentity(this.userIdentity);
        }
        object = new LocalMimbThread((Request)dataProfilingObject2, new MimbAxisLogEventHandler(log));
        ((Thread)object).start();
        return ((Thread)object).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMimbExecutionStatusResponse getMimbExecutionStatus(String string, int n, int n2) throws RemoteException {
        if (this.internalDriver != null) {
            GetMimbExecutionStatusResponse getMimbExecutionStatusResponse = null;
            MimbSession mimbSession = new MimbSession(string);
            MimbStatus mimbStatus = null;
            try {
                mimbStatus = this.internalDriver.getStatus(mimbSession);
                getMimbExecutionStatusResponse = MimbDriverUtil.convert(mimbStatus);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return getMimbExecutionStatusResponse;
        }
        LocalMimbThread localMimbThread = null;
        Object object = this.mimbThreads;
        synchronized (object) {
            localMimbThread = this.mimbThreads.get(string);
        }
        object = new GetMimbExecutionStatusResponse();
        ((GetMimbExecutionStatusResponse)object).setIsRunning(localMimbThread != null);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMimbExecution(String string) {
        Object object;
        if (this.internalDriver != null) {
            object = new MimbSession(string);
            try {
                this.internalDriver.stop(object);
            }
            catch (DriverError driverError) {
                // empty catch block
            }
        }
        object = null;
        HashMap<String, LocalMimbThread> hashMap = this.mimbThreads;
        synchronized (hashMap) {
            object = this.mimbThreads.get(string);
        }
        if (object != null) {
            this.stopMimb((LocalMimbThread)object);
        }
    }

    @Override
    public boolean executeImportExport(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map3, Map<String, String> map4, boolean bl2, ResetCacheType resetCacheType, ValidationLevelType validationLevelType, Log log, int n) throws RemoteException {
        if (this.internalDriver != null) {
            boolean bl3 = false;
            try {
                BridgeConfiguration bridgeConfiguration = MimbDriverUtil.prepareBridgeConfig(string, BridgeId.Direction.IMPORT, getBridgeInformationResponse, map, map2, bl);
                BridgeConfiguration bridgeConfiguration2 = MimbDriverUtil.prepareBridgeConfig(string2, BridgeId.Direction.EXPORT, getBridgeInformationResponse2, map3, map4, bl2);
                MimbDriverLogAdapter mimbDriverLogAdapter = new MimbDriverLogAdapter(log, n);
                RequestOptions requestOptions = this.getInternalOptions();
                requestOptions.setValidationLevel(ValidationLevel.getByName((String)validationLevelType.getValue()));
                bl3 = this.internalDriver.run(bridgeConfiguration, bridgeConfiguration2, requestOptions, (MimbLog)mimbDriverLogAdapter);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return bl3;
        }
        LocalMimbThread localMimbThread = this.startMimb(string, getBridgeInformationResponse, map, map2, bl, string2, getBridgeInformationResponse2, map3, map4, bl2, resetCacheType, validationLevelType, log, n);
        Response response = this.waitForMimb(localMimbThread, this.getWaitTimeout());
        return response instanceof RunMimbResponse;
    }

    private LocalMimbThread startMimb(String string, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, String string2, GetBridgeInformationResponse getBridgeInformationResponse2, Map<String, String> map3, Map<String, String> map4, boolean bl2, ResetCacheType resetCacheType, ValidationLevelType validationLevelType, Log log, int n) throws RemoteException {
        MimbOptions mimbOptions = this.prepareUserOptions(string, DirectionType.IMPORT, getBridgeInformationResponse, map2);
        BridgeRunRequest bridgeRunRequest = new BridgeRunRequest();
        bridgeRunRequest.setBridgeId(string);
        if (getBridgeInformationResponse != null && getBridgeInformationResponse.getBridgeDisplayName() != null) {
            bridgeRunRequest.setBridgeDisplayName(getBridgeInformationResponse.getBridgeDisplayName());
            bridgeRunRequest.setDisableLog("MIMB Intermediate Step".equals(getBridgeInformationResponse.getBridgeDisplayName()));
        } else {
            bridgeRunRequest.setDisableLog(false);
        }
        bridgeRunRequest.setVaultOptions(map);
        bridgeRunRequest.setUserOptions(mimbOptions);
        MimbOptions mimbOptions2 = this.prepareUserOptions(string2, DirectionType.EXPORT, getBridgeInformationResponse2, map4);
        BridgeRunRequest bridgeRunRequest2 = new BridgeRunRequest();
        bridgeRunRequest2.setBridgeId(string2);
        if (getBridgeInformationResponse2 != null && getBridgeInformationResponse2.getBridgeDisplayName() != null) {
            bridgeRunRequest2.setBridgeDisplayName(getBridgeInformationResponse2.getBridgeDisplayName());
            bridgeRunRequest2.setDisableLog("MIMB Intermediate Step".equals(getBridgeInformationResponse2.getBridgeDisplayName()));
        } else {
            bridgeRunRequest2.setDisableLog(false);
        }
        bridgeRunRequest.setVaultOptions(map3);
        bridgeRunRequest2.setUserOptions(mimbOptions2);
        RunMimbExtendedRequest runMimbExtendedRequest = new RunMimbExtendedRequest();
        runMimbExtendedRequest.setImportRequest(bridgeRunRequest);
        runMimbExtendedRequest.setExportRequest(bridgeRunRequest2);
        if (this.userIdentity != null) {
            runMimbExtendedRequest.setUserIdentity(this.userIdentity);
        }
        runMimbExtendedRequest.setResetCache(resetCacheType != null ? resetCacheType.toString() : "");
        runMimbExtendedRequest.setLanguage(this.getLanguage());
        MIRValidationLevel.Enum enum_ = MIRValidationLevel.BASIC;
        if (validationLevelType == ValidationLevelType.ADVANCED) {
            enum_ = MIRValidationLevel.ADVANCED;
        } else if (validationLevelType == ValidationLevelType.NONE) {
            enum_ = MIRValidationLevel.NONE;
        }
        runMimbExtendedRequest.setValidationLevel(enum_);
        runMimbExtendedRequest.setLogLevel(new Integer(n).toString());
        LocalMimbThread localMimbThread = new LocalMimbThread((Request)runMimbExtendedRequest, new MimbAxisLogEventHandler(log));
        localMimbThread.start();
        return localMimbThread;
    }

    private Response waitForMimb(LocalMimbThread localMimbThread, int n) {
        long l = System.currentTimeMillis();
        while (localMimbThread.isAlive()) {
            if (this.getEnvironment() != null && this.getEnvironment().isAbortRequested()) {
                this.stopMimb(localMimbThread);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
            if (n > 0 && System.currentTimeMillis() > l + (long)n * 1000L) {
                this.stopMimb(localMimbThread);
                return null;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return localMimbThread.getResponse();
    }

    private void stopMimb(LocalMimbThread localMimbThread) {
        localMimbThread.interrupt();
    }

    private MimbOptions prepareUserOptions(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map) throws MimbAgentFault, MimbErrorResponse, RemoteException {
        MimbOptions mimbOptions = new MimbOptions();
        if (getBridgeInformationResponse == null) {
            getBridgeInformationResponse = this.getBridgeInfo(string, directionType);
        }
        GetBridgeInformationResponseBridgeParameter[] getBridgeInformationResponseBridgeParameterArray = getBridgeInformationResponse.getBridgeParameter();
        HashSet<String> hashSet = new HashSet<String>();
        if (getBridgeInformationResponseBridgeParameterArray != null) {
            for (GetBridgeInformationResponseBridgeParameter getBridgeInformationResponseBridgeParameter : getBridgeInformationResponseBridgeParameterArray) {
                String string2 = getBridgeInformationResponseBridgeParameter.getBridgeParameterIdentifier();
                String string3 = map.get(string2);
                hashSet.add(string2);
                if (string3 == null) continue;
                mimbOptions.addOption(string2, string3, "");
            }
        }
        for (String string4 : map.keySet()) {
            if (hashSet.contains(string4)) continue;
            String string5 = map.get(string4);
            mimbOptions.addOption(string4, string5, "");
        }
        return mimbOptions;
    }

    @Override
    public boolean browse(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, String string2, boolean bl, String string3, Log log, int n) throws RemoteException {
        File file = new File(string3);
        return this.browse(string, directionType, getBridgeInformationResponse, null, map, string2, bl, file, log, n);
    }

    @Override
    public boolean browse(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, String string2, boolean bl, File file, Log log, int n) throws RemoteException {
        if (this.internalDriver != null) {
            boolean bl2 = false;
            try {
                BridgeId.Direction direction = directionType == DirectionType.IMPORT ? BridgeId.Direction.IMPORT : BridgeId.Direction.EXPORT;
                BridgeConfiguration bridgeConfiguration = MimbDriverUtil.prepareBridgeConfig(string, direction, getBridgeInformationResponse, map, map2, bl);
                MimbDriverLogAdapter mimbDriverLogAdapter = new MimbDriverLogAdapter(log, n);
                RequestOptions requestOptions = this.getInternalOptions();
                requestOptions.setValidationLevel(ValidationLevel.BASIC);
                bl2 = this.internalDriver.browse(bridgeConfiguration, string2, file, requestOptions, (MimbLog)mimbDriverLogAdapter);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return bl2;
        }
        MimbOptions mimbOptions = this.prepareUserOptions(string, directionType, getBridgeInformationResponse, map2);
        BrowseRequest browseRequest = new BrowseRequest();
        browseRequest.setBridgeId(string);
        browseRequest.setBridgeDisplayName("");
        browseRequest.setVaultOptions(map);
        browseRequest.setUserOptions(mimbOptions);
        browseRequest.setIsExport(DirectionType.EXPORT.equals((Object)directionType));
        browseRequest.setBowseParameterIdentifier(string2);
        browseRequest.setBrowseFile(file.getAbsolutePath());
        browseRequest.setDisableLog(false);
        browseRequest.setLogLevel(new Integer(n).toString());
        browseRequest.setLanguage(this.getLanguage());
        if (this.userIdentity != null) {
            browseRequest.setUserIdentity(this.userIdentity);
        }
        browseRequest.setValidationLevel(MIRValidationLevel.BASIC);
        Response response = this.executeMimbRequest((Request)browseRequest, new MimbAxisLogEventHandler(log));
        return response instanceof RunMimbResponse;
    }

    @Override
    public boolean test(String string, DirectionType directionType, GetBridgeInformationResponse getBridgeInformationResponse, Map<String, String> map, Map<String, String> map2, boolean bl, Log log, int n) throws RemoteException {
        Response response;
        if (this.internalDriver != null) {
            boolean bl2 = false;
            try {
                BridgeId.Direction direction = directionType == DirectionType.IMPORT ? BridgeId.Direction.IMPORT : BridgeId.Direction.EXPORT;
                BridgeConfiguration bridgeConfiguration = MimbDriverUtil.prepareBridgeConfig(string, direction, getBridgeInformationResponse, map, map2, bl);
                MimbDriverLogAdapter mimbDriverLogAdapter = new MimbDriverLogAdapter(log, n);
                RequestOptions requestOptions = this.getInternalOptions();
                bl2 = this.internalDriver.test(bridgeConfiguration, requestOptions, (MimbLog)mimbDriverLogAdapter);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return bl2;
        }
        MimbOptions mimbOptions = this.prepareUserOptions(string, directionType, getBridgeInformationResponse, map2);
        TestRequest testRequest = new TestRequest();
        testRequest.setBridgeId(string);
        testRequest.setBridgeDisplayName("");
        testRequest.setVaultOptions(map);
        testRequest.setUserOptions(mimbOptions);
        testRequest.setDisableLog(false);
        testRequest.setLogLevel(new Integer(n).toString());
        testRequest.setIsExport(DirectionType.EXPORT.equals((Object)directionType));
        testRequest.setLanguage(this.getLanguage());
        if (this.userIdentity != null) {
            testRequest.setUserIdentity(this.userIdentity);
        }
        return (response = this.executeMimbRequest((Request)testRequest, new MimbAxisLogEventHandler(log))) instanceof RunMimbResponse;
    }

    @Override
    public GetBridgeInformationResponse getBridgeInfo(String string, DirectionType directionType) throws MimbAgentFault, MimbErrorResponse, RemoteException {
        BufferedLogEventHandler bufferedLogEventHandler;
        Response response;
        if (this.internalDriver != null) {
            GetBridgeInformationResponse getBridgeInformationResponse = null;
            try {
                BridgeId.Direction direction = directionType == DirectionType.IMPORT ? BridgeId.Direction.IMPORT : BridgeId.Direction.EXPORT;
                BridgeId bridgeId = new BridgeId(string, direction);
                RequestOptions requestOptions = this.getInternalOptions();
                Bridge bridge = this.internalDriver.getBridge(bridgeId, requestOptions);
                getBridgeInformationResponse = MimbDriverUtil.convertBridgeInfo(bridge);
                getBridgeInformationResponse.setLanguage(this.getLanguage());
                getBridgeInformationResponse.setUserIdentity(this.userIdentity);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return getBridgeInformationResponse;
        }
        GetBridgeInformationRequest getBridgeInformationRequest = new GetBridgeInformationRequest();
        getBridgeInformationRequest.setBridgeId(string);
        getBridgeInformationRequest.setIsExport(DirectionType.EXPORT.equals((Object)directionType));
        getBridgeInformationRequest.setLanguage(this.getLanguage());
        if (this.userIdentity != null) {
            getBridgeInformationRequest.setUserIdentity(this.userIdentity);
        }
        if ((response = this.executeMimbRequest((Request)getBridgeInformationRequest, bufferedLogEventHandler = new BufferedLogEventHandler())) instanceof BridgeInformationResponse) {
            return this.convertToAxis((BridgeInformationResponse)response);
        }
        this.handleMimbError(response, bufferedLogEventHandler);
        return null;
    }

    private GetBridgeInformationResponse convertToAxis(BridgeInformationResponse bridgeInformationResponse) {
        GetBridgeInformationResponse getBridgeInformationResponse = new GetBridgeInformationResponse();
        getBridgeInformationResponse.setBridgeDisplayName(bridgeInformationResponse.getBridgeDisplayName());
        getBridgeInformationResponse.setBridgeIdentifier(bridgeInformationResponse.getBridgeId());
        getBridgeInformationResponse.setDescription(bridgeInformationResponse.getBridgeDescription());
        getBridgeInformationResponse.setDirection(bridgeInformationResponse.isExport() ? DirectionType.EXPORT : DirectionType.IMPORT);
        getBridgeInformationResponse.setLanguage(bridgeInformationResponse.getLanguage());
        Parameters parameters = bridgeInformationResponse.getParameters();
        int n = 0;
        GetBridgeInformationResponseBridgeParameter[] getBridgeInformationResponseBridgeParameterArray = new GetBridgeInformationResponseBridgeParameter[parameters.getCount()];
        for (Parameter parameter : parameters) {
            GetBridgeInformationResponseBridgeParameter getBridgeInformationResponseBridgeParameter = this.convertToAxis(parameter);
            getBridgeInformationResponseBridgeParameterArray[n++] = getBridgeInformationResponseBridgeParameter;
        }
        getBridgeInformationResponse.setBridgeParameter(getBridgeInformationResponseBridgeParameterArray);
        BridgeSpecificationType bridgeSpecificationType = this.convertToAxis(bridgeInformationResponse.getSpecification());
        getBridgeInformationResponse.setSpecification(bridgeSpecificationType);
        return getBridgeInformationResponse;
    }

    private LogType convertToAxis(List<LogEvent> list) {
        LogType logType = new LogType();
        MessageType[] messageTypeArray = new MessageType[list.size()];
        int n = 0;
        for (LogEvent logEvent : list) {
            MessageType messageType = MimbAxisLogEventHandler.convertLogEventToAxis(logEvent);
            messageTypeArray[n++] = messageType;
        }
        logType.setMessage(messageTypeArray);
        return logType;
    }

    private GetBridgeInformationResponseBridgeParameter convertToAxis(Parameter parameter) {
        GetBridgeInformationResponseBridgeParameter getBridgeInformationResponseBridgeParameter = new GetBridgeInformationResponseBridgeParameter();
        getBridgeInformationResponseBridgeParameter.setBridgeParameterIdentifier(parameter.getName());
        getBridgeInformationResponseBridgeParameter.setDisplayName(parameter.getDisplayName());
        getBridgeInformationResponseBridgeParameter.setDescription(parameter.getDescription());
        BridgeParameterValue bridgeParameterValue = new BridgeParameterValue();
        bridgeParameterValue.set_value(parameter.getDefaultValue());
        getBridgeInformationResponseBridgeParameter.setDefaultValue(bridgeParameterValue);
        getBridgeInformationResponseBridgeParameter.setMandatory(parameter.isMandatory());
        String[] stringArray = new String[parameter.getFileExtensions().size()];
        int n = 0;
        for (String object2 : parameter.getFileExtensions()) {
            stringArray[n++] = object2;
        }
        getBridgeInformationResponseBridgeParameter.setFileExtension(stringArray);
        Object object3 = OpenModeType.DEFAULT;
        if (parameter.getOpenMode() == Parameter.OpenMode.READ) {
            object3 = OpenModeType.READ;
        } else if (parameter.getOpenMode() == Parameter.OpenMode.WRITE) {
            object3 = OpenModeType.WRITE;
        } else if (parameter.getOpenMode() == Parameter.OpenMode.READWRITE) {
            object3 = OpenModeType.READWRITE;
        }
        getBridgeInformationResponseBridgeParameter.setOpenMode((OpenModeType)((Object)object3));
        Map<String, String> map = parameter.getPossibleValues();
        GetBridgeInformationResponseBridgeParameterPossibleValue[] getBridgeInformationResponseBridgeParameterPossibleValueArray = new GetBridgeInformationResponseBridgeParameterPossibleValue[map.values().size()];
        n = 0;
        for (String string : map.keySet()) {
            GetBridgeInformationResponseBridgeParameterPossibleValue getBridgeInformationResponseBridgeParameterPossibleValue = new GetBridgeInformationResponseBridgeParameterPossibleValue();
            getBridgeInformationResponseBridgeParameterPossibleValue.setIdentifier(string);
            getBridgeInformationResponseBridgeParameterPossibleValue.set_value(map.get(string));
            getBridgeInformationResponseBridgeParameterPossibleValueArray[n++] = getBridgeInformationResponseBridgeParameterPossibleValue;
        }
        getBridgeInformationResponseBridgeParameter.setPossibleValue(getBridgeInformationResponseBridgeParameterPossibleValueArray);
        getBridgeInformationResponseBridgeParameter.setTransferable(parameter.isTransferable());
        Object object = TypeType.STRING;
        if (parameter.getType() == Parameter.Type.BOOLEAN) {
            object = TypeType.BOOLEAN;
        } else if (parameter.getType() == Parameter.Type.DATE) {
            object = TypeType.DATE;
        } else if (parameter.getType() == Parameter.Type.DIRECTORY) {
            object = TypeType.DIRECTORY;
        } else if (parameter.getType() == Parameter.Type.ENUMERATED) {
            object = TypeType.ENUMERATED;
        } else if (parameter.getType() == Parameter.Type.FILE) {
            object = TypeType.FILE;
        } else if (parameter.getType() == Parameter.Type.NUMERIC) {
            object = TypeType.NUMERIC;
        } else if (parameter.getType() == Parameter.Type.PASSWORD) {
            object = TypeType.PASSWORD;
        } else if (parameter.getType() == Parameter.Type.REPOSITORY_MODEL) {
            object = TypeType.REPOSITORY_MODEL;
        } else if (parameter.getType() == Parameter.Type.REPOSITORY_SUBSET) {
            object = TypeType.REPOSITORY_SUBSET;
        }
        getBridgeInformationResponseBridgeParameter.setType((TypeType)((Object)object));
        return getBridgeInformationResponseBridgeParameter;
    }

    @Override
    public GetBridgeListResponse getBridgeList(DirectionType directionType) throws MimbErrorResponse {
        if (this.internalDriver != null) {
            GetBridgeListResponse getBridgeListResponse = null;
            try {
                BridgeId.Direction direction = directionType == DirectionType.IMPORT ? BridgeId.Direction.IMPORT : BridgeId.Direction.EXPORT;
                RequestOptions requestOptions = this.getInternalOptions();
                Collection collection = this.internalDriver.getBridgeList(direction, requestOptions);
                getBridgeListResponse = MimbDriverUtil.convert(collection);
                getBridgeListResponse.setDirection(directionType);
                getBridgeListResponse.setLanguage(this.getLanguage());
                getBridgeListResponse.setUserIdentity(this.userIdentity);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return getBridgeListResponse;
        }
        GetBridgeListRequest getBridgeListRequest = new GetBridgeListRequest();
        getBridgeListRequest.setIsExport(DirectionType.EXPORT.equals((Object)directionType));
        getBridgeListRequest.setLanguage(this.getLanguage());
        if (this.userIdentity != null) {
            getBridgeListRequest.setUserIdentity(this.userIdentity);
        }
        getBridgeListRequest.setWithSpecification(false);
        BufferedLogEventHandler bufferedLogEventHandler = new BufferedLogEventHandler();
        Response response = this.executeMimbRequest((Request)getBridgeListRequest, bufferedLogEventHandler);
        if (response instanceof BridgeListResponse) {
            return this.convertToAxis((BridgeListResponse)response);
        }
        this.handleMimbError(response, bufferedLogEventHandler);
        return null;
    }

    private GetBridgeListResponse convertToAxis(BridgeListResponse bridgeListResponse) {
        GetBridgeListResponse getBridgeListResponse = new GetBridgeListResponse();
        getBridgeListResponse.setDirection(bridgeListResponse.isExport() ? DirectionType.EXPORT : DirectionType.IMPORT);
        getBridgeListResponse.setLanguage(bridgeListResponse.getLanguage());
        getBridgeListResponse.setSpecification(bridgeListResponse.getWithSpecification());
        getBridgeListResponse.setUserIdentity(bridgeListResponse.getUserIdentity());
        BridgeType[] bridgeTypeArray = new BridgeType[bridgeListResponse.getBridges().size()];
        int n = 0;
        for (BridgeLibrary bridgeLibrary : bridgeListResponse.getBridges()) {
            boolean bl = bridgeListResponse.lastBridge().equals(bridgeLibrary.getDisplayName());
            BridgeType bridgeType = this.convertToAxis(bridgeLibrary, bridgeListResponse.getBridgeSpec(bridgeLibrary), bl, getBridgeListResponse.getDirection());
            bridgeTypeArray[n++] = bridgeType;
        }
        getBridgeListResponse.setBridge(bridgeTypeArray);
        return getBridgeListResponse;
    }

    private BridgeType convertToAxis(BridgeLibrary bridgeLibrary, BridgeSpecificationLiteral bridgeSpecificationLiteral, boolean bl, DirectionType directionType) {
        BridgeType bridgeType = new BridgeType();
        bridgeType.setBridgeIdentifier(bridgeLibrary.getBridgeId());
        BridgeTypeDisplayName bridgeTypeDisplayName = new BridgeTypeDisplayName();
        bridgeTypeDisplayName.setBridgeDisplayName(bridgeLibrary.getDisplayName());
        bridgeTypeDisplayName.setLastUsed(bl);
        bridgeType.setDisplayName(bridgeTypeDisplayName);
        bridgeType.setDirection(directionType);
        BridgeSpecificationType bridgeSpecificationType = this.convertToAxis(bridgeSpecificationLiteral);
        bridgeType.setSpecification(bridgeSpecificationType);
        return bridgeType;
    }

    private BridgeSpecificationType convertToAxis(BridgeSpecificationLiteral bridgeSpecificationLiteral) {
        BridgeSpecificationType bridgeSpecificationType = new BridgeSpecificationType();
        if (bridgeSpecificationLiteral != null) {
            bridgeSpecificationType.setVersion(bridgeSpecificationLiteral.getTool_Versions());
            bridgeSpecificationType.setMethodology(bridgeSpecificationLiteral.getMethodology_Summary());
            bridgeSpecificationType.setProductName(bridgeSpecificationLiteral.getTool_Name());
            bridgeSpecificationType.setProductVersion(bridgeSpecificationLiteral.getTool_Versions());
            bridgeSpecificationType.setProductCompany(bridgeSpecificationLiteral.getVendor_Name());
            bridgeSpecificationType.setProductWeb(bridgeSpecificationLiteral.getTool_Web());
            bridgeSpecificationType.setIsMultiModel(bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel());
        } else {
            bridgeSpecificationType.setVersion("UNDEFINED");
            bridgeSpecificationType.setMethodology("UNDEFINED");
            bridgeSpecificationType.setProductName("UNDEFINED");
            bridgeSpecificationType.setProductVersion("UNDEFINED");
            bridgeSpecificationType.setProductCompany("UNDEFINED");
            bridgeSpecificationType.setProductWeb("http://UNDEFINED");
            bridgeSpecificationType.setIsMultiModel(false);
        }
        return bridgeSpecificationType;
    }

    private BridgeSpecificationType convertToAxis(BridgeSpecification bridgeSpecification) {
        BridgeSpecificationType bridgeSpecificationType = new BridgeSpecificationType();
        if (bridgeSpecification != null) {
            bridgeSpecificationType.setIsMultiModel(bridgeSpecification.getMultiModel());
            bridgeSpecificationType.setMethodology(bridgeSpecification.getProductMethodology());
            bridgeSpecificationType.setProductCompany(bridgeSpecification.getProductCompany());
            bridgeSpecificationType.setProductName(bridgeSpecification.getProductName());
            bridgeSpecificationType.setProductVersion(bridgeSpecification.getProductVersion());
            bridgeSpecificationType.setVersion(bridgeSpecification.getBridgeVersion());
            bridgeSpecificationType.setProductWeb(bridgeSpecification.getProductWeb());
        } else {
            bridgeSpecificationType.setVersion("UNDEFINED");
            bridgeSpecificationType.setMethodology("UNDEFINED");
            bridgeSpecificationType.setProductName("UNDEFINED");
            bridgeSpecificationType.setProductVersion("UNDEFINED");
            bridgeSpecificationType.setProductCompany("UNDEFINED");
            bridgeSpecificationType.setProductWeb("http://UNDEFINED");
            bridgeSpecificationType.setIsMultiModel(false);
        }
        return bridgeSpecificationType;
    }

    @Override
    public GetBridgeSpecsResponse getBridgeSpecs() throws MimbErrorResponse {
        if (this.internalDriver != null) {
            // empty if block
        }
        GetBridgeSpecsRequest getBridgeSpecsRequest = new GetBridgeSpecsRequest();
        if (this.userIdentity != null) {
            getBridgeSpecsRequest.setUserIdentity(this.userIdentity);
        }
        getBridgeSpecsRequest.setLanguage(this.getLanguage());
        BufferedLogEventHandler bufferedLogEventHandler = new BufferedLogEventHandler();
        Response response = this.executeMimbRequest((Request)getBridgeSpecsRequest, bufferedLogEventHandler);
        if (response instanceof BridgeSpecsResponse) {
            return this.convertToAxis((BridgeSpecsResponse)response);
        }
        this.handleMimbError(response, bufferedLogEventHandler);
        return null;
    }

    @Override
    public GetBridgeSpecsResponse getBridgeSpecs(String string, DirectionType directionType) throws MimbErrorResponse {
        if (this.internalDriver != null) {
            GetBridgeSpecsResponse getBridgeSpecsResponse = null;
            try {
                BridgeId.Direction direction = directionType == DirectionType.IMPORT ? BridgeId.Direction.IMPORT : BridgeId.Direction.EXPORT;
                BridgeId bridgeId = new BridgeId(string, direction);
                RequestOptions requestOptions = this.getInternalOptions();
                MITI.mimb.bridge.BridgeSpecification bridgeSpecification = this.internalDriver.getBridgeSpecification(bridgeId, requestOptions);
                getBridgeSpecsResponse = MimbDriverUtil.convert(bridgeSpecification);
            }
            catch (DriverError driverError) {
                MimbDriverUtil.handleDriverError(driverError);
            }
            return getBridgeSpecsResponse;
        }
        GetBridgeSpecsRequest getBridgeSpecsRequest = new GetBridgeSpecsRequest(string, DirectionType.EXPORT.equals((Object)directionType));
        if (this.userIdentity != null) {
            getBridgeSpecsRequest.setUserIdentity(this.userIdentity);
        }
        getBridgeSpecsRequest.setLanguage(this.getLanguage());
        BufferedLogEventHandler bufferedLogEventHandler = new BufferedLogEventHandler();
        Response response = this.executeMimbRequest((Request)getBridgeSpecsRequest, bufferedLogEventHandler);
        if (response instanceof BridgeSpecsResponse) {
            return this.convertToAxis((BridgeSpecsResponse)response);
        }
        this.handleMimbError(response, bufferedLogEventHandler);
        return null;
    }

    private GetBridgeSpecsResponse convertToAxis(BridgeSpecsResponse bridgeSpecsResponse) {
        GetBridgeSpecsResponse getBridgeSpecsResponse = new GetBridgeSpecsResponse();
        Map map = bridgeSpecsResponse.getSpecs();
        if (map != null && !map.keySet().isEmpty()) {
            GetBridgeSpecsResponseModelBridge[] getBridgeSpecsResponseModelBridgeArray = new GetBridgeSpecsResponseModelBridge[map.keySet().size()];
            int n = 0;
            for (BridgeSpecificationLiteral bridgeSpecificationLiteral : map.keySet()) {
                BridgeLibrary bridgeLibrary = (BridgeLibrary)map.get(bridgeSpecificationLiteral);
                GetBridgeSpecsResponseModelBridge getBridgeSpecsResponseModelBridge = this.convertToAxis(bridgeSpecificationLiteral, bridgeLibrary);
                getBridgeSpecsResponseModelBridgeArray[n++] = getBridgeSpecsResponseModelBridge;
            }
            getBridgeSpecsResponse.setModelBridge(getBridgeSpecsResponseModelBridgeArray);
        }
        return getBridgeSpecsResponse;
    }

    private GetBridgeSpecsResponseModelBridge convertToAxis(BridgeSpecificationLiteral bridgeSpecificationLiteral, BridgeLibrary bridgeLibrary) {
        GetBridgeSpecsResponseModelBridge getBridgeSpecsResponseModelBridge = new GetBridgeSpecsResponseModelBridge();
        GetBridgeSpecsResponseModelBridgeBridge getBridgeSpecsResponseModelBridgeBridge = new GetBridgeSpecsResponseModelBridgeBridge();
        getBridgeSpecsResponseModelBridgeBridge.setDisplayName(bridgeLibrary != null ? bridgeLibrary.getDisplayName() : "");
        getBridgeSpecsResponseModelBridgeBridge.setDirection(bridgeSpecificationLiteral.getBridge_Direction().equalsIgnoreCase("Export") ? DirectionType.EXPORT : DirectionType.IMPORT);
        getBridgeSpecsResponseModelBridgeBridge.setId(bridgeSpecificationLiteral.getBridge_Id());
        getBridgeSpecsResponseModelBridgeBridge.setIsEnabled(bridgeLibrary != null);
        getBridgeSpecsResponseModelBridgeBridge.setIsAlias(bridgeSpecificationLiteral.isBridge_IsAlias());
        getBridgeSpecsResponseModelBridgeBridge.setIsWindowsOnly(bridgeSpecificationLiteral.isBridge_IsWindowsOnly());
        getBridgeSpecsResponseModelBridgeBridge.setIsToolRequired(bridgeSpecificationLiteral.isBridge_IsToolRequired());
        getBridgeSpecsResponseModelBridgeBridge.setIsRepositoryBrowsable(bridgeSpecificationLiteral.isBridge_IsRepositoryBrowsable());
        getBridgeSpecsResponseModelBridgeBridge.setIsIncrementallyHarvestable(bridgeSpecificationLiteral.isBridge_IsIncrementallyHarvestable());
        getBridgeSpecsResponseModelBridgeBridge.setIsDataProfile(bridgeSpecificationLiteral.isBridge_IsDataProfile());
        getBridgeSpecsResponseModelBridgeBridge.setIsRepositoryMultiModel(bridgeSpecificationLiteral.isBridge_IsRepositoryMultiModel());
        getBridgeSpecsResponseModelBridgeBridge.setIsMimbOemEnabled(bridgeSpecificationLiteral.isBridge_IsMimbOemEnabled());
        getBridgeSpecsResponseModelBridgeBridge.setPartnershipLevel(bridgeSpecificationLiteral.getBridge_PartnershipLevel());
        getBridgeSpecsResponseModelBridge.setBridge(getBridgeSpecsResponseModelBridgeBridge);
        GetBridgeSpecsResponseModelBridgeVendor getBridgeSpecsResponseModelBridgeVendor = new GetBridgeSpecsResponseModelBridgeVendor();
        getBridgeSpecsResponseModelBridgeVendor.setName(bridgeSpecificationLiteral.getVendor_Name());
        getBridgeSpecsResponseModelBridgeVendor.setId(bridgeSpecificationLiteral.getVendor_Id());
        getBridgeSpecsResponseModelBridgeVendor.setWeb(bridgeSpecificationLiteral.getVendor_Web());
        getBridgeSpecsResponseModelBridge.setVendor(getBridgeSpecsResponseModelBridgeVendor);
        GetBridgeSpecsResponseModelBridgeTool getBridgeSpecsResponseModelBridgeTool = new GetBridgeSpecsResponseModelBridgeTool();
        getBridgeSpecsResponseModelBridgeTool.setName(bridgeSpecificationLiteral.getTool_Name());
        getBridgeSpecsResponseModelBridgeTool.setPreviousName(bridgeSpecificationLiteral.getTool_PreviousName());
        getBridgeSpecsResponseModelBridgeTool.setVersions(bridgeSpecificationLiteral.getTool_Versions());
        getBridgeSpecsResponseModelBridgeTool.setWeb(bridgeSpecificationLiteral.getTool_Web());
        getBridgeSpecsResponseModelBridge.setTool(getBridgeSpecsResponseModelBridgeTool);
        GetBridgeSpecsResponseModelBridgeMethodology getBridgeSpecsResponseModelBridgeMethodology = new GetBridgeSpecsResponseModelBridgeMethodology();
        getBridgeSpecsResponseModelBridgeMethodology.setSummary(bridgeSpecificationLiteral.getMethodology_Summary());
        getBridgeSpecsResponseModelBridgeMethodology.setToolCategory(bridgeSpecificationLiteral.getMethodology_ToolCategory());
        getBridgeSpecsResponseModelBridge.setMethodology(getBridgeSpecsResponseModelBridgeMethodology);
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage();
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setSummary(bridgeSpecificationLiteral.getMethodology_MetadataCoverage_Summary());
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setRepository(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_Repository() ? "1" : "0");
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore();
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setRecordModel(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_RecordModel() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setHierarchicalModel(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_HierarchicalModel() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setXmlSchemas(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_XmlSchemas() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setObjectModel(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_ObjectModel() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setPhysicalDataModel(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_PhysicalDataModel() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setLogicalDataModel(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_LogicalDataModel() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setDimensionalModel(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_DimensionalModel() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore.setExpressionParsing(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataStore_ViewExpressionParsing() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setDataStore(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataStore);
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess();
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess.setType(bridgeSpecificationLiteral.getMethodology_MetadataCoverage_DataIntegrationProcess_Type());
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess.setSourceTargetDataStore(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataIntegrationProcess_SourceTargetDataStore() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess.setTransformationLineage(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataIntegrationProcess_TransformationLineage() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess.setExpressionParsing(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataIntegrationProcess_ExpressionParsing() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess.setExpressionConversion(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_DataIntegrationProcess_ExpressionConversion() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setDataIntegrationProcess(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageDataIntegrationProcess);
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess();
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess.setType(bridgeSpecificationLiteral.getMethodology_MetadataCoverage_BusinessIntelligenceProcess_Type());
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess.setModelGraphicalLayout(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_ModelGraphicalLayout() ? "1" : "0");
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign();
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign.setRdbmsSource(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Design_RdbmsSource() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign.setOlapSource(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Design_OlapSource() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign.setDimensionalTarget(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Design_DimensionalTarget() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign.setTransformationLineage(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Design_TransformationLineage() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign.setExpressionParsing(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Design_ExpressionParsing() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign.setExpressionConversion(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Design_ExpressionConversion() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess.setDesign(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessDesign);
        GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport = new GetBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport();
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport.setRelationalSource(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Report_RelationalSource() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport.setDimensionalSource(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Report_DimensionalSource() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport.setExpressionParsing(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Report_ExpressionParsing() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport.setReportStructure(bridgeSpecificationLiteral.isMethodology_MetadataCoverage_BusinessIntelligenceProcess_Report_ReportStructure() ? "1" : "0");
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess.setReport(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcessReport);
        getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage.setBusinessIntelligenceProcess(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverageBusinessIntelligenceProcess);
        getBridgeSpecsResponseModelBridgeMethodology.setMetadataCoverage(getBridgeSpecsResponseModelBridgeMethodologyMetadataCoverage);
        GetBridgeSpecsResponseModelBridgeToolInterface getBridgeSpecsResponseModelBridgeToolInterface = new GetBridgeSpecsResponseModelBridgeToolInterface();
        getBridgeSpecsResponseModelBridgeToolInterface.setSummary(bridgeSpecificationLiteral.getToolInterface_Summary());
        getBridgeSpecsResponseModelBridgeToolInterface.setApi(bridgeSpecificationLiteral.getToolInterface_Api());
        getBridgeSpecsResponseModelBridgeToolInterface.setFile(bridgeSpecificationLiteral.getToolInterface_File());
        getBridgeSpecsResponseModelBridge.setToolInterface(getBridgeSpecsResponseModelBridgeToolInterface);
        return getBridgeSpecsResponseModelBridge;
    }

    private Response executeMimbRequest(Request request, LogEventHandler logEventHandler) {
        LocalMimbThread localMimbThread = new LocalMimbThread(request, logEventHandler);
        localMimbThread.start();
        return this.waitForMimb(localMimbThread, this.getWaitTimeout());
    }

    private void handleMimbError(Response response, BufferedLogEventHandler bufferedLogEventHandler) throws MimbErrorResponse {
        String string = response != null ? response.getReturnCode().name() : ErrorResponse.getErrorMessage(bufferedLogEventHandler.getEvents());
        LogType logType = this.convertToAxis(bufferedLogEventHandler.getEvents());
        throw new MimbErrorResponse(string, logType);
    }

    @Override
    public void deinit() {
    }

    @Override
    public void setWaitTimeout(int n) {
    }

    public boolean updateSemanticTypes(Log log, String string) {
        boolean bl = true;
        LinkedList<MessageType> linkedList = new LinkedList<MessageType>();
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();){
            int n = DataQualityUtil.exportSemanticTypes(string, new PrintStream(byteArrayOutputStream), new PrintStream(byteArrayOutputStream2));
            if (n != 0) {
                MessageType messageType;
                bl = false;
                if (byteArrayOutputStream.size() > 0) {
                    messageType = new MessageType(byteArrayOutputStream.toString());
                    messageType.setCode(BLIB.MSG_PROCESS_STDOUT.getId());
                    messageType.setType(MessageLevel.ERROR);
                    linkedList.add(messageType);
                }
                if (byteArrayOutputStream2.size() > 0) {
                    messageType = new MessageType(byteArrayOutputStream2.toString());
                    messageType.setCode(BLIB.MSG_PROCESS_STDERR.getId());
                    messageType.setType(MessageLevel.ERROR);
                    linkedList.add(messageType);
                }
            }
        }
        catch (MIRException | IOException exception) {
            MessageType messageType = new MessageType(BLIB.ERR_OPERATION_FAILED.getMessage(exception.getClass().getName() + (exception.getMessage() != null ? ": " + exception.getMessage() : "")));
            messageType.setCode(BLIB.ERR_OPERATION_FAILED.getId());
            messageType.setType(MessageLevel.ERROR);
            linkedList.add(messageType);
            bl = false;
        }
        if (linkedList.size() > 0) {
            log.printMimbLog(new LogType(linkedList.toArray(new MessageType[linkedList.size()]), false));
        }
        return bl;
    }

    @Deprecated
    private class LocalMimbThread
    extends Thread {
        private Request request = null;
        private Response response = null;
        private LogEventHandler handler = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LocalMimbThread(Request request, LogEventHandler logEventHandler) {
            this.request = request;
            this.handler = logEventHandler;
            HashMap hashMap = LocalMimbDriver.this.mimbThreads;
            synchronized (hashMap) {
                this.setName("MIMB-" + String.valueOf(System.currentTimeMillis() + "-" + LocalMimbDriver.this.mimbThreads.size()));
                LocalMimbDriver.this.mimbThreads.put(this.getName(), this);
            }
        }

        Response getResponse() {
            return this.response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MIRLogger mIRLogger = MIRLogger.init(this.handler, new BufferedLogEventHandler());
            try {
                this.response = MimbExecutable.executeRequest((Request)this.request, (MIRLogger)mIRLogger, (File)LocalMimbDriver.this.mimbHomeDir, (String)LocalMimbDriver.this.oemPartnerToken);
            }
            catch (Throwable throwable) {
                SFCL.ERR_MIMB_REQUEST.log(throwable, throwable.getClass().getName() + (throwable.getMessage() != null ? ": " + throwable.getMessage() : ""));
            }
            finally {
                if (Thread.interrupted()) {
                    SFCL.DBG_ABORT_REQUESTED.log(new Object[0]);
                }
                HashMap hashMap = LocalMimbDriver.this.mimbThreads;
                synchronized (hashMap) {
                    LocalMimbDriver.this.mimbThreads.remove(Thread.currentThread().getName());
                }
                MIRLogger.clear();
            }
        }
    }
}

