/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import com.sas.scheduler.visuals.swing.ButtonsLayout;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class TriggerOptionsPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private FlowInfo m_flow;
    private JList m_list = null;
    private JScrollPane m_triggers = null;
    private GridBagConstraints m_gbc_triggers = null;
    private JButton m_newtime = new JButton(m_bundle.getString("TriggerOptionsPanel.Button.NewTimeEvent.txt"));
    private JButton m_newfile = null;
    private JButton m_edit = new JButton(m_bundle.getString("TriggerOptionsPanel.Button.Edit.txt"));
    private JButton m_delete = new JButton(m_bundle.getString("TriggerOptionsPanel.Button.Delete.txt"));

    public TriggerOptionsPanel(FlowInfo flow) {
        this.m_flow = flow;
        this.__initialize();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_flow = null;
        this.m_triggers = null;
        this.m_gbc_triggers = null;
        this.m_newtime = null;
        this.m_newfile = null;
        this.m_edit = null;
        this.m_delete = null;
    }

    public void addNewTimeEventListener(ActionListener al) {
        this.m_newtime.addActionListener(al);
        this.m_newtime.setVisible(true);
        this.invalidate();
    }

    public boolean addNewFileEventListener(ActionListener al) {
        if (this.m_newfile != null) {
            this.m_newfile.addActionListener(al);
            this.m_newfile.setVisible(true);
            this.invalidate();
            return true;
        }
        return false;
    }

    public void addEditEventListener(ActionListener al) {
        this.m_edit.addActionListener(al);
        this.m_edit.setVisible(true);
        this.invalidate();
    }

    public void addDeleteEventListener(ActionListener al) {
        this.m_delete.addActionListener(al);
        this.m_delete.setVisible(true);
        this.invalidate();
    }

    public boolean updateTriggerEventList(FlowInfo finfo) {
        if (this.m_triggers != null) {
            this.remove(this.m_triggers);
            this.m_list = null;
            this.m_triggers = null;
        }
        this.m_list = new JList();
        this.m_list.setSelectionMode(0);
        List triggerList = finfo.getFlowTriggerEvents("Event");
        this.m_list.setListData(new Vector(triggerList));
        if (finfo == this.m_flow) {
            this.m_list.setSelectedIndex(0);
        } else {
            this.m_list.setSelectedIndex(this.m_list.getMaxSelectionIndex());
        }
        this.m_triggers = new JScrollPane(this.m_list, 20, 30);
        this.m_triggers.setPreferredSize(new Dimension(350, 200));
        this.add((Component)this.m_triggers, this.m_gbc_triggers);
        this.paintAll(this.m_triggers.getGraphics());
        if (this.m_list.isSelectionEmpty()) {
            this.m_edit.setEnabled(false);
            this.m_delete.setEnabled(false);
        } else {
            this.m_edit.setEnabled(true);
            this.m_delete.setEnabled(true);
        }
        return true;
    }

    public TriggerEventInfo getSelected() {
        return (TriggerEventInfo)this.m_list.getSelectedValue();
    }

    public void setSelected(TriggerEventInfo trigger) {
        this.m_list.setSelectedValue(trigger, true);
        if (this.m_list.isSelectionEmpty()) {
            this.m_edit.setEnabled(false);
            this.m_delete.setEnabled(false);
        } else {
            this.m_edit.setEnabled(true);
            this.m_delete.setEnabled(true);
        }
    }

    private void __initialize() {
        JLabel label = new JLabel(MessageFormat.format(m_bundle.getString("TriggerOptionsPanel.Description.fmt"), this.m_flow.getName()));
        this.updateTriggerEventList(this.m_flow);
        StandardPanel pnlButtons = new StandardPanel();
        pnlButtons.setLayout(new ButtonsLayout(1, 1));
        pnlButtons.add(this.m_newtime);
        if (this.m_flow.getScheduler().isFileEventSupportedAsTriggers()) {
            this.m_newfile = new JButton(m_bundle.getString("TriggerOptionsPanel.Button.NewFileEvent.txt"));
            pnlButtons.add(this.m_newfile);
        }
        pnlButtons.add(this.m_edit);
        pnlButtons.add(this.m_delete);
        GridBagConstraints gbc_label = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0);
        this.m_gbc_triggers = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_buttons = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 12, 3, new Insets(0, 0, 0, 5), 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)label, gbc_label);
        this.add((Component)this.m_triggers, this.m_gbc_triggers);
        this.add((Component)pnlButtons, gbc_buttons);
    }

    static {
        String strClassName = TriggerOptionsPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

