/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SchedulerServerPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JComboBox m_cmbServerList;
    private JButton m_btnNewServer;
    private boolean m_enableNewButton = false;

    public SchedulerServerPanel(List<?> listOfSchedulers, SchedulerServerInfo defaultsch) {
        this.__initialize(listOfSchedulers.toArray(), defaultsch);
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_cmbServerList = null;
        this.m_btnNewServer = null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_cmbServerList.setEnabled(enabled);
        if (enabled) {
            this.m_btnNewServer.setEnabled(this.m_enableNewButton);
        } else {
            this.m_btnNewServer.setEnabled(false);
        }
    }

    public void __initialize(Object[] arr, SchedulerServerInfo defaultsch) {
        int i;
        ComboItemChangedListener comboListener = new ComboItemChangedListener();
        this.m_cmbServerList = new JComboBox();
        this.m_cmbServerList.setModel(new DefaultComboBoxModel<Object>(arr));
        this.m_cmbServerList.setToolTipText(m_bundle.getString("SchedulerServerPanel.SchedulingServer.ToolTip.txt"));
        this.m_cmbServerList.addActionListener(comboListener);
        String labelText = m_bundle.getString("SchedulerServerPanel.SchedulingServer.txt");
        JLabel lblschedulingServer = new JLabel(Util.getLabelWithoutMnemonic((String)labelText));
        lblschedulingServer.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)labelText));
        lblschedulingServer.setLabelFor(this.m_cmbServerList);
        String newText = m_bundle.getString("SchedulerServerPanel.NewButton.txt");
        this.m_btnNewServer = new JButton(Util.getLabelWithoutMnemonic((String)newText));
        this.m_btnNewServer.setMnemonic(Util.getDisplayedMnemonic((String)newText));
        this.m_btnNewServer.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)newText));
        this.m_btnNewServer.setToolTipText(m_bundle.getString("SchedulerServerPanel.NewButton.ToolTip.txt"));
        this.m_btnNewServer.setVisible(this.m_enableNewButton);
        for (i = 0; i < arr.length - 1; ++i) {
            for (int j = 0; j < arr.length - 1 - i; ++j) {
                String name1 = ((SchedulerServerInfo)arr[i]).getName();
                String name2 = ((SchedulerServerInfo)arr[j + 1]).getName();
                if (name2.compareToIgnoreCase(name1) >= 0) continue;
                SchedulerServerInfo sc = (SchedulerServerInfo)arr[j];
                arr[j] = arr[j + 1];
                arr[j] = sc;
            }
        }
        this.m_cmbServerList.setModel(new DefaultComboBoxModel<Object>(arr));
        if (defaultsch != null) {
            for (i = 0; i < arr.length; ++i) {
                String id = ((SchedulerServerInfo)arr[i]).getId();
                if (id == null || !id.equals(defaultsch.getId())) continue;
                this.m_cmbServerList.setSelectedIndex(i);
                break;
            }
        } else if (this.m_cmbServerList.getItemCount() != 0) {
            this.m_cmbServerList.setSelectedIndex(0);
        }
        this.setListeningForChanges(false);
        this.addComboListener(comboListener);
        this.setListeningForChanges(true);
        this.setLayout(new GridBagLayout());
        this.add((Component)lblschedulingServer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbServerList, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_btnNewServer, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
    }

    public Dimension getServerFieldDim() {
        return this.m_cmbServerList.getPreferredSize();
    }

    public void setServerFieldDim(Dimension dim) {
        this.m_cmbServerList.setPreferredSize(dim);
    }

    public Dimension getServerButtonDim() {
        return this.m_btnNewServer.getPreferredSize();
    }

    public void setServerButtonDim(Dimension dim) {
        this.m_btnNewServer.setPreferredSize(dim);
    }

    public boolean addServer(SchedulerServerInfo sinfo) {
        this.m_cmbServerList.addItem(sinfo);
        this.m_cmbServerList.setSelectedItem(sinfo);
        return true;
    }

    public SchedulerServerInfo getSelectedServer() {
        return (SchedulerServerInfo)this.m_cmbServerList.getSelectedItem();
    }

    public List<SchedulerServerInfo> getSchedulerServerList() {
        ArrayList<SchedulerServerInfo> list = new ArrayList<SchedulerServerInfo>();
        int count = this.m_cmbServerList.getItemCount();
        for (int x = 0; x < count; ++x) {
            list.add((SchedulerServerInfo)this.m_cmbServerList.getItemAt(x));
        }
        return list;
    }

    public void setSelectedServer(SchedulerServerInfo server) {
        this.m_cmbServerList.setSelectedItem(server);
    }

    public void addComboListener(ActionListener acl) {
        this.m_cmbServerList.addActionListener(acl);
    }

    public void removeComboListener(ActionListener acl) {
        this.m_cmbServerList.removeActionListener(acl);
    }

    public void addNewButtonListener(ActionListener acl) {
        this.m_btnNewServer.addActionListener(acl);
        if (!this.m_enableNewButton) {
            this.m_enableNewButton = true;
            this.m_btnNewServer.setVisible(true);
            this.invalidate();
        }
    }

    public void removeNewButtonListener(ActionListener acl) {
        this.m_btnNewServer.removeActionListener(acl);
        if (this.m_enableNewButton) {
            this.m_enableNewButton = false;
            this.m_btnNewServer.setVisible(false);
            this.invalidate();
        }
    }

    static {
        String strClassName = SchedulerServerPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private class ComboItemChangedListener
    implements ActionListener {
        private ComboItemChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent it) {
            SchedulerServerPanel.this.setDataChanged(true);
        }
    }
}

