/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.security.InvalidParameterException;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class FolderSelectionPanel
extends StandardPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private JScrollPane m_scrollpane;
    private GridBagConstraints m_scrollpane_gbc;
    private JTree m_tree;
    private DefaultMutableTreeNode m_selectedNode;

    public FolderSelectionPanel(JTree tree) {
        if (tree == null) {
            InvalidParameterException ex = new InvalidParameterException();
            throw ex;
        }
        this.m_tree = tree;
        this._initialize();
    }

    private void _initialize() {
        this.m_tree.addTreeSelectionListener(this);
        this.m_scrollpane = new JScrollPane(this.m_tree, 20, 30);
        this.setLayout(new GridBagLayout());
        this.m_scrollpane_gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 28, 0);
        this.add((Component)this.m_scrollpane, this.m_scrollpane_gbc);
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return this.m_selectedNode;
    }

    public boolean setSelectedNode(DefaultMutableTreeNode node) {
        TreePath treePath = new TreePath(node.getPath());
        this.m_selectedNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.m_tree.setSelectionPath(treePath);
        this.m_tree.scrollPathToVisible(treePath);
        return true;
    }

    @Override
    public boolean moveDataToView() {
        if (this.m_selectedNode != null) {
            TreePath path = new TreePath(this.m_selectedNode.getPath());
            this.m_tree.setSelectionPath(path);
            this.m_tree.scrollPathToVisible(path);
        }
        return true;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = this.m_tree.getSelectionPath();
        this.m_selectedNode = path != null ? (DefaultMutableTreeNode)path.getLastPathComponent() : null;
    }
}

