/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class FlowTablePanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private FlowInfo m_flow;
    private JTable m_table;
    private JScrollPane m_scrollpane;
    private GridBagConstraints m_scrollpane_gbc;

    public FlowTablePanel(FlowInfo flow) throws SchedulerException {
        this.m_flow = flow;
        this.__initialize();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_flow = null;
        this.m_table = null;
        this.m_scrollpane = null;
        this.m_scrollpane_gbc = null;
    }

    public void refreshData(FlowInfo flow) throws SchedulerException {
        this.m_flow = flow;
        this.m_scrollpane.remove(this.m_table);
        this.remove(this.m_scrollpane);
        this.m_table = null;
        this.m_scrollpane = null;
        try {
            this.m_table = new JTable(this.m_flow.getData(), FlowInfo.getColumns()){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    int rowIndex = this.rowAtPoint(p);
                    int colIndex = this.columnAtPoint(p);
                    Object tip = null;
                    if (rowIndex >= 0 && colIndex >= 0) {
                        try {
                            tip = this.getValueAt(rowIndex, colIndex);
                        }
                        catch (RuntimeException ex) {
                            tip = null;
                        }
                    }
                    return tip != null ? tip.toString() : "";
                }
            };
            this.m_table.setBackground(SystemColor.window);
            this.m_table.setEnabled(false);
            this.m_table.setSize(new Dimension(5000, 5000));
            this.m_table.setAutoscrolls(true);
        }
        catch (RuntimeException ex) {
            throw new SchedulerException(ex.toString());
        }
        this.m_scrollpane = new JScrollPane(this.m_table, 20, 30);
        this.add((Component)this.m_scrollpane, this.m_scrollpane_gbc);
        this.paintAll(this.m_scrollpane.getGraphics());
    }

    private void __initialize() throws SchedulerException {
        this.setSize(new Dimension(1000, 800));
        this.setLayout(new GridBagLayout());
        try {
            this.m_table = new JTable(this.m_flow.getData(), FlowInfo.getColumns()){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    int rowIndex = this.rowAtPoint(p);
                    int colIndex = this.columnAtPoint(p);
                    Object tip = null;
                    if (rowIndex >= 0 && colIndex >= 0) {
                        try {
                            tip = this.getValueAt(rowIndex, colIndex);
                        }
                        catch (RuntimeException ex) {
                            tip = null;
                        }
                    }
                    return tip != null ? tip.toString() : "";
                }
            };
            this.m_table.setBackground(SystemColor.window);
            this.m_table.setEnabled(false);
            this.m_table.setSize(new Dimension(5000, 5000));
            this.m_table.setAutoscrolls(true);
        }
        catch (RuntimeException ex) {
            throw new SchedulerException(ex.toString());
        }
        JLabel label = new JLabel(m_bundle.getString("FlowTablePanel.Label.txt"));
        this.m_scrollpane = new JScrollPane(this.m_table, 20, 30);
        GridBagConstraints gbc1 = new GridBagConstraints(0, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.m_scrollpane_gbc = new GridBagConstraints(0, 1, 10, 100, 100.0, 100.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)label, gbc1);
        this.add((Component)this.m_scrollpane, this.m_scrollpane_gbc);
    }

    @Override
    public boolean onParentOK() {
        if (super.onParentOK()) {
            this.m_flow = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean onParentCancel() {
        if (super.onParentCancel()) {
            this.m_flow = null;
            return true;
        }
        return false;
    }

    static {
        String strClassName = FlowTablePanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

