/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences.editors;

import com.sas.preferences.ConfigurationPropertiesException;
import com.sas.preferences.SASProfileInterface;
import com.sas.preferences.data.GuiDefDataInterface;
import com.sas.preferences.editors.CustomEditor;
import com.sas.preferences.editors.EditorInstanceImpl;
import com.sas.preferences.editors.EditorInstanceInterface;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.PrototypeInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.webapp.ServicesFacade;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;

public class GUICreatorFactory {
    private static GUICreatorFactory m_instance = null;
    private static Map m_existingInstances = new HashMap();
    private final String _loggingContext = this.getClass().getName();

    private GUICreatorFactory() {
    }

    public static void reset() {
        m_existingInstances = new HashMap();
    }

    public static EditorInstanceInterface GetAppropriateGUI(PrototypeInterface omrPrototype, UserContextInterface userContext, SASProfileInterface sasProfile) throws RemoteException {
        if (m_instance == null) {
            m_instance = new GUICreatorFactory();
        }
        String key = null;
        try {
            key = omrPrototype.getEntityKey();
            if (m_existingInstances.containsKey(key)) {
                return (EditorInstanceInterface)m_existingInstances.get(key);
            }
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
        EditorInstanceInterface newInstance = m_instance.getAppropriateGUI(omrPrototype, userContext, sasProfile);
        if (key != null) {
            m_existingInstances.put(key, newInstance);
        }
        return newInstance;
    }

    private void createDefaultImplementor(PrototypeInterface omrPrototype, UserContextInterface userContext) throws RemoteException {
        try {
            InformationServiceInterface informationService = ServicesFacade.getInformationService();
            RepositoryInterface repository = userContext.getPerson().getRepository();
            ServerInterface newDeployedComponentSmart = (ServerInterface)informationService.newMetadata(null, "GuiSupportingClass", repository, "DeployedComponent");
            if (omrPrototype.getName().equals("Default.Theme GUIDEF")) {
                newDeployedComponentSmart.setClassIdentifier("com.sas.preferences.data.ThemeGuiDefData");
            } else if (omrPrototype.getName().equals("Locale.DefaultLocale GUIDEF")) {
                newDeployedComponentSmart.setClassIdentifier("com.sas.preferences.data.LocaleGuiDefData");
            } else {
                newDeployedComponentSmart.setClassIdentifier("com.sas.preferences.editors.HTMLDropDownEditor");
            }
            newDeployedComponentSmart.setPlatform("servlet");
            List implementors = omrPrototype.getImplementors();
            implementors.add(newDeployedComponentSmart);
            omrPrototype.update();
        }
        catch (InitializationException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private EditorInstanceInterface getAppropriateGUI(PrototypeInterface omrPrototype, UserContextInterface userContext, SASProfileInterface sasProfile) throws RemoteException {
        EditorInstanceImpl newEditorImpl = null;
        GuiDefDataInterface myDataPiece = null;
        CustomEditor myEditorPiece = null;
        try {
            List implementorList = omrPrototype.getImplementors();
            if (implementorList == null || implementorList.size() == 0) {
                this.createDefaultImplementor(omrPrototype, userContext);
                implementorList = omrPrototype.getImplementors();
            }
            for (Object obj2 : implementorList) {
                ServerInterface guiDefinition = (ServerInterface)obj2;
                String platform = guiDefinition.getPlatform();
                if (platform == null || !platform.equalsIgnoreCase("servlet")) continue;
                String className = guiDefinition.getClassIdentifier();
                ClassLoader cl = this.getClass().getClassLoader();
                Class<?> loaderClass = cl.loadClass(className);
                Object obj = loaderClass.newInstance();
                if (obj instanceof CustomEditor) {
                    myEditorPiece = (CustomEditor)loaderClass.newInstance();
                    String dataClassName = myEditorPiece.getDataClassName();
                    if (dataClassName == null) {
                        dataClassName = "com.sas.preferences.data.OMRGuiDefData";
                    }
                    Class<?> loaderForData = cl.loadClass(dataClassName);
                    myDataPiece = (GuiDefDataInterface)loaderForData.newInstance();
                    myDataPiece.init(omrPrototype, userContext);
                } else if (obj instanceof GuiDefDataInterface) {
                    myDataPiece = (GuiDefDataInterface)loaderClass.newInstance();
                    myDataPiece.init(omrPrototype, userContext);
                    String editorClassName = myDataPiece.getEditorClassName();
                    loaderClass = cl.loadClass(editorClassName);
                    myEditorPiece = (CustomEditor)loaderClass.newInstance();
                }
                newEditorImpl = new EditorInstanceImpl();
                newEditorImpl.setProfile(sasProfile);
                newEditorImpl.setUserContext(userContext);
                newEditorImpl.setEditor(myEditorPiece);
                String valueToUse = myDataPiece == null ? "" : myDataPiece.getPrefKey();
                String profileCurrentValue = sasProfile.getAttributeLookThrough(valueToUse);
                String profileValueAtPerson = null;
                if (myDataPiece.getPrefKey() != null) {
                    profileValueAtPerson = sasProfile.getAttributeValueAtPersonLevel(myDataPiece.getPrefKey());
                }
                if (profileCurrentValue != null) {
                    myDataPiece.setProfileCurrentValue(profileCurrentValue);
                }
                myDataPiece.setOMRValue(profileCurrentValue);
                if (profileValueAtPerson != null) {
                    myDataPiece.setAsOverride(true);
                } else {
                    myDataPiece.setAsOverride(false);
                }
                String profileDefaultValue = sasProfile.getAttributeValueAbovePersonLevel(myDataPiece.getPrefKey());
                if (profileDefaultValue == null) {
                    LogManager.getLogger(userContext.getClass()).warn("AttributeAbovePersonLevel is returning null - keeping default from OMR which is " + myDataPiece.getDefaultValue(), (Object)this._loggingContext);
                } else {
                    myDataPiece.setDefaultValue(profileDefaultValue);
                }
                newEditorImpl.setData(myDataPiece);
                break;
            }
        }
        catch (ConfigurationPropertiesException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return newEditorImpl;
    }
}

