/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences.editors;

import com.sas.common.util.InputScreener;
import com.sas.preferences.ConfigurationPropertiesException;
import com.sas.preferences.SASProfileInterface;
import com.sas.preferences.data.GuiDefDataInterface;
import com.sas.preferences.editors.CustomEditor;
import com.sas.preferences.res.RB;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.logging.log4j.LogManager;

public class EntryFieldEditor
implements CustomEditor {
    static final long serialVersionUID = 4861036396239589408L;
    private String _loggingContext = this.getClass().getName();
    private Locale m_profileLocale = null;
    private UserContextInterface m_userContext = null;

    @Override
    public void setProfile(SASProfileInterface profile) throws RemoteException {
        this.setProfileLocale(profile);
    }

    @Override
    public void setProfileLocale(SASProfileInterface profile) throws RemoteException {
        try {
            if (profile != null) {
                this.m_profileLocale = profile.getLocale();
                this.m_userContext = profile.getUserContext();
            }
        }
        catch (ConfigurationPropertiesException configurationPropertiesException) {
            // empty catch block
        }
    }

    @Override
    public String getDisplayPromptOutputString(GuiDefDataInterface withData) throws RemoteException {
        String promptToUse = withData.getPrompt();
        Locale userLocale = Locale.getDefault();
        if (this.m_profileLocale != null) {
            userLocale = this.m_profileLocale;
        }
        String aKey = withData.getPrompt();
        try {
            promptToUse = RB.getStringResource(aKey, userLocale);
        }
        catch (MissingResourceException e) {
            try {
                promptToUse = RB.getStringResource(aKey + ".txt", userLocale);
            }
            catch (MissingResourceException e2) {
                String errorMsg = MessageFormat.format(RB.getStringResource("no_resources_for_translating_internal_value.fmt.txt"), aKey);
                System.err.println(errorMsg);
            }
        }
        if (promptToUse == null) {
            promptToUse = withData.getPrompt();
        }
        return promptToUse;
    }

    @Override
    public String getBodyOutputString(GuiDefDataInterface withData) throws RemoteException {
        String defaultVal;
        String userDefaultVal;
        StringBuffer sbuf = new StringBuffer();
        String profileCurrentValue = withData.getProfileCurrentValue();
        Locale userLocale = Locale.getDefault();
        if (this.m_profileLocale != null) {
            userLocale = this.m_profileLocale;
        }
        if ((userDefaultVal = withData.translateInternalVal(userLocale, defaultVal = withData.getDefaultValue())) != null && userDefaultVal.trim().length() > 0) {
            defaultVal = userDefaultVal;
        }
        sbuf.append("<input name=\"" + withData.getPrefKey() + "\" value=\"" + profileCurrentValue + "\" />  " + RB.getStringResource("Default.Label.txt", userLocale) + " " + defaultVal + "\n");
        return sbuf.toString();
    }

    @Override
    public String toStringGivenData(GuiDefDataInterface data) {
        StringBuffer sbuf = new StringBuffer();
        try {
            sbuf.append("Locale = " + (this.m_profileLocale != null ? this.m_profileLocale.toString() : "unknown") + "\n");
            sbuf.append("Profile current value = " + data.getProfileCurrentValue() + "\n");
            sbuf.append("getDisplayPromptOutputString: " + this.getDisplayPromptOutputString(data) + "\n");
            sbuf.append("getBodyOutputString: " + this.getBodyOutputString(data) + "\n");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sbuf.toString();
    }

    @Override
    public String getDataClassName() {
        return "com.sas.preferences.data.OMRGuiDefData";
    }

    @Override
    public void pullInfoOutOfDisplayAndSetInData(Map displayAttributes, GuiDefDataInterface data) throws RemoteException {
        String valToSet = null;
        if (displayAttributes.containsKey(data.getPrefKey())) {
            Object obj = displayAttributes.get(data.getPrefKey());
            if (obj instanceof String) {
                valToSet = (String)obj;
            } else if (obj instanceof String[]) {
                String[] valueList = (String[])obj;
                valToSet = valueList[0];
            } else {
                String errorMsg = MessageFormat.format(RB.getStringResource("got_an_internal_map_with_contents_other_than_string_or_string_array.fmt.txt"), obj.getClass().getName());
                LogManager.getLogger(this.m_userContext.getClass()).warn(errorMsg, (Object)this._loggingContext);
            }
            String screenedValToSet = InputScreener.screen(valToSet);
            data.setProfileCurrentValue(screenedValToSet);
        } else {
            String errorMsg = MessageFormat.format(RB.getStringResource("no_key_in_map_for_preference_key_provided.fmt.txt"), data.getPrefKey());
            LogManager.getLogger(this.m_userContext.getClass()).warn(errorMsg, (Object)this._loggingContext);
        }
    }
}

