/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences.data;

import com.sas.preferences.ConfigurationPropertiesException;
import com.sas.preferences.OMRGuiDefValidValueItem;
import com.sas.preferences.SASProfileInterface;
import com.sas.preferences.data.GuiDefDataInterface;
import com.sas.preferences.res.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.PrototypeInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.logging.log4j.LogManager;

public class OMRGuiDefData
implements GuiDefDataInterface {
    static final long serialVersionUID = -3390873665808006665L;
    private String m_strCategoryName;
    private String m_strPrompt;
    private String m_strPrefKey;
    private String m_strDefaultVal;
    List m_listValidValues = new ArrayList();
    UserContextInterface m_userContext;
    private String m_strCurrentValue;
    private String m_strOMRValue;
    private boolean m_bDirty;
    private boolean m_bOverrideAtPerson = false;
    private String _loggingContext = this.getClass().getName();

    @Override
    public void init(PrototypeInterface aJOMAGuiDef, UserContextInterface myUserContext) throws RemoteException {
        this.m_userContext = myUserContext;
        try {
            this.m_strPrefKey = aJOMAGuiDef.getDescription();
            Iterator it = aJOMAGuiDef.getUsedByPrototypes().iterator();
            if (it.hasNext()) {
                PropertyInterface aProperty = (PropertyInterface)it.next();
                this.m_strDefaultVal = aProperty.getValue();
                this.m_strPrefKey = aProperty.getName();
            }
            if (this.m_strDefaultVal == null) {
                String infoMsg = MessageFormat.format(RB.getStringResource("no_default_value_found_for_preference.fmt.txt"), this.m_strPrefKey);
                LogManager.getLogger(this.m_userContext.getClass()).warn(infoMsg, (Object)this._loggingContext);
                this.m_strDefaultVal = "";
            }
            for (PropertyInterface aProperty : aJOMAGuiDef.getObjectProperties()) {
                if (aProperty.getName().equalsIgnoreCase("prompt")) {
                    this.m_strPrompt = aProperty.getValue();
                    continue;
                }
                if (!aProperty.getName().equalsIgnoreCase("validvalue")) continue;
                this.m_listValidValues.add(new OMRGuiDefValidValueItem(aProperty.getValue(), aProperty.getDescription()));
            }
            it = aJOMAGuiDef.getParents().iterator();
            if (it.hasNext()) {
                MetadataInterface aParent = (MetadataInterface)it.next();
                this.m_strCategoryName = aParent.getName();
            }
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isSetAsOverride() {
        return this.m_bOverrideAtPerson;
    }

    @Override
    public void setAsOverride(boolean isOverrideAtPerson) {
        this.m_bOverrideAtPerson = isOverrideAtPerson;
    }

    @Override
    public String getPrompt() throws RemoteException {
        return this.m_strPrompt;
    }

    @Override
    public List getValidValues() throws RemoteException {
        return this.m_listValidValues;
    }

    @Override
    public String getPrefKey() throws RemoteException {
        return this.m_strPrefKey;
    }

    @Override
    public String getCategory() throws RemoteException {
        return this.m_strCategoryName;
    }

    @Override
    public String getDefaultValue() throws RemoteException {
        return this.m_strDefaultVal;
    }

    @Override
    public void setDefaultValue(String newVal) throws RemoteException {
        this.m_strDefaultVal = newVal;
    }

    @Override
    public String translateInternalVal(Locale aLocale, String internalVal) throws RemoteException {
        String retVal = null;
        try {
            retVal = RB.getStringResource(internalVal, aLocale);
        }
        catch (MissingResourceException e) {
            try {
                retVal = RB.getStringResource(internalVal + ".txt", aLocale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (retVal == null) {
            String infoMsg = MessageFormat.format(RB.getStringResource("no_resources_for_translating_internal_value.fmt.txt"), internalVal);
            LogManager.getLogger(this.m_userContext.getClass()).info(infoMsg, (Object)this._loggingContext);
            retVal = internalVal;
        }
        return retVal;
    }

    @Override
    public String getEditorClassName() throws RemoteException {
        return "com.sas.preferences.editors.HTMLDropDownEditor";
    }

    @Override
    public void setProfileCurrentValue(String newVal) throws RemoteException {
        if (this.m_strOMRValue == null) {
            this.m_strOMRValue = newVal;
            this.setDirty(true);
        } else if (this.m_strOMRValue != null && newVal != null) {
            this.setDirty(!this.m_strOMRValue.equals(newVal));
        } else {
            this.setDirty(true);
        }
        this.m_strCurrentValue = newVal;
    }

    @Override
    public void setOMRValue(String omrValue) throws RemoteException {
        this.m_strOMRValue = omrValue;
    }

    @Override
    public String getProfileCurrentValue() throws RemoteException {
        return this.m_strCurrentValue;
    }

    @Override
    public void setDirty(boolean newVal) throws RemoteException {
        this.m_bDirty = newVal;
    }

    @Override
    public boolean isDirty() throws RemoteException {
        return this.m_bDirty;
    }

    @Override
    public void persist(SASProfileInterface sasProfile) throws RemoteException {
        if (this.isDirty()) {
            sasProfile.setAttributeValue(this.getPrefKey(), this.getProfileCurrentValue());
            this.setOMRValue(this.getProfileCurrentValue());
            this.setAsOverride(true);
            this.setDirty(false);
        } else {
            String errorMsg = MessageFormat.format(RB.getStringResource("not_persisting_to_omr_as_not_changed.fmt.txt"), this.getPrefKey());
            LogManager.getLogger(this.m_userContext.getClass()).info(errorMsg, (Object)this._loggingContext);
        }
    }

    @Override
    public void resetToDefaults(SASProfileInterface sasProfile) throws RemoteException {
        try {
            sasProfile.removeAttributeValue(this.getPrefKey());
            String valFromProfile = sasProfile.getAttributeLookThrough(this.getPrefKey());
            this.setProfileCurrentValue(valFromProfile);
            this.setOMRValue(valFromProfile);
            this.setAsOverride(false);
            this.setDirty(false);
        }
        catch (ConfigurationPropertiesException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Category name:\t" + this.m_strCategoryName + "\n");
        sbuf.append("Prompt:\t\t" + this.m_strPrompt + "\n");
        sbuf.append("pref key:\t\t " + this.m_strPrefKey + "\n");
        sbuf.append("default value:\t " + this.m_strDefaultVal + "\n");
        sbuf.append("current value:\t " + this.m_strCurrentValue + "\n");
        sbuf.append("OMR value:\t " + this.m_strOMRValue + "\n");
        sbuf.append("List of valid values: \n");
        try {
            List validValues = this.getValidValues();
            if (validValues != null) {
                if (validValues.size() == 0) {
                    sbuf.append("\t-- LIST IS EMPTY --\n");
                } else {
                    for (int i = 0; i < validValues.size(); ++i) {
                        sbuf.append("\t" + validValues.get(i) + "\n");
                    }
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return sbuf.toString();
    }
}

