/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences.data;

import com.sas.preferences.data.GuiDefDataInterface;
import com.sas.preferences.data.OMRGuiDefData;
import com.sas.preferences.res.RB;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.MissingResourceException;

public class CurrencyDisplayGuiDefData
extends OMRGuiDefData
implements GuiDefDataInterface {
    private static final long serialVersionUID = -5497625388563004495L;

    @Override
    public String translateInternalVal(Locale locale, String value) throws RemoteException {
        Locale localeToUse = locale;
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance(localeToUse);
        if (currencyFormat.getCurrency().getSymbol().equals("XXX")) {
            if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("es")) {
                localeToUse = new Locale("es", "ES");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("it")) {
                localeToUse = new Locale("it", "IT");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("de")) {
                localeToUse = new Locale("DE", "DE");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("fr")) {
                localeToUse = new Locale("fr", "FR");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("ko")) {
                localeToUse = new Locale("ko", "KR");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("sv")) {
                localeToUse = new Locale("sv", "SE");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("ja")) {
                localeToUse = new Locale("ja", "JP");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("pl")) {
                localeToUse = new Locale("pl", "PL");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("ru")) {
                localeToUse = new Locale("ru", "RU");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("no")) {
                localeToUse = new Locale("no", "NO");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("da")) {
                localeToUse = new Locale("da", "DK");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("nl")) {
                localeToUse = new Locale("nl", "NL");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("zh")) {
                localeToUse = new Locale("zh", "CN");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("hu")) {
                localeToUse = new Locale("hu", "HU");
            } else if (localeToUse.getCountry().equals("") && localeToUse.getLanguage().equals("tr")) {
                localeToUse = new Locale("tr", "TR");
            }
            currencyFormat = NumberFormat.getCurrencyInstance(localeToUse);
        }
        String rbString = null;
        try {
            rbString = RB.getStringResource(value, locale);
        }
        catch (MissingResourceException e) {
            try {
                rbString = RB.getStringResource(value + ".txt", locale);
            }
            catch (MissingResourceException e2) {
                String errorMsg = MessageFormat.format(RB.getStringResource("no_resources_for_translating_internal_value.fmt.txt"), value);
                System.err.println(errorMsg);
            }
        }
        NumberFormat numFormat3 = NumberFormat.getCurrencyInstance(localeToUse);
        DecimalFormat decFormat3 = (DecimalFormat)numFormat3;
        decFormat3.applyPattern("\u00a4\u00a4");
        String stringForISO = decFormat3.format(0L);
        String stringForSymbol = currencyFormat.format(0L);
        stringForSymbol = stringForSymbol.charAt(0) == '0' ? stringForSymbol.substring(stringForSymbol.lastIndexOf("0") + 1).trim() : stringForSymbol.substring(0, stringForSymbol.indexOf("0")).trim();
        stringForISO = stringForISO.charAt(0) == '0' ? stringForISO.substring(stringForISO.lastIndexOf("0") + 1).trim() : stringForISO.substring(0, stringForISO.indexOf("0")).trim();
        String format2 = MessageFormat.format(rbString, stringForSymbol, stringForISO);
        return format2;
    }
}

