/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences;

import com.sas.preferences.OMRDefinedGUIInterface;
import com.sas.preferences.res.RB;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;

public class GuiDefValidValue
implements Serializable,
Comparable {
    static final long serialVersionUID = 6722021609406396092L;
    private String m_strOMRValue = null;
    private Locale _localeForJSPBeans = null;

    public GuiDefValidValue(String defaultOMRValue, OMRDefinedGUIInterface translationHelper) {
        this(defaultOMRValue);
        translationHelper.getClass();
    }

    public GuiDefValidValue(String defaultOMRValue) {
        this.m_strOMRValue = defaultOMRValue;
    }

    public void setLocaleForJSP(Locale aLocale) {
        this._localeForJSPBeans = aLocale;
    }

    public Locale getLocaleForJSP() {
        return this._localeForJSPBeans;
    }

    public String getDisplayString() {
        return this.getDisplayString(this.getLocaleForJSP());
    }

    public String getDisplayString(Locale aLocale) {
        String retVal = null;
        if (retVal == null && this.m_strOMRValue != null && this.m_strOMRValue.trim().length() > 0) {
            try {
                retVal = RB.getStringResource(this.m_strOMRValue, aLocale);
            }
            catch (MissingResourceException e) {
                try {
                    retVal = RB.getStringResource(this.m_strOMRValue + ".txt", aLocale);
                }
                catch (MissingResourceException e2) {
                    String errorMsg = MessageFormat.format(RB.getStringResource("no_resources_for_translating_internal_value.fmt.txt"), this.m_strOMRValue);
                    System.err.println(errorMsg);
                }
            }
        }
        if (retVal == null) {
            retVal = this.m_strOMRValue;
        }
        return retVal;
    }

    public String getOMRValue() {
        return this.m_strOMRValue;
    }

    public String toString() {
        return this.getDisplayString();
    }

    public String toString(Locale aLocale) {
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("OMRValue=" + this.m_strOMRValue);
        sBuf.append("\tGetDisplayString(" + aLocale.toString() + ")=");
        sBuf.append(this.getDisplayString(aLocale) + "\n");
        return sBuf.toString();
    }

    public int compareTo(Object obj) {
        int retVal = 0;
        if (obj instanceof GuiDefValidValue) {
            GuiDefValidValue otherGuy = (GuiDefValidValue)obj;
            retVal = this.getDisplayString().compareTo(otherGuy.getDisplayString());
        }
        return retVal;
    }
}

