/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences;

import com.sas.preferences.ConfigurationPropertiesException;
import com.sas.preferences.ConfigurationPropertiesInterface;
import com.sas.preferences.SASProfileUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PropertySetInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.Properties;

public class GlobalProperties
implements ConfigurationPropertiesInterface {
    private static final long serialVersionUID = 1L;
    private static Properties m_properties = new Properties();
    private static Object m_syncObj = new Object();

    protected GlobalProperties(Properties infoFromOMR) throws ConfigurationPropertiesException {
        GlobalProperties.setGlobalProperties(infoFromOMR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setGlobalProperties(Properties newSet) {
        Object object = m_syncObj;
        synchronized (object) {
            m_properties = newSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearGlobalProperties() {
        Object object = m_syncObj;
        synchronized (object) {
            m_properties = new Properties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getAllAttributes() {
        Object object = m_syncObj;
        synchronized (object) {
            return m_properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttributeValue(String strKey) throws ConfigurationPropertiesException {
        Object object = m_syncObj;
        synchronized (object) {
            String retVal = null;
            if (m_properties != null) {
                retVal = (String)m_properties.get(strKey);
            }
            return retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributeValue(UserContextInterface userContext, String strKey, String strValue) throws ConfigurationPropertiesException {
        Object object = m_syncObj;
        synchronized (object) {
            SASProfileUtil.setAttributeValueOnSoftwareComponent(userContext, "SAS Application Infrastructure", strKey, strValue, this.getAttributeValue(strKey));
            m_properties.setProperty(strKey, strValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String removeAttributeValue(UserContextInterface userContext, String strKey) throws ConfigurationPropertiesException {
        Object object = m_syncObj;
        synchronized (object) {
            String prevValue = SASProfileUtil.removeAttributeValueOnSoftwareComponent(userContext, "SAS Application Infrastructure", strKey);
            m_properties.remove(strKey);
            return prevValue;
        }
    }

    @Override
    public boolean canSetAttribute(UserContextInterface userContext, String strKey) throws ConfigurationPropertiesException {
        if (strKey != null) {
            // empty if block
        }
        boolean canWriteToProperties = false;
        try {
            PropertySetInterface aPropertySet = SASProfileUtil.getPropertySetForSoftwareComponent(userContext, "SAS Application Infrastructure");
            canWriteToProperties = SASProfileUtil.canWriteData((MetadataInterface)aPropertySet);
        }
        catch (RemoteException e) {
            throw new ConfigurationPropertiesException(e);
        }
        return canWriteToProperties;
    }

    @Override
    public boolean canRemoveAttribute(UserContextInterface userContext, String strKey) throws ConfigurationPropertiesException {
        if (strKey != null) {
            // empty if block
        }
        boolean canRemoveProperties = false;
        try {
            PropertySetInterface aPropertySet = SASProfileUtil.getPropertySetForSoftwareComponent(userContext, "SAS Application Infrastructure");
            canRemoveProperties = SASProfileUtil.canDeleteData((MetadataInterface)aPropertySet);
        }
        catch (RemoteException e) {
            throw new ConfigurationPropertiesException(e);
        }
        return canRemoveProperties;
    }

    @Override
    public void clearCache() throws ConfigurationPropertiesException {
        GlobalProperties.clearGlobalProperties();
    }
}

