/*
 * Decompiled with CFR 0.152.
 */
package com.sas.nls.l10n.font;

import com.sas.nls.l10n.font.LoadTTFont;
import com.sas.nls.l10n.font.PropMappings;
import com.sas.nls.l10n.font.TTFontInfo;
import com.sas.nls.l10n.font.TTMappingInfo;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public class TTFontLanguageMapping {
    private static final Map<Locale, PropMappings> pMappings = new WeakHashMap<Locale, PropMappings>();
    private static final Map<Locale, LoadTTFont> loadTTFont = new WeakHashMap<Locale, LoadTTFont>();
    private static final TTFontInfo[] EMPTY_FONTS = new TTFontInfo[0];

    private TTFontLanguageMapping() {
    }

    public static String[] getFontFileNames() {
        HashSet<String> results = new HashSet<String>();
        TTMappingInfo[] fontMappings = TTFontLanguageMapping.getPMappings().getFontMappings();
        for (int i = 0; i < fontMappings.length; ++i) {
            results.add(fontMappings[i].getFontFileName());
        }
        return results.toArray(new String[results.size()]);
    }

    public static TTFontInfo[] getTTFontInfo(String fontName) {
        ArrayList<TTMappingInfo> results = new ArrayList<TTMappingInfo>();
        TTMappingInfo[] mappings = TTFontLanguageMapping.getPMappings().getMappingsForName(fontName);
        for (int i = 0; i < mappings.length; ++i) {
            if (!fontName.equals(mappings[i].getFontFileName()) && !fontName.equalsIgnoreCase(mappings[i].getFontFamilyName()) && !fontName.equalsIgnoreCase(mappings[i].getFontName()) && !fontName.equalsIgnoreCase(mappings[i].getLocalizedFontFamilyName()) && !fontName.equalsIgnoreCase(mappings[i].getLocalizedFontName())) continue;
            results.add(mappings[i]);
        }
        return results.toArray(new TTFontInfo[results.size()]);
    }

    public static String[] getLanguagesForFont(String fontName) {
        TTMappingInfo[] mappings = TTFontLanguageMapping.getPMappings().getMappingsForName(fontName);
        if (mappings.length > 0) {
            Collection languages = mappings[0].getLanguages();
            return languages.toArray(new String[languages.size()]);
        }
        return new String[0];
    }

    public static String[] getLocalesForFont(String fontName) {
        TTMappingInfo[] mappings = TTFontLanguageMapping.getPMappings().getMappingsForName(fontName);
        if (mappings.length > 0) {
            Collection locales = mappings[0].getLocales();
            return locales.toArray(new String[locales.size()]);
        }
        return new String[0];
    }

    public static TTFontInfo[] getFontsForLanguage(String language) {
        String lang = language.toLowerCase();
        String simpleLanguage = null;
        int pos = lang.indexOf(" (");
        if (pos > 0) {
            simpleLanguage = lang.substring(0, pos);
        }
        ArrayList<TTMappingInfo> results = null;
        ArrayList<TTMappingInfo> languageList = null;
        TTMappingInfo[] fontMappings = TTFontLanguageMapping.getPMappings().getFontMappings();
        for (int i = 0; i < fontMappings.length; ++i) {
            if (TTFontLanguageMapping.containsLanguage(fontMappings[i], lang)) {
                if (results == null) {
                    results = new ArrayList<TTMappingInfo>();
                }
                results.add(fontMappings[i]);
            }
            if (results != null || simpleLanguage == null || !TTFontLanguageMapping.containsLanguage(fontMappings[i], simpleLanguage)) continue;
            if (languageList == null) {
                languageList = new ArrayList<TTMappingInfo>();
            }
            languageList.add(fontMappings[i]);
        }
        if (results != null) {
            return results.toArray(new TTFontInfo[results.size()]);
        }
        if (languageList != null) {
            return languageList.toArray(new TTFontInfo[languageList.size()]);
        }
        return EMPTY_FONTS;
    }

    public static TTFontInfo[] getFontsForLocale(Locale locale) {
        String language = locale.getLanguage();
        ArrayList<TTMappingInfo> results = new ArrayList<TTMappingInfo>();
        TTMappingInfo[] fontMappings = TTFontLanguageMapping.getPMappings().getFontMappings();
        String country = locale.getCountry();
        if (country != null && country.length() > 0) {
            String localeName = language + "_" + country;
            ArrayList<TTMappingInfo> coResults = new ArrayList<TTMappingInfo>();
            for (int i = 0; i < fontMappings.length; ++i) {
                Collection locales = fontMappings[i].getLocales();
                if (locales.contains(language)) {
                    results.add(fontMappings[i]);
                }
                if (!locales.contains(localeName)) continue;
                coResults.add(fontMappings[i]);
            }
            if (!coResults.isEmpty()) {
                return coResults.toArray(new TTFontInfo[coResults.size()]);
            }
            return results.toArray(new TTFontInfo[results.size()]);
        }
        for (int i = 0; i < fontMappings.length; ++i) {
            Collection locales = fontMappings[i].getLocales();
            if (!locales.contains(language)) continue;
            results.add(fontMappings[i]);
        }
        return results.toArray(new TTFontInfo[results.size()]);
    }

    public static boolean hasSupport(String fontName, String language) {
        String lang = language.toLowerCase();
        String simpleLanguage = null;
        int pos = lang.indexOf(" (");
        if (pos > 0 && !lang.startsWith("chinese")) {
            simpleLanguage = lang.substring(0, pos);
        }
        TTMappingInfo[] mappings = TTFontLanguageMapping.getPMappings().getMappingsForName(fontName);
        for (int i = 0; i < mappings.length; ++i) {
            if (TTFontLanguageMapping.containsLanguage(mappings[i], lang)) {
                return true;
            }
            if (simpleLanguage == null || !TTFontLanguageMapping.containsLanguage(mappings[i], simpleLanguage)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSupport(String fontName, Locale locale) {
        String localeName;
        String language = localeName = locale.getLanguage();
        String country = locale.getCountry();
        if (country != null && country.length() > 0) {
            localeName = localeName + "_" + country;
        }
        if (language.equals("zh")) {
            language = "xx";
        }
        TTMappingInfo[] mappings = TTFontLanguageMapping.getPMappings().getMappingsForName(fontName);
        for (int i = 0; i < mappings.length; ++i) {
            Collection locales;
            if (!fontName.equals(mappings[i].getFontFileName()) && !fontName.equalsIgnoreCase(mappings[i].getFontFamilyName()) && !fontName.equalsIgnoreCase(mappings[i].getFontName()) && !fontName.equalsIgnoreCase(mappings[i].getLocalizedFontFamilyName()) && !fontName.equalsIgnoreCase(mappings[i].getLocalizedFontName()) || !(locales = mappings[i].getLocales()).contains(language) && !locales.contains(localeName)) continue;
            return true;
        }
        return false;
    }

    public static Font loadFont(String name, int style, int size) {
        return TTFontLanguageMapping.getLoadTTFont().loadFont(name, style, size);
    }

    public static Font loadFont(String text) {
        return TTFontLanguageMapping.getLoadTTFont().loadFont(text);
    }

    public static Font loadFont(Map attributes) {
        return TTFontLanguageMapping.getLoadTTFont().loadFont(attributes);
    }

    public static String getITextFileName(String name, int style) {
        return TTFontLanguageMapping.getLoadTTFont().getITextFileName(name, style);
    }

    public static TTFontInfo findTrueTypeFontInfo(String name, int style) {
        return TTFontLanguageMapping.getLoadTTFont().findTrueTypeFontInfo(name, style);
    }

    public static TTFontInfo findTrueTypeFontInfo(String name) {
        return TTFontLanguageMapping.getLoadTTFont().findTrueTypeFontInfo(name);
    }

    static TTFontInfo findTrueTypeFontInfo(Map attributes) {
        return TTFontLanguageMapping.getLoadTTFont().findTrueTypeFontInfo(attributes);
    }

    private static boolean containsLanguage(TTMappingInfo info, String language) {
        Collection languages = info.getLanguages();
        if (!languages.isEmpty()) {
            Object[] langs = languages.toArray(new String[languages.size()]);
            Arrays.sort(langs);
            for (String lng : info.getLanguages()) {
                if (!lng.toLowerCase().startsWith(language)) continue;
                return true;
            }
        }
        return false;
    }

    private static PropMappings getPMappings() {
        Locale locale = Locale.getDefault();
        PropMappings mappings = pMappings.get(locale);
        if (mappings == null) {
            mappings = new PropMappings();
            pMappings.put(locale, mappings);
        }
        return mappings;
    }

    private static LoadTTFont getLoadTTFont() {
        Locale locale = Locale.getDefault();
        LoadTTFont load = loadTTFont.get(locale);
        if (load == null) {
            load = new LoadTTFont(TTFontLanguageMapping.getPMappings());
            loadTTFont.put(locale, load);
        }
        return load;
    }
}

