/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.FixedLengthPlainDocument;
import com.sas.query.models.JDataSourceTree;
import com.sas.query.visuals.AddTableDialog;
import com.sas.query.visuals.JDataSourceTreeView;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.StandardDialog;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;

public class ViewDialog
extends StandardDialog {
    public static final int LOAD = 1;
    public static final int SAVE = 2;
    public static final int CREATE = 3;
    static QueryResource bundle = new QueryResource(AddTableDialog.class);
    protected int m_mode;
    protected String m_viewTemplate;
    protected String m_viewName;
    protected int m_type;
    protected boolean m_overwriteOccured;
    protected boolean m_saveCancelled = false;
    protected boolean m_promptForPasswords = false;
    protected JDataSourceTreeView m_dataSourceTreeView;
    protected JTextField m_textField;
    protected JTextField m_passwordField;
    protected JLabel m_passwordLabel;

    public ViewDialog(Query query, Frame frame, int type) {
        this(query, frame, true, type);
    }

    public ViewDialog(Query query, Frame frame, boolean bModal, int type) {
        super(query, frame, bModal);
        this.setMode(1);
        this.m_viewName = null;
        this.m_type = type;
        JDataSourceTree metadataModel = new JDataSourceTree(this.m_query, this.m_query.getDataSource(), false);
        this.m_dataSourceTreeView = new JDataSourceTreeView(this.m_query, metadataModel){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                block8: {
                    Object node;
                    block5: {
                        DataSourceTable table;
                        block7: {
                            block6: {
                                TreePath path = event.getNewLeadSelectionPath();
                                if (path == null) {
                                    return;
                                }
                                node = path.getLastPathComponent();
                                if (node == null) {
                                    return;
                                }
                                if (!(node instanceof DataSourceTable)) break block5;
                                table = (DataSourceTable)node;
                                if (table.isView()) break block6;
                                int n = ViewDialog.this.m_type;
                                ViewDialog.this._getSqlProperties();
                                if ((n & 1) != 0) break block7;
                            }
                            if (!table.isView()) break block8;
                            int n = ViewDialog.this.m_type;
                            ViewDialog.this._getSqlProperties();
                            if ((n & 2) == 0) break block8;
                        }
                        ViewDialog.this.m_textField.setText(table.getQualifiedName());
                        break block8;
                    }
                    if (node instanceof DataSourceContainer) {
                        DataSourceContainer parent = (DataSourceContainer)node;
                        ViewDialog.this.m_textField.setText(parent.getQualifiedName() + this.m_query.getDataSource().getProperties().getCatalogSeparator());
                    }
                }
            }

            @Override
            public void onAction(TreePath path) {
                block4: {
                    block6: {
                        DataSourceTable table;
                        block5: {
                            Object node = path.getLastPathComponent();
                            if (node == null) {
                                return;
                            }
                            if (!(node instanceof DataSourceTable)) break block4;
                            table = (DataSourceTable)node;
                            if (table.isView()) break block5;
                            int n = ViewDialog.this.m_type;
                            ViewDialog.this._getSqlProperties();
                            if ((n & 1) != 0) break block6;
                        }
                        if (!table.isView()) break block4;
                        int n = ViewDialog.this.m_type;
                        ViewDialog.this._getSqlProperties();
                        if ((n & 2) == 0) break block4;
                    }
                    ViewDialog.this.onOK();
                }
            }
        };
        this._getSqlProperties();
        if ((type & 1) == 0) {
            this.m_dataSourceTreeView.enableTables(false);
        }
        this._getSqlProperties();
        if ((type & 2) == 0) {
            this.m_dataSourceTreeView.enableViews(false);
        }
        this.m_strCancelLabel = bundle.getString("Standard.ButtonLabel.Cancel.txt");
        this._addWidgets();
        this.setSize(450, 270);
    }

    @Override
    public void closing() {
    }

    public void selectNodeinTree(String qualifiedName) {
        int containerRow = 0;
        int tableRow = 0;
        String strContainer = qualifiedName;
        if (qualifiedName != null) {
            int j;
            int pos = qualifiedName.indexOf(this._getSqlProperties().getCatalogSeparator());
            if (pos != -1) {
                strContainer = qualifiedName.substring(0, qualifiedName.indexOf(this._getSqlProperties().getCatalogSeparator()));
            }
            String[] containerNames = this.m_query.getDataSource().getItemNames();
            for (int i = 0; i < containerNames.length; ++i) {
                if (!containerNames[i].equalsIgnoreCase(strContainer)) continue;
                containerRow = i + 1;
            }
            if (!this.isTreeOneLevel()) {
                DataSourceTable table = this.m_query.getDataSource().getTable(qualifiedName);
                DataSourceContainerList containerList = this.m_query.getDataSource().getItems();
                if (table != null) {
                    for (int containerIndex = 0; containerIndex < containerList.size(); ++containerIndex) {
                        DataSourceContainer child = containerList.elementAt(containerIndex);
                        if (!child.getName().equalsIgnoreCase(strContainer)) continue;
                        DataSourceContainerList tableList = child.getItems();
                        for (int tableIndex = 0; tableIndex < tableList.size(); ++tableIndex) {
                            DataSourceContainer container = tableList.elementAt(tableIndex);
                            if (!(container instanceof DataSourceTable) || !container.getName().equalsIgnoreCase(table.getName())) continue;
                            tableRow = tableIndex + 1;
                        }
                    }
                }
            }
            if (containerRow != 0) {
                for (j = 0; j < this.getTree().getRowCount(); ++j) {
                    this.getTree().collapseRow(j + 1);
                    if (!this.getTree().isRowSelected(j + 1)) continue;
                    this.getTree().removeSelectionRow(j + 1);
                }
                this.getTree().expandRow(containerRow);
                this.getTree().setSelectionRow(containerRow + tableRow);
            } else {
                for (j = 0; j < this.getTree().getRowCount(); ++j) {
                    if (!this.getTree().isRowSelected(j + 1)) continue;
                    this.getTree().removeSelectionRow(j + 1);
                }
            }
        }
    }

    protected JTree getTree() {
        return this.m_dataSourceTreeView.m_tree;
    }

    protected boolean isTreeOneLevel() {
        DataSourceContainerList container = this.m_query.getDataSource().getItems();
        DataSourceContainer child = container.elementAt(0);
        return child instanceof DataSourceTable;
    }

    public void setMode(int mode) {
        this.m_mode = mode;
        if (mode == 1) {
            this.setOkLabel(bundle.getString("Standard.ButtonLabel.Open.txt"));
        } else if (mode == 2) {
            this.setOkLabel(bundle.getString("Standard.ButtonLabel.Save.txt"));
        } else {
            this.setOkLabel(bundle.getString("Standard.ButtonLabel.Create.txt"));
        }
        if (this.m_passwordField != null) {
            this.m_passwordField.setText("");
        }
        this.m_saveCancelled = false;
    }

    public void setView(String viewTemplate) {
        this.m_viewTemplate = viewTemplate;
    }

    public String getViewName() {
        return this.m_viewName;
    }

    public String getPassword() {
        if (this.m_passwordField == null) {
            return null;
        }
        if (this.m_passwordField.getText().length() < 1) {
            return null;
        }
        return this.m_passwordField.getText();
    }

    public void setViewName(String qualifiedName) {
        this.m_viewName = qualifiedName;
    }

    @Override
    public void onOK() {
        this.m_viewName = this.m_textField.getText();
        if (this.m_viewName != null && this.m_viewName.length() == 0) {
            this.m_viewName = null;
        }
        if (this.m_viewName == null) {
            return;
        }
        this.m_viewName = this.getQuery().getSqlLogic().getQualifiedName(this.m_viewName);
        this.m_overwriteOccured = false;
        DataSourceTable table = this.m_query.getDataSource().getTable(this.m_viewName);
        int choice = 2;
        Object[] warningOptions = new Object[]{bundle.getString("Standard.ButtonLabel.Yes.txt"), bundle.getString("Standard.ButtonLabel.No.txt")};
        if ((this.m_mode == 2 || this.m_mode == 3) && table != null) {
            if (table.isView()) {
                if (this._getSqlProperties().supportsReplacingViews(this.m_type)) {
                    choice = JOptionPane.showOptionDialog(this, bundle.messageString("Message.Label.ReplaceView.fmt.txt", this.m_viewName), this.getTitle(), 0, 3, null, warningOptions, warningOptions[1]);
                }
            } else if (this._getSqlProperties().supportsReplacingTables(this.m_type)) {
                choice = JOptionPane.showOptionDialog(this, bundle.messageString("Message.Label.ReplaceTable.fmt.txt", this.m_viewName), this.getTitle(), 0, 3, null, warningOptions, warningOptions[1]);
            }
            if (choice == 1 || choice == -1) {
                this.m_textField.requestFocus();
                return;
            }
            if (choice == 0) {
                this.m_overwriteOccured = true;
            }
        }
        super.onOK();
    }

    @Override
    protected void onCancel() {
        this.m_saveCancelled = true;
        super.onCancel();
    }

    public boolean isCancelPressed() {
        return this.m_saveCancelled;
    }

    public boolean overwriteHasOccurred() {
        return this.m_overwriteOccured;
    }

    protected SqlProperties _getSqlProperties() {
        return this.getQuery().getDataSource().getProperties();
    }

    protected boolean passwordPromptingEnabled() {
        return this.m_promptForPasswords;
    }

    public void setPasswordPrompting(boolean val) {
        this.m_promptForPasswords = val;
        if (this.m_passwordField != null) {
            this.m_passwordField.setVisible(val);
            this.m_passwordLabel.setVisible(val);
        }
    }

    protected void _addWidgets() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(10, 10));
        mainPanel.add(this.m_dataSourceTreeView);
        JLabel textLabel = null;
        this._getSqlProperties();
        textLabel = this.m_type == 1 ? new JLabel(bundle.getString("ViewDialog.DataSetName.txt")) : new JLabel(bundle.getString("ViewDialog.ViewName.txt"));
        this.m_textField = new JTextField();
        int maxStrLength = this._getSqlProperties().getMaxTableNameLength();
        if (!this.isTreeOneLevel()) {
            maxStrLength = maxStrLength + this._getSqlProperties().getCatalogSeparator().length() + maxStrLength;
        }
        this.m_textField.setDocument(new FixedLengthPlainDocument(maxStrLength));
        this.m_passwordLabel = new JLabel(bundle.getString("ViewDialog.AlterPassword.txt"));
        this.m_passwordField = new JPasswordField();
        this.m_passwordField.setVisible(this.passwordPromptingEnabled());
        this.m_passwordLabel.setVisible(this.passwordPromptingEnabled());
        JPanel textPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        textPanel.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 10, 0, 0);
        gridBagLayout.setConstraints(textLabel, gbc);
        textPanel.add(textLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 10, 0, 0);
        gridBagLayout.setConstraints(this.m_textField, gbc);
        textPanel.add(this.m_textField);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 10, 0, 0);
        gridBagLayout.setConstraints(this.m_passwordLabel, gbc);
        textPanel.add(this.m_passwordLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 0, 0);
        gridBagLayout.setConstraints(this.m_passwordField, gbc);
        textPanel.add(this.m_passwordField);
        mainPanel.add("South", textPanel);
        this.setMainPanel(mainPanel);
    }
}

