/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.QueryResource;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import javax.swing.JComponent;

public class VerticalHeader
extends JComponent {
    int m_ascent = 0;
    int m_lineHeight = 0;
    String m_text;
    Image m_image;
    int m_textWidth = 0;
    protected static QueryResource bundle = new QueryResource(VerticalHeader.class);

    public VerticalHeader(String text) {
        this.m_text = text;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.m_lineHeight != 0) {
            return new Dimension(this.m_lineHeight + 2, this.m_textWidth + 10);
        }
        return new Dimension(20, 100);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.m_lineHeight != 0) {
            return new Dimension(this.m_lineHeight + 2, this.m_textWidth + 10);
        }
        return new Dimension(20, 100);
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        if (this.m_lineHeight == 0) {
            Font font = this.getFont();
            Font newFont = new Font(font.getName(), font.getStyle(), font.getSize() + 2);
            this.setFont(newFont);
            g.setFont(newFont);
            FontMetrics fontmetrics = g.getFontMetrics();
            this.m_ascent = fontmetrics.getAscent();
            this.m_lineHeight = fontmetrics.getAscent() + fontmetrics.getDescent() + 4;
            this.m_textWidth = fontmetrics.stringWidth(this.m_text);
            this.m_image = this.getVerticalImage(this, g, Color.white, this.getBackground().darker(), this.m_text, 3, size.height / 3);
        }
        Rectangle bounds = this.getBounds();
        DrawUtil.draw3DBox(g, this.getBackground().darker(), this.getBackground().brighter(), this.getBackground().darker().darker(), 0, 0, size.width - 1, size.height - 1);
        int imageY = (bounds.height - this.m_textWidth) / 2;
        int imageX = (bounds.width - this.m_ascent) / 2;
        g.setClip(2, 2, bounds.width - 4, bounds.height - 4);
        g.drawImage(this.m_image, imageX, imageY, null);
    }

    public Image getVerticalImage(JComponent component, Graphics g, Color foreground, Color background, String text, int x, int y) {
        FontMetrics fontmetrics = g.getFontMetrics();
        int width = fontmetrics.stringWidth(text);
        int height = fontmetrics.getAscent() + fontmetrics.getDescent();
        Image horizontalImage = component.createImage(width, height);
        Graphics imageG = horizontalImage.getGraphics();
        imageG.setFont(g.getFont());
        imageG.setColor(background);
        imageG.fillRect(0, 0, width, height);
        imageG.setColor(foreground);
        imageG.drawString(text, 0, fontmetrics.getAscent());
        int[] horizontalPixels = this.grabPixels(horizontalImage);
        if (horizontalPixels == null) {
            return null;
        }
        int[] verticalPixels = new int[width * height];
        for (int heightIndex = 0; heightIndex < height; ++heightIndex) {
            for (int widthIndex = 0; widthIndex < width; ++widthIndex) {
                verticalPixels[(width - widthIndex - 1) * height + heightIndex] = horizontalPixels[heightIndex * width + widthIndex];
            }
        }
        Image verticalImage = this.createImage(new MemoryImageSource(height, width, verticalPixels, 0, height));
        return verticalImage;
    }

    public int[] grabPixels(Image image) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            MessageHandler.addStaticError(bundle.getString("Message.VerticalHeader.Interupt.txt"));
            return null;
        }
        if ((grabber.getStatus() & 0x80) != 0) {
            MessageHandler.addStaticError(bundle.getString("Message.VerticalHeader.ImageFetchInterupt.txt"));
            return null;
        }
        return pixels;
    }
}

