/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.UnionConstants;
import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.QueryComponentInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class UnionPropertyView
extends JPanel
implements QueryComponentInterface,
UnionConstants,
ItemListener {
    protected Query m_query;
    protected int m_unionType;
    protected JLabel m_typeLabel;
    protected JComboBox m_typeCombo;
    protected JTextArea m_typeText;
    protected JPanel m_previewPanel;

    UnionPropertyView(Query query) {
        this.m_query = query;
        this._initialize();
        this._layoutWidgets();
        this._setState();
    }

    @Override
    public void closing() {
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    @Override
    public void doDataExchange(boolean bSaveToModel) {
        if (this.m_query == null) {
            return;
        }
        if (bSaveToModel) {
            this.m_query.setUnionType(this.m_unionType);
        } else {
            this.m_unionType = this.m_query.getUnionType();
            this.m_typeCombo.setSelectedIndex(this.m_unionType);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.m_typeCombo && event.getStateChange() == 1) {
            this.m_unionType = this.m_typeCombo.getSelectedIndex();
            this._setState();
            this.repaint();
        }
    }

    protected void _initialize() {
        this.m_typeLabel = new JLabel("Type");
        this.m_typeCombo = new JComboBox();
        this.m_typeCombo.addItem("Union");
        this.m_typeCombo.addItem("Union All");
        this.m_typeCombo.addItem("Intersect");
        this.m_typeCombo.addItem("Except");
        this.m_typeCombo.addItemListener(this);
        this.m_typeText = new JTextArea();
        this.m_typeText.setEditable(false);
        this.m_typeText.setRows(4);
        this.m_typeText.setColumns(25);
        this.m_previewPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(309, 160);
            }

            @Override
            public void paintComponent(Graphics g) {
                int m_lineHeight = 0;
                int m_descent = 0;
                if (m_lineHeight == 0) {
                    FontMetrics fontmetrics = g.getFontMetrics();
                    m_lineHeight = fontmetrics.getAscent() + fontmetrics.getDescent() + 2;
                    m_descent = fontmetrics.getDescent();
                }
                Rectangle leftRect = new Rectangle(8, 0, 124, 116);
                Rectangle rightRect = new Rectangle(167, 0, 124, 116);
                Color lightBackground = new Color(211, 211, 211);
                DrawUtil.draw3DBox(g, lightBackground, Color.white, this.getBackground().darker().darker(), leftRect.x, leftRect.y + m_lineHeight, leftRect.width - 1, leftRect.height - 1 - m_lineHeight);
                DrawUtil.draw3DBox(g, this.getBackground().darker(), Color.white, this.getBackground().darker().darker(), leftRect.x, leftRect.y, leftRect.width - 1, m_lineHeight - 1);
                DrawUtil.draw3DBox(g, lightBackground, Color.white, this.getBackground().darker().darker(), rightRect.x, rightRect.y + m_lineHeight, rightRect.width - 1, rightRect.height - 1 - m_lineHeight);
                DrawUtil.draw3DBox(g, this.getBackground().darker(), Color.white, this.getBackground().darker().darker(), rightRect.x, rightRect.y, rightRect.width - 1, m_lineHeight - 1);
                g.setColor(Color.white);
                int index = Query.getUnionIndex(UnionPropertyView.this.m_query);
                g.drawString("Select " + index, leftRect.x + 6, leftRect.y + m_lineHeight - m_descent);
                g.drawString("Select " + (index + 1), rightRect.x + 6, rightRect.y + m_lineHeight - m_descent);
                g.setColor(Color.black);
                if (UnionPropertyView.this.m_unionType == 3) {
                    g.drawString("Provides distinct", leftRect.x + 6, leftRect.y + m_lineHeight * 2);
                    g.drawString("rows that may be", leftRect.x + 6, leftRect.y + m_lineHeight * 3);
                    g.drawString("in the result set.", leftRect.x + 6, leftRect.y + m_lineHeight * 4);
                    g.drawString("Controls which rows", rightRect.x + 6, rightRect.y + m_lineHeight * 2);
                    g.drawString("are not returned in", rightRect.x + 6, rightRect.y + m_lineHeight * 3);
                    g.drawString("the result set.", rightRect.x + 6, rightRect.y + m_lineHeight * 4);
                }
                if (UnionPropertyView.this.m_unionType == 2) {
                    g.drawString("Provides distinct", leftRect.x + 6, leftRect.y + m_lineHeight * 2);
                    g.drawString("rows that may be", leftRect.x + 6, leftRect.y + m_lineHeight * 3);
                    g.drawString("in the result set.", leftRect.x + 6, leftRect.y + m_lineHeight * 4);
                    g.drawString("Provides distinct", rightRect.x + 6, rightRect.y + m_lineHeight * 2);
                    g.drawString("rows that may be", rightRect.x + 6, rightRect.y + m_lineHeight * 3);
                    g.drawString("in the result set.", rightRect.x + 6, rightRect.y + m_lineHeight * 4);
                }
                if (UnionPropertyView.this.m_unionType == 1) {
                    g.drawString("All selected rows", leftRect.x + 6, leftRect.y + m_lineHeight * 2);
                    g.drawString("will be in the", leftRect.x + 6, leftRect.y + m_lineHeight * 3);
                    g.drawString("result set.", leftRect.x + 6, leftRect.y + m_lineHeight * 4);
                    g.drawString("All selected rows", rightRect.x + 6, rightRect.y + m_lineHeight * 2);
                    g.drawString("will be in the", rightRect.x + 6, rightRect.y + m_lineHeight * 3);
                    g.drawString("result set.", rightRect.x + 6, rightRect.y + m_lineHeight * 4);
                }
                if (UnionPropertyView.this.m_unionType == 0) {
                    g.drawString("Provides rows that", leftRect.x + 6, leftRect.y + m_lineHeight * 2);
                    g.drawString("will be in a distinct", leftRect.x + 6, leftRect.y + m_lineHeight * 3);
                    g.drawString("result set.", leftRect.x + 6, leftRect.y + m_lineHeight * 4);
                    g.drawString("Provides rows that", rightRect.x + 6, rightRect.y + m_lineHeight * 2);
                    g.drawString("will be in a distinct", rightRect.x + 6, rightRect.y + m_lineHeight * 3);
                    g.drawString("result set.", rightRect.x + 6, rightRect.y + m_lineHeight * 4);
                }
                DrawUtil.drawUnionLine(UnionPropertyView.this.m_unionType, this, g, leftRect, rightRect);
            }
        };
        this.m_previewPanel.setSize(370, 170);
        if (this.m_query == null) {
            this.setEnabled(false);
        }
    }

    protected void _layoutWidgets() {
        JPanel typePanel = new JPanel();
        typePanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        GridBagLayout gridBagLayout = new GridBagLayout();
        typePanel.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_typeLabel, gbc);
        typePanel.add(this.m_typeLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(6, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_typeCombo, gbc);
        typePanel.add(this.m_typeCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.gridheight = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 8, 0, 0);
        this.m_typeText.setPreferredSize(new Dimension(233, 55));
        this.m_typeText.setBackground(this.getBackground());
        this.m_typeText.setLineWrap(true);
        this.m_typeText.setFont(this.getFont());
        gridBagLayout.setConstraints(this.m_typeText, gbc);
        typePanel.add(this.m_typeText);
        gridy += 2;
        JLabel label = new JLabel("Preview");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 0, 0, 0);
        gridBagLayout.setConstraints(label, gbc);
        typePanel.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.anchor = 12;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_previewPanel, gbc);
        typePanel.add(this.m_previewPanel);
        this.setLayout(new BorderLayout());
        this.add(typePanel);
    }

    protected void _setState() {
        if (this.m_unionType == 0) {
            this.m_typeText.setText("Returns all distinct rows selected by\neither query.");
        } else if (this.m_unionType == 1) {
            this.m_typeText.setText("Returns all rows selected by either query,\nincluding duplicate rows.");
        } else if (this.m_unionType == 2) {
            this.m_typeText.setText("Returns all distinct rows selected by both\nqueries.");
        } else if (this.m_unionType == 3) {
            this.m_typeText.setText("Returns all distinct rows selected by the\nfirst query but not the selected by the\nsecond query. ");
        }
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        Rectangle rect = this.getBounds();
        rect.x = this.m_typeLabel.getBounds().x + 55;
        rect.width -= this.m_typeLabel.getBounds().x + 67;
        rect.y += 7;
        DrawUtil.drawSeparatorLine(g, this.getBackground(), rect);
        rect.y += 87;
        DrawUtil.drawSeparatorLine(g, this.getBackground(), rect);
    }
}

