/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.FilterNodeView;
import com.sas.query.visuals.Part;
import com.sas.query.visuals.QueryResource;
import java.awt.Dimension;
import java.awt.Graphics;

class Terminator
extends Part {
    protected static QueryResource bundle = new QueryResource(Terminator.class);
    protected Object m_object = new Object();
    protected int m_defaultCircleSize = 23;

    Terminator(FilterNodeView nodeView, int placementX, int placementY) {
        super(nodeView.getParent());
        this.setSize(this.getPreferredSize(this.getParent().getGraphics()));
        this.x = placementX;
        this.y = placementY;
        this.height = nodeView.height;
    }

    public void setDefaultCircleSize(int size) {
        this.m_defaultCircleSize = size;
        this.setSize(new Dimension(this.m_defaultCircleSize, this.m_defaultCircleSize));
    }

    protected void paintView(Graphics g, FilterNodeView nodeView) {
        String countMessage = null;
        if (nodeView.getTreeView().is3DEnabled()) {
            long terminatorRecordCount = nodeView.getNodeRecordCount();
            countMessage = bundle.messageString("Message.Terminator.Count.fmt.txt", new Long(terminatorRecordCount));
        }
        DrawUtil.drawTerminator(nodeView.getTreeView(), g, nodeView.getBounds(), this.getBounds(), false, countMessage);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredSize(null);
    }

    @Override
    public Dimension getPreferredSize(Graphics gr) {
        return new Dimension(30, 30);
    }

    @Override
    public int hashCode() {
        return this.m_object.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Terminator) {
            return this == object;
        }
        return false;
    }
}

