/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.visuals.BarView;
import com.sas.query.visuals.DataFilterBarView;
import com.sas.query.visuals.QueryResource;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class SummaryView
extends JPanel {
    public static final int RESULT_BAR = 1;
    public static final int TABLE_BAR = 2;
    public static final int WHERE_BAR = 4;
    public static final int GROUP_BAR = 8;
    public static final int HAVING_BAR = 16;
    public static final int ORDER_BAR = 32;
    public static final int ALL_BARS = 4095;
    protected Query m_query;
    protected boolean m_bDisplayResultBar = true;
    protected boolean m_bDisplayTableBar = true;
    protected DataFilterBarView m_dataFilterBar;
    protected boolean m_bDisplayDataFilterBar = true;
    protected boolean m_bDisplayGroupBar = true;
    protected boolean m_bDisplayHavingBar = true;
    protected boolean m_bDisplayOrderBar = true;
    static QueryResource bundle = new QueryResource(SummaryView.class);

    public SummaryView(Query query, int displayOptions) {
        this.m_query = query;
        if ((displayOptions & 1) == 0) {
            this.m_bDisplayResultBar = false;
        }
        if ((displayOptions & 2) == 0) {
            this.m_bDisplayTableBar = false;
        }
        if ((displayOptions & 4) == 0) {
            this.m_bDisplayDataFilterBar = false;
        }
        if ((displayOptions & 8) == 0) {
            this.m_bDisplayGroupBar = false;
        }
        if ((displayOptions & 0x10) == 0) {
            this.m_bDisplayHavingBar = false;
        }
        if ((displayOptions & 0x20) == 0) {
            this.m_bDisplayOrderBar = false;
        }
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this._layoutWidgets();
    }

    public SummaryView(Query query) {
        this(query, 4095);
    }

    public void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        if (this.m_bDisplayResultBar) {
            // empty if block
        }
        if (this.m_bDisplayTableBar) {
            // empty if block
        }
        if (this.m_bDisplayDataFilterBar) {
            this.m_dataFilterBar = new DataFilterBarView(this.m_query);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 0, 0, 0);
            gridBagLayout.setConstraints(this.m_dataFilterBar, gbc);
            this.add(this.m_dataFilterBar);
        }
        if (this.m_bDisplayGroupBar) {
            // empty if block
        }
        if (this.m_bDisplayHavingBar) {
            // empty if block
        }
        if (this.m_bDisplayOrderBar) {
            // empty if block
        }
        this.allignFirstNouns();
    }

    public void showEditorButtons(boolean val) {
        Vector bars = this.getBars();
        for (int i = 0; i < bars.size(); ++i) {
            BarView aBar = (BarView)bars.elementAt(i);
            aBar.showEditorButton(val);
        }
    }

    private Vector getBars() {
        Vector<DataFilterBarView> bars = new Vector<DataFilterBarView>();
        if (this.m_dataFilterBar != null) {
            bars.addElement(this.m_dataFilterBar);
        }
        return bars;
    }

    public void allignFirstNouns() {
        int i;
        Vector bars = this.getBars();
        if (bars.size() < 2) {
            return;
        }
        int[] textSizes = new int[bars.size()];
        int maxTextSize = -1;
        for (i = 0; i < bars.size(); ++i) {
            int aBarsSize;
            BarView aBar = (BarView)bars.elementAt(i);
            textSizes[i] = aBarsSize = aBar.getLabel().getFontMetrics(aBar.getLabel().getFont()).stringWidth(aBar.getLabel().getText());
            if (aBarsSize <= maxTextSize) continue;
            maxTextSize = aBarsSize;
        }
        for (i = 0; i < bars.size(); ++i) {
            int delta = maxTextSize - textSizes[i];
            BarView aBar = (BarView)bars.elementAt(i);
            aBar.setGap(delta);
        }
    }
}

