/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.PropertyChangeConstants;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.WindowUtil;
import javax.swing.JPanel;

public abstract class StandardView
extends JPanel
implements ModelChangeListener,
PropertyChangeConstants {
    protected transient Query m_query;
    protected transient boolean m_bSetIconsCalled = false;

    public StandardView(Query query) {
        this.m_query = query;
    }

    public Query getQuery() {
        return this.m_query;
    }

    public abstract void closing();

    public void busyOn() {
        WindowUtil.busyOn(this);
    }

    public void busyOff() {
        WindowUtil.busyOff(this);
    }

    public void finalize() {
        this.closing();
    }

    public void addError(String message) {
        this.m_query.getMessageHandler().addError(message);
    }

    public void addError(Exception e) {
        this.m_query.getMessageHandler().addError(e);
    }

    public void addInternalError(Exception e) {
        this.m_query.getMessageHandler().addInternalError(e);
    }

    public void addInternalError(Throwable t) {
        this.m_query.getMessageHandler().addInternalError(t);
    }

    public void endQueryChange() {
        this.firePropertyChanges();
        MessageUtil.displayMessages(this.m_query.getMessageHandler());
    }

    public boolean failureHasOccurred() {
        this.m_query.getPropertyChangeHandler().firePropertyChanges();
        return this.m_query.getMessageHandler().failureHasOccurred();
    }

    public void firePropertyChanges() {
        this.m_query.getPropertyChangeHandler().firePropertyChanges();
    }

    public void displayAndExitOnError() {
        MessageUtil.displayAndExitOnError(this.m_query.getMessageHandler());
    }

    public void displayMessages() {
        MessageUtil.displayMessages(this.m_query.getMessageHandler());
    }

    public boolean displayMessagesAndCheckForErrors() {
        return MessageUtil.displayMessagesAndCheckForErrors(this.m_query.getMessageHandler());
    }

    public boolean displayMessagesAndCheckForErrors(MessageHandler messages) {
        return MessageUtil.displayMessagesAndCheckForErrors(messages);
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
    }
}

