/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionConstants;
import com.sas.query.datasources.FunctionList;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.ColumnList;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.ConstantExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.visuals.ExpressionEditDialog;
import com.sas.query.visuals.PopMenuItem;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelper;
import com.sas.query.visuals.SqlTextHelperConstants;
import com.sas.query.visuals.WindowUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class SqlTextHelperPlus
extends SqlTextHelper
implements ExpressionConstants,
FunctionConstants,
SqlTextHelperConstants {
    JPopupMenu m_mainPopmenu = null;
    Method m_sqlTextFieldCallBack = null;
    ExpressionEditDialog m_expBuilder;
    protected static QueryResource bundle = new QueryResource(SqlTextHelperPlus.class);

    @Override
    public boolean hasEditFunction() {
        return this.getEditorClass(this.getExpectedType()) != "";
    }

    @Override
    public String getEditorClass(int expType) {
        switch (expType) {
            case 0: {
                return "";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "";
            }
            case 4: {
                return "";
            }
            case 8: {
                return "";
            }
            case 16: {
                return "";
            }
            case 32: {
                return "";
            }
            case 64: {
                return "";
            }
            case 128: {
                return "";
            }
            case 256: {
                return "";
            }
            case 32768: {
                return "";
            }
        }
        return "";
    }

    public SqlTextHelperPlus(JTextComponent widget) {
        super(widget);
        SqlTextHelper.SQLMouse aSQLMouse = new SqlTextHelper.SQLMouse();
        this.getWidget().addMouseListener(aSQLMouse);
    }

    private boolean getCurrentTokenBounds(int[] bounds) {
        int start;
        String curText = this.getWidget().getText();
        int maxPos = curText.length();
        int curPos = this.getWidget().getCaretPosition();
        if (curPos == 0) {
            ++curPos;
        }
        if (maxPos > curPos && SqlTextHelperPlus.isTokenDelimiter(curText.charAt(curPos - 1))) {
            ++curPos;
        }
        if (maxPos == 0 || SqlTextHelperPlus.isTokenDelimiter(curText.charAt(curPos - 1))) {
            return false;
        }
        int end = curPos;
        for (start = curPos; start > 1 && !SqlTextHelperPlus.isTokenDelimiter(curText.charAt(start - 2)); --start) {
        }
        while (end < maxPos && !SqlTextHelperPlus.isTokenDelimiter(curText.charAt(end))) {
            ++end;
        }
        bounds[0] = start;
        bounds[1] = end;
        return true;
    }

    @Override
    public String getCurrentToken() {
        String curText = this.getWidget().getText();
        String token = "";
        int[] bounds = new int[2];
        token = this.getCurrentTokenBounds(bounds) ? curText.substring(bounds[0] - 1, bounds[1]) : "";
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean showExpressionBuilder() {
        SqlTextHelperPlus sqlTextHelperPlus = this;
        synchronized (sqlTextHelperPlus) {
            if (this.m_expBuilder != null) {
                return false;
            }
            this.m_expBuilder = new ExpressionEditDialog(WindowUtil.getParentFrame(this.getWidget()), true, this);
        }
        WindowUtil.busyOn(this.getWidget());
        Component focus = null;
        try {
            WindowUtil.centerOver(this.m_expBuilder, this.getWidget().getParent());
            focus = WindowUtil.getParentFrame(this.getWidget()).getFocusOwner();
            if (!this.hasBehavior(512)) {
                this.m_expBuilder.setFullSQLMode();
            }
            this.m_expBuilder.show();
        }
        catch (Throwable t) {
            WindowUtil.busyOff(this.getWidget());
            this.m_myQuery.getMessageHandler().addInternalError(t);
        }
        WindowUtil.busyOff(this.getWidget());
        if (focus != null) {
            focus.requestFocus();
        }
        boolean retVal = this.m_expBuilder.m_success;
        this.m_expBuilder = null;
        return retVal;
    }

    @Override
    public void popMenuCallbackExpBuilder() {
        this.showExpressionBuilder();
    }

    @Override
    public void popMenuCallbackRevert(Expression exp) {
        this.setExpression(exp);
    }

    @Override
    public void callbackUndo() {
        if (this.m_myPreviousExpressions != null && this.m_myPreviousExpressions.size() > 0) {
            this.popMenuCallbackRevert(this.m_myPreviousExpressions.elementAt(0));
        }
    }

    @Override
    public void popMenuCallbackOtherColumn(String colname, Column col) {
        ColumnExpression newExp = new ColumnExpression(col);
        this.replaceSelectedWith(newExp);
    }

    @Override
    public void popMenuCallbackAddValue(Expression newExp) {
        this.replaceSelectedWith(newExp);
    }

    @Override
    public void popMenuCallbackFunction(Function fun) {
        CompoundExpression funExp = fun.generateTemplate();
        this.replaceSelectedWith(funExp);
    }

    @Override
    public void popMenuCallbackWrapWithFunction(Function fun) {
        int index;
        CompoundExpression funExp = fun.generateTemplate();
        Expression selectedSubExpression = this.getSelectedExpression();
        if (selectedSubExpression == null) {
            selectedSubExpression = this.getExpression();
        }
        if (selectedSubExpression != null && (index = fun.getPrimaryParameterIndex()) != -1) {
            funExp.setParameter(selectedSubExpression, index);
        }
        this.replaceSelectedWith(funExp);
    }

    @Override
    public void popMenuCallbackSetBehavior(Integer behavior) {
        this.setBehavior(behavior);
    }

    @Override
    public void popMenuCallback(String parm1, String parm2, Object parm3) {
        if (parm1.equals("EDITVALUE") || parm1.equals("DISTINCTVALUE") || parm1.equals("OPERATOR") || parm1.equals("CUSTOMVALUE") || parm1.equals("CONSTANT")) {
            // empty if block
        }
    }

    @Override
    public void showRevertPopmenu(JComponent where) {
        JPopupMenu main = new JPopupMenu("Main");
        this.addUndoList(main);
        this.m_widget.add(main);
        main.show(where, 0, where.getSize().height);
    }

    private void addUndoList(JPopupMenu addToMenu) {
        if (this.m_myPreviousExpressions != null) {
            for (int i = 0; i < this.m_myPreviousExpressions.size(); ++i) {
                Expression historyexp = this.m_myPreviousExpressions.elementAt(i);
                try {
                    PopMenuItem menuItem1 = new PopMenuItem(historyexp.toString(), "popMenuCallbackRevert", (Object)this, (Object)historyexp, Class.forName("com.sas.query.models.Expression"));
                    addToMenu.add(menuItem1);
                    continue;
                }
                catch (Throwable t) {
                    this.m_myQuery.getMessageHandler().addInternalError(bundle.messageString("SqlTextHelperPlus.exception.fmt.txt", t.toString()));
                }
            }
        } else {
            PopMenuItem menuItem1 = new PopMenuItem(bundle.getString("SqlTextHelperPlus.NoHistoryAvailable.txt"));
            menuItem1.setEnabled(false);
            addToMenu.add(menuItem1);
        }
    }

    private void addColumnList(JPopupMenu main, boolean addDirectly) {
        JPopupMenu secondary = null;
        ColumnList others = null;
        int typeOfColsToShow = 0;
        Expression curExp = this.getSelectedExpression();
        if (curExp == null) {
            curExp = this.getExpression();
        }
        typeOfColsToShow = curExp == null ? this.getExpectedType() : curExp.getDataType();
        others = this.hasTableContext() ? this.getQuery().getReferableColumnsOfType(this.getTableContext(), typeOfColsToShow) : this.getQuery().getReferableColumnsOfType(typeOfColsToShow);
        if (others.size() > 0) {
            if (!addDirectly) {
                secondary = new JPopupMenu(bundle.getString("SqlTextHelperPlus.ColumnsPopMenu.txt"));
            }
            for (int i = 0; i < others.size(); ++i) {
                Column col = others.elementAt(i);
                try {
                    PopMenuItem menuItem1 = new PopMenuItem(col.getName(), "popMenuCallbackOtherColumn", (Object)this, (Object)col.getName(), (Object)col, Class.forName("com.sas.query.models.Column"));
                    if (!addDirectly) {
                        secondary.add(menuItem1);
                        continue;
                    }
                    main.add(menuItem1);
                    continue;
                }
                catch (Throwable t) {
                    this.m_myQuery.getMessageHandler().addInternalError(bundle.messageString("SqlTextHelperPlus.exception.fmt.txt", t.toString()));
                }
            }
            if (!addDirectly) {
                main.add(secondary);
            }
        } else {
            int i = this.getExpectedType();
            PopMenuItem menuItem1 = new PopMenuItem(bundle.messageString("SqlTextHelperPlus.NoReferableColsOfTypeMessage.fmt.txt", Expression.getExpectedTypeString(i)));
            menuItem1.setEnabled(false);
            main.add(menuItem1);
        }
    }

    @Override
    public void showColumnPopmenu(JComponent where) {
        JPopupMenu main = new JPopupMenu("Main");
        this.addColumnList(main, true);
        this.m_widget.add(main);
        where.add(main);
        main.show(where, 0, 0);
    }

    protected JPopupMenu generatePopup() {
        Function fun;
        int i;
        int i2;
        JMenuItem menuItem2;
        Expression exp = this.getSelectedExpression();
        if (exp == null) {
            exp = this.getExpression();
        }
        JPopupMenu secondary = null;
        JPopupMenu main = new JPopupMenu("Main");
        if (exp == null) {
            menuItem2 = new JMenuItem("Expression NOT set");
            menuItem2.setEnabled(false);
            main.add(menuItem2);
        } else {
            menuItem2 = new JMenuItem("Expression Set");
            menuItem2.setEnabled(false);
            main.add(menuItem2);
            if (exp instanceof ColumnExpression) {
                menuItem2 = new JMenuItem("Exptype = ColumnExpression");
                menuItem2.setEnabled(false);
                main.add(menuItem2);
            }
            if (exp instanceof UnparsedExpression) {
                menuItem2 = new JMenuItem("Exptype = UnparsedExpression");
                menuItem2.setEnabled(false);
                main.add(menuItem2);
            }
            if (exp instanceof ConstantExpression) {
                menuItem2 = new JMenuItem("Exptype = ConstantExpression");
                menuItem2.setEnabled(false);
                main.add(menuItem2);
            }
        }
        PopMenuItem menuItem1 = new PopMenuItem("Expression Builder", "popMenuCallbackExpBuilder", this);
        main.add(menuItem1);
        main.addSeparator();
        if (this.hasBehavior(4)) {
            menuItem1 = new PopMenuItem("View SQL", "popMenuCallbackSetBehavior", this, new Integer(8));
            main.add(menuItem1);
        } else {
            menuItem1 = new PopMenuItem("Non-SQL View", "popMenuCallbackSetBehavior", this, new Integer(4));
            main.add(menuItem1);
        }
        main.addSeparator();
        if (this.m_myPreviousExpressions != null) {
            secondary = new JPopupMenu("Revert to");
            this.addUndoList(secondary);
            main.add(secondary);
        } else {
            menuItem1 = new PopMenuItem("No history available");
            menuItem1.setEnabled(false);
            main.add(menuItem1);
        }
        if (exp != null && this.getExpression() instanceof ColumnExpression) {
            i2 = this.getExpectedType();
            menuItem1 = new PopMenuItem("Edit not appropriate for COLUMN (type=" + Expression.getExpectedTypeString(i2) + ")");
            menuItem1.setEnabled(false);
            main.add(menuItem1);
        } else if (this.hasEditFunction()) {
            menuItem1 = new PopMenuItem("Edit Value...", "popMenuCallback", (Object)this, (Object)"EDITVALUE", (Object)this.getEditorClass(this.getExpectedType()), this);
            main.add(menuItem1);
        } else {
            i2 = this.getExpectedType();
            menuItem1 = new PopMenuItem("No editor defined for type " + Expression.getExpectedTypeString(i2));
            menuItem1.setEnabled(false);
            main.add(menuItem1);
        }
        this.addColumnList(main, false);
        main.addSeparator();
        menuItem2 = new JMenuItem("sDistinct Value in FirstName");
        main.add(menuItem2);
        FunctionList funs = this.m_myQuery.getDataSourceFunctions().getSubset(null, 0, Expression.getDataType(exp));
        funs = funs.getSubsetByFunctionType(18);
        if (funs.size() > 0) {
            secondary = new JPopupMenu("Replace with function");
            for (i = 0; i < funs.size(); ++i) {
                fun = funs.elementAt(i);
                try {
                    menuItem1 = new PopMenuItem(fun.getNiceFunctionName(), "popMenuCallbackFunction", (Object)this, (Object)fun, Class.forName("com.sas.query.datasources.Function"));
                    secondary.add(menuItem1);
                    continue;
                }
                catch (Throwable t) {
                    this.m_myQuery.getMessageHandler().addInternalError(t);
                }
            }
            main.add(secondary);
        } else {
            i = this.getExpectedType();
            menuItem1 = new PopMenuItem("No functions defined returning type  " + Expression.getExpectedTypeString(i));
            menuItem1.setEnabled(false);
            main.add(menuItem1);
        }
        main.add(secondary);
        funs = this.m_myQuery.getDataSourceFunctions().getSubset(null, Expression.getDataType(exp), 0);
        funs = funs.getSubsetByFunctionType(18);
        if (funs.size() > 0) {
            secondary = new JPopupMenu("Wrap with function");
            for (i = 0; i < funs.size(); ++i) {
                fun = funs.elementAt(i);
                try {
                    menuItem1 = new PopMenuItem(fun.getNiceFunctionName(), "popMenuCallbackFunction", (Object)this, (Object)fun, Class.forName("com.sas.query.datasources.Function"));
                    secondary.add(menuItem1);
                    continue;
                }
                catch (Throwable t) {
                    this.m_myQuery.getMessageHandler().addInternalError(bundle.messageString("SqlTextHelperPlus.exception.fmt.txt", t.toString()));
                }
            }
            main.add(secondary);
        } else {
            i = this.getExpectedType();
            menuItem1 = new PopMenuItem("No functions defined returning type  " + Expression.getExpectedTypeString(i));
            menuItem1.setEnabled(false);
            main.add(menuItem1);
        }
        main.add(secondary);
        return main;
    }

    @Override
    public void popMenuRequest(MouseEvent event) {
    }

    @Override
    public void runExpressionBuilder() {
        this.popMenuCallbackExpBuilder();
    }
}

