/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.models.JDataSourceTree;
import com.sas.query.visuals.AddTableDialog;
import com.sas.query.visuals.JDataSourceTreeView;
import java.awt.Frame;

public class SelectMapDialog
extends AddTableDialog {
    protected boolean m_bOkPressed = false;
    protected DataSourceTable m_selectedTable = null;
    protected DataSourceColumn m_selectedColumn = null;
    protected DataSource m_dataSource;

    public SelectMapDialog(Frame parentFrame, Query query, DataSource dataSource, boolean bDisplayColumns) {
        super(parentFrame, true, bDisplayColumns);
        this.m_query = query;
        this.m_parentFrame = parentFrame;
        this.m_dataSource = dataSource;
        this._initialization();
        this._layoutWidgets();
    }

    @Override
    protected void _initialization() {
        this.m_strTitle = bundle.getString("SelectMapDialog.SelectTableMapping.txt");
        this.m_strActionLabel = bundle.getString("Common.OK.txt");
        this.m_strCancelLabel = bundle.getString("Common.Cancel.txt");
        JDataSourceTree m_metadataModel = new JDataSourceTree(this.m_query, this.m_dataSource, this.m_bDisplayColumns);
        this.m_dataSourceTreeView = new JDataSourceTreeView(this.m_query, m_metadataModel);
    }

    protected void _performTableAction(DataSourceTable table) {
        this.m_bOkPressed = true;
        this.m_selectedTable = table;
        this.dispose();
    }

    protected void _performColumnAction(DataSourceColumn column) {
        this.m_bOkPressed = true;
        this.m_selectedColumn = column;
        this.dispose();
    }

    public boolean wasOkPressed() {
        return this.m_bOkPressed;
    }

    public DataSourceTable getSelectedTable() {
        return this.m_selectedTable;
    }

    public DataSourceColumn getSelectedColumn() {
        return this.m_selectedColumn;
    }
}

