/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.QueryUtils;
import com.sas.query.visuals.ConnectionPropertiesDefiner;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SasConnectPropertyDefiner;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SasITPropertyDefiner
extends ConnectionPropertiesDefiner {
    protected Properties m_info;
    protected JLabel m_hostLabel;
    protected JLabel m_portLabel;
    protected JLabel m_protocolLabel;
    protected JLabel m_remoteInitialFileLabel;
    protected JLabel m_initialStmtsLabel;
    protected JTextField m_hostTextField;
    protected JTextField m_portTextField;
    protected JComboBox m_protocolCombo;
    protected JTextField m_remoteInitialFileTextField;
    protected JTextArea m_initialStmtsTextArea;
    protected JScrollPane m_statementsScrollPane;
    static QueryResource bundle = new QueryResource(SasConnectPropertyDefiner.class);

    public SasITPropertyDefiner() {
        this._initialize();
        this._layoutWidgets();
        this._dodataexchange(false);
    }

    public SasITPropertyDefiner(Properties info) {
        super(info);
        this._initialize();
        this._layoutWidgets();
        this._dodataexchange(false);
    }

    public void _initialize() {
        this.m_hostLabel = new JLabel(bundle.getString("SasITPropertyDefiner.hostLabel.txt"));
        this.m_portLabel = new JLabel(bundle.getString("SasITPropertyDefiner.portLabel.txt"));
        this.m_protocolLabel = new JLabel(bundle.getString("SasITPropertyDefiner.protocolLabel.txt"));
        this.m_remoteInitialFileLabel = new JLabel(bundle.getString("SasITPropertyDefiner.remoteInitialFileLabel.txt"));
        this.m_initialStmtsLabel = new JLabel(bundle.getString("SasITPropertyDefiner.initialStmtsLabel.txt"));
        this.m_hostTextField = new JTextField();
        this.m_portTextField = new JTextField();
        this.m_portTextField.setColumns(10);
        this.m_protocolCombo = new JComboBox();
        this.m_protocolCombo.addItem(bundle.getString("SasITPropertyDefiner.BRIDGE.notrans"));
        this.m_protocolCombo.addItem(bundle.getString("SasITPropertyDefiner.CONNECT.notrans"));
        this.m_protocolCombo.addItem(bundle.getString("SasITPropertyDefiner.SHARENET.notrans"));
        this.m_protocolCombo.addItem(bundle.getString("SasITPropertyDefiner.ORB.notrans"));
        this.m_remoteInitialFileTextField = new JTextField();
        this.m_initialStmtsTextArea = new JTextArea();
        this.m_statementsScrollPane = new JScrollPane(this.m_initialStmtsTextArea);
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(bundle.getString("SasITPropertyDefiner.borderTitle.txt"));
        this.setBorder(BorderFactory.createCompoundBorder(titleBorder, BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_hostLabel, gbc);
        this.add(this.m_hostLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 8, 0, 0);
        gridBagLayout.setConstraints(this.m_hostTextField, gbc);
        this.add(this.m_hostTextField);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_portLabel, gbc);
        this.add(this.m_portLabel);
        gbc = new GridBagConstraints();
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(8, 8, 0, 0);
        gridBagLayout.setConstraints(this.m_portTextField, gbc);
        this.add(this.m_portTextField);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_protocolLabel, gbc);
        this.add(this.m_protocolLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 8, 0, 0);
        gridBagLayout.setConstraints(this.m_protocolCombo, gbc);
        this.add(this.m_protocolCombo);
        gbc = new GridBagConstraints();
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_remoteInitialFileLabel, gbc);
        this.add(this.m_remoteInitialFileLabel);
        gbc = new GridBagConstraints();
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 8, 0, 0);
        gridBagLayout.setConstraints(this.m_remoteInitialFileTextField, gbc);
        this.add(this.m_remoteInitialFileTextField);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_initialStmtsLabel, gbc);
        this.add(this.m_initialStmtsLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridheight = 3;
        gbc.gridwidth = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_statementsScrollPane, gbc);
        this.add(this.m_statementsScrollPane);
    }

    public void _dodataexchange(boolean save2model) {
        if (save2model) {
            if (this.m_info == null) {
                this.m_info = new Properties();
            }
            if (this.m_info.containsKey("Host")) {
                this.m_info.remove("Host");
            }
            if (this.m_info.containsKey("Port")) {
                this.m_info.remove("Port");
            }
            if (this.m_info.containsKey("Protocol")) {
                this.m_info.remove("Protocol");
            }
            if (this.m_info.containsKey("RemoteInitialSubmitFile")) {
                this.m_info.remove("RemoteInitialSubmitFile");
            }
            if (this.m_info.containsKey("LocalInitialSubmitStmts")) {
                this.m_info.remove("LocalInitialSubmitStmts");
            }
            this.m_info.put("Host", this.m_hostTextField.getText());
            this.m_info.put("Port", this.m_portTextField.getText());
            String protocol = this.m_protocolCombo.getSelectedItem().toString();
            if (protocol.equals(bundle.getString("SasITPropertyDefiner.BRIDGE.notrans"))) {
                this.m_info.put("Protocol", "BRIDGE");
            } else if (protocol.equals(bundle.getString("SasITPropertyDefiner.CONNECT.notrans"))) {
                this.m_info.put("Protocol", "CONNECT");
            } else if (protocol.equals(bundle.getString("SasITPropertyDefiner.SHARENET.notrans"))) {
                this.m_info.put("Protocol", "SHARENET");
            } else if (protocol.equals(bundle.getString("SasITPropertyDefiner.ORB.notrans"))) {
                this.m_info.put("Protocol", "ORB");
            } else {
                this.m_info.put("Protocol", this.m_protocolCombo.getSelectedItem().toString());
            }
            this.m_info.put("RemoteInitialSubmitFile", this.m_remoteInitialFileTextField.getText());
            this.m_info.put("LocalInitialSubmitStmts", QueryUtils.URLEncoder(this.m_initialStmtsTextArea.getText()));
        } else if (this.m_info != null) {
            this.m_hostTextField.setText(this.m_info.getProperty("Host"));
            this.m_portTextField.setText(this.m_info.getProperty("Port"));
            String protocol = this.m_info.getProperty("Protocol");
            String protocolKey = "SasITPropertyDefiner." + protocol.trim();
            String translatedProtocol = bundle.getString(protocolKey);
            this.m_protocolCombo.setSelectedItem(translatedProtocol);
            this.m_remoteInitialFileTextField.setText(this.m_info.getProperty("RemoteInitialSubmitFile"));
            this.m_initialStmtsTextArea.setText(QueryUtils.URLDecoder(this.m_info.getProperty("LocalInitialSubmitStmts")));
        }
    }

    @Override
    public void setReadOnly() {
        this.m_hostTextField.setEditable(false);
        this.m_portTextField.setEditable(false);
        this.m_protocolCombo.setEditable(false);
        this.m_remoteInitialFileTextField.setEditable(false);
        this.m_initialStmtsTextArea.setEditable(false);
    }

    @Override
    public Properties getConnectionProperties() {
        this._dodataexchange(true);
        return this.m_info;
    }

    @Override
    public void setConnectionProperties(Properties info) {
        this.m_info = new Properties(info);
        this._dodataexchange(false);
    }
}

