/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.QueryUtils;
import com.sas.query.visuals.ConnectionPropertiesDefiner;
import com.sas.query.visuals.QueryResource;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SasConnectPropertyDefiner
extends ConnectionPropertiesDefiner {
    protected Properties m_info;
    protected JLabel m_connectLocationLabel;
    protected JLabel m_remoteInitialFileLabel;
    protected JLabel m_initialStmtsLabel;
    protected JTextField m_connectLocationTextField;
    protected JTextField m_remoteInitialFileTextField;
    protected JTextArea m_initialStmtsTextArea;
    protected JScrollPane m_statementsScrollPane;
    protected JButton m_browseButton;
    static QueryResource bundle = new QueryResource(SasConnectPropertyDefiner.class);

    public SasConnectPropertyDefiner() {
        this._initialize();
        this._layoutWidgets();
        this._dodataexchange(false);
    }

    public SasConnectPropertyDefiner(Properties info) {
        super(info);
        this._initialize();
        this._layoutWidgets();
        this._dodataexchange(false);
    }

    public void _initialize() {
        this.m_connectLocationLabel = new JLabel(bundle.getString("SasConnectPropertyDefiner.connectLocationLabel.txt"));
        this.m_remoteInitialFileLabel = new JLabel(bundle.getString("SasConnectPropertyDefiner.remoteInitialFileLabel.txt"));
        this.m_initialStmtsLabel = new JLabel(bundle.getString("SasConnectPropertyDefiner.initialStmtsLabel.txt"));
        this.m_connectLocationTextField = new JTextField();
        this.m_remoteInitialFileTextField = new JTextField();
        this.m_initialStmtsTextArea = new JTextArea();
        this.m_statementsScrollPane = new JScrollPane(this.m_initialStmtsTextArea);
        this.m_browseButton = new JButton(bundle.getString("Common.Browse....txt"));
        this.m_browseButton.addActionListener(new OnBrowse());
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(bundle.getString("SasConnectPropertyDefiner.borderTitle.txt"));
        this.setBorder(BorderFactory.createCompoundBorder(titleBorder, BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.fill = 0;
        gridBagLayout.setConstraints(this.m_connectLocationLabel, gbc);
        this.add(this.m_connectLocationLabel);
        gbc = new GridBagConstraints();
        gbc.gridy = gridy;
        gbc.gridwidth = -1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 3, 0, 3);
        gridBagLayout.setConstraints(this.m_connectLocationTextField, gbc);
        this.add(this.m_connectLocationTextField);
        gbc = new GridBagConstraints();
        gbc.gridy = gridy++;
        gbc.anchor = 12;
        gbc.fill = 0;
        gridBagLayout.setConstraints(this.m_browseButton, gbc);
        this.add(this.m_browseButton);
        gbc = new GridBagConstraints();
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_remoteInitialFileLabel, gbc);
        this.add(this.m_remoteInitialFileLabel);
        gbc = new GridBagConstraints();
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_remoteInitialFileTextField, gbc);
        this.add(this.m_remoteInitialFileTextField);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_initialStmtsLabel, gbc);
        this.add(this.m_initialStmtsLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridheight = 0;
        gbc.gridwidth = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_statementsScrollPane, gbc);
        this.add(this.m_statementsScrollPane);
    }

    public void _dodataexchange(boolean save2model) {
        if (save2model) {
            if (this.m_info == null) {
                this.m_info = new Properties();
            }
            if (this.m_info.containsKey("ConnectPropertiesLocation")) {
                this.m_info.remove("ConnectPropertiesLocation");
            }
            if (this.m_info.containsKey("RemoteInitialSubmitFile")) {
                this.m_info.remove("RemoteInitialSubmitFile");
            }
            if (this.m_info.containsKey("LocalInitialSubmitStmts")) {
                this.m_info.remove("LocalInitialSubmitStmts");
            }
            this.m_info.put("ConnectPropertiesLocation", this.m_connectLocationTextField.getText());
            this.m_info.put("RemoteInitialSubmitFile", this.m_remoteInitialFileTextField.getText());
            this.m_info.put("LocalInitialSubmitStmts", QueryUtils.URLEncoder(this.m_initialStmtsTextArea.getText()));
        } else if (this.m_info != null) {
            this.m_connectLocationTextField.setText(this.m_info.getProperty("ConnectPropertiesLocation"));
            this.m_remoteInitialFileTextField.setText(this.m_info.getProperty("RemoteInitialSubmitFile"));
            this.m_initialStmtsTextArea.setText(QueryUtils.URLDecoder(this.m_info.getProperty("LocalInitialSubmitStmts")));
        }
    }

    @Override
    public void setReadOnly() {
        this.m_connectLocationTextField.setEditable(false);
        this.m_remoteInitialFileTextField.setEditable(false);
        this.m_initialStmtsTextArea.setEditable(false);
    }

    @Override
    public Properties getConnectionProperties() {
        this._dodataexchange(true);
        return this.m_info;
    }

    @Override
    public void setConnectionProperties(Properties info) {
        this.m_info = new Properties(info);
        this._dodataexchange(false);
    }

    protected class OnBrowse
    implements ActionListener {
        protected OnBrowse() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(SasConnectPropertyDefiner.this);
            if (returnVal == 0) {
                SasConnectPropertyDefiner.this.m_connectLocationTextField.setText(fc.getSelectedFile().getPath());
            }
        }
    }
}

