/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.ModelInterface;
import com.sas.awt.TextArea;
import com.sas.awt.print.Annotation;
import com.sas.awt.print.AnnotationView;
import com.sas.awt.print.PageFormat;
import com.sas.awt.print.PrintGraphics;
import com.sas.awt.print.PrintableInterface;
import com.sas.awt.print.PrinterGraphics;
import com.sas.collection.StringCollection;
import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceResultSet;
import com.sas.query.models.FilterNode;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.WebAfTableViewModel;
import com.sas.query.visuals.CrossJoinWarningDialog;
import com.sas.query.visuals.DataBaseUIRequest;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.WindowUtil;
import com.sas.table.TableView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class ResultPanel
extends StandardView
implements Runnable {
    static QueryResource bundle = new QueryResource(ResultPanel.class);
    public static final String dataProperty = "data";
    protected TableView m_tableViewer;
    protected DataSourceResultSet m_resultSet;
    protected FilterNode m_finalWhereNode = null;
    protected FilterNode m_finalHavingNode = null;
    protected JLabel m_rowCountLabel;
    protected JCheckBox m_autoRefresh;
    protected JButton m_refreshButton;
    protected JButton m_printButton;
    protected boolean m_bDataExpired = true;
    protected JRadioButton m_distinct;
    protected JRadioButton m_all;

    public ResultPanel(Query query) {
        this(query, null, null);
    }

    public ResultPanel(Query query, FilterNode finalWhereNode, FilterNode finalHavingNode) {
        super(query);
        this.m_finalWhereNode = finalWhereNode;
        this.m_finalHavingNode = finalHavingNode;
        this.m_query.addPropertyListener(this, 65535);
        try {
            this.m_tableViewer = new TableView();
            this.m_tableViewer.initialize();
            this.m_tableViewer.setColumnsSelectedByLabel(false);
            this.m_tableViewer.setRowsSelectedByLabel(true);
            this.m_tableViewer.setColumnLabelsVisible(true);
            query.enableHelpKey((Component)this.m_tableViewer, "Tab.Results");
        }
        catch (Throwable t) {
            this.m_tableViewer = null;
        }
        this._layoutWidgets();
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener(this);
        if (this.m_resultSet != null) {
            this.m_resultSet.close();
        }
    }

    @Override
    public void run() {
        this.onRefresh();
    }

    protected DataSource getDataSource() {
        return this.m_query.getDataSource();
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints((Component)this.m_tableViewer, gbc);
        this.add((Component)this.m_tableViewer);
        this.m_printButton = new JButton(bundle.getString("ResultPanel.ButtonLabel.Print.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 8, 0, 12);
        gridBagLayout.setConstraints(this.m_printButton, gbc);
        if (QueryConfiguration.getConfigurationBoolean("PrintResults.Enabled.notrans", false)) {
            this.add(this.m_printButton);
        }
        this.m_printButton.addActionListener(new PrintButtonHandler());
        this.m_refreshButton = new JButton(bundle.getString("ResultPanel.ButtonLabel.Refresh.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 8, 0, 12);
        gridBagLayout.setConstraints(this.m_refreshButton, gbc);
        this.add(this.m_refreshButton);
        this.m_refreshButton.addActionListener(new RefreshButtonHandler());
        this.m_autoRefresh = new JCheckBox(bundle.getString("ResultPanel.Auto-refresh.txt"), true);
        this.m_autoRefresh.setToolTipText(bundle.getString("ResultPanel.autoRefreshToolTip.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 8, 8, 12);
        gridBagLayout.setConstraints(this.m_autoRefresh, gbc);
        this.add(this.m_autoRefresh);
        this.m_autoRefresh.addActionListener(new CheckBoxListener());
        this.m_rowCountLabel = new JLabel(bundle.getString("ResultPanel.ButtonLabel.Changed.txt"));
        this.m_rowCountLabel.setForeground(Color.red);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 9;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 8, 12, 12);
        gridBagLayout.setConstraints(this.m_rowCountLabel, gbc);
        this.add(this.m_rowCountLabel);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.m_distinct = new JRadioButton(bundle.getString("ResultPanel.Distinct.txt"));
        this.m_distinct.setToolTipText(bundle.getString("ResultPanel.distinctToolTip.txt"));
        this.m_all = new JRadioButton(bundle.getString("ResultPanel.AllResults.txt"));
        this.m_all.setToolTipText(bundle.getString("ResultPanel.AllResultsToolTip.txt"));
        p.add("North", this.m_all);
        p.add("South", this.m_distinct);
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 6, 0, 0)));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 8, 8, 12);
        gridBagLayout.setConstraints(p, gbc);
        this.add(p);
        this.m_all.setSelected(this.m_query.getDuplicateRows());
        this.m_distinct.setSelected(!this.m_query.getDuplicateRows());
        this.m_distinct.addActionListener(new RadioButtonListener());
        this.m_all.addActionListener(new RadioButtonListener());
    }

    public void onRefresh() {
        MessageHandler tempMessages = new MessageHandler();
        this.m_refreshButton.setEnabled(this.getQuery().canResultsBeGotten());
        this.m_all.setSelected(this.m_query.getDuplicateRows());
        this.m_distinct.setSelected(!this.m_query.getDuplicateRows());
        if (!this.getQuery().canResultsBeGotten()) {
            return;
        }
        try {
            CrossJoinWarningDialog warningDialog;
            if (QueryConfiguration.getConfigurationBoolean("CrossJoinWarningDialog.Enabled.notrans", true) && (warningDialog = new CrossJoinWarningDialog(WindowUtil.getParentFrame(this), this.getQuery())).isProcessCrossJoinCancelled()) {
                return;
            }
            if (this.m_tableViewer != null) {
                this.m_tableViewer.setModelInterface(null);
            }
            this.m_query.validateQuery();
            if (this.m_resultSet != null) {
                this.m_resultSet.close();
            }
            this.m_resultSet = this.getDataSource().getFormattedResultSet(this.m_query, this.m_finalWhereNode, this.m_finalHavingNode);
            DataBaseUIRequest request = new DataBaseUIRequest(this.m_query, this, bundle.getString("ResultPanel.Label.GettingResults.txt"));
            request.setDelayBeforeProgressCancelDialog(0);
            request.exec(this, "refresh", "cancelRefresh", "cleanupRefresh", this.m_resultSet, tempMessages);
            if (!request.wasCancelRequested()) {
                this.m_bDataExpired = false;
            }
        }
        catch (Exception e) {
            this.addError(e);
            this.m_bDataExpired = true;
        }
        if (this.displayMessagesAndCheckForErrors() || this.displayMessagesAndCheckForErrors(tempMessages)) {
            this.m_bDataExpired = true;
        }
        this.firePropertyChange(dataProperty, null, this.m_query);
        this._setState();
        this.m_refreshButton.requestFocus();
    }

    public void onPrint() {
        PrintLater later = new PrintLater();
        new Thread(later).start();
    }

    public WebAfTableViewModel getDataSet() {
        if (this.m_tableViewer == null) {
            return null;
        }
        return (WebAfTableViewModel)this.m_tableViewer.getModelInterface();
    }

    public boolean isDataExpired() {
        return this.m_bDataExpired;
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        if (bVisible && this.isEnabled()) {
            this.m_all.setSelected(this.m_query.getDuplicateRows());
            this.m_distinct.setSelected(!this.m_query.getDuplicateRows());
            if (this.m_autoRefresh.isSelected() && this.isDataExpired()) {
                SwingUtilities.invokeLater(this);
            }
        }
    }

    public void cleanupRefresh(Object requestInfo, MessageHandler messages) {
        DataSourceResultSet resultSet = (DataSourceResultSet)requestInfo;
        resultSet.close();
    }

    public void cancelRefresh(Object requestInfo, MessageHandler messages) {
        DataSourceResultSet resultSet = (DataSourceResultSet)requestInfo;
        resultSet.cancel();
    }

    public void refresh(Object requestInfo, MessageHandler messages) {
        DataSourceResultSet resultSet = (DataSourceResultSet)requestInfo;
        WebAfTableViewModel dataSetInterface = null;
        try {
            if (!resultSet.isCanceled()) {
                resultSet.initialize();
            }
            if (!resultSet.isCanceled()) {
                dataSetInterface = new WebAfTableViewModel(resultSet);
            }
            if (!this.failureHasOccurred() && this.m_tableViewer != null && !resultSet.isCanceled()) {
                this.m_tableViewer.setModelInterface((ModelInterface)dataSetInterface);
                this.m_tableViewer.setVisible(true);
            }
        }
        catch (Exception e) {
            this.addInternalError(e);
        }
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        if (event.isStructureChange() && !event.isDataChange() && (event.didOnlyThisStructureTypeChange(8) || event.didOnlyThisStructureAreaChange(1024))) {
            return;
        }
        this.m_bDataExpired = true;
        if (this.isShowing() && this.m_autoRefresh.isSelected()) {
            this.onRefresh();
        }
        this._setState();
    }

    protected void _setState() {
        if (!this.m_bDataExpired) {
            try {
                int cRows = this.getDataSet().getRowCount();
                if (cRows == -1) {
                    cRows = this.getDataSet().countRows(101);
                    if (cRows > 100) {
                        this.m_rowCountLabel.setText(bundle.messageString("ResultPanel.Label.Greater.fmt.txt", new Integer(100)));
                    } else {
                        this.m_rowCountLabel.setText(bundle.messageString("ResultPanel.Label.Records.fmt.txt", new Integer(cRows)));
                    }
                } else {
                    this.m_rowCountLabel.setText(bundle.messageString("ResultPanel.Label.Records.fmt.txt", new Integer(cRows)));
                }
                this.m_rowCountLabel.setForeground(Color.black);
                return;
            }
            catch (Exception exception) {}
        } else {
            this.m_rowCountLabel.setText(bundle.getString("ResultPanel.ButtonLabel.Changed.txt"));
            this.m_rowCountLabel.setForeground(Color.red);
            this.m_refreshButton.setEnabled(this.getQuery().canResultsBeGotten());
        }
    }

    class PrintLater
    implements Runnable {
        @Override
        public void run() {
            try {
                PageFormat pageFormat = new PageFormat();
                PrintJob nativePrintJob = Toolkit.getDefaultToolkit().getPrintJob(WindowUtil.getParentFrame(ResultPanel.this), bundle.getString("ResultPanel.Print.Title.txt"), null);
                if (nativePrintJob != null) {
                    PrinterGraphics printerGraphics = new PrinterGraphics(nativePrintJob);
                    com.sas.awt.print.PrintJob printJob = com.sas.awt.print.PrintJob.getPrintJob((PrintGraphics)printerGraphics);
                    Dimension pageDimension = nativePrintJob.getPageDimension();
                    if (pageDimension.width > pageDimension.height) {
                        pageFormat.setOrientation(0);
                    } else {
                        pageFormat.setOrientation(1);
                    }
                    AnnotationView header = new AnnotationView();
                    header.initialize();
                    Annotation titleAnnotation = new Annotation(null, bundle.getString("ResultPanel.Print.Title.txt"), null);
                    header.attachModel((ModelInterface)titleAnnotation);
                    pageFormat.setHeader((PrintableInterface)header);
                    AnnotationView footer = new AnnotationView();
                    footer.initialize();
                    Annotation dateTimeAnnotation = new Annotation(bundle.getString("ResultPanel.Print.Footer1.txt"), bundle.getString("ResultPanel.Print.Footer2.txt"), null);
                    footer.attachModel((ModelInterface)dateTimeAnnotation);
                    pageFormat.setFooter((PrintableInterface)footer);
                    printJob.setPrintable((PrintableInterface)ResultPanel.this.m_tableViewer, pageFormat);
                    try {
                        printJob.print();
                    }
                    catch (Exception e) {
                        ResultPanel.this.addInternalError(e);
                        ResultPanel.this.displayMessagesAndCheckForErrors();
                    }
                }
            }
            catch (Exception e) {
                ResultPanel.this.addInternalError(e);
                ResultPanel.this.displayMessagesAndCheckForErrors();
            }
        }
    }

    class PrintableTextArea
    extends TextArea
    implements PrintableInterface {
        int y;
        int fontHeight;
        int fontAscent;
        boolean donePrinting = false;
        int currentLine = 0;
        StringCollection lines;

        PrintableTextArea() {
        }

        public Rectangle getPageBounds(Graphics g, int PageNumber, int pageWidth, int pageHeight) {
            return new Rectangle(0, 0, pageWidth, pageHeight);
        }

        public Panel getPrintOptionsPanel() {
            return null;
        }

        public boolean pageExists(int pageNumber) {
            return !this.donePrinting;
        }

        public void print(Graphics g, int pageNumber, int pageWidth, int pageHeight) {
            this.y = this.fontAscent;
            g.setFont(this.getFont());
            g.setColor(Color.black);
            while (this.y < pageHeight) {
                if (this.currentLine == this.lines.count()) {
                    this.donePrinting = true;
                    break;
                }
                g.drawString(this.lines.getString(this.currentLine++), 0, this.y);
                this.y += this.fontHeight;
            }
        }

        public void printInitialize(Graphics g) {
            this.donePrinting = false;
            FontMetrics fm = g.getFontMetrics(this.getFont());
            this.fontHeight = fm.getHeight();
            this.fontAscent = fm.getAscent();
            this.lines = new StringCollection(this.getText(), '\n');
        }

        public void printFinalize() {
        }
    }

    protected class PrintButtonHandler
    implements ActionListener {
        PrintButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ResultPanel.this.onPrint();
        }
    }

    protected class RefreshButtonHandler
    implements ActionListener {
        RefreshButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ResultPanel.this.onRefresh();
        }
    }

    protected class RadioButtonListener
    implements ActionListener {
        RadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == ResultPanel.this.m_all) {
                ResultPanel.this.m_distinct.setSelected(false);
                ResultPanel.this.m_query.setDuplicateRowsRule(1);
            } else if (event.getSource() == ResultPanel.this.m_distinct) {
                ResultPanel.this.m_all.setSelected(false);
                ResultPanel.this.m_query.setDuplicateRowsRule(0);
            }
            ResultPanel.this.firePropertyChanges();
        }
    }

    protected class CheckBoxListener
    implements ActionListener {
        CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ResultPanel.this.m_autoRefresh.isSelected() && ResultPanel.this.isDataExpired()) {
                ResultPanel.this.onRefresh();
            }
        }
    }
}

