/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionList;
import com.sas.query.models.Expression;
import com.sas.query.models.GroupItemList;
import com.sas.query.models.OrderItem;
import com.sas.query.models.OrderItemList;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.visuals.QueryComponentInterface;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelperConstants;
import com.sas.query.visuals.SqlTextPanel;
import com.sas.query.visuals.SqlTextPanelPlus;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;

public class ResultItemPropertyView
extends JPanel
implements QueryComponentInterface,
SqlTextHelperConstants {
    protected Query m_query;
    protected boolean m_bSortBy = false;
    protected ResultItem m_resultItem;
    protected OrderItem m_orderItem = null;
    protected JTextField m_nameText;
    protected SqlTextPanel m_expressionText;
    protected Checkbox m_sortCheckbox;
    protected JComboBox m_sortDirectionChoice;
    protected JComboBox m_sortOrderChoice;
    protected JComboBox m_aggregationChoice;
    static QueryResource bundle = new QueryResource(ResultItemPropertyView.class);
    public static String[] m_priorityNames = null;

    public ResultItemPropertyView(Query query, ResultItem resultItem) {
        if (m_priorityNames == null) {
            m_priorityNames = new String[16];
            ResultItemPropertyView.m_priorityNames[0] = new String(bundle.getString("Common.First.txt"));
            ResultItemPropertyView.m_priorityNames[1] = new String(bundle.getString("Common.Second.txt"));
            ResultItemPropertyView.m_priorityNames[2] = new String(bundle.getString("Common.Third.txt"));
            ResultItemPropertyView.m_priorityNames[3] = new String(bundle.getString("Common.Fourth.txt"));
            ResultItemPropertyView.m_priorityNames[4] = new String(bundle.getString("Common.Fifth.txt"));
            ResultItemPropertyView.m_priorityNames[5] = new String(bundle.getString("Common.Sixth.txt"));
            ResultItemPropertyView.m_priorityNames[6] = new String(bundle.getString("Common.Seventh.txt"));
            ResultItemPropertyView.m_priorityNames[7] = new String(bundle.getString("Common.Eight.txt"));
            ResultItemPropertyView.m_priorityNames[8] = new String(bundle.getString("Common.Ninth.txt"));
            ResultItemPropertyView.m_priorityNames[9] = new String(bundle.getString("Common.Tenth.txt"));
            ResultItemPropertyView.m_priorityNames[10] = new String(bundle.getString("Common.Eleventh.txt"));
            ResultItemPropertyView.m_priorityNames[11] = new String(bundle.getString("Common.Twelfth.txt"));
            ResultItemPropertyView.m_priorityNames[12] = new String(bundle.getString("Common.Thirteenth.txt"));
            ResultItemPropertyView.m_priorityNames[13] = new String(bundle.getString("Common.Fourteenth.txt"));
            ResultItemPropertyView.m_priorityNames[14] = new String(bundle.getString("Common.Fifteenth.txt"));
            ResultItemPropertyView.m_priorityNames[15] = new String(bundle.getString("Common.Sixteenth.txt"));
        }
        this.m_query = query;
        this.m_resultItem = resultItem;
        this._initialize();
        this._layoutWidgets();
        this._setState();
    }

    public void setResultItem(ResultItem resultItem) {
        this.doDataExchange(true);
        this.m_resultItem = resultItem;
        this.doDataExchange(false);
        if (this.m_resultItem == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        FunctionList functionList = this.m_query.getDataSourceFunctions();
        functionList = functionList.getSubsetByFunctionType(1);
        if (this.m_resultItem != null) {
            functionList = functionList.getSubsetByPrimaryParmType(this.m_resultItem.getExpression().getDataType());
        }
        this.m_aggregationChoice.removeAllItems();
        this.m_aggregationChoice.addItem(" ");
        this.m_aggregationChoice.addItem(bundle.getString("Common.groupinBrackets.txt"));
        for (int index = 0; index < functionList.size(); ++index) {
            this.m_aggregationChoice.addItem(functionList.elementAt(index));
        }
    }

    @Override
    public void closing() {
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    @Override
    public void doDataExchange(boolean bSaveToModel) {
        if (this.m_resultItem == null) {
            return;
        }
        if (bSaveToModel) {
            String strAlias = this.m_nameText.getText();
            if (strAlias != null && strAlias.length() == 0) {
                strAlias = null;
            }
            if (!QueryUtils.equals(strAlias, this.m_resultItem.getAlias())) {
                this.m_resultItem.setAlias(strAlias);
            }
            if (this.m_expressionText.getExpression() != this.m_resultItem.getExpression()) {
                this.m_resultItem.setExpression(this.m_expressionText.getExpression());
            }
            this.m_bSortBy = this.m_sortCheckbox.getState();
            if (this.m_bSortBy) {
                int oldPosition;
                int newPosition;
                if (this.m_orderItem == null) {
                    this.m_orderItem = this.m_query.addOrderItem(this.m_resultItem);
                }
                if ((newPosition = this.m_sortOrderChoice.getSelectedIndex()) != (oldPosition = this.m_query.getPositionForOrderItem(this.m_orderItem))) {
                    this.m_query.moveOrderItem(oldPosition, newPosition);
                }
                if (this.m_sortDirectionChoice.getSelectedItem().equals(bundle.getString("Common.Ascending.txt"))) {
                    this.m_orderItem.setSortingDirection(1);
                } else if (this.m_sortDirectionChoice.getSelectedItem().equals(bundle.getString("Common.Descending.txt"))) {
                    this.m_orderItem.setSortingDirection(2);
                } else if (this.m_sortDirectionChoice.getSelectedItem().equals(bundle.getString("Common.defaultinBrackets.txt"))) {
                    this.m_orderItem.setSortingDirection(0);
                }
            }
            Expression exp = this.m_resultItem.getExpression();
            Object selectedObject = this.m_aggregationChoice.getSelectedItem();
            if (exp.isAggregation()) {
                exp = exp.deleteAggregation();
            }
            if (selectedObject instanceof Function) {
                Function aggFunction = (Function)selectedObject;
                exp = exp.addAggregation(aggFunction);
                this.m_resultItem.setExpression(exp);
                GroupItemList groupList = this.m_query.getGroupItems();
                ResultItemList resultItems = this.m_query.getResultItems();
                for (int index = 0; index < resultItems.size(); ++index) {
                    if (resultItems.elementAt(index).getExpression().isAggregation()) continue;
                    boolean bAlreadyGrouped = false;
                    for (int orderIndex = 0; orderIndex < groupList.size(); ++orderIndex) {
                        if (resultItems.elementAt(index) != groupList.elementAt(orderIndex).getResultItem()) continue;
                        bAlreadyGrouped = true;
                    }
                    if (bAlreadyGrouped) continue;
                    this.m_query.addGroupItem(resultItems.elementAt(index));
                }
            }
        } else {
            this.m_nameText.setText(this.m_resultItem.getAlias());
            this.m_expressionText.setExpression(this.m_resultItem.getExpression());
            this.m_sortCheckbox.setState(this.m_bSortBy);
            if (this.m_orderItem != null) {
                if (this.m_orderItem.getSortingDirection() == 1) {
                    this.m_sortDirectionChoice.setSelectedItem(bundle.getString("Common.Ascending.txt"));
                } else if (this.m_orderItem.getSortingDirection() == 2) {
                    this.m_sortDirectionChoice.setSelectedItem(bundle.getString("Common.Descending.txt"));
                } else if (this.m_orderItem.getSortingDirection() == 0) {
                    this.m_sortDirectionChoice.setSelectedItem(bundle.getString("Common.defaultinBrackets.txt"));
                }
                this.m_sortOrderChoice.setSelectedIndex(this.m_query.getPositionForOrderItem(this.m_orderItem));
            }
            if (this.m_resultItem.getExpression().isAggregation()) {
                this.m_aggregationChoice.setSelectedItem(this.m_resultItem.getExpression().getAggregationType());
            }
        }
    }

    protected void _initialize() {
        OrderItemList orderList = this.m_query.getOrderItems();
        for (int index = 0; index < orderList.size(); ++index) {
            OrderItem orderItem = orderList.elementAt(index);
            if (orderItem.getResultItem() != this.m_resultItem) continue;
            this.m_orderItem = orderItem;
            this.m_bSortBy = true;
            break;
        }
        this.m_nameText = new JTextField();
        this.m_expressionText = new SqlTextPanelPlus(2);
        this.m_expressionText.setBehavior(16);
        this.m_sortCheckbox = new Checkbox(bundle.getString("Common.OrderBy.txt"), this.m_bSortBy);
        this.m_sortCheckbox.addItemListener(new SortHandler());
        this.m_sortDirectionChoice = new JComboBox();
        this.m_sortDirectionChoice.addItem(bundle.getString("Common.defaultinBrackets.txt"));
        this.m_sortDirectionChoice.addItem(bundle.getString("Common.Ascending.txt"));
        this.m_sortDirectionChoice.addItem(bundle.getString("Common.Descending.txt"));
        this.m_sortOrderChoice = new JComboBox();
        int orderCount = this.m_query.getOrderItemCount();
        for (int index = 0; index <= orderCount; ++index) {
            if (index > m_priorityNames.length - 1) {
                this.m_sortOrderChoice.addItem(index + "");
                continue;
            }
            this.m_sortOrderChoice.addItem(m_priorityNames[index]);
        }
        FunctionList functionList = this.m_query.getDataSourceFunctions();
        functionList = functionList.getSubsetByFunctionType(1);
        if (this.m_resultItem != null) {
            functionList = functionList.getSubsetByPrimaryParmType(this.m_resultItem.getExpression().getDataType());
        }
        this.m_aggregationChoice = new JComboBox();
        this.m_aggregationChoice.addItem(" ");
        this.m_aggregationChoice.addItem(bundle.getString("Common.groupinBrackets.txt"));
        for (int index = 0; index < functionList.size(); ++index) {
            this.m_aggregationChoice.addItem(functionList.elementAt(index));
        }
        if (this.m_resultItem == null) {
            this.setEnabled(false);
        }
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        JLabel label = new JLabel(bundle.getString("ResultItemPropertyView.NameLabel.txt"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(label, gbc);
        this.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(this.m_nameText, gbc);
        this.add(this.m_nameText);
        label = new JLabel(bundle.getString("ResultItemPropertyView.AggregationLabel.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 0, 0, 0);
        gridBagLayout.setConstraints(label, gbc);
        this.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(6, 8, 0, 0);
        gridBagLayout.setConstraints(this.m_aggregationChoice, gbc);
        this.add(this.m_aggregationChoice);
        JPanel borderPanel = new JPanel();
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), bundle.getString("CommonUI.BorderTitle.Expression.txt")), BorderFactory.createEmptyBorder(8, 8, 8, 8));
        borderPanel.setBorder(border);
        borderPanel.setLayout(new BorderLayout(12, 10));
        borderPanel.add("Center", this.m_expressionText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 0, 0, 0);
        gridBagLayout.setConstraints(borderPanel, gbc);
        this.add(borderPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 4, 0, 0);
        gridBagLayout.setConstraints(this.m_sortCheckbox, gbc);
        this.add(this.m_sortCheckbox);
        borderPanel = new JPanel();
        border = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 8, 8, 8));
        borderPanel.setBorder(border);
        borderPanel.setLayout(new BorderLayout());
        GridBagLayout sortLayout = new GridBagLayout();
        borderPanel.setLayout(sortLayout);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(16, 0, 2, 0);
        gridBagLayout.setConstraints(borderPanel, gbc);
        this.add(borderPanel);
        label = new JLabel(bundle.getString("ResultItemPropertyView.DirectionLabel.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(6, 0, 0, 0);
        sortLayout.setConstraints(label, gbc);
        borderPanel.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 8, 0, 0);
        sortLayout.setConstraints(this.m_sortDirectionChoice, gbc);
        borderPanel.add(this.m_sortDirectionChoice);
        label = new JLabel(bundle.getString("ResultItemPropertyView.PriorityLabel.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(6, 0, 2, 0);
        sortLayout.setConstraints(label, gbc);
        borderPanel.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(6, 8, 6, 0);
        sortLayout.setConstraints(this.m_sortOrderChoice, gbc);
        borderPanel.add(this.m_sortOrderChoice);
    }

    protected void _setState() {
        this.m_sortDirectionChoice.setEnabled(this.m_bSortBy);
        this.m_sortOrderChoice.setEnabled(this.m_bSortBy);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(260, 280);
    }

    class SortHandler
    implements ItemListener {
        SortHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            ResultItemPropertyView.this.m_bSortBy = ResultItemPropertyView.this.m_sortCheckbox.getState();
            ResultItemPropertyView.this._setState();
        }
    }
}

