/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.visuals.QueryResource;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class ResultItemListPanel
extends Panel {
    protected Query m_query;
    protected ResultItem m_resultItem;
    protected Label m_label;
    protected List m_listView;
    protected Button m_moveFirstButton;
    protected Button m_moveUpButton;
    protected Button m_moveDownButton;
    protected Button m_moveLastButton;
    protected Button m_newButton;
    protected Button m_deleteButton;
    static QueryResource bundle = new QueryResource(ResultItemListPanel.class);

    ResultItemListPanel(Query query, ResultItem resultItem) {
        this.m_query = query;
        this.m_resultItem = resultItem;
        this._initialize();
        this._layoutWidgets();
        this._setState();
    }

    public List getList() {
        return this.m_listView;
    }

    protected void _initialize() {
        this.m_label = new Label(bundle.getString("ResultItemListPanel.ResultItems(inReturnOrder).txt"));
        this.m_listView = new List();
        ResultItemList list = this.m_query.getResultItems();
        for (int index = 0; index < list.size(); ++index) {
            this.m_listView.addItem(list.elementAt(index).getDisplayString());
            if (list.elementAt(index) != this.m_resultItem) continue;
            this.m_listView.select(index);
        }
        this.m_listView.addItemListener(new ListHandler());
        this.m_moveFirstButton = new Button(bundle.getString("ResultItemListPanel.MoveFirst.txt"));
        this.m_moveUpButton = new Button(bundle.getString("ResultItemListPanel.MoveUp.txt"));
        this.m_moveDownButton = new Button(bundle.getString("ResultItemListPanel.MoveDown.txt"));
        this.m_moveLastButton = new Button(bundle.getString("ResultItemListPanel.MoveLast.txt"));
        this.m_newButton = new Button(bundle.getString("Common.Add....txt"));
        this.m_deleteButton = new Button(bundle.getString("Common.Delete.txt"));
    }

    protected void _setState() {
        int nSelected = this.m_listView.getSelectedIndex();
        boolean bCanMoveUp = true;
        boolean bCanMoveDown = true;
        if (nSelected == 0) {
            bCanMoveUp = false;
        } else if (nSelected == -1) {
            bCanMoveUp = false;
            bCanMoveDown = false;
        } else if (nSelected == this.m_listView.getItemCount() - 1) {
            bCanMoveDown = false;
        }
        this.m_moveFirstButton.setEnabled(bCanMoveUp);
        this.m_moveUpButton.setEnabled(bCanMoveUp);
        this.m_moveDownButton.setEnabled(bCanMoveDown);
        this.m_moveLastButton.setEnabled(bCanMoveDown);
        if (!bCanMoveUp && !bCanMoveUp) {
            this.m_deleteButton.setEnabled(false);
        }
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 4, 0, 0);
        gridBagLayout.setConstraints(this.m_label, gbc);
        this.add(this.m_label);
        Panel listPanel = new Panel();
        GridBagLayout listPanelGridBagLayout = new GridBagLayout();
        listPanel.setLayout(listPanelGridBagLayout);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(listPanel, gbc);
        this.add(listPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 4, 0, 8);
        listPanelGridBagLayout.setConstraints(this.m_listView, gbc);
        listPanel.add(this.m_listView);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveFirstButton, gbc);
        listPanel.add(this.m_moveFirstButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveUpButton, gbc);
        listPanel.add(this.m_moveUpButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveDownButton, gbc);
        listPanel.add(this.m_moveDownButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveLastButton, gbc);
        listPanel.add(this.m_moveLastButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 20, 0, 10);
        listPanelGridBagLayout.setConstraints(this.m_newButton, gbc);
        listPanel.add(this.m_newButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 10, 0, 20);
        listPanelGridBagLayout.setConstraints(this.m_deleteButton, gbc);
        listPanel.add(this.m_deleteButton);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(250, 280);
    }

    class ListHandler
    implements ItemListener {
        ListHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            ResultItemListPanel.this._setState();
        }
    }
}

