/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.query.Query;
import com.sas.query.QueryException;
import com.sas.query.datasources.WebAfDataSource;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.QueryTabView;
import com.sas.visuals.PushButton;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JFrame;

public class QueryButton
extends PushButton
implements ActionListener {
    protected Query model;
    protected QueryTabView m_qTabView;
    protected JFrame m_appFrame;
    protected WebAfDataSource m_dataSource;
    protected boolean m_showQuery;
    protected boolean m_showWhere;
    protected boolean m_showGroup;
    protected boolean m_showResults;
    protected boolean m_showSQL;
    protected boolean m_showLabels;
    protected String remoteHost = "dbipc7";

    public QueryButton() {
        this.setText("Query");
        this.m_qTabView = new QueryTabView();
    }

    public QueryButton(boolean doDefault) {
        this();
        if (doDefault) {
            this.createDefaultQuery();
        }
    }

    private void createDefaultQuery() {
        MessageHandler messages = new MessageHandler();
        try {
            WebAfDataSource dso = new WebAfDataSource("dbipc7", messages);
            Query tmp = new Query(dso);
            this.setModel(tmp);
        }
        catch (QueryException e) {
            e.printStackTrace();
        }
    }

    public void setModel(Query query) {
        this.model = query;
        this.m_qTabView.setQuery(this.model);
        if (this.m_appFrame == null) {
            this.m_appFrame = new JFrame("Query Builder");
            Dimension iSize = this.m_qTabView.getPreferredSize();
            this.m_appFrame.setSize(iSize.width + 16, iSize.height + 16);
            try {
                this.m_appFrame.getContentPane().add(this.m_qTabView);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public Query getModel() {
        return this.model;
    }

    public void setSQL(String sqlStatement) {
        if (this.model != null) {
            this.model.setSQL(sqlStatement);
        }
    }

    public String getSQL() {
        String retString = "";
        if (this.model != null) {
            retString = this.model.getSql();
        }
        return retString;
    }

    public void setQueryTabVisible(boolean show) {
        this.m_showQuery = show;
    }

    public void setWhereTabVisible(boolean show) {
        this.m_showWhere = show;
    }

    public void setGroupTabVisible(boolean show) {
        this.m_showGroup = show;
    }

    public void setResultsVisible(boolean show) {
        this.m_showResults = show;
    }

    public void setSQLTabVisible(boolean show) {
        this.m_showSQL = show;
    }

    public void setUseLabels(boolean show) {
        this.m_showLabels = show;
    }

    public void displayQuery() {
        if (this.model != null) {
            this.m_qTabView.orderTabs();
            this.m_appFrame.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.getButtonModel()) {
            this.displayQuery();
        }
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String newhost) {
        try {
            this.m_dataSource = new WebAfDataSource(this.remoteHost, new MessageHandler());
            this.remoteHost = newhost;
        }
        catch (QueryException e) {
            e.printStackTrace();
        }
    }

    public void setTabOrder(StaticOrderedCollectionInterface tabOrder) {
        Enumeration x = tabOrder.getItems();
        int i = 0;
        String[] tOrder = new String[tabOrder.count()];
        while (x.hasMoreElements()) {
            String temp = (String)x.nextElement();
            tOrder[i++] = temp;
        }
        this.setTabOrder(tOrder);
    }

    public void setTabOrder(String[] orderArray) {
        this.m_qTabView.setTabOrder(orderArray);
    }

    public void setTabOrder(int[] orderArray) {
        this.m_qTabView.setTabOrder(orderArray);
    }

    public int[] getTabOrder() {
        return this.m_qTabView.getTabOrder();
    }

    public OrderedCollection getFormattedDefaultTabs() {
        return this.m_qTabView.getFormattedDefaultTabs();
    }

    public OrderedCollection getFormattedCurrentTabs() {
        if (this.m_qTabView == null) {
            return new OrderedCollection();
        }
        return this.m_qTabView.getFormattedCurrentTabs();
    }
}

