/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.Expression;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.OrderItem;
import com.sas.query.models.OrderItemList;
import com.sas.query.models.PropertyChangeConstants;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.visuals.OrderItemPropertyView;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class OrderItemListView
extends StandardView {
    protected OrderItemList m_OrderItems = null;
    protected JTable m_tableView;
    protected JScrollPane m_scrollpane;
    protected JButton m_editButton;
    protected JButton m_deleteButton;
    protected JButton m_moveFirstButton;
    protected JButton m_moveUpButton;
    protected JButton m_moveDownButton;
    protected JButton m_moveLastButton;
    protected static QueryResource bundle = new QueryResource(OrderItemListView.class);
    protected String[] m_labels = new String[]{"", bundle.getString("OrderItemListView.DataItemToOrderBy.txt"), bundle.getString("OrderItemListView.Direction.txt")};
    protected int[] m_minSize = new int[]{30, 200, 80};

    public OrderItemListView(Query query) {
        super(query);
        this.m_tableView = new JTable(new OrderItemTableModel(query)){

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                OrderItemListView.this._setState();
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                OrderItemListView.this._setState();
            }
        };
        this.m_tableView.setSelectionMode(0);
        TableColumn resultCol = this.m_tableView.getColumnModel().getColumn(0);
        TableCellRenderer headerRenderer = resultCol.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            URL url = this.getClass().getResource("res/DataSet.gif");
            ImageIcon icon = new ImageIcon(url);
            ((DefaultTableCellRenderer)headerRenderer).setIcon(icon);
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText(bundle.getString("OrderItemListView.ReturnItemInResults.txt"));
        }
        for (int index = 0; index < this.m_minSize.length; ++index) {
            this.m_tableView.getColumnModel().getColumn(index).setMinWidth(this.m_minSize[index]);
        }
        this.m_scrollpane = new JScrollPane(this.m_tableView);
        WindowUtil.fixupJScrollPane(this.m_scrollpane);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem(bundle.getString("Common.defaultinBrackets.txt"));
        comboBox.addItem(bundle.getString("Common.Ascending.txt"));
        comboBox.addItem(bundle.getString("Common.Descending.txt"));
        this.m_tableView.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(comboBox));
        this.m_editButton = new JButton(bundle.getString("Common.Edit....txt"));
        this.m_editButton.addActionListener(new EditButtonHandler());
        this.m_deleteButton = new JButton(bundle.getString("Common.Delete.txt"));
        this.m_deleteButton.addActionListener(new DeleteButtonHandler());
        URL url = this.getClass().getResource("res/upFirst.gif");
        ImageIcon defaultIcon = new ImageIcon(url);
        this.m_moveFirstButton = new JButton(bundle.getString("Common.First.txt"));
        this.m_moveFirstButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_moveFirstButton.addActionListener(new MoveButtonHandler("First"));
        url = this.getClass().getResource("res/upArrow.gif");
        defaultIcon = new ImageIcon(url);
        this.m_moveUpButton = new JButton(bundle.getString("Common.Up.txt"));
        this.m_moveUpButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_moveUpButton.addActionListener(new MoveButtonHandler("Up"));
        url = this.getClass().getResource("res/downArrow.gif");
        defaultIcon = new ImageIcon(url);
        this.m_moveDownButton = new JButton(bundle.getString("Common.Down.txt"));
        this.m_moveDownButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_moveDownButton.addActionListener(new MoveButtonHandler("Down"));
        url = this.getClass().getResource("res/downLast.gif");
        defaultIcon = new ImageIcon(url);
        this.m_moveLastButton = new JButton(bundle.getString("Common.Last.txt"));
        this.m_moveLastButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_moveLastButton.addActionListener(new MoveButtonHandler("Last"));
        JPanel listPanel = new JPanel();
        GridBagLayout listPanelGridBagLayout = new GridBagLayout();
        listPanel.setLayout(listPanelGridBagLayout);
        listPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_editButton, gbc);
        listPanel.add(this.m_editButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 11;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_deleteButton, gbc);
        listPanel.add(this.m_deleteButton);
        JPanel spacer = new JPanel();
        spacer.setSize(10, 80);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 11;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(spacer, gbc);
        listPanel.add(spacer);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveFirstButton, gbc);
        listPanel.add(this.m_moveFirstButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveUpButton, gbc);
        listPanel.add(this.m_moveUpButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveDownButton, gbc);
        listPanel.add(this.m_moveDownButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveLastButton, gbc);
        listPanel.add(this.m_moveLastButton);
        this.setLayout(new BorderLayout());
        this.add(this.m_scrollpane);
        this.add("East", listPanel);
        this.m_tableView.setRowSelectionInterval(0, 0);
        this._setState();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener((OrderItemTableModel)this.m_tableView.getModel());
    }

    public void onEdit() {
        OrderItem item = this.getSelectedItem();
        OrderItemPropertyView propertyPanel = new OrderItemPropertyView(this.m_query, item);
        QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "BUG - need Prefix");
        WindowUtil.centerOverWindow(editDialog, this);
        editDialog.setModal(true);
        editDialog.pack();
        editDialog.setVisible(true);
        propertyPanel.closing();
    }

    public void onDelete() {
        OrderItem item = this.getSelectedItem();
        this.m_query.deleteOrderItem(item);
        this.firePropertyChanges();
    }

    public void valueChanged(ListSelectionEvent e) {
        this._setState();
    }

    protected void _setState() {
        int nSelected = this.m_tableView.getSelectedRow();
        if (this.m_tableView.getRowCount() == 0 || nSelected > this.m_tableView.getRowCount() - 1) {
            nSelected = -1;
        }
        boolean bCanMoveUp = true;
        boolean bCanMoveDown = true;
        if (nSelected == 0) {
            bCanMoveUp = false;
        } else if (nSelected == -1) {
            bCanMoveUp = false;
            bCanMoveDown = false;
        } else if (nSelected == this.m_tableView.getRowCount() - 1) {
            bCanMoveDown = false;
        }
        this.m_moveFirstButton.setEnabled(bCanMoveUp);
        this.m_moveUpButton.setEnabled(bCanMoveUp);
        this.m_moveDownButton.setEnabled(bCanMoveDown);
        this.m_moveLastButton.setEnabled(bCanMoveDown);
        if (!bCanMoveUp && !bCanMoveDown) {
            this.m_editButton.setEnabled(false);
            this.m_deleteButton.setEnabled(false);
        } else {
            this.m_editButton.setEnabled(true);
            this.m_deleteButton.setEnabled(true);
        }
    }

    protected OrderItem getSelectedItem() {
        OrderItem item = null;
        int index = this.m_tableView.getSelectedRow();
        if (index != -1) {
            item = this.m_OrderItems.elementAt(index);
        }
        return item;
    }

    protected class MoveButtonHandler
    implements ActionListener {
        String m_strAction;

        MoveButtonHandler(String action) {
            this.m_strAction = action;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int index = OrderItemListView.this.m_tableView.getSelectedRow();
            if (this.m_strAction.equals("First")) {
                OrderItemListView.this.m_query.moveOrderItem(index, 0);
                OrderItemListView.this.m_tableView.setRowSelectionInterval(0, 0);
            } else if (this.m_strAction.equals("Up")) {
                OrderItemListView.this.m_query.moveOrderItem(index, index - 1);
                OrderItemListView.this.m_tableView.setRowSelectionInterval(index - 1, index - 1);
            } else if (this.m_strAction.equals("Down")) {
                OrderItemListView.this.m_query.moveOrderItem(index, index + 2);
                OrderItemListView.this.m_tableView.setRowSelectionInterval(index + 1, index + 1);
            } else if (this.m_strAction.equals("Last")) {
                OrderItemListView.this.m_query.moveOrderItem(index, OrderItemListView.this.m_OrderItems.size());
                OrderItemListView.this.m_tableView.setRowSelectionInterval(OrderItemListView.this.m_OrderItems.size() - 1, OrderItemListView.this.m_OrderItems.size() - 1);
            }
        }
    }

    protected class DeleteButtonHandler
    implements ActionListener {
        DeleteButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            OrderItemListView.this.onDelete();
            OrderItemListView.this._setState();
        }
    }

    protected class EditButtonHandler
    implements ActionListener {
        EditButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            OrderItemListView.this.onEdit();
        }
    }

    class OrderItemTableModel
    extends AbstractTableModel
    implements PropertyChangeConstants,
    ModelChangeListener {
        Hashtable isItemSelectedList = new Hashtable();

        public OrderItemTableModel(Query query) {
            query.addPropertyListener(this, 256);
            this.refresh();
        }

        @Override
        public int getColumnCount() {
            return OrderItemListView.this.m_labels.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return OrderItemListView.this.m_labels[columnIndex];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public int getRowCount() {
            return OrderItemListView.this.m_OrderItems.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            OrderItem item = OrderItemListView.this.m_OrderItems.elementAt(row);
            if (col == 0) {
                return new Boolean(item.getResultItem() != null);
            }
            if (col == 1) {
                return item.getDisplayString();
            }
            if (col == 2) {
                if (item.getSortingDirection() == 0) {
                    return bundle.getString("Common.defaultinBrackets.txt");
                }
                if (item.getSortingDirection() == 1) {
                    return bundle.getString("Common.Ascending.txt");
                }
                if (item.getSortingDirection() == 2) {
                    return bundle.getString("Common.Descending.txt");
                }
            }
            return bundle.getString("Common.nullinBrackets.txt");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            boolean bEditable = false;
            if (col == 0 || col == 2) {
                bEditable = true;
            }
            return bEditable;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            OrderItem item = OrderItemListView.this.m_OrderItems.elementAt(row);
            if (col == 0) {
                if (item.getResultItem() == null) {
                    this._shareWithResultItem(item);
                } else {
                    try {
                        item.setExpression((Expression)item.getResultItem().getExpression().clone());
                    }
                    catch (Exception e) {
                        OrderItemListView.this.m_query.addError("Unable to copy result expression into order item.");
                    }
                }
            }
            if (col == 2) {
                String defStr = bundle.getString("Common.defaultinBrackets.txt");
                String ascStr = bundle.getString("Common.Ascending.txt");
                String descStr = bundle.getString("Common.Descending.txt");
                if (value.equals(defStr)) {
                    item.setSortingDirection(0);
                } else if (value.equals(ascStr)) {
                    item.setSortingDirection(1);
                } else if (value.equals(descStr)) {
                    item.setSortingDirection(2);
                }
            }
            this.refresh();
            OrderItemListView.this.firePropertyChanges();
        }

        protected void _shareWithResultItem(OrderItem item) {
            ResultItemList resultList = OrderItemListView.this.m_query.getResultItems();
            OrderItemList orderList = OrderItemListView.this.m_query.getOrderItems();
            for (int index = 0; index < resultList.size(); ++index) {
                ResultItem resultItem = resultList.elementAt(index);
                if (!resultItem.getExpression().equivalentTo(OrderItemListView.this.m_query, item.getExpression())) continue;
                boolean bUsed = false;
                for (int orderIndex = 0; orderIndex < orderList.size(); ++orderIndex) {
                    OrderItem orderItem = orderList.elementAt(orderIndex);
                    if (orderItem.getResultItem() != resultItem) continue;
                    bUsed = true;
                }
                if (bUsed) continue;
                item.setResultItem(resultItem);
                return;
            }
            OrderItemListView.this.m_query.addResultItem(item.getExpression());
        }

        public void refresh() {
            OrderItemListView.this.m_OrderItems = OrderItemListView.this.m_query.getOrderItems();
            TableModelEvent event = new TableModelEvent(this);
            this.fireTableChanged(event);
        }

        @Override
        public void modelChangeCallback(ModelChangeEvent event) {
            this.refresh();
        }
    }
}

