/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.QueryException;
import com.sas.query.datasources.DataSource;
import com.sas.query.models.ConnectionHandler;
import com.sas.query.models.DefinedConnection;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.DefinedConnectionPropertyView;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.WindowUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OpenQueryDialog
extends JDialog {
    protected Query m_query;
    protected DataSource m_dataSource = null;
    protected Frame m_parentFrame;
    protected MessageHandler m_messages;
    protected Vector m_connectList;
    protected Vector m_recentList;
    protected String m_strTitle;
    protected String m_strOkLabel;
    protected String m_strCancelLabel;
    protected JTabbedPane m_tabbedPane;
    protected JPanel m_dataSourceTab;
    protected JPanel m_queryTab;
    protected JTextField m_dataSourceText;
    protected JList m_dataSourceList;
    protected JTextField m_savedQueryText;
    protected JList m_savedQueryList;
    protected JButton m_newButton;
    protected JButton m_editButton;
    protected JButton m_deleteButton;
    protected JButton m_helpButton;
    protected transient String m_helpSetLocation;
    protected transient HelpBroker m_hb;
    static QueryResource bundle = new QueryResource(OpenQueryDialog.class);

    public OpenQueryDialog(Frame parentFrame, MessageHandler messages, String helpSetLocation) {
        super(parentFrame, "", true);
        if (parentFrame == null) {
            WindowUtil.fixupDialogIcons();
        }
        this.m_messages = messages;
        this.m_helpSetLocation = helpSetLocation;
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            drivers.nextElement();
        }
        this._initialization();
    }

    protected void _initialization() {
        this.m_strTitle = bundle.getString("OpenDataSource.Title.txt");
        this.m_strOkLabel = bundle.getString("Standard.ButtonLabel.Open.txt");
        this.m_strCancelLabel = bundle.getString("Standard.ButtonLabel.Cancel.txt");
        this.m_connectList = ConnectionHandler.getDefinedConnectionList(this.m_messages);
        this.m_recentList = ConnectionHandler.getUserDefinedRecentQueryList(this.m_messages);
        this._layoutWidgets();
        this._layoutDataSourceTabWidgets();
        this._layoutQueryTabWidgets();
        this._setState();
        MessageUtil.displayMessages(this.m_messages);
        this.setTitle(this.m_strTitle);
        this.setSize(415, 275);
        WindowUtil.center(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OpenQueryDialog.this.onCancel();
            }
        });
    }

    protected void _refreshDefinedConnectionList(DefinedConnection selectedConnection) {
        this.m_connectList = ConnectionHandler.getDefinedConnectionList(this.m_messages);
        this.m_dataSourceList.removeAll();
        this.m_dataSourceList.setListData(this.m_connectList);
        if (this.m_connectList.size() > 0) {
            if (selectedConnection != null) {
                int size = this.m_connectList.size();
                for (int index = 0; index < size; ++index) {
                    DefinedConnection connect = (DefinedConnection)this.m_connectList.elementAt(index);
                    if (!connect.equals(selectedConnection)) continue;
                    this.m_dataSourceList.setSelectedIndex(index);
                    break;
                }
            } else {
                this.m_dataSourceList.setSelectedIndex(0);
            }
        }
        MessageUtil.displayMessages(this.m_messages);
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public String getSql() {
        String returnValue = null;
        if (this.m_query != null) {
            returnValue = this.m_query.getSql();
        }
        return returnValue;
    }

    public Query getQuery() {
        return this.m_query;
    }

    public void onOk() {
        block9: {
            WindowUtil.busyOn(this);
            try {
                if (this.m_tabbedPane.getSelectedIndex() == 0) {
                    Object junk = this.m_dataSourceList.getSelectedValue();
                    this.m_dataSource = ConnectionHandler.openDataSource(junk, this.m_messages);
                } else {
                    Object junk = this.m_savedQueryList.getSelectedValue();
                    this.m_query = ConnectionHandler.openSavedQuery(junk, this.m_messages);
                    this.m_dataSource = this.m_query.getDataSource();
                }
            }
            catch (QueryException e) {
                if (e.getErrorCode() == QueryException.USER_CANCELLED_CONNECTION) {
                    this.m_dataSource = null;
                    this.setVisible(true);
                    return;
                }
                if (!this.m_messages.failureHasOccurred()) {
                    this.m_messages.addError(e, bundle, "Standard.Message.InternalError.fmt.txt");
                }
            }
            catch (Exception e) {
                if (this.m_messages.failureHasOccurred()) break block9;
                this.m_messages.addError(e, bundle, "Standard.Message.InternalError.fmt.txt");
            }
        }
        WindowUtil.busyOff(this);
        if (this.m_messages.failureHasOccurred()) {
            this.m_dataSource = null;
            MessageUtil.displayMessages(this.m_messages);
            this.setVisible(true);
        } else {
            MessageUtil.displayMessages(this.m_messages);
            this.dispose();
        }
    }

    public void onCancel() {
        this.dispose();
    }

    public void onNew() {
        if (this.m_tabbedPane.getSelectedIndex() == 0) {
            DefinedConnection connection = new DefinedConnection();
            connection.setIsLocalDefinition(true);
            DefinedConnectionPropertyView propertyPanel = new DefinedConnectionPropertyView(this.m_query, connection);
            QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "DefinedConnection.Title.txt");
            WindowUtil.center(editDialog);
            editDialog.setModal(true);
            editDialog.pack();
            editDialog.setVisible(true);
            if (editDialog.getReturnValue() == 1) {
                ConnectionHandler.addDefinedConnection(connection, this.m_messages);
                this._refreshDefinedConnectionList(connection);
            }
        }
        MessageUtil.displayMessages(this.m_messages);
    }

    public void onEdit() {
        if (this.m_tabbedPane.getSelectedIndex() == 0) {
            DefinedConnection oldConnection = (DefinedConnection)this.m_dataSourceList.getSelectedValue();
            DefinedConnection connection = (DefinedConnection)oldConnection.clone();
            DefinedConnectionPropertyView propertyPanel = new DefinedConnectionPropertyView(this.m_query, connection);
            QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "DefinedConnection.Title.txt");
            if (!oldConnection.isLocalDefinition()) {
                propertyPanel.setReadOnly();
                editDialog.removeCancelButton();
            }
            WindowUtil.center(editDialog);
            editDialog.setModal(true);
            editDialog.pack();
            editDialog.setVisible(true);
            if (editDialog.getReturnValue() == 1) {
                ConnectionHandler.changeDefinedConnection(oldConnection, connection, this.m_messages);
                this._refreshDefinedConnectionList(connection);
            }
        }
        MessageUtil.displayMessages(this.m_messages);
    }

    public void onHelp() {
        HelpSet hs = null;
        if (this.m_hb == null && this.m_helpSetLocation != null) {
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)this.m_helpSetLocation);
                if (url != null) {
                    hs = new HelpSet(cl, url);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (hs != null) {
                this.m_hb = hs.createHelpBroker();
                if (this.m_hb == null) {
                    this.m_helpButton.setVisible(false);
                } else {
                    this.m_hb.enableHelpOnButton((Component)this.m_helpButton, "OpenQueryDialog.SelectDataSourceHelp", null);
                    this.m_hb.setCurrentID("OpenQueryDialog.SelectDataSourceHelp");
                    this.m_helpButton.doClick();
                }
            }
        }
    }

    public void onDelete() {
        if (this.m_tabbedPane.getSelectedIndex() == 0) {
            DefinedConnection temp = (DefinedConnection)this.m_dataSourceList.getSelectedValue();
            ConnectionHandler.deleteDefinedConnection(temp, this.m_messages);
            this._refreshDefinedConnectionList(null);
        } else {
            Object temp = this.m_savedQueryList.getSelectedValue();
            ConnectionHandler.deleteSavedQuery(temp, this.m_messages);
        }
        MessageUtil.displayMessages(this.m_messages);
        if (this.m_messages.failureHasOccurred()) {
            this.m_dataSource = null;
        }
    }

    protected void _layoutWidgets() {
        this.setResizable(true);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event) {
            }

            @Override
            public void keyTyped(KeyEvent event) {
            }

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == 27) {
                    OpenQueryDialog.this.onCancel();
                } else if (event.getKeyCode() == 10) {
                    OpenQueryDialog.this.onOk();
                }
            }
        });
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(14, 12, 12, 10);
        this.m_tabbedPane = new JTabbedPane();
        gridBagLayout.setConstraints(this.m_tabbedPane, gbc);
        this.getContentPane().add(this.m_tabbedPane);
        this.m_tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                OpenQueryDialog.this._setState();
            }
        });
        JButton addButton = new JButton(this.m_strOkLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(16, 8, 0, 12);
        gridBagLayout.setConstraints(addButton, gbc);
        this.getContentPane().add(addButton);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenQueryDialog.this.onOk();
            }
        });
        CompoundBorder defaultBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), addButton.getBorder());
        addButton.setBorder(defaultBorder);
        JButton closeButton = new JButton(this.m_strCancelLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 8, 8, 12);
        gridBagLayout.setConstraints(closeButton, gbc);
        this.getContentPane().add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenQueryDialog.this.onCancel();
            }
        });
        this.m_newButton = new JButton(bundle.getString("OpenDataSource.ButtonLabel.New.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(16, 8, 8, 12);
        gridBagLayout.setConstraints(this.m_newButton, gbc);
        this.getContentPane().add(this.m_newButton);
        this.m_newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenQueryDialog.this.onNew();
            }
        });
        this.m_editButton = new JButton(bundle.getString("OpenDataSource.ButtonLabel.Edit.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 8, 8, 12);
        gridBagLayout.setConstraints(this.m_editButton, gbc);
        this.getContentPane().add(this.m_editButton);
        this.m_editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenQueryDialog.this.onEdit();
            }
        });
        this.m_deleteButton = new JButton(bundle.getString("Standard.ButtonLabel.Delete.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 8, 8, 12);
        gridBagLayout.setConstraints(this.m_deleteButton, gbc);
        this.getContentPane().add(this.m_deleteButton);
        this.m_deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenQueryDialog.this.onDelete();
            }
        });
        if (this.m_helpSetLocation != null) {
            this.m_helpButton = new JButton(bundle.getString("Common.Help.txt"));
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.anchor = 12;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 8, 8, 12);
            gridBagLayout.setConstraints(this.m_helpButton, gbc);
            this.getContentPane().add(this.m_helpButton);
            this.m_helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    OpenQueryDialog.this.onHelp();
                }
            });
        }
    }

    protected void _layoutDataSourceTabWidgets() {
        this.setResizable(true);
        this.m_dataSourceTab = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_dataSourceTab.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.m_dataSourceText = new JTextField();
        gridBagLayout.setConstraints(this.m_dataSourceText, gbc);
        this.m_dataSourceTab.add(this.m_dataSourceText);
        this.m_dataSourceText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenQueryDialog.this.onOk();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.m_dataSourceList = new JList(this.m_connectList);
        JScrollPane scrollPane = new JScrollPane(this.m_dataSourceList);
        WindowUtil.fixupJScrollPane(scrollPane);
        gridBagLayout.setConstraints(scrollPane, gbc);
        this.m_dataSourceTab.add(scrollPane);
        this.m_dataSourceList.addListSelectionListener(new ListListener());
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    OpenQueryDialog.this.onOk();
                }
            }
        };
        this.m_dataSourceList.addMouseListener(mouseListener);
        this.m_dataSourceList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event) {
            }

            @Override
            public void keyTyped(KeyEvent event) {
            }

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    OpenQueryDialog.this.onOk();
                }
            }
        });
        if (this.m_connectList.size() > 0) {
            this.m_dataSourceList.setSelectedIndex(0);
        }
        this.m_tabbedPane.addTab(bundle.getString("OpenDataSource.TabLabel.New.txt"), this.m_dataSourceTab);
    }

    protected void _layoutQueryTabWidgets() {
        this.setResizable(true);
        this.m_queryTab = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_queryTab.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.m_savedQueryText = new JTextField();
        gridBagLayout.setConstraints(this.m_savedQueryText, gbc);
        this.m_queryTab.add(this.m_savedQueryText);
        this.m_savedQueryText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenQueryDialog.this.onOk();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.m_savedQueryList = new JList(this.m_recentList);
        JScrollPane scrollPane = new JScrollPane(this.m_savedQueryList);
        WindowUtil.fixupJScrollPane(scrollPane);
        gridBagLayout.setConstraints(scrollPane, gbc);
        this.m_queryTab.add(scrollPane);
        this.m_savedQueryList.addListSelectionListener(new ListListener());
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    OpenQueryDialog.this.onOk();
                }
            }
        };
        this.m_savedQueryList.addMouseListener(mouseListener);
        this.m_savedQueryList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event) {
            }

            @Override
            public void keyTyped(KeyEvent event) {
            }

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    OpenQueryDialog.this.onOk();
                }
            }
        });
        if (this.m_recentList.size() > 0) {
            this.m_savedQueryList.setSelectedIndex(0);
        }
        this.m_tabbedPane.addTab(bundle.getString("OpenDataSource.TabLabel.Recent.txt"), this.m_queryTab);
    }

    protected void _setState() {
        boolean bDeleteEnabled;
        boolean bEditEnabled;
        boolean bNewEnabled;
        String strEditLabel = bundle.getString("OpenDataSource.ButtonLabel.Edit.txt");
        if (this.m_tabbedPane.getTabCount() > 1) {
            this.m_tabbedPane.setEnabledAt(1, this.m_recentList.size() > 0);
        }
        if (this.m_tabbedPane.getSelectedIndex() == 0) {
            DefinedConnection temp = (DefinedConnection)this.m_dataSourceList.getSelectedValue();
            bNewEnabled = ConnectionHandler.isLocalDefineAccessable();
            boolean bl = bEditEnabled = ConnectionHandler.isLocalDefineAccessable() || temp != null && !temp.isLocalDefinition();
            if (temp != null && !temp.isLocalDefinition()) {
                strEditLabel = bundle.getString("OpenDataSource.ButtonLabel.View.txt");
            }
            bDeleteEnabled = ConnectionHandler.isLocalDefineAccessable() && temp != null && temp.isLocalDefinition();
        } else {
            bNewEnabled = false;
            bEditEnabled = false;
            bDeleteEnabled = false;
        }
        this.m_newButton.setEnabled(bNewEnabled);
        this.m_newButton.setFocusPainted(bNewEnabled);
        this.m_editButton.setText(strEditLabel);
        this.m_editButton.setEnabled(bEditEnabled);
        this.m_editButton.setFocusPainted(bEditEnabled);
        this.m_deleteButton.setEnabled(bDeleteEnabled);
        this.m_deleteButton.setFocusPainted(bDeleteEnabled);
    }

    protected class ListListener
    implements ListSelectionListener {
        protected ListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getSource() == OpenQueryDialog.this.m_dataSourceList && OpenQueryDialog.this.m_dataSourceList.getSelectedValue() != null) {
                OpenQueryDialog.this.m_dataSourceText.setText(OpenQueryDialog.this.m_dataSourceList.getSelectedValue().toString());
            } else if (event.getSource() == OpenQueryDialog.this.m_savedQueryList && OpenQueryDialog.this.m_savedQueryList.getSelectedValue() != null) {
                OpenQueryDialog.this.m_savedQueryText.setText(OpenQueryDialog.this.m_savedQueryList.getSelectedValue().toString());
            }
            OpenQueryDialog.this._setState();
        }
    }
}

