/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.DisplayLater;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.WindowUtil;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class MessageUtil {
    protected static QueryResource bundle = new QueryResource(MessageUtil.class);

    public static void displayAndExitOnError(MessageHandler messageHandler) {
        MessageUtil.displayMessages(messageHandler);
        if (messageHandler.failureHasOccurred()) {
            System.exit(0);
        }
    }

    public static boolean displayMessagesAndCheckForErrors(MessageHandler messageHandler) {
        boolean bError = messageHandler.failureHasOccurred();
        MessageUtil.displayMessages(messageHandler);
        return bError;
    }

    public static void displayMessages(MessageHandler messageHandler) {
        String[] messages = messageHandler.getMessages();
        if (messages.length == 0) {
            return;
        }
        int cLines = 0;
        int maxWidth = 60;
        for (int index = 0; index < messages.length; ++index) {
            int newLine;
            ++cLines;
            int startPoint = 0;
            while ((newLine = messages[index].indexOf(10, startPoint)) >= 0) {
                ++cLines;
                maxWidth = Math.max(maxWidth, newLine - startPoint);
                startPoint = newLine + 1;
            }
            maxWidth = Math.max(maxWidth, messages[index].length() - startPoint);
        }
        cLines = Math.min(10, cLines);
        maxWidth = Math.min(100, maxWidth + 1);
        JTextArea textArea = new JTextArea(Math.max(4, cLines), Math.max(60, maxWidth));
        textArea.setText(messageHandler.getOneBigMessage());
        textArea.setBackground(SystemColor.control);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(false);
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea);
        WindowUtil.fixupJScrollPane(scrollPane);
        MessageUtil.showMessageDialog(null, scrollPane);
        messageHandler.removeAllMessages();
    }

    protected static void showMessageDialog(Object ignoredParent, JComponent messageWidget) {
        JDialog dialog = new JDialog();
        dialog.setModal(true);
        dialog.setTitle(bundle.getString("Common.Information.txt"));
        Container contentPane = dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.gridheight = 3;
        gbc.insets = new Insets(8, 8, 8, 8);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbl.setConstraints(messageWidget, gbc);
        contentPane.add(messageWidget);
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridheight = 3;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(8, 8, 8, 8);
        UIDefaults defaults = UIManager.getDefaults();
        JLabel infoIcon = new JLabel(defaults.getIcon("OptionPane.informationIcon"));
        gbl.setConstraints(infoIcon, gbc);
        contentPane.add(infoIcon);
        JPanel dummy1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.anchor = 14;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 8, 8, 8);
        gbl.setConstraints(dummy1, gbc);
        contentPane.add(dummy1);
        JPanel dummy2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.anchor = 14;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 8, 8, 8);
        gbl.setConstraints(dummy2, gbc);
        contentPane.add(dummy2);
        JButton okBut = new JButton(bundle.getString("Common.OK.txt"));
        okBut.addActionListener(new buttonListener(dialog));
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 14;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 8, 8, 8);
        gbl.setConstraints(okBut, gbc);
        contentPane.add(okBut);
        contentPane.doLayout();
        dialog.pack();
        WindowUtil.center(dialog);
        dialog.show();
    }

    public static void displayMessagesLater(MessageHandler messageHandler) {
        new DisplayLater(messageHandler);
    }

    static class buttonListener
    implements ActionListener {
        private JDialog dialog;

        public buttonListener(JDialog d) {
            this.dialog = d;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.dialog.dispose();
        }
    }
}

