/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class LifeSign
extends JPanel {
    int m_width;
    int m_waveSize;
    int m_currentState;

    public LifeSign(int width, int wavesize, int startingPoint) {
        this.m_width = width;
        this.m_waveSize = wavesize;
        this.m_currentState = startingPoint;
    }

    public void pulse() {
        this.m_currentState += 2;
        if (this.m_currentState > this.m_width * 2) {
            this.m_currentState = this.m_currentState % this.m_width + this.m_width;
        }
        this.invalidate();
        this.repaint();
    }

    private int greyNum(int slot) {
        int whatState = this.m_currentState - slot;
        if (whatState < 0) {
            whatState = 0;
        }
        double percent = (double)((whatState %= this.m_waveSize) % this.m_waveSize) / (double)this.m_waveSize;
        int retval = (int)(255.0 * Math.cos(percent * 2.0 * Math.PI));
        return Math.abs(retval);
    }

    @Override
    public void paintComponent(Graphics g) {
        Color currentColor = g.getColor();
        int totalHeight = this.getSize().height;
        int totalWidth = this.getSize().width;
        int y1 = 0;
        int y2 = totalHeight;
        for (int i = 0; i < this.m_width; ++i) {
            int x1 = i * totalWidth / this.m_width;
            int x2 = (i + 1) * totalWidth / this.m_width;
            int intpercent = this.greyNum(i);
            Color cur = new Color(intpercent, intpercent, intpercent);
            g.setColor(cur);
            g.fillRect(x1, y1, x2, y2);
        }
        g.setColor(currentColor);
    }
}

