/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.QueryResource;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JoinTypeRadioGroup
extends JPanel {
    public static final int JOIN_TYPE_IMAGE = 1;
    public static final int JLABEL_ONLY = 2;
    public static final int JRADIO_BUTTON_ONLY = 3;
    private final double XWEIGHT = 1.0;
    protected JRadioButton m_buttonLeft;
    protected JRadioButton m_buttonRight;
    protected JRadioButton m_buttonFull;
    protected JRadioButton m_buttonInner;
    protected ClickablePart m_graphicLeft;
    protected ClickablePart m_graphicRight;
    protected ClickablePart m_graphicFull;
    protected ClickablePart m_graphicInner;
    protected ClickablePart m_rightTextLeft;
    protected ClickablePart m_rightTextRight;
    protected ClickablePart m_rightTextInner;
    protected ClickablePart m_rightTextFull;
    protected static QueryResource bundle = new QueryResource(JoinTypeRadioGroup.class);

    public JoinTypeRadioGroup() {
        String strMatch = bundle.messageString("Join.Label.Matching.txt");
        String strAll = bundle.messageString("Join.Label.All.txt");
        this.m_buttonInner = new JRadioButton(strMatch);
        this.m_buttonLeft = new JRadioButton(strAll);
        this.m_buttonRight = new JRadioButton(strMatch);
        this.m_buttonFull = new JRadioButton(strAll);
        this.m_graphicInner = new ClickablePart(1, 0, this.m_buttonInner, "");
        this.m_graphicLeft = new ClickablePart(1, 1, this.m_buttonLeft, "");
        this.m_graphicRight = new ClickablePart(1, 2, this.m_buttonRight, "");
        this.m_graphicFull = new ClickablePart(1, 3, this.m_buttonFull, "");
        this.m_rightTextInner = new ClickablePart(2, 0, this.m_buttonInner, strMatch);
        this.m_rightTextLeft = new ClickablePart(2, 0, this.m_buttonLeft, strMatch);
        this.m_rightTextRight = new ClickablePart(2, 0, this.m_buttonRight, strAll);
        this.m_rightTextFull = new ClickablePart(2, 0, this.m_buttonFull, strAll);
        this.layoutWidgets();
    }

    public JRadioButton getButton(int which) {
        if (which == 0) {
            return this.m_buttonInner;
        }
        if (which == 1) {
            return this.m_buttonLeft;
        }
        if (which == 2) {
            return this.m_buttonRight;
        }
        if (which == 3) {
            return this.m_buttonFull;
        }
        return null;
    }

    private Insets buttonInset() {
        return new Insets(0, 35, 0, 0);
    }

    private Insets graphicInset() {
        return new Insets(0, 3, 0, 3);
    }

    private Insets rightTextInset() {
        return new Insets(0, 5, 0, 15);
    }

    private void layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 3;
        gbc.insets = this.buttonInset();
        gridBagLayout.setConstraints(this.m_buttonInner, gbc);
        this.add(this.m_buttonInner);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = this.graphicInset();
        gridBagLayout.setConstraints(this.m_graphicInner, gbc);
        this.add(this.m_graphicInner);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 3;
        gbc.insets = this.rightTextInset();
        gridBagLayout.setConstraints(this.m_rightTextInner, gbc);
        this.add(this.m_rightTextInner);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 3;
        gbc.insets = this.buttonInset();
        gridBagLayout.setConstraints(this.m_buttonLeft, gbc);
        this.add(this.m_buttonLeft);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = this.graphicInset();
        gridBagLayout.setConstraints(this.m_graphicLeft, gbc);
        this.add(this.m_graphicLeft);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 12;
        gbc.fill = 3;
        gbc.insets = this.rightTextInset();
        gridBagLayout.setConstraints(this.m_rightTextLeft, gbc);
        this.add(this.m_rightTextLeft);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 3;
        gbc.insets = this.buttonInset();
        gridBagLayout.setConstraints(this.m_buttonRight, gbc);
        this.add(this.m_buttonRight);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = this.graphicInset();
        gridBagLayout.setConstraints(this.m_graphicRight, gbc);
        this.add(this.m_graphicRight);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 12;
        gbc.fill = 3;
        gbc.insets = this.rightTextInset();
        gridBagLayout.setConstraints(this.m_rightTextRight, gbc);
        this.add(this.m_rightTextRight);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 3;
        gbc.insets = this.buttonInset();
        gridBagLayout.setConstraints(this.m_buttonFull, gbc);
        this.add(this.m_buttonFull);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = this.graphicInset();
        gridBagLayout.setConstraints(this.m_graphicFull, gbc);
        this.add(this.m_graphicFull);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 12;
        gbc.fill = 3;
        gbc.insets = this.rightTextInset();
        gridBagLayout.setConstraints(this.m_rightTextFull, gbc);
        this.add(this.m_rightTextFull);
    }

    class ClickablePart
    extends JPanel {
        private int m_imageType;
        private int m_imageSubType;
        private AbstractButton m_button;
        private String m_text;
        private JComponent m_jcomponent;

        protected AbstractButton getButton() {
            return this.m_button;
        }

        int getType() {
            return this.m_imageType;
        }

        int getSubType() {
            return this.m_imageSubType;
        }

        void setType(int newType) {
            this.m_imageType = newType;
        }

        void setSubType(int newType) {
            this.m_imageSubType = newType;
        }

        String getText() {
            return this.m_text;
        }

        void setText(String text) {
            this.m_text = text;
        }

        public ClickablePart(int type, int subtype) {
            this(type, subtype, null, "");
        }

        public ClickablePart(int type, int subtype, AbstractButton clickReciever, String text) {
            this.m_button = clickReciever;
            this.setType(type);
            this.setSubType(subtype);
            this.setText(text);
            this.init();
        }

        private void init() {
            if (this.getType() == 1) {
                ClickListener clickListener = new ClickListener();
                this.addMouseListener(clickListener);
            } else if (this.getType() == 2) {
                JLabel j = new JLabel(this.getText());
                this.m_jcomponent = j;
                this.setLayout(new BorderLayout());
                this.add("West", j);
                ClickListener clickListener = new ClickListener();
                this.addMouseListener(clickListener);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Rectangle rect = this.getBounds();
            g.setColor(this.getForeground());
            if (this.getType() == 1) {
                Rectangle left = new Rectangle(0, 0, 0, rect.height);
                Rectangle right = new Rectangle(rect.width, 0, 0, rect.height);
                DrawUtil.drawJoinLine(g, false, this.getSubType(), left, right);
            }
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        class ClickListener
        extends MouseAdapter {
            ClickListener() {
            }

            @Override
            public void mousePressed(MouseEvent event) {
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if ((event.getModifiers() & 4) != 0) {
                    return;
                }
                ClickablePart source = (ClickablePart)event.getSource();
                if (source.getButton() != null) {
                    source.getButton().doClick();
                } else {
                    MessageHandler.addStaticError("no button to click");
                }
            }
        }
    }
}

