/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.Join;
import com.sas.query.models.JoinList;
import com.sas.query.models.JoinRelationshipList;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.ImageHandler;
import com.sas.query.visuals.PopMenuItem;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.StandardView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;

public class JoinTreeView
extends StandardView {
    protected transient JoinList m_joinList;
    protected transient JoinRelationshipList m_joinRelationshipList;
    protected static transient ImageIcon m_dataSourceImage;
    protected transient boolean m_bReadyToDrag = false;
    protected transient boolean m_bDragging = false;
    protected transient boolean m_bControlKeyPressed = false;
    protected transient boolean m_processingNodeAction = false;
    protected transient Cursor m_previousCursor = null;
    protected transient Point m_dragPoint = new Point(-1, -1);
    protected transient Vector m_dropRegions;
    protected transient Rectangle m_dragOrigin;
    protected transient Point m_realDragOrigin;
    protected transient JScrollPane m_scrollPane = null;
    private transient int m_nodeHitLocation;
    static final int NO_AUTO_SCROLL = 0;
    static final int AUTO_SCROLL_LEFT = 1;
    static final int AUTO_SCROLL_RIGHT = 2;
    static final int AUTO_SCROLL_UP = 4;
    static final int AUTO_SCROLL_DOWN = 8;
    private transient AutoScrollTimerThread m_autoScrollThread = null;
    private transient JPopupMenu popup = null;
    public static final String selectedPropertyChange = "selected";
    public static final String joinPropertyChange = "joins";
    private static final int NOT_ON_A_BOX = -1;
    private static final int ON_BOX = 2;
    protected transient JoinBox m_selectedJoinBox;
    protected transient JoinBox.JoinTile m_selectedJoinTile;
    protected transient Vector m_joinBoxList = new Vector();
    protected static QueryResource bundle;
    protected Dimension m_preferredSize = new Dimension(160, 340);
    protected ImageIcon m_datasetIcon = ImageHandler.getImageIcon(bundle, "dataSetIcon");
    protected static int BOX_RAISED;
    protected static int BOX_NORMAL;
    protected static int BOX_LOWERED;

    public JoinTreeView(Query query, JoinList joinList, JoinRelationshipList joinRelationshipList, JScrollPane scrollPane) {
        super(query);
        this._initialize();
        this.m_joinList = joinList;
        this.m_joinRelationshipList = joinRelationshipList;
        query.addPropertyListener(this, 16, 4);
        this.m_scrollPane = scrollPane;
        if (this.m_scrollPane != null) {
            this.addPropertyChangeListener(new ScrollListener());
        }
        this.layoutWidgets();
        this.setSelectedJoin(null);
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener(this);
    }

    protected void _initialize() {
        this.setBackground(new Color(128, 128, 128));
        this.enableEvents(60L);
        if (m_dataSourceImage == null) {
            m_dataSourceImage = ImageHandler.getImageIcon(bundle, "dataSourceIcon");
        }
    }

    public void setJoinLists(JoinList joinList, JoinRelationshipList joinRelationshipList) {
        this.m_joinList = joinList;
        this.m_joinRelationshipList = joinRelationshipList;
        JoinBox.JoinTile selectedJoinTile = this.getSelectedJoinTile();
        Join selectedJoin = null;
        if (selectedJoinTile != null) {
            selectedJoin = selectedJoinTile.getJoin();
        }
        this.refresh();
        this.setSelectedJoin(null);
        if (selectedJoin != null) {
            for (int index = 0; index < this.m_joinBoxList.size(); ++index) {
                JoinBox box = (JoinBox)this.m_joinBoxList.elementAt(index);
                if (box.getJoin().getTable() == selectedJoin.getTable()) {
                    this.setSelectedJoinBox(box, box.getJoinTile());
                    break;
                }
                if (box.getSecondJoin() == null || box.getSecondJoin().getTable() != selectedJoin.getTable()) continue;
                this.setSelectedJoinBox(box, box.getSecondJoinTile());
                break;
            }
        }
        this.update();
        this.repaint();
    }

    @Override
    public Query getQuery() {
        return this.m_query;
    }

    protected void layoutWidgets() {
        JoinBox previousBox = null;
        this.removeAll();
        for (int index = 0; this.m_joinList != null && index < this.m_joinList.size(); ++index) {
            JoinBox newBox;
            Join join = this.m_joinList.elementAt(index);
            boolean nextJoinIsNewGroup = false;
            if (index + 1 < this.m_joinList.size() && this.m_joinList.elementAt(index + 1).getNewJoinGroupValue()) {
                nextJoinIsNewGroup = true;
            }
            if (join.getNewJoinGroupValue()) {
                if (nextJoinIsNewGroup || index + 1 == this.m_joinList.size()) {
                    newBox = new JoinBox(join);
                } else {
                    newBox = new JoinBox(this.m_joinList.elementAt(index + 1), join);
                    ++index;
                }
                this.m_joinBoxList.addElement(newBox);
                this.add(newBox);
            } else {
                newBox = new JoinBox(join);
                this.m_joinBoxList.addElement(newBox);
                if (previousBox == null) {
                    this.add(newBox);
                } else {
                    this.add(newBox);
                    newBox.add(previousBox);
                }
            }
            previousBox = newBox;
        }
    }

    public void onAction() {
        JoinBox box = this.getSelectedJoinBox();
        if (box != null) {
            // empty if block
        }
    }

    public JoinBox getRoot() {
        return null;
    }

    public JoinBox.JoinTile getSelectedJoinTile() {
        return this.m_selectedJoinTile;
    }

    public JoinBox getSelectedJoinBox() {
        return this.m_selectedJoinBox;
    }

    protected int getTargetIndex(Point pnt) {
        int targetIndex = this.m_dropRegions.size();
        for (int index = 0; index < this.m_dropRegions.size(); ++index) {
            JoinBox region = (JoinBox)this.m_dropRegions.elementAt(index);
            Point adjustment = this.getAdjustment(region, this.m_dragPoint, this.m_dropRegions, index);
            Point adjustedDragPoint = new Point(pnt.x + adjustment.x, pnt.y + adjustment.y);
            if (!region.contains(adjustedDragPoint)) continue;
            targetIndex = index;
            break;
        }
        return targetIndex;
    }

    protected int getSelectedIndex() {
        int selIndex = -1;
        if (this.m_dropRegions != null) {
            for (int index = 0; index < this.m_dropRegions.size(); ++index) {
                JoinBox region = (JoinBox)this.m_dropRegions.elementAt(index);
                if (!region.getJoin().equals(this.m_selectedJoinTile.getJoin())) continue;
                selIndex = index;
                break;
            }
        }
        return selIndex;
    }

    public void setSelectedJoin(Join join) {
        block3: {
            block2: {
                if (join != null) break block2;
                if (this.m_joinList == null || this.m_joinList.size() <= 0) break block3;
                this.setSelectedJoin(this.m_joinList.elementAt(this.m_joinList.size() - 1));
                break block3;
            }
            for (int index = 0; index < this.m_joinBoxList.size(); ++index) {
                JoinBox box = (JoinBox)this.m_joinBoxList.elementAt(index);
                if (box.getJoin() == join) {
                    this.setSelectedJoinBox(box, box.getJoinTile());
                    break;
                }
                if (box.getSecondJoin() != join) continue;
                this.setSelectedJoinBox(box, box.getSecondJoinTile());
                break;
            }
        }
    }

    public synchronized void setSelectedJoinBox(JoinBox joinBox, JoinBox.JoinTile joinTile) {
        if (this.m_selectedJoinBox == joinBox && this.m_selectedJoinTile == joinTile) {
            return;
        }
        Join oldSelected = null;
        if (this.m_selectedJoinBox != null) {
            oldSelected = this.m_selectedJoinBox.getJoin();
            this.m_selectedJoinBox.setUnselected();
        }
        this.m_selectedJoinBox = joinBox;
        this.m_selectedJoinTile = joinTile;
        Join newSelected = null;
        if (this.m_selectedJoinBox != null) {
            newSelected = this.m_selectedJoinBox.getJoin();
            this.m_selectedJoinBox.setSelected();
        }
        this.firePropertyChange(selectedPropertyChange, oldSelected, newSelected);
    }

    public Object[] getSelectedObjects() {
        if (this.getSelectedJoinBox() == null) {
            return null;
        }
        Object[] obj = new Object[]{this.getSelectedJoinBox()};
        return obj;
    }

    protected int joinNestedDepth(JoinBox box) {
        Join join = box.getJoin();
        int retval = -1;
        while (!join.getNewJoinGroupValue()) {
            ++retval;
            int myindex = this.m_joinList.indexOf(join);
            join = this.m_joinList.elementAt(myindex - 1);
        }
        return retval;
    }

    protected int joinNestingDepth(JoinBox box) {
        Join join = box.getJoin();
        int retval = 0;
        while (join != null && !join.getNewJoinGroupValue()) {
            ++retval;
            int myindex = this.m_joinList.indexOf(join);
            if (myindex == this.m_joinList.size() - 1) {
                join = null;
                continue;
            }
            join = this.m_joinList.elementAt(myindex + 1);
        }
        return retval - 1;
    }

    protected Point getAdjustment(JoinBox box, Point local, Vector list, int index) {
        Point ret;
        int depth = this.joinNestedDepth(box);
        int myOwndepth = this.joinNestingDepth(box);
        if (myOwndepth == 0) {
            ret = new Point(0, 0);
        } else {
            Point treeLoc = this.getLocationOnScreen();
            Point myLoc = box.getLocationOnScreen();
            int deltax = myLoc.x - treeLoc.x;
            int deltay = myLoc.y - treeLoc.y;
            ret = new Point(deltax -= 2 * --depth, deltay -= 2 * depth);
        }
        return ret;
    }

    protected Point getSizeAdjustment(JoinBox box, Point local, Vector list, int index) {
        int depth = this.joinNestingDepth(box);
        Point ret = new Point(-depth * 5, -depth * 5);
        return ret;
    }

    @Override
    public void processFocusEvent(FocusEvent event) {
        switch (event.getID()) {
            case 1004: {
                this.focusGained(event);
                break;
            }
            case 1005: {
                this._cancelCurrentAction();
                this.focusLost(event);
                break;
            }
        }
    }

    protected void _cancelCurrentAction() {
        this.m_dropRegions = null;
        this.m_bReadyToDrag = false;
        this.m_bDragging = false;
        this.m_bControlKeyPressed = false;
        this.busyOff();
        if (this.m_autoScrollThread != null) {
            this.m_autoScrollThread.stop();
            this.m_autoScrollThread = null;
        }
        this.repaint();
    }

    @Override
    public void processKeyEvent(KeyEvent event) {
        if (event.getID() == 402 && event.getKeyCode() == 17 && this.m_bControlKeyPressed) {
            this.m_bControlKeyPressed = false;
            this.repaint();
        }
        if (event.getID() != 401) {
            return;
        }
        JoinBox node = this.getSelectedJoinBox();
        if (node == null) {
            return;
        }
        switch (event.getKeyCode()) {
            case 17: {
                if (this.m_bControlKeyPressed) break;
                this.m_bControlKeyPressed = true;
                this.repaint();
                break;
            }
            case 27: {
                this._cancelCurrentAction();
                break;
            }
            case 127: {
                if (!this.ensureNodeIsSelected()) break;
                this.onDelete();
                this.makeNodeVisible(this.getSelectedJoinBox());
                break;
            }
            case 40: {
                if (!this.ensureNodeIsSelected() || event.isControlDown()) break;
                this._selectNextOrItem();
                break;
            }
            case 38: {
                if (!this.ensureNodeIsSelected() || event.isControlDown()) break;
                this.moveUp();
                break;
            }
            case 37: {
                if (!this.ensureNodeIsSelected()) break;
                this.moveLeft();
                break;
            }
            case 39: {
                if (!this.ensureNodeIsSelected() || event.isControlDown()) break;
                this._selectNextAndItem();
                break;
            }
            case 10: {
                this.onAction();
                break;
            }
            case 34: {
                if (!this.ensureNodeIsSelected()) break;
                this.pageDown();
                break;
            }
            case 33: {
                if (!this.ensureNodeIsSelected()) break;
                this.pageUp();
                break;
            }
            case 36: {
                if (this.m_scrollPane != null) {
                    this.m_scrollPane.getHorizontalScrollBar().setValue(0);
                    this.m_scrollPane.getVerticalScrollBar().setValue(0);
                }
                this.setSelectedJoinBox(this.getRoot(), this.getRoot().getTopJoinTile());
                this.makeNodeVisible(this.getSelectedJoinBox());
                break;
            }
            case 35: {
                if (this.ensureNodeIsSelected()) break;
                break;
            }
        }
        super.processKeyEvent(event);
    }

    protected void _dropNode(MouseEvent event) {
        if (this.m_bDragging && this.m_selectedJoinTile != null) {
            int selectedIndex = this.getSelectedIndex();
            JoinBox.JoinTile atile = this.getSelectedJoinTile();
            Rectangle arect = atile.getBounds();
            Point eventPoint = event.getPoint();
            Point adjustedPoint = new Point(eventPoint.x + arect.x, eventPoint.y + arect.y);
            int targetIndex = this.getTargetIndex(adjustedPoint);
            int rowShift = targetIndex - selectedIndex;
            if (rowShift > 0) {
                for (int i = 1; i < rowShift; ++i) {
                    this.m_joinList.moveJoinDown(this.m_selectedJoinTile.getJoin(), this.m_joinRelationshipList);
                }
            } else if (rowShift < 0) {
                for (int i = 0; i > rowShift; --i) {
                    this.m_joinList.moveJoinUp(this.m_selectedJoinTile.getJoin(), this.m_joinRelationshipList);
                }
            }
        }
        this.removeAll();
        this.refresh();
        this.update();
        this.m_dropRegions = null;
        this.m_bDragging = false;
        this.repaint();
        this.firePropertyChange(joinPropertyChange, null, this.m_joinList);
    }

    protected void displayPopmenu(MouseEvent event) {
        JPopupMenu popmenu = null;
        if (this.m_nodeHitLocation == 2) {
            popmenu = new JPopupMenu();
            popmenu.add(new PopMenuItem(bundle.getString("Common.Edit....txt"), "onEdit", this));
            popmenu.add(new PopMenuItem(bundle.getString("Common.Delete.txt"), "onDelete", this));
        }
        if (popmenu != null) {
            JComponent source = (JComponent)event.getSource();
            source.add(popmenu);
            popmenu.show(source, event.getX(), event.getY());
        }
    }

    public void onEdit() {
    }

    public void onDelete() {
        if (!this.ensureNodeIsSelected()) {
            return;
        }
        JoinBox box = this.removeNode(this.getSelectedJoinBox());
        JoinBox.JoinTile joinTile = box != null ? box.getTopJoinTile() : null;
        this.setSelectedJoinBox(box, joinTile);
        this.update();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent event) {
        int id = event.getID();
        if (id == 506) {
            if (this.m_bReadyToDrag) {
                Point p = event.getPoint();
                if (Math.abs(this.m_dragPoint.x - p.x) > 2 || Math.abs(this.m_dragPoint.y - p.y) > 2) {
                    this.m_bDragging = true;
                    this.m_bReadyToDrag = false;
                    this.m_dragOrigin = this.m_selectedJoinTile.getBounds();
                    Point adjustment = this.getAdjustment(this.m_selectedJoinBox, new Point(0, 0), this.m_joinBoxList, this.m_joinBoxList.indexOf(this.m_selectedJoinBox.getJoin()));
                    this.m_dragOrigin.translate(-adjustment.x, -adjustment.y);
                    try {
                        this.m_dropRegions = (Vector)this.m_joinBoxList.clone();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.m_bDragging && this.m_scrollPane != null) {
                this.m_dragPoint = event.getPoint();
                int scrollType = 0;
                Point shouldScrollPoint = event.getPoint();
                shouldScrollPoint.translate(-this.m_scrollPane.getHorizontalScrollBar().getValue(), -this.m_scrollPane.getVerticalScrollBar().getValue());
                if (shouldScrollPoint.x < 2) {
                    scrollType |= 1;
                }
                if (shouldScrollPoint.y < 2) {
                    scrollType |= 4;
                }
                Dimension viewPortSize = this.m_scrollPane.getViewport().getSize();
                if (shouldScrollPoint.x > viewPortSize.width - 2) {
                    scrollType |= 2;
                }
                if (shouldScrollPoint.y > viewPortSize.height - 2) {
                    scrollType |= 8;
                }
                if (scrollType != 0) {
                    if (this.m_autoScrollThread == null) {
                        this.m_autoScrollThread = new AutoScrollTimerThread(scrollType);
                        this.m_autoScrollThread.start();
                    } else {
                        this.m_autoScrollThread.setScrollType(scrollType);
                    }
                } else if (scrollType == 0 && this.m_autoScrollThread != null) {
                    this.m_autoScrollThread.stop();
                    this.m_autoScrollThread = null;
                }
                this.repaint();
            } else if (this.m_bDragging) {
                this.m_dragPoint = event.getPoint();
                this.repaint();
            }
        } else if (id == 503) {
            this.m_dragPoint = event.getPoint();
        }
    }

    protected void refresh() {
        JoinBox.JoinTile selectedJoinTile = this.getSelectedJoinTile();
        Join selectedJoin = null;
        if (selectedJoinTile != null) {
            selectedJoin = selectedJoinTile.getJoin();
        }
        this.m_joinBoxList.removeAllElements();
        this.layoutWidgets();
        for (int index = 0; index < this.m_joinBoxList.size(); ++index) {
            JoinBox box = (JoinBox)this.m_joinBoxList.elementAt(index);
            if (box.getJoin() == selectedJoin) {
                this.setSelectedJoinBox(box, box.getJoinTile());
                break;
            }
            if (box.getSecondJoin() != selectedJoin) continue;
            this.setSelectedJoinBox(box, box.getSecondJoinTile());
            break;
        }
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        if (event.isStructureChange()) {
            JoinBox selectedNode;
            this.refresh();
            if (event.didThisStructureTypeChange(1) && (selectedNode = this.getSelectedJoinBox()) != null) {
                this.makeNodeVisible(selectedNode);
            }
        }
        this.update();
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.m_dropRegions != null && this.m_bDragging) {
            Point adjustment;
            int tileHeight;
            Rectangle targetRect;
            int selectedIndex = this.getSelectedIndex();
            JoinBox.JoinTile atile = this.getSelectedJoinTile();
            Rectangle arect = atile.getBounds();
            Point test = new Point(this.m_dragPoint.x + arect.x, this.m_dragPoint.y + arect.y);
            int targetIndex = this.getTargetIndex(test);
            int deltatiles = targetIndex - selectedIndex;
            if (targetIndex < this.m_joinBoxList.size()) {
                JoinBox targetBox = (JoinBox)this.m_joinBoxList.elementAt(targetIndex);
                targetRect = targetBox.getBounds();
                tileHeight = targetBox.getJoinTile().getSize().height;
                adjustment = this.getAdjustment(targetBox, new Point(0, 0), this.m_joinBoxList, targetIndex);
            } else {
                JoinBox lastBox = (JoinBox)this.m_joinBoxList.elementAt(this.m_joinBoxList.size() - 1);
                targetRect = lastBox.getBounds();
                adjustment = this.getAdjustment(lastBox, new Point(0, 0), this.m_joinBoxList, this.m_joinBoxList.size() - 1);
                tileHeight = lastBox.getJoinTile().getSize().height;
                targetRect.y += targetRect.height;
                targetRect.width += 10;
                adjustment = new Point(0, 0);
                targetRect.height = 0;
            }
            boolean bDropCausesTileToMove = true;
            if (deltatiles == 1 || deltatiles == 0) {
                bDropCausesTileToMove = false;
            } else if (deltatiles < 1) {
                if (targetIndex == 0) {
                    targetRect.width += 10;
                }
                this._drawDropPosition(g, targetRect.x + adjustment.x + 20, targetRect.y + targetRect.height + adjustment.y - (tileHeight + 20), this.getWidth(), targetRect.y + targetRect.height + adjustment.y - (tileHeight + 20));
            } else if (targetRect.height == 0) {
                this._drawDropPosition(g, targetRect.x, targetRect.y, this.getWidth(), targetRect.y);
            } else {
                this._drawDropPosition(g, targetRect.x + adjustment.x + 20, targetRect.y + targetRect.height + adjustment.y - (tileHeight + 20), this.getWidth(), targetRect.y + targetRect.height + adjustment.y - (tileHeight + 20));
            }
            JoinBox.JoinTile tile = this.getSelectedJoinTile();
            Rectangle rect = tile.getBounds();
            rect.x = this.m_dragPoint.x - (adjustment.x - rect.x);
            rect.y = this.m_dragPoint.y - (adjustment.y - rect.y);
            DrawUtil.draw3DBox(g, this.getParent().getBackground(), Color.white, Color.darkGray, rect.x, rect.y, rect.width - 1, rect.height - 1);
            if (bDropCausesTileToMove) {
                DrawUtil.draw3DBox(g, Color.blue, Color.white, Color.white, rect.x + 3, rect.y + 3, rect.width - 7, rect.height - 7);
            } else {
                DrawUtil.draw3DBox(g, this.getBackground(), Color.white, Color.white, rect.x + 3, rect.y + 3, rect.width - 7, rect.height - 7);
            }
            g.drawString(tile.m_label.getText(), rect.x + 7, rect.y + rect.height - 7);
        }
    }

    protected void _drawDropPosition(Graphics g, int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, 10);
        DrawUtil.draw3DBox(g, this.getParent().getBackground(), Color.white, Color.darkGray, 0, rect.y, rect.width - 1, rect.height - 1);
        DrawUtil.draw3DBox(g, this.getBackground(), Color.blue, Color.white, 3, rect.y + 3, rect.width - 7, rect.height - 7);
    }

    public void repositionNodes() {
        if (this.getRoot() != null) {
            // empty if block
        }
    }

    public JoinBox removeNode(JoinBox nodeToRemove) {
        this.firePropertyChanges();
        return null;
    }

    public void update() {
        this.repositionNodes();
        if (this.isShowing()) {
            this.resizeForNodes();
            this.repaint();
        }
    }

    public boolean isProcessingNodeAction() {
        return this.m_processingNodeAction;
    }

    public void startProcessingNodeAction() {
        this.m_processingNodeAction = true;
        this.busyOn();
    }

    public void endProcessingNodeAction() {
        this.busyOff();
        this.m_previousCursor = null;
        this.m_processingNodeAction = false;
    }

    private boolean ensureNodeIsSelected() {
        return false;
    }

    private void focusGained(FocusEvent event) {
        this.repaint();
    }

    private void focusLost(FocusEvent event) {
        this.repaint();
    }

    protected void moveLeft() {
    }

    protected void moveUp() {
    }

    private synchronized void pageDown() {
        if (this.m_scrollPane != null) {
            int position = this.m_scrollPane.getVerticalScrollBar().getValue();
            Dimension viewPortSize = this.m_scrollPane.getViewport().getSize();
            this.m_scrollPane.getVerticalScrollBar().setValue(position + viewPortSize.height);
        }
    }

    private synchronized void pageUp() {
        if (this.m_scrollPane != null) {
            int position = this.m_scrollPane.getVerticalScrollBar().getValue();
            Dimension viewPortSize = this.m_scrollPane.getViewport().getSize();
            this.m_scrollPane.getVerticalScrollBar().setValue(position - viewPortSize.height);
        }
    }

    private void makeNodeVisible(JoinBox joinBox) {
        boolean fPositionChanged = false;
        if (joinBox == null) {
            return;
        }
        this.resizeForNodes();
        this.m_scrollPane.validate();
        if (joinBox.getX() > 0 && this.m_scrollPane != null) {
            int scrollX = this.m_scrollPane.getHorizontalScrollBar().getValue();
            int scrollY = this.m_scrollPane.getVerticalScrollBar().getValue();
            Dimension viewPortSize = this.m_scrollPane.getViewport().getSize();
            int change = scrollX + viewPortSize.width - (joinBox.getX() + joinBox.getWidth() + 20);
            if (change < 0) {
                this.m_scrollPane.getHorizontalScrollBar().setValue(scrollX - change);
                fPositionChanged = true;
            } else {
                change = scrollX - joinBox.getX() + 20;
                if (change > 0) {
                    this.m_scrollPane.getHorizontalScrollBar().setValue(scrollX - change);
                    fPositionChanged = true;
                }
            }
            change = scrollY + viewPortSize.height - (joinBox.getY() + joinBox.getHeight() + 20);
            if (change < 0) {
                this.m_scrollPane.getVerticalScrollBar().setValue(scrollY - change);
                fPositionChanged = true;
            } else {
                change = scrollY - joinBox.getY() + 20;
                if (change > 0) {
                    this.m_scrollPane.getVerticalScrollBar().setValue(scrollY - change);
                    fPositionChanged = true;
                }
            }
        }
        if (fPositionChanged) {
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_preferredSize;
    }

    @Override
    public void setSize(Dimension d) {
        if (d.width > this.m_preferredSize.width) {
            this.m_preferredSize.width = d.width;
        }
        if (d.height > this.m_preferredSize.height) {
            this.m_preferredSize.height = d.height;
        }
        super.setSize(d);
    }

    private void resizeForNodes() {
        if (this.m_scrollPane != null) {
            Dimension newSize;
            int maxWidth = 0;
            int maxHeight = 0;
            for (int index = 0; index < this.m_joinBoxList.size(); ++index) {
                JoinBox node = (JoinBox)this.m_joinBoxList.elementAt(index);
                Rectangle bounds = node.getBounds();
                if (bounds.x + bounds.width > maxWidth) {
                    maxWidth = bounds.x + bounds.width;
                }
                if (bounds.y + bounds.height <= maxHeight) continue;
                maxHeight = bounds.y + bounds.height;
            }
            this.m_preferredSize = newSize = new Dimension(maxWidth + 60, maxHeight + 20);
            this.revalidate();
        }
    }

    private void _selectNextOrItem() {
        JoinBox selectedView = this.getSelectedJoinBox();
        if (selectedView == null) {
            return;
        }
    }

    private void _selectNextAndItem() {
        JoinBox selectedView = this.getSelectedJoinBox();
        if (selectedView == null) {
            return;
        }
    }

    static {
        bundle = new QueryResource(JoinTreeView.class);
        BOX_RAISED = 1;
        BOX_NORMAL = 2;
        BOX_LOWERED = 3;
    }

    class JoinBox
    extends JPanel {
        protected Join m_join;
        protected Join m_secondJoin;
        protected JoinTile m_joinTile;
        protected JoinTile m_secondJoinTile;

        public JoinBox(Join join) {
            this(join, null);
        }

        public JoinBox(Join join, Join secondJoin) {
            this.m_join = join;
            this.m_secondJoin = secondJoin;
            this.setLayout(new BorderLayout(3, 3));
            int lineWidth = 1;
            if (join.getJoinType() == 2 || join.getJoinType() == 1 || join.getJoinType() == 3) {
                lineWidth = 2;
            }
            Color lineColor = Color.black;
            if (join.getRelationships() == null || join.getRelationships().size() == 0) {
                lineColor = Color.red;
            }
            this.setBorder(BOX_NORMAL);
            this.setBackground(SystemColor.control);
            if (this.m_secondJoin != null) {
                this.m_secondJoinTile = new JoinTile(this.m_secondJoin);
                this.add("North", this.m_secondJoinTile);
            }
            this.m_joinTile = new JoinTile(join);
            this.add("South", this.m_joinTile);
        }

        public Join getJoin() {
            return this.m_join;
        }

        public Join getSecondJoin() {
            return this.m_secondJoin;
        }

        public JoinTile getJoinTile() {
            return this.m_joinTile;
        }

        public JoinTile getSecondJoinTile() {
            return this.m_secondJoinTile;
        }

        public JoinTile getTopJoinTile() {
            if (this.m_secondJoinTile != null) {
                return this.m_secondJoinTile;
            }
            return this.m_joinTile;
        }

        public void setSelected() {
            this.setBorder(BOX_RAISED);
            JoinBox child = this.getChildBox();
            if (child != null) {
                child.setBorder(BOX_LOWERED);
            }
            this.setBackground(new Color(211, 211, 211));
        }

        public void setUnselected() {
            this.setBorder(BOX_NORMAL);
            JoinBox child = this.getChildBox();
            if (child != null) {
                child.setBorder(BOX_NORMAL);
            }
            this.setBackground(Color.lightGray);
        }

        public void setBorder(int borderType) {
            if (borderType == BOX_RAISED) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            } else if (borderType == BOX_LOWERED) {
                CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5));
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), border));
            } else {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            }
        }

        protected JoinBox getChildBox() {
            JoinBox child = null;
            try {
                child = (JoinBox)this.getComponent(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return child;
        }

        class JoinTile
        extends JPanel {
            protected Join m_join;
            protected boolean m_selected = false;
            protected JLabel m_label;
            protected JLabel m_iconLabel;
            protected Color m_greenColor = new Color(102, 204, 153);

            public JoinTile(Join join) {
                this.m_join = join;
                this.setLayout(new BorderLayout());
                this.setBackground(Color.lightGray);
                this.m_label = new JLabel(join.getTable().getDisplayName());
                this.m_label.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                this.m_label.setBackground(this.m_greenColor);
                this.m_label.setOpaque(true);
                this.m_label.setForeground(Color.black);
                this.add(this.m_label);
                this.m_iconLabel = new JLabel(JoinTreeView.this.m_datasetIcon);
                this.m_iconLabel.setOpaque(true);
                this.m_iconLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                this.add("West", this.m_iconLabel);
                this.enableEvents(48L);
            }

            public Join getJoin() {
                return this.m_join;
            }

            public void setSelected(boolean flag) {
                this.m_selected = flag;
                if (JoinTreeView.this.m_selectedJoinTile.getJoin() == this.m_join) {
                    this.m_label.setBackground(Color.white);
                } else {
                    this.m_label.setBackground(this.m_greenColor);
                }
            }

            @Override
            public void paint(Graphics g) {
                if (JoinTreeView.this.m_selectedJoinTile != null && JoinTreeView.this.m_selectedJoinTile.getJoin() == this.m_join) {
                    this.m_label.setBackground(Color.white);
                    this.m_iconLabel.setBackground(Color.white);
                } else {
                    this.m_label.setBackground(this.m_greenColor);
                    this.m_iconLabel.setBackground(this.m_greenColor);
                }
                super.paint(g);
            }

            @Override
            public void paintComponent(Graphics g) {
                Rectangle rect = this.getBounds();
                DrawUtil.draw3DBox(g, this.getParent().getBackground(), Color.white, Color.darkGray, 0, 0, rect.width - 1, rect.height - 1);
                DrawUtil.draw3DBox(g, this.getBackground(), Color.darkGray, Color.white, 3, 3, rect.width - 7, rect.height - 7);
            }

            @Override
            protected void processMouseEvent(MouseEvent event) {
                int id = event.getID();
                int modifiers = event.getModifiers();
                MouseEvent newevent = new MouseEvent(JoinTreeView.this, event.getID(), event.getWhen(), id, event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger());
                if (id == 501) {
                    Point point = newevent.getPoint();
                    JoinTreeView.this.m_bReadyToDrag = true;
                    JoinTreeView.this.m_dragPoint = newevent.getPoint();
                    Point adjustment = JoinTreeView.this.getAdjustment(JoinTreeView.this.m_selectedJoinBox, JoinTreeView.this.m_dragPoint, JoinTreeView.this.m_joinBoxList, JoinTreeView.this.m_joinBoxList.indexOf(JoinTreeView.this.m_selectedJoinBox.getJoin()));
                    JoinTreeView.this.m_dragPoint = new Point(JoinTreeView.this.m_dragPoint.x + adjustment.x, JoinTreeView.this.m_dragPoint.y + adjustment.y);
                    Join selectedJoin = this.getJoin();
                    if (JoinBox.this.getSecondJoin() != null && point.y < this.getHeight() / 2) {
                        selectedJoin = JoinBox.this.getSecondJoin();
                    }
                    JoinTreeView.this.setSelectedJoinBox(JoinBox.this, this);
                } else if (id == 502) {
                    if (JoinTreeView.this.m_bDragging) {
                        JoinTreeView.this._dropNode(newevent);
                    } else if ((modifiers & 4) != 0) {
                        JoinTreeView.this.displayPopmenu(newevent);
                    }
                    JoinTreeView.this.m_bReadyToDrag = false;
                    JoinTreeView.this.m_dropRegions = null;
                    if (JoinTreeView.this.m_autoScrollThread != null) {
                        JoinTreeView.this.m_autoScrollThread.stop();
                        JoinTreeView.this.m_autoScrollThread = null;
                    }
                }
                super.processMouseEvent(newevent);
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent event) {
                MouseEvent newevent = new MouseEvent(JoinTreeView.this, event.getID(), event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger());
                JoinTreeView.this.processMouseMotionEvent(newevent);
            }
        }
    }

    public class AutoScrollTimerThread
    extends Thread {
        long m_delay = 40L;
        int m_type;

        AutoScrollTimerThread(int type) {
            this.m_type = type;
        }

        public void setScrollType(int type) {
            this.m_type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    AutoScrollTimerThread.sleep(this.m_delay);
                }
                catch (InterruptedException e) {
                    break;
                }
                JoinTreeView joinTreeView = JoinTreeView.this;
                synchronized (joinTreeView) {
                    int newX = JoinTreeView.this.m_scrollPane.getHorizontalScrollBar().getValue();
                    int newY = JoinTreeView.this.m_scrollPane.getVerticalScrollBar().getValue();
                    if ((this.m_type & 1) == 1) {
                        newX -= 10;
                    }
                    if ((this.m_type & 2) == 2) {
                        newX += 10;
                    }
                    if ((this.m_type & 4) == 4) {
                        newY -= 10;
                    }
                    if ((this.m_type & 8) == 8) {
                        newY += 10;
                    }
                    JoinTreeView.this.m_scrollPane.getHorizontalScrollBar().setValue(newX);
                    JoinTreeView.this.m_scrollPane.getVerticalScrollBar().setValue(newY);
                }
            }
        }
    }

    public class ScrollListener
    implements PropertyChangeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JoinTreeView joinTreeView = JoinTreeView.this;
            synchronized (joinTreeView) {
                if (e.getPropertyName().equals("verticalPosition")) {
                    int delta = (Integer)e.getNewValue() - (Integer)e.getOldValue();
                    if (JoinTreeView.this.m_bReadyToDrag) {
                        JoinTreeView.this.m_dragPoint.y -= delta;
                    }
                } else if (e.getPropertyName().equals("horizontalPosition")) {
                    int delta2 = (Integer)e.getNewValue() - (Integer)e.getOldValue();
                    if (JoinTreeView.this.m_bReadyToDrag) {
                        JoinTreeView.this.m_dragPoint.x -= delta2;
                    }
                }
            }
        }
    }
}

