/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.ColumnStar;
import com.sas.query.models.Expression;
import com.sas.query.models.ResultItem;
import com.sas.query.models.Table;
import com.sas.query.visuals.ImageHandler;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.WindowUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class JTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    protected static Font defaultFont;
    protected static ImageIcon m_dataSourceIcon;
    protected static ImageIcon m_catalogIcon;
    protected static ImageIcon m_catalogOpenedIcon;
    protected static ImageIcon m_folderIcon;
    protected static ImageIcon m_folderOpenedIcon;
    protected static ImageIcon m_dataSetIcon;
    protected static ImageIcon m_viewIcon;
    protected static ImageIcon m_columnIcon;
    protected boolean m_enableTables = true;
    protected boolean m_enableViews = true;

    public JTreeCellRenderer(JTree source, QueryResource bundle) {
        if (m_dataSourceIcon == null) {
            m_dataSourceIcon = ImageHandler.getImageIcon(bundle, "SASSystemIcon");
            m_catalogIcon = ImageHandler.getImageIcon(bundle, "CatalogIcon");
            m_catalogOpenedIcon = ImageHandler.getImageIcon(bundle, "CatalogExpandedIcon");
            m_folderIcon = ImageHandler.getImageIcon(bundle, "FolderIcon");
            m_folderOpenedIcon = ImageHandler.getImageIcon(bundle, "FolderOpenIcon");
            m_dataSetIcon = ImageHandler.getImageIcon(bundle, "DataSetIcon");
            m_viewIcon = ImageHandler.getImageIcon(bundle, "ViewIcon");
            m_columnIcon = ImageHandler.getImageIcon(bundle, "ColumnIcon");
        }
        if (m_dataSourceIcon == null) {
            source.setRowHeight(16);
        } else {
            source.setRowHeight(Math.max(16, m_dataSourceIcon.getIconHeight() + 2));
        }
    }

    public void enableTables(boolean flag) {
        this.m_enableTables = flag;
    }

    public void enableViews(boolean flag) {
        this.m_enableViews = flag;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Expression expression;
        String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        this.setText(stringValue);
        this.setIcon(null);
        String tipText = null;
        if (value instanceof DataSourceColumn) {
            tipText = ((DataSourceColumn)value).getQualifiedName();
        } else if (value instanceof Column) {
            String text = ((Column)value).getLabel();
            if (text == null || text.length() == 0) {
                text = ((Column)value).toString();
            }
            tipText = text;
        } else if (value instanceof DataSourceTable) {
            tipText = ((DataSourceTable)value).getQualifiedName();
        } else if (value instanceof Table) {
            tipText = ((Table)value).toString();
        } else if (value instanceof DataSource) {
            tipText = ((DataSource)value).getDescription();
        } else if (value instanceof DataSourceContainer) {
            tipText = ((DataSourceContainer)value).getQualifiedName();
        } else if (value instanceof ResultItem) {
            ResultItem temp = (ResultItem)value;
            if (temp.getLabel() != null && temp.getLabel().length() > 0) {
                tipText = temp.getLabel();
            } else {
                tipText = temp.getExpression().toString();
                if (temp.getExpression() instanceof ColumnExpression) {
                    ColumnExpression ce = (ColumnExpression)temp.getExpression();
                    tipText = ce.getColumn().getParent().toString() + "." + ce.getColumn().toString();
                }
            }
            int type = ((ResultItem)value).getExpression().getDataType();
            this.setIcon(WindowUtil.getDataTypeIcon(type));
        } else if (value instanceof String) {
            tipText = (String)value;
        }
        if (tipText != null && tipText.length() > 0 && !tipText.equals(stringValue)) {
            this.setToolTipText(tipText);
        } else {
            this.setToolTipText(null);
        }
        if (value instanceof DataSourceColumn) {
            int type = ((DataSourceColumn)value).getDataType();
            ImageIcon icon = WindowUtil.getDataTypeIcon(type);
            if (icon == null) {
                icon = m_columnIcon;
            }
            this.setIcon(icon);
        } else if (value instanceof Column) {
            int type = ((Column)value).getDataType();
            ImageIcon icon = WindowUtil.getDataTypeIcon(type);
            if (icon == null) {
                icon = m_columnIcon;
            }
            this.setIcon(icon);
        } else if (value instanceof DataSourceTable) {
            if (((DataSourceTable)value).isView()) {
                this.setIcon(m_viewIcon);
            } else {
                this.setIcon(m_dataSetIcon);
            }
        } else if (value instanceof Table) {
            this.setIcon(m_dataSetIcon);
        } else if (value instanceof DataSource) {
            this.setIcon(m_dataSourceIcon);
        } else if (value instanceof String) {
            if (expanded) {
                this.setIcon(m_folderOpenedIcon);
            } else {
                this.setIcon(m_folderIcon);
            }
        } else if (value instanceof DataSourceContainer) {
            if (expanded) {
                this.setIcon(m_catalogOpenedIcon);
            } else {
                this.setIcon(m_catalogIcon);
            }
        }
        this.setFont(this.getFont());
        if (selected) {
            this.setForeground(SystemColor.textHighlightText);
        } else {
            this.setForeground(SystemColor.textText);
        }
        if ((value instanceof DataSourceColumn && ((DataSourceColumn)value).isIndexed() || value instanceof Column && ((Column)value).isIndexed()) && !selected) {
            this.setForeground(Color.blue);
        }
        this.setEnabled(true);
        if (value instanceof DataSourceTable) {
            if (((DataSourceTable)value).isView()) {
                this.setEnabled(this.m_enableViews);
            } else {
                this.setEnabled(this.m_enableTables);
            }
        } else if (value instanceof ResultItem && (expression = ((ResultItem)value).getExpression()) instanceof ColumnExpression && ((ColumnExpression)expression).getColumn() instanceof ColumnStar) {
            this.setEnabled(false);
        }
        this.selected = selected;
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Icon currentI = this.getIcon();
        if (currentI != null && this.getText() != null) {
            int offset = currentI.getIconWidth() + this.getIconTextGap();
            g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
        } else {
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(g);
    }
}

