/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.models.JDataSourceTree;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.Table;
import com.sas.query.visuals.JTreeCellRenderer;
import com.sas.query.visuals.PopMenuItem;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class JDataSourceTreeView
extends StandardView
implements TreeSelectionListener {
    public static final int DO_NOTHING = 0;
    public static final int ADD_RECORD_FILTER = 1;
    public static final int ADD_GROUP_FILTER = 2;
    public static final int ADD_RESULT_ITEM = 3;
    public static final int ADD_GROUP_ITEM = 4;
    public static final int ADD_ORDER_ITEM = 5;
    protected JTree m_tree;
    protected JDataSourceTree m_dataSourceTree = null;
    protected KeyAdapter m_keyAdapter = null;
    protected MouseListener m_mouseListener = null;
    protected int m_defaultAction = 0;
    protected boolean m_processingAction = false;
    protected static QueryResource bundle = new QueryResource(JDataSourceTreeView.class);

    public JDataSourceTreeView(Query query, JDataSourceTree dataSourceTree) {
        super(query);
        this.m_dataSourceTree = dataSourceTree;
        this.setLayout(new BorderLayout());
        this._initialize();
    }

    @Override
    public void closing() {
        if (this.m_mouseListener != null) {
            this.m_tree.removeMouseListener(this.m_mouseListener);
        }
        if (this.m_keyAdapter != null) {
            this.m_tree.removeKeyListener(this.m_keyAdapter);
        }
    }

    public void setDefaultAction(int defaultAction) {
        this.m_defaultAction = defaultAction;
    }

    public Object getSelectedObject() {
        TreePath path = this.m_tree.getSelectionPath();
        return path.getLastPathComponent();
    }

    public void enableTables(boolean flag) {
        ((JTreeCellRenderer)this.m_tree.getCellRenderer()).enableTables(flag);
    }

    public void enableViews(boolean flag) {
        ((JTreeCellRenderer)this.m_tree.getCellRenderer()).enableViews(flag);
    }

    protected void _initialize() {
        this.m_tree = new JTree(){

            @Override
            public void expandPath(TreePath path) {
                JDataSourceTreeView.this.busyOn();
                try {
                    super.expandPath(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JDataSourceTreeView.this.busyOff();
            }
        };
        this.m_tree.addTreeSelectionListener(this);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setCellRenderer(new JTreeCellRenderer(this.m_tree, bundle));
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        JScrollPane scrollPane = new JScrollPane(this.m_tree);
        WindowUtil.fixupJScrollPane(scrollPane);
        this.add(scrollPane);
        this.m_tree.setModel(this.m_dataSourceTree);
        this.m_mouseListener = new MouseInputAdapter(){
            int previouslySelectedRow = -1;
            MouseEvent previousMouseEvent = null;

            @Override
            public void mouseReleased(MouseEvent e) {
                long timeDiff;
                int selectedRow = JDataSourceTreeView.this.m_tree.getRowForLocation(e.getX(), e.getY());
                TreePath selectedPath = JDataSourceTreeView.this.m_tree.getPathForLocation(e.getX(), e.getY());
                int clickCount = e.getClickCount();
                if (this.previousMouseEvent != null && selectedRow == this.previouslySelectedRow && (timeDiff = e.getWhen() - this.previousMouseEvent.getWhen()) < 900L && clickCount < 2 && !e.isPopupTrigger()) {
                    if ((e.getModifiers() & 4) == 0) {
                        ++clickCount;
                    }
                }
                if (selectedRow != -1) {
                    this.previousMouseEvent = e;
                    this.previouslySelectedRow = selectedRow;
                }
                if (selectedRow != -1) {
                    if (clickCount == 2 && selectedPath.equals(JDataSourceTreeView.this.m_tree.getSelectionPath())) {
                        JDataSourceTreeView.this.onAction(selectedPath);
                        this.previousMouseEvent = null;
                        selectedRow = -1;
                    } else if ((e.getModifiers() & 4) != 0) {
                        JDataSourceTreeView.this.m_tree.setSelectionRow(selectedRow);
                        JDataSourceTreeView.this.displayPopmenu(e, selectedPath);
                    }
                }
            }
        };
        this.m_tree.addMouseListener(this.m_mouseListener);
        this.m_keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                TreePath selectedPath = JDataSourceTreeView.this.m_tree.getLeadSelectionPath();
                if (selectedPath != null && event.getKeyChar() == '\n') {
                    JDataSourceTreeView.this.onAction(selectedPath);
                }
            }
        };
        this.m_tree.addKeyListener(this.m_keyAdapter);
        this.setMinimumSize(new Dimension(0, 0));
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
    }

    public void onAction() {
        TreePath path = this.m_tree.getSelectionPath();
        this.onAction(path);
    }

    public void onAction(TreePath path) {
        if (this.m_processingAction) {
            return;
        }
        if (path == null) {
            return;
        }
        Object node = path.getLastPathComponent();
        if (node == null) {
            return;
        }
        if (node instanceof DataSourceTable) {
            DataSourceTable table = (DataSourceTable)node;
            this._performTableAction(table);
        }
        if (node instanceof DataSourceColumn) {
            DataSourceColumn column = (DataSourceColumn)node;
            this._performColumnAction(column);
        }
    }

    public void _performTableAction(DataSourceTable table) {
        this.busyOn();
        this.m_processingAction = true;
        try {
            if (table.getReadPassword() && !table.isPasswordSet()) {
                String password = JOptionPane.showInputDialog(this, bundle.messageString("JDataSourceTreeView.enterReadPasswordMsg.fmt.txt", table.getName()), bundle.getString("JDataSourceTreeView.passwordDialogTitle.txt"), 3);
                if (password != null) {
                    table.addPassword(password);
                    Table newTable = this.getQuery().addTable(table);
                    if (newTable == null) {
                        table.clearPassword();
                    }
                }
            } else {
                this.getQuery().addTable(table);
            }
            this.firePropertyChanges();
        }
        catch (Exception e) {
            this.m_query.getMessageHandler().addInternalError(bundle.messageString("Standard.Message.InternalError.fmt.txt", e));
        }
        this.m_processingAction = false;
        this.busyOff();
        this.displayMessages();
        if (this.failureHasOccurred()) {
            table.clearPassword();
            return;
        }
    }

    public void _performColumnAction(DataSourceColumn column) {
        this.busyOn();
        this.m_processingAction = true;
        this.m_processingAction = false;
        this.busyOff();
    }

    public void onRefreshDataSource(DataSource dataSource) {
        this.busyOn();
        dataSource.refresh();
        this.firePropertyChanges();
        this.displayMessages();
        this.busyOff();
    }

    public void onRefreshContainer(DataSourceContainer container) {
        this.busyOn();
        container.refresh();
        this.firePropertyChanges();
        this.displayMessages();
        this.busyOff();
    }

    protected void displayPopmenu(MouseEvent event, TreePath path) {
        Object node = path.getLastPathComponent();
        if (node == null) {
            return;
        }
        JPopupMenu popmenu = null;
        popmenu = new JPopupMenu();
        if (node instanceof DataSource) {
            DataSource dataSource = (DataSource)node;
            popmenu.add(new PopMenuItem(bundle.getString("Common.Refresh.txt"), "onRefreshDataSource", (Object)this, (Object)dataSource, DataSource.class));
        } else if (node instanceof DataSourceTable) {
            DataSourceTable table = (DataSourceTable)node;
            popmenu.add(new PopMenuItem(bundle.getString("Common.AddToQuery.txt"), "_performTableAction", (Object)this, (Object)table, DataSourceTable.class));
            popmenu.add(new PopMenuItem(bundle.getString("Common.Refresh.txt"), "onRefreshContainer", (Object)this, (Object)table, DataSourceContainer.class));
        } else if (node instanceof DataSourceContainer) {
            DataSourceContainer container = (DataSourceContainer)node;
            popmenu.add(new PopMenuItem(bundle.getString("Common.Refresh.txt"), "onRefreshContainer", (Object)this, (Object)container, DataSourceContainer.class));
        } else if (node instanceof DataSourceColumn) {
            DataSourceColumn column = (DataSourceColumn)node;
            popmenu.add(new PopMenuItem(bundle.getString("Common.AddToQuery.txt"), "_performColumnAction", (Object)this, (Object)column, DataSourceColumn.class));
        }
        if (popmenu.getSubElements().length != 0) {
            JComponent source = (JComponent)event.getSource();
            source.add(popmenu);
            popmenu.show(source, event.getX(), event.getY());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
    }
}

