/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.GroupItem;
import com.sas.query.models.GroupItemList;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.visuals.BarNoun;
import com.sas.query.visuals.BarView;
import java.awt.Color;

public class GroupItemBarView
extends BarView {
    public GroupItemBarView(Query query) {
        super(query, bundle.getString("GroupItemBarView.Title.txt"), new Color(0, 204, 255), Color.black);
        this.m_query.addPropertyListener(this, 64);
        this.refresh();
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener(this);
    }

    @Override
    public void refresh() {
        GroupItemList list = this.m_query.getGroupItems();
        this.removeAllParts();
        for (int index = 0; index < list.size(); ++index) {
            GroupItem item = list.elementAt(index);
            try {
                BarNoun noun = new BarNoun(item, item.getClass().getMethod("getDisplayString", null));
                this.addPart(noun);
                continue;
            }
            catch (Exception e) {
                this.addError("Error creating GroupItem BarNoun ");
                this.addError(e);
            }
        }
        super.refresh();
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this.refresh();
    }

    @Override
    public boolean hasEditor() {
        return false;
    }

    @Override
    public void onEditBar() {
    }

    @Override
    public void onEdit() {
    }

    @Override
    public void onInsert() {
    }

    @Override
    public void onDelete() {
        GroupItem item = (GroupItem)this.getSelectedPart().getData();
        this.m_query.deleteGroupItem(item);
        super.onDelete();
        this.displayMessages();
        this.firePropertyChanges();
    }

    @Override
    public void onMovePart(int oldIndex, int newIndex) {
        if (oldIndex != newIndex) {
            this.m_query.moveGroupItem(oldIndex, newIndex);
        }
        this.refresh();
        this.displayMessages();
        this.firePropertyChanges();
    }

    protected GroupItem getSelectedItem() {
        GroupItem item = null;
        if (this.getSelectedPart() != null) {
            item = (GroupItem)this.getSelectedPart().getData();
        }
        return item;
    }
}

