/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.datasources.SasFormat;
import com.sas.query.datasources.SasInformat;
import com.sas.query.models.FixedNumericPlainDocument;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.StandardDialog;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FormatDialog
extends StandardDialog {
    public static final int FORMAT = 1;
    public static final int INFORMAT = 2;
    protected int m_category;
    protected int m_dataType;
    protected SasFormat[] m_formatArray;
    protected JList m_formatList;
    protected JLabel m_listTitle;
    protected JTextField m_exampleText;
    protected JTextField m_widthRangeText;
    protected JTextField m_widthText;
    protected JLabel m_decimalLabel;
    protected JTextField m_decimalText;
    protected JTextField m_nameLabel;
    protected JPanel m_mainPanel;
    protected JPanel m_listPanel;
    protected JPanel m_examplePanel;
    protected int m_maxDocumentLength;

    public FormatDialog(Query query, Frame frame, boolean bModal) {
        this(query, frame, bModal, 1, 4);
    }

    public FormatDialog(Query query, Frame frame, boolean bModal, int category, int dataType) {
        super(query, frame, bModal);
        this.m_category = category;
        this.m_dataType = dataType;
        this._initializeFormat();
        this._layoutListWidgets();
        this._layoutExampleWidgets();
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BorderLayout());
        this.m_mainPanel.add(this.m_listPanel);
        this.m_mainPanel.add("South", this.m_examplePanel);
        this.setMainPanel(this.m_mainPanel);
        this.m_formatList.setSelectedIndex(0);
        this.m_mainPanel.setMinimumSize(new Dimension(430, 200));
    }

    public String getFormat() {
        return this.m_nameLabel.getText() + this.m_widthText.getText() + "." + this.m_decimalText.getText();
    }

    public void setFormat(String format) {
        int index;
        String name = "";
        String width = "";
        String decimal = "";
        if (format == null || format.length() == 0) {
            return;
        }
        int periodPosition = format.indexOf(46);
        for (index = periodPosition + 1; index != -1 && index < format.length() && Character.isDigit(format.charAt(index)); ++index) {
            decimal = decimal + format.substring(index, index + 1);
        }
        for (index = periodPosition - 1; index > 0; --index) {
            if (!Character.isDigit(format.charAt(index))) {
                name = format.substring(0, index + 1);
                break;
            }
            width = format.substring(index, index + 1) + width;
        }
        int size = this.m_formatArray.length;
        String lowercaseName = name.toLowerCase();
        for (int index2 = 0; index2 < size; ++index2) {
            if (!this.m_formatArray[index2].toString().startsWith(lowercaseName)) continue;
            this.m_formatList.setSelectedIndex(index2);
            this.m_formatList.ensureIndexIsVisible(index2);
            break;
        }
        this.m_nameLabel.setText(name.toUpperCase());
        this.onSelection();
        this.m_widthText.setText(width);
        this.m_decimalText.setText(decimal);
    }

    protected void _initializeFormat() {
        String title;
        this.m_formatArray = this.m_category == 1 ? SasFormat.getFormatList(this.m_category, this.m_dataType).toArray() : SasInformat.getFormatList(this.m_category, this.m_dataType).toArray();
        this.m_formatList = new JList<SasFormat>(this.m_formatArray);
        this.m_formatList.setFont(new Font(QueryConfiguration.getConfigurationString("FormatDialog.FontName.txt", "Courier"), this.getFont().getStyle(), this.getFont().getSize()));
        this.m_formatList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                FormatDialog.this.onSelection();
            }
        });
        if (this.m_category == 1) {
            title = bundle.getString("FormatDialog.Label.Format.Title.txt");
            this.m_listTitle = new JLabel(bundle.getString("FormatDialog.Label.Format.ListTitle.txt"));
        } else {
            title = bundle.getString("FormatDialog.Label.Informat.Title.txt");
            this.m_listTitle = new JLabel(bundle.getString("FormatDialog.Label.Informat.ListTitle.txt"));
        }
        this.setTitle(title);
        this.m_exampleText = new JTextField();
        this.m_exampleText.setColumns(9);
        this.m_exampleText.setBorder(null);
        this.m_exampleText.setBackground(this.getBackground());
        this.m_exampleText.setEditable(false);
        this.m_widthRangeText = new JTextField();
        this.m_widthRangeText.setColumns(9);
        this.m_widthRangeText.setBorder(null);
        this.m_widthRangeText.setBackground(this.getBackground());
        this.m_widthRangeText.setEditable(false);
        this.m_nameLabel = new JTextField();
        this.m_nameLabel.setColumns(9);
        this.m_nameLabel.setBorder(null);
        this.m_nameLabel.setBackground(this.getBackground());
        this.m_nameLabel.setEditable(false);
        this.setDocumentLength(5);
        this.m_widthText = new JTextField();
        this.m_widthText.setColumns(4);
        this.m_widthText.setDocument(new FixedNumericPlainDocument(this.getDocumentLength()));
        this.m_decimalLabel = new JLabel(bundle.getString("FormatDialog.Label.Decimal.txt"));
        this.m_decimalText = new JTextField();
        this.m_decimalText.setColumns(4);
        this.m_decimalText.setDocument(new FixedNumericPlainDocument(this.getDocumentLength()));
        this.m_listPanel = new JPanel();
        this.m_examplePanel = new JPanel();
    }

    protected void _layoutListWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_listPanel.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_listTitle, gbc);
        this.m_listPanel.add(this.m_listTitle);
        JScrollPane scrollPane = new JScrollPane(this.m_formatList, 20, 30);
        WindowUtil.fixupJScrollPane(scrollPane);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(scrollPane, gbc);
        this.m_listPanel.add(scrollPane);
    }

    protected void _layoutExampleWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_examplePanel.setLayout(gridBagLayout);
        int gridy = 0;
        JLabel label = new JLabel(bundle.getString("FormatDialog.Label.WidthRange.txt"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 0, 0, 0);
        gridBagLayout.setConstraints(label, gbc);
        this.m_examplePanel.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(8, 6, 0, 0);
        gridBagLayout.setConstraints(this.m_widthRangeText, gbc);
        this.m_examplePanel.add(this.m_widthRangeText);
        gridy = 0;
        label = new JLabel(bundle.getString("FormatDialog.Label.Width.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 12, 0, 0);
        gridBagLayout.setConstraints(label, gbc);
        this.m_examplePanel.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(6, 6, 0, 0);
        gridBagLayout.setConstraints(this.m_widthText, gbc);
        this.m_examplePanel.add(this.m_widthText);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_decimalLabel, gbc);
        this.m_examplePanel.add(this.m_decimalLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = gridy++;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(6, 6, 0, 0);
        gridBagLayout.setConstraints(this.m_decimalText, gbc);
        this.m_examplePanel.add(this.m_decimalText);
        ++gridy;
    }

    public void onSelection() {
        SasFormat format = null;
        this.m_exampleText.setText("");
        this.m_widthRangeText.setText("");
        this.m_widthText.setText("");
        this.m_decimalText.setText("");
        this.m_nameLabel.setText("");
        this.m_decimalLabel.setEnabled(true);
        this.m_decimalText.setEnabled(true);
        try {
            format = (SasFormat)this.m_formatList.getSelectedValue();
        }
        catch (Exception e) {
            return;
        }
        if (format == null) {
            return;
        }
        this.m_exampleText.setText(format.getSample());
        this.m_widthRangeText.setText(format.getWidthMin() + " - " + format.getWidthMax());
        this.m_widthText.setText(Integer.toString(format.getWidthDefault()));
        this.m_nameLabel.setText(format.getName().toUpperCase());
        if (!format.isDecimalAllowed()) {
            this.m_decimalLabel.setEnabled(false);
            this.m_decimalText.setEnabled(false);
        } else {
            this.m_decimalText.setText("0");
        }
    }

    protected void setDocumentLength(int maxLength) {
        this.m_maxDocumentLength = maxLength;
    }

    protected int getDocumentLength() {
        return this.m_maxDocumentLength;
    }

    @Override
    public void onOK() {
        String strWidth = this.m_widthText.getText();
        String strDecimal = this.m_decimalText.getText();
        if (strWidth.length() > 0 && !this.isWidthValid(Long.parseLong(strWidth))) {
            this.m_query.getMessageHandler().addError(bundle.messageString("FormatDialog.Message.WidthOutOfRange.txt"));
            MessageUtil.displayMessages(this.m_query.getMessageHandler());
            this.m_widthText.requestFocus();
        } else if (strDecimal.length() > 0 && !this.isDecimalValid(Long.parseLong(strWidth), Long.parseLong(strDecimal))) {
            this.m_query.getMessageHandler().addError(bundle.messageString("FormatDialog.Message.DecimalLessThanWidth.txt"));
            MessageUtil.displayMessages(this.m_query.getMessageHandler());
            this.m_decimalText.requestFocus();
        } else {
            this.m_returnValue = 1;
            this.dispose();
        }
    }

    @Override
    protected void onCancel() {
        this.m_returnValue = 2;
        this.dispose();
    }

    public boolean isWidthValid(long width) {
        SasFormat format = (SasFormat)this.m_formatList.getSelectedValue();
        return width >= (long)format.getWidthMin() && width <= (long)format.getWidthMax();
    }

    public boolean isDecimalValid(long width, long decimal) {
        return decimal < width;
    }
}

