/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.datasources.DataSourceResultSet;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.models.FilterNode;
import com.sas.query.models.FilterTree;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.visuals.CrossJoinWarningDialog;
import com.sas.query.visuals.CutRegion;
import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.DropRegion;
import com.sas.query.visuals.FilterNodeView;
import com.sas.query.visuals.FilterNodeViewList;
import com.sas.query.visuals.ImageHandler;
import com.sas.query.visuals.PopMenuItem;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.ResultDialog;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.Terminator;
import com.sas.query.visuals.TerminatorRegion;
import com.sas.query.visuals.WindowUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class FilterTreeView
extends StandardView {
    protected transient FilterTree m_model = null;
    protected transient FilterNodeViewList m_views = new FilterNodeViewList();
    protected transient boolean m_doActionOnNewNode = true;
    protected transient boolean m_bShowArrangeMessage = true;
    protected transient boolean m_bHasUsedDrag = false;
    protected static transient ImageIcon m_dataSourceImage;
    protected static transient ImageIcon m_bulbImage;
    protected static transient ImageIcon m_pipeFilterIcon;
    protected static transient ImageIcon m_pipeFilterCollarIcon;
    protected static transient ImageIcon m_pipeElboSouthWestIcon;
    protected static transient ImageIcon m_pipeTeeEastIcon;
    protected static transient ImageIcon m_pipeHorizontalIcon;
    protected static transient ImageIcon m_pipeNodeConnectWestIcon;
    protected transient boolean m_fReadyToDrag = false;
    protected transient boolean m_fDragging = false;
    protected transient boolean m_fControlKeyPressed = false;
    protected transient boolean m_processingNodeAction = false;
    protected transient Cursor m_previousCursor = null;
    protected transient Dimension m_dragOffset;
    protected transient Point m_dragPoint = new Point(-1, -1);
    protected transient Vector m_dropRegions;
    protected transient JScrollPane m_scrollPane = null;
    protected transient Vector m_terminatorDropRegions;
    private transient int m_nodeHitLocation;
    protected transient Vector m_cutRegions = new Vector();
    protected transient CutRegion m_lastCutRegion = null;
    static ImageIcon m_cutImage;
    static final int NO_AUTO_SCROLL = 0;
    static final int AUTO_SCROLL_LEFT = 1;
    static final int AUTO_SCROLL_RIGHT = 2;
    static final int AUTO_SCROLL_UP = 4;
    static final int AUTO_SCROLL_DOWN = 8;
    private transient AutoScrollTimerThread m_autoScrollThread = null;
    private transient JPopupMenu popup = null;
    private static final int NOT_ON_A_NODE = -1;
    private static final int ON_TERMINATOR = 0;
    private static final int ON_EXPANDER = 1;
    private static final int ON_NODE = 2;
    protected static QueryResource bundle;
    protected static Dimension m_preferredSize;
    protected boolean m_dataFlowAnalysisState = false;
    protected long m_totalRowCount = 0L;
    protected long m_resultRowCount = 0L;

    public FilterTreeView(Query query, FilterTree filterTree, JScrollPane scrollPane) {
        super(query);
        this._initialize();
        this.m_model = filterTree;
        query.addPropertyListener(this, 32, 4);
        this.m_scrollPane = scrollPane;
        if (this.m_scrollPane != null) {
            this.addPropertyChangeListener(new ScrollListener());
        }
        query.addPropertyListener(this, 24);
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener(this);
    }

    protected void _initialize() {
        this.setBackground(SystemColor.control);
        this.enableEvents(60L);
        if (m_pipeNodeConnectWestIcon == null) {
            m_dataSourceImage = ImageHandler.getImageIcon(bundle, "dataSourceIcon");
            m_cutImage = ImageHandler.getImageIcon(bundle, "scissorsIcon");
            m_bulbImage = ImageHandler.getImageIcon(bundle, "bulbBlueIcon");
            m_pipeFilterIcon = ImageHandler.getImageIcon(bundle, "pipeFilterIcon");
            m_pipeFilterCollarIcon = ImageHandler.getImageIcon(bundle, "pipeFilterCollarIcon");
            m_pipeElboSouthWestIcon = ImageHandler.getImageIcon(bundle, "pipeElboSouthWestIcon");
            m_pipeTeeEastIcon = ImageHandler.getImageIcon(bundle, "pipeTeeEastIcon");
            m_pipeHorizontalIcon = ImageHandler.getImageIcon(bundle, "pipeHorizontalIcon");
            m_pipeNodeConnectWestIcon = ImageHandler.getImageIcon(bundle, "pipeNodeConnectWestIcon");
        }
    }

    @Override
    public Query getQuery() {
        return this.m_query;
    }

    public FilterTree getModel() {
        return this.m_model;
    }

    public FilterNodeView getNodeView(FilterNode node) {
        for (int index = 0; index < this.m_views.size(); ++index) {
            if (this.m_views.elementAt(index).getNode() != node) continue;
            return this.m_views.elementAt(index);
        }
        FilterNodeView newView = new FilterNodeView(this, node);
        this.m_views.addElement(newView);
        if (this.m_doActionOnNewNode && this.isShowing()) {
            this.setSelectedNode(newView);
            newView.getPreferredSize();
            this.update();
        }
        return newView;
    }

    public FilterNodeView getNodeAtPoint(Point point) {
        FilterNodeView node = this.internalNodeHitTest(this.getRoot(), point);
        return this.m_nodeHitLocation == 2 ? node : null;
    }

    public void onAction() {
        FilterNodeView view = this.getSelectedNode();
        if (view != null) {
            view.onAction();
        }
    }

    public FilterNodeView getRoot() {
        FilterNode rootNode = this.m_model.getRoot();
        if (rootNode == null) {
            return null;
        }
        return this.getNodeView(rootNode);
    }

    public FilterNodeView getSelectedNode() {
        FilterNode node = this.m_model.getSelectedNode();
        if (node != null) {
            return this.getNodeView(node);
        }
        return null;
    }

    public synchronized void setSelectedNode(FilterNodeView nodeView) {
        if (nodeView == null) {
            this.m_model.setSelectedNode(null);
        } else {
            this.m_model.setSelectedNode(nodeView.getNode());
        }
        this.firePropertyChanges();
    }

    public Object[] getSelectedObjects() {
        if (this.getSelectedNode() == null) {
            return null;
        }
        Object[] obj = new Object[]{this.getSelectedNode()};
        return obj;
    }

    @Override
    public void processFocusEvent(FocusEvent event) {
        switch (event.getID()) {
            case 1004: {
                this.focusGained(event);
                break;
            }
            case 1005: {
                this._cancelCurrentAction();
                this.focusLost(event);
                break;
            }
        }
    }

    protected void _cancelCurrentAction() {
        this.m_dropRegions = null;
        this.m_terminatorDropRegions = null;
        this.m_fReadyToDrag = false;
        this.m_fDragging = false;
        this.m_fControlKeyPressed = false;
        this.busyOff();
        if (this.m_autoScrollThread != null) {
            this.m_autoScrollThread.stop();
            this.m_autoScrollThread = null;
        }
        this.repaint();
    }

    @Override
    public void processKeyEvent(KeyEvent event) {
        if (event.getID() == 402 && event.getKeyCode() == 17 && this.m_fControlKeyPressed) {
            this.m_fControlKeyPressed = false;
            this.repaint();
        }
        if (event.getID() != 401) {
            return;
        }
        FilterNodeView node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        switch (event.getKeyCode()) {
            case 17: {
                if (this.m_fControlKeyPressed) break;
                this.m_fControlKeyPressed = true;
                this.repaint();
                break;
            }
            case 27: {
                this._cancelCurrentAction();
                break;
            }
            case 127: {
                if (!this.ensureNodeIsSelected()) break;
                this.onDelete();
                this.makeNodeVisible(this.getSelectedNode());
                break;
            }
            case 40: {
                if (!this.ensureNodeIsSelected() || event.isControlDown()) break;
                this._selectNextOrItem();
                break;
            }
            case 38: {
                if (!this.ensureNodeIsSelected() || event.isControlDown()) break;
                this.moveUp();
                break;
            }
            case 37: {
                if (!this.ensureNodeIsSelected()) break;
                this.moveLeft();
                break;
            }
            case 39: {
                if (!this.ensureNodeIsSelected() || event.isControlDown()) break;
                this._selectNextAndItem();
                break;
            }
            case 10: {
                this.onAction();
                break;
            }
            case 34: {
                if (!this.ensureNodeIsSelected()) break;
                this.pageDown();
                break;
            }
            case 33: {
                if (!this.ensureNodeIsSelected()) break;
                this.pageUp();
                break;
            }
            case 36: {
                if (this.m_scrollPane != null) {
                    this.m_scrollPane.getHorizontalScrollBar().setValue(0);
                    this.m_scrollPane.getVerticalScrollBar().setValue(0);
                }
                this.setSelectedNode(this.getRoot());
                this.makeNodeVisible(this.getSelectedNode());
                break;
            }
            case 35: {
                if (!this.ensureNodeIsSelected()) break;
                node = this.getSelectedNode();
                while (node.getAndNodeView() != null) {
                    node = node.getAndNodeView();
                }
                this.setSelectedNode(node);
                this.makeNodeVisible(this.getSelectedNode());
                break;
            }
        }
        super.processKeyEvent(event);
    }

    @Override
    protected void processMouseEvent(MouseEvent event) {
        int id = event.getID();
        int modifiers = event.getModifiers();
        super.processMouseEvent(event);
        if (id == 501) {
            this.requestFocus();
            this.mouseDown(event);
        } else if (id == 502) {
            if (this.m_fDragging) {
                this._dropNode(event);
            } else if ((modifiers & 4) != 0) {
                this.displayPopmenu(event);
            }
            this.m_fReadyToDrag = false;
            this.m_dropRegions = null;
            this.m_terminatorDropRegions = null;
            if (this.m_autoScrollThread != null) {
                this.m_autoScrollThread.stop();
                this.m_autoScrollThread = null;
            }
        }
    }

    protected DropRegion _findDropRegion(Point point, boolean bCopying) {
        int shortestDistance = 145;
        DropRegion returnValue = null;
        for (int index = 0; this.m_dropRegions != null && index < this.m_dropRegions.size(); ++index) {
            DropRegion region = (DropRegion)this.m_dropRegions.elementAt(index);
            int distance = region.getDistanceFromPoint(point);
            if (distance >= shortestDistance || !bCopying && region.isCopyRequired()) continue;
            shortestDistance = distance;
            returnValue = region;
        }
        return returnValue;
    }

    protected void _dropNode(MouseEvent event) {
        try {
            DropRegion region = this._findDropRegion(this.m_dragPoint, event.isControlDown());
            if (region != null) {
                this.m_bHasUsedDrag = true;
                FilterNodeView[] parentArray = null;
                FilterNodeView sourceNodeView = this.getSelectedNode();
                if (event.isControlDown()) {
                    sourceNodeView = (FilterNodeView)sourceNodeView.clone();
                    this.m_views.addElement(sourceNodeView);
                } else {
                    if (region.getDropType() == 4 && region.getTargetView().equals(sourceNodeView)) {
                        parentArray = sourceNodeView.getParentViews();
                    }
                    this.removeNode(sourceNodeView);
                }
                if (region.getDropType() == 0 || region.getDropType() == 2) {
                    region.getTargetView().getNode().addAnd(sourceNodeView.getNode());
                } else if (region.getDropType() == 1) {
                    region.getTargetView().getNode().addOr(sourceNodeView.getNode());
                    sourceNodeView.getNode().setAnd(region.getTargetView().getNode().getAnd());
                } else if (region.getDropType() == 4) {
                    FilterNode andNode = null;
                    if (!region.getTargetView().equals(sourceNodeView)) {
                        parentArray = region.getTargetView().getParentViews();
                    }
                    for (int parentIndex = 0; parentIndex < parentArray.length; ++parentIndex) {
                        FilterNode parentNode = parentArray[parentIndex].getNode();
                        andNode = parentNode.getAnd();
                        parentNode.setAnd(sourceNodeView.getNode());
                    }
                    sourceNodeView.getNode().setAnd(andNode);
                    sourceNodeView.getNode().setOr(null);
                } else if (region.getDropType() == 3) {
                    if (region.getTargetView().getNode().equals(this.m_model.getRoot())) {
                        sourceNodeView.getNode().setAnd(this.m_model.getRoot());
                        sourceNodeView.getNode().setOr(this.m_model.getRoot().getOr());
                        this.m_model.getRoot().setOr(null);
                        this.m_model.setRoot(sourceNodeView.getNode());
                    } else {
                        parentArray = region.getTargetView().getParentViews();
                        for (int parentIndex = 0; parentIndex < parentArray.length; ++parentIndex) {
                            FilterNode parentNode = parentArray[parentIndex].getNode();
                            if (region.getTargetView().getNode().equals(parentNode.getOr())) {
                                parentNode.setOr(sourceNodeView.getNode());
                                continue;
                            }
                            parentNode.setAnd(sourceNodeView.getNode());
                        }
                        sourceNodeView.getNode().setAnd(region.getTargetView().getNode());
                        sourceNodeView.getNode().setOr(region.getTargetView().getNode().getOr());
                        region.getTargetView().getNode().setOr(null);
                    }
                } else if (region.getDropType() == 5) {
                    region.getTargetView().getNode().addAnd(sourceNodeView.getNode());
                }
                this.update();
                this.setSelectedNode(sourceNodeView);
            }
            for (int index = 0; this.m_terminatorDropRegions != null && index < this.m_terminatorDropRegions.size(); ++index) {
                TerminatorRegion termRegion = (TerminatorRegion)this.m_terminatorDropRegions.elementAt(index);
                if (!termRegion.contains(this.m_dragPoint)) continue;
                this.m_bHasUsedDrag = true;
                this.getSelectedNode().getNode().setAnd(termRegion.getTargetView().getNode());
                break;
            }
            this.firePropertyChanges();
        }
        catch (Exception e) {
            this.m_query.getMessageHandler().addError(bundle.messageString("Message.FilterTree.DropAndClone.fmt.txt", e.toString()));
        }
        this.m_dropRegions = null;
        this.m_terminatorDropRegions = null;
        this.m_fDragging = false;
        this.update();
    }

    protected void displayPopmenu(MouseEvent event) {
        boolean dispResultCount;
        JPopupMenu popmenu = null;
        if (this.m_nodeHitLocation == 2) {
            popmenu = new JPopupMenu();
            popmenu.add(new PopMenuItem(bundle.getString("Common.Edit....txt"), "onEdit", this));
            popmenu.add(new PopMenuItem(bundle.getString("Common.Delete.txt"), "onDelete", this));
            dispResultCount = QueryConfiguration.getConfigurationBoolean("Queries.FilterTreeViewDisplayCountOptionAvailable.notrans", false);
            boolean dispResults = QueryConfiguration.getConfigurationBoolean("Queries.FilterTreeViewDisplayResultsOptionAvailable.notrans", false);
            if (dispResultCount || dispResults) {
                popmenu.addSeparator();
            }
            if (dispResultCount) {
                popmenu.add(new PopMenuItem(bundle.getString("Common.DisplayResultCount.txt"), "onDisplayCount", this));
            }
            if (dispResults && this.m_query.canResultsBeGotten()) {
                popmenu.add(new PopMenuItem(bundle.getString("Common.DisplayResults.txt"), "onDisplayResults", this));
            }
        } else if (this.m_nodeHitLocation == 0) {
            popmenu = new JPopupMenu();
            dispResultCount = QueryConfiguration.getConfigurationBoolean("Queries.FilterTreeViewDisplayCountOptionAvailable.notrans", false);
            boolean dispResults = QueryConfiguration.getConfigurationBoolean("Queries.FilterTreeViewDisplayResultsOptionAvailable.notrans", false);
            if (dispResultCount) {
                popmenu.add(new PopMenuItem(bundle.getString("Common.DisplayResultCount.txt"), "onDisplayCount", this));
            }
            if (dispResults && this.m_query.canResultsBeGotten()) {
                popmenu.add(new PopMenuItem(bundle.getString("Common.DisplayResults.txt"), "onDisplayResults", this));
            }
        }
        if (popmenu != null) {
            JComponent source = (JComponent)event.getSource();
            source.add(popmenu);
            popmenu.show(source, event.getX(), event.getY());
        }
    }

    public void onEdit() {
        this.getSelectedNode().onAction();
    }

    public void onDelete() {
        if (!this.ensureNodeIsSelected()) {
            return;
        }
        if (QueryConfiguration.getConfigurationBoolean("DeleteFilterWarningDialogEnabled.notrans", true)) {
            Object[] options = new Object[]{bundle.getString("Standard.ButtonLabel.Yes.txt"), bundle.getString("Standard.ButtonLabel.No.txt")};
            int annoyedUserSays = JOptionPane.showOptionDialog(null, bundle.messageString("FilterTree.Label.DeleteFilter.txt"), bundle.messageString("Title.Confirm.txt"), 0, 3, null, options, options[0]);
            if (annoyedUserSays != 0) {
                this.requestFocus();
                return;
            }
        }
        this.setSelectedNode(this.removeNode(this.getSelectedNode()));
        this.requestFocus();
        this.update();
        this.firePropertyChanges();
    }

    public void onDisplayCount() {
        CrossJoinWarningDialog warningDialog = new CrossJoinWarningDialog(WindowUtil.getParentFrame(this), this.getQuery());
        if (warningDialog.isProcessCrossJoinCancelled()) {
            return;
        }
        long rowCount = this.getRowCount(this.getNodeCountStringQuery(this.getSelectedNode().getNode()));
        JOptionPane.showMessageDialog(null, bundle.messageString("FilterTreeView.ResultCountMessage.fmt.txt", new Long(rowCount)), bundle.getString("FilterTreeView.ResultCountDialogTitle.txt"), 1);
    }

    public String getTotalCountStringQuery() {
        SqlLogic sqlLogic = this.m_query.getSqlLogic();
        String strQuery = "SELECT count(*) FROM ";
        strQuery = strQuery + sqlLogic.genFromClause();
        this.displayMessages();
        if (this.failureHasOccurred()) {
            return null;
        }
        return strQuery;
    }

    public String getNodeCountStringQuery(FilterNode node) {
        String strQuery = this.getTotalCountStringQuery();
        strQuery = strQuery + " WHERE ";
        strQuery = this.m_model == this.m_query.getWhereFilterTree() ? strQuery + this.m_query.getSqlLogic().genWhereClause(node) : strQuery + this.m_query.getSqlLogic().genHavingClause(node);
        this.displayMessages();
        if (this.failureHasOccurred()) {
            return null;
        }
        return strQuery;
    }

    public String getResultCountStringQuery() {
        String strQuery = this.getTotalCountStringQuery();
        strQuery = strQuery + " WHERE " + this.getQuery().getWhereString();
        this.displayMessages();
        if (this.failureHasOccurred()) {
            return null;
        }
        return strQuery;
    }

    public long getTotalRowCount() {
        return this.m_totalRowCount;
    }

    public long getResultRowCount() {
        return this.m_resultRowCount;
    }

    public long getRowCount(String strQuery) {
        DataSourceResultSet resultSet = this.m_query.getDataSource().getResultSet(strQuery);
        resultSet.initialize();
        if (this.failureHasOccurred()) {
            this.displayMessages();
            return 0L;
        }
        this.displayMessages();
        long rowCount = 0L;
        try {
            Object count = resultSet.getCell(1, 1);
            if (count instanceof Integer) {
                rowCount = ((Integer)count).longValue();
            } else if (count instanceof Long) {
                rowCount = (Long)count;
            } else if (count instanceof Double) {
                rowCount = ((Double)count).longValue();
            } else if (count instanceof String) {
                Integer tmpInt = new Integer((String)count);
                rowCount = tmpInt.longValue();
            }
        }
        catch (Exception e) {
            this.displayMessages();
            return 0L;
        }
        resultSet.close();
        return rowCount;
    }

    public void onDisplayResults() {
        ResultDialog sqlDialog = this.m_model == this.m_query.getWhereFilterTree() ? new ResultDialog(this.m_query, this.getModel(), this.getSelectedNode().getNode(), null, WindowUtil.getParentFrame(this), false) : new ResultDialog(this.m_query, this.getModel(), null, this.getSelectedNode().getNode(), WindowUtil.getParentFrame(this), false);
        sqlDialog.show();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        int id = e.getID();
        if (id == 506) {
            if (this.m_fReadyToDrag) {
                Point p = e.getPoint();
                if (Math.abs(this.m_dragPoint.x - p.x) > 2 || Math.abs(this.m_dragPoint.y - p.y) > 2) {
                    this.m_dragOffset = new Dimension(this.m_dragPoint.x - this.getSelectedNode().x, this.m_dragPoint.y - this.getSelectedNode().y);
                    this.m_fDragging = true;
                    this.m_fReadyToDrag = false;
                }
            }
            if (this.m_fDragging && this.m_scrollPane != null) {
                this.m_dragPoint = e.getPoint();
                int scrollType = 0;
                Point shouldScrollPoint = e.getPoint();
                shouldScrollPoint.translate(-this.m_scrollPane.getHorizontalScrollBar().getValue(), -this.m_scrollPane.getVerticalScrollBar().getValue());
                if (shouldScrollPoint.x < 2) {
                    scrollType |= 1;
                }
                if (shouldScrollPoint.y < 2) {
                    scrollType |= 4;
                }
                Dimension viewPortSize = this.m_scrollPane.getViewport().getSize();
                if (shouldScrollPoint.x > viewPortSize.width - 2) {
                    scrollType |= 2;
                }
                if (shouldScrollPoint.y > viewPortSize.height - 2) {
                    scrollType |= 8;
                }
                if (scrollType != 0) {
                    if (this.m_autoScrollThread == null) {
                        this.m_autoScrollThread = new AutoScrollTimerThread(scrollType);
                        this.m_autoScrollThread.start();
                    } else {
                        this.m_autoScrollThread.setScrollType(scrollType);
                    }
                } else if (scrollType == 0 && this.m_autoScrollThread != null) {
                    this.m_autoScrollThread.stop();
                    this.m_autoScrollThread = null;
                }
                this.repaint();
            } else if (this.m_fDragging) {
                this.m_dragPoint = e.getPoint();
                this.repaint();
            }
        } else if (id == 503) {
            CutRegion region = null;
            this.m_dragPoint = e.getPoint();
            for (int index = 0; index < this.m_cutRegions.size(); ++index) {
                region = (CutRegion)this.m_cutRegions.elementAt(index);
                if (region.contains(e.getPoint())) {
                    this.repaint();
                    break;
                }
                region = null;
            }
            if (region == null && this.m_lastCutRegion != null) {
                this.m_dragPoint = new Point(-1, -1);
                this.repaint();
            }
            this.m_lastCutRegion = region;
        }
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        if (event.isStructureChange()) {
            FilterNodeView selectedNode;
            if (!event.didOnlyThisStructureTypeChange(8)) {
                this.setDataFlowAnalysisEnable(false);
            }
            if (event.didThisStructureTypeChange(1) && (selectedNode = this.getSelectedNode()) != null) {
                this.makeNodeVisible(selectedNode);
            }
        }
        if (event.isDataChange() && this.is3DEnabled() && event.didThisDataAreaChange(32)) {
            this.setDataFlowAnalysisEnable(false);
        }
        this.update();
    }

    @Override
    public void paintComponent(Graphics g) {
        block6: {
            block5: {
                Rectangle rect = this.getBounds();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, rect.width - rect.x, rect.height - rect.y);
                this.paintNodesAndPipes(g);
                if (this.is3DEnabled()) {
                    this.drawRecordStrings(g);
                }
                if (!this.m_fDragging) break block5;
                g.setColor(this.getBackground().brighter());
                g.drawRect(this.m_dragPoint.x + 10, this.m_dragPoint.y + 12, 12, 10);
                if (this.m_fControlKeyPressed) {
                    g.setColor(Color.black);
                    int startX = this.m_dragPoint.x + 8;
                    int startY = this.m_dragPoint.y - 4;
                    int width = 6;
                    int height = 6;
                    g.drawLine(startX, startY - height / 2, startX, startY + height / 2);
                    g.drawLine(startX - width / 2, startY, startX + width / 2, startY);
                }
                g.setColor(Color.black);
                DropRegion region = this._findDropRegion(this.m_dragPoint, this.m_fControlKeyPressed);
                if (region != null) {
                    Rectangle targetRect = region.getTargetView().getBounds();
                    region.paint(g, targetRect);
                }
                for (int index = 0; this.m_terminatorDropRegions != null && index < this.m_terminatorDropRegions.size(); ++index) {
                    TerminatorRegion termRegion = (TerminatorRegion)this.m_terminatorDropRegions.elementAt(index);
                    if (!termRegion.contains(this.m_dragPoint)) continue;
                    termRegion.paint(g, this.m_dragPoint);
                }
                break block6;
            }
            if (this.m_dragPoint.x <= 0 || this.m_dragPoint.y <= 0) break block6;
            for (int index = 0; index < this.m_cutRegions.size(); ++index) {
                CutRegion region = (CutRegion)this.m_cutRegions.elementAt(index);
                if (!region.contains(this.m_dragPoint)) continue;
                region.paint(g, this.m_dragPoint, this.m_cutRegions);
            }
        }
    }

    public void repositionNodes() {
        int maxRow = 1;
        int maxColumn = 1;
        if (this.getRoot() != null) {
            this.getRoot().repositionNode(this, null, 0, maxRow, maxColumn);
        }
    }

    protected void paintNodesAndPipes(Graphics g) {
        FilterNode[] nodeArray = this.m_model.getNodesArray();
        if (this.getRoot() == null) {
            boolean bOldOnAction = this.m_doActionOnNewNode;
            this.m_doActionOnNewNode = false;
            for (int index = 0; index < nodeArray.length; ++index) {
                this.getNodeView(nodeArray[index]);
            }
            this.m_doActionOnNewNode = bOldOnAction;
            if (nodeArray.length > 0) {
                this.repositionNodes();
            }
        }
        if (this.getRoot() == null) {
            if (QueryConfiguration.getConfigurationBoolean("DisplayFilterHintViews.notrans", true)) {
                String message1 = bundle.messageString("Message.FilterTree.NoData.Prompt.1.txt");
                String message2 = bundle.messageString("Message.FilterTree.NoData.Prompt.2.txt");
                this.displayFYI(g, message1, message2, 10, 10);
            }
            return;
        }
        if (!this.m_bHasUsedDrag && nodeArray.length >= 2 && this.m_bShowArrangeMessage && QueryConfiguration.getConfigurationBoolean("DisplayFilterHintViews.notrans", true)) {
            String message1 = bundle.messageString("Message.FilterTree.DragAndDrop.Prompt.1.txt");
            String message2 = bundle.messageString("Message.FilterTree.DragAndDrop.Prompt.2.txt");
            int xOffset = this.getRoot().getAndNodeView() == null ? this.getRoot().x + this.getRoot().width + FilterNodeView.INTER_NODE_AND_SPACE : this.getRoot().getAndNodeView().x;
            this.displayFYI(g, message1, message2, xOffset, 5);
        }
        FilterNodeView nodeView = this.getRoot();
        ImageIcon leftSideIcon = m_pipeElboSouthWestIcon;
        FilterNodeView orNode = nodeView.getOrNodeView();
        if (orNode != null) {
            leftSideIcon = m_pipeTeeEastIcon;
        }
        if (this.is3DEnabled()) {
            m_pipeNodeConnectWestIcon = m_pipeHorizontalIcon;
        }
        DrawUtil.tileHorizontal(this, g, new Rectangle(nodeView.x - m_pipeFilterCollarIcon.getIconWidth() * 2, nodeView.y + 27 - m_pipeHorizontalIcon.getIconHeight() / 2, 0, 0), new Rectangle(nodeView.x - 1, nodeView.y + 27 - m_pipeHorizontalIcon.getIconHeight() / 2, 0, 0), leftSideIcon, m_pipeHorizontalIcon, m_pipeNodeConnectWestIcon);
        for (int index = 0; index < nodeArray.length; ++index) {
            nodeView = this.getNodeView(nodeArray[index]);
            nodeView.paintView(g);
        }
        if (m_pipeFilterIcon != null) {
            nodeView = this.getRoot();
            int x = nodeView.x - m_pipeFilterIcon.getIconWidth();
            int y = nodeView.y + 27 - m_pipeFilterIcon.getIconHeight() - m_pipeFilterCollarIcon.getIconHeight() * 2 + 8;
            g.drawImage(m_pipeFilterIcon.getImage(), x, y, this);
            x = nodeView.x - m_pipeFilterCollarIcon.getIconWidth() * 2;
            y = nodeView.y + 27 - m_pipeFilterCollarIcon.getIconHeight() * 2 + 8;
            g.drawImage(m_pipeFilterCollarIcon.getImage(), x, y, this);
        } else {
            Color c = g.getColor();
            g.setColor(Color.green);
            g.fillArc(FilterNodeView.INTER_NODE_AND_SPACE / 3 + 3, this.getRoot().y + 27 - 8, 16, 16, 0, 360);
            g.setColor(c);
        }
    }

    protected void drawRecordStrings(Graphics g) {
        long totalRecordCount = this.getTotalRowCount();
        long resultRecordCount = this.getResultRowCount();
        String strTotalRecordCount = bundle.messageString("Message.Total.Count.fmt.txt", new Long(totalRecordCount));
        String strResultRecordCount = bundle.messageString("Message.Result.Count.fmt.txt", new Long(resultRecordCount));
        Color currentColor = g.getColor();
        Font currentFont = g.getFont();
        g.setColor(Color.black);
        g.setFont(DrawUtil.getLargeBoldFont());
        FontMetrics fontmetrics = g.getFontMetrics(DrawUtil.getLargeBoldFont());
        g.drawString(strTotalRecordCount, this.getBounds().x + 2, this.getBounds().y + 10);
        if (totalRecordCount == resultRecordCount) {
            g.setColor(Color.red);
            g.setFont(DrawUtil.getLargeFont());
            ImageIcon xIcon = ImageHandler.getImageIcon(bundle, "xIcon");
            if (xIcon != null) {
                g.drawImage(xIcon.getImage(), this.getBounds().width - fontmetrics.stringWidth(strResultRecordCount) - 2, this.getBounds().height - 27, this);
            }
            g.drawString(bundle.messageString("Message.Node.NoRecordsBlockedError.txt"), this.getBounds().width - fontmetrics.stringWidth(strResultRecordCount) + 16, this.getBounds().height - 14);
            g.setColor(Color.black);
            g.setFont(DrawUtil.getLargeBoldFont());
        }
        g.drawString(strResultRecordCount, this.getBounds().width - fontmetrics.stringWidth(strResultRecordCount) - 2, this.getBounds().height - 2);
        g.setColor(currentColor);
        g.setFont(currentFont);
    }

    protected void displayFYI(Graphics g, String message1, String message2, int startX, int startY) {
        FontMetrics fontmetrics = this.getParent().getGraphics().getFontMetrics();
        int lineHeight = fontmetrics.getAscent() + fontmetrics.getDescent() + 1;
        int bulbWidth = 0;
        if (m_bulbImage != null) {
            bulbWidth = m_bulbImage.getIconWidth();
        }
        int width = 8 + bulbWidth + 16 + Math.max(fontmetrics.stringWidth(message1), fontmetrics.stringWidth(message2));
        int height = (int)((double)lineHeight * 2.6);
        g.setColor(new Color(211, 211, 211));
        g.fillRect(startX, startY, width, height);
        if (m_bulbImage != null) {
            g.drawImage(m_bulbImage.getImage(), startX + 2, startY + 2, new Color(211, 211, 211), this);
        }
        g.setColor(Color.black);
        g.drawString(message1, startX + bulbWidth + 16, startY + (int)((double)lineHeight * 1.2));
        g.drawString(message2, startX + bulbWidth + 16, startY + (int)((double)lineHeight * 1.2) + lineHeight);
        g.drawLine(startX, startY + height, startX + width, startY + height);
        g.drawLine(startX + width, startY, startX + width, startY + height);
        g.setColor(Color.white);
        g.drawLine(startX, startY, startX + width, startY);
        g.drawLine(startX, startY, startX, startY + height);
    }

    public FilterNodeView removeNode(FilterNodeView nodeToRemove) {
        nodeToRemove.removeTerminator();
        if (this.getSelectedNode().equals(nodeToRemove)) {
            FilterNode replacementNode = this.m_model.removeNode(nodeToRemove.getNode());
            if (replacementNode == null) {
                return null;
            }
            return this.getNodeView(replacementNode);
        }
        this.m_model.removeNode(nodeToRemove.getNode());
        return null;
    }

    public void setRoot(FilterNodeView newValue) {
        this.m_model.setRoot(newValue.getNode());
        this.firePropertyChanges();
    }

    public void update() {
        this._clearNodeViewPositions();
        this.repositionNodes();
        this.m_cutRegions = new Vector();
        if (this.getRoot() != null) {
            this._computeCutRegions(this.m_cutRegions, this.getRoot());
        }
        if (this.isShowing()) {
            this.resizeForNodes();
            this.repaint();
        }
    }

    protected void _clearNodeViewPositions() {
        FilterNode[] nodeArray = this.m_model.getNodesArray();
        for (int index = 0; index < nodeArray.length; ++index) {
            FilterNodeView nodeView = this.getNodeView(nodeArray[index]);
            nodeView.x = 0;
            nodeView.y = 0;
        }
    }

    public boolean isProcessingNodeAction() {
        return this.m_processingNodeAction;
    }

    public void startProcessingNodeAction() {
        this.m_processingNodeAction = true;
        this.busyOn();
    }

    public void endProcessingNodeAction() {
        this.busyOff();
        this.m_previousCursor = null;
        this.m_processingNodeAction = false;
    }

    private boolean ensureNodeIsSelected() {
        return this.m_model.getSelectedNode() != null;
    }

    private void focusGained(FocusEvent event) {
        this.repaint();
    }

    private void focusLost(FocusEvent event) {
        this.repaint();
    }

    protected void _computeDropRegions(Vector regions, FilterNodeView rootView, FilterNodeView sourceView, FilterNodeView targetView) {
        FilterNodeView andView;
        regions.addElement(new DropRegion(1, targetView, sourceView.equals(targetView)));
        if (targetView.equals(rootView)) {
            regions.addElement(new DropRegion(3, targetView, sourceView.equals(targetView)));
        }
        if ((andView = targetView.getAndNodeView()) != null) {
            FilterNodeView[] parentArray;
            int cParents;
            int fNeedTwoAnds = 0;
            if (andView.getOrNodeView() != null) {
                ++fNeedTwoAnds;
            }
            if ((cParents = (parentArray = andView.getParentViews()).length) > 1) {
                ++fNeedTwoAnds;
            }
            if (fNeedTwoAnds > 0) {
                regions.addElement(new DropRegion(2, targetView, sourceView.equals(targetView)));
                regions.addElement(new DropRegion(3, andView, sourceView.equals(andView)));
                if (fNeedTwoAnds > 1) {
                    regions.addElement(new DropRegion(4, andView, false));
                }
            } else {
                regions.addElement(new DropRegion(0, targetView, sourceView.equals(targetView) || sourceView.equals(andView)));
            }
            this._computeDropRegions(regions, rootView, sourceView, andView);
        } else {
            regions.addElement(new DropRegion(5, targetView, sourceView.equals(targetView)));
        }
        FilterNodeView orView = targetView.getOrNodeView();
        if (orView != null) {
            regions.addElement(new DropRegion(3, orView, sourceView.equals(orView)));
            this._computeDropRegions(regions, rootView, sourceView, orView);
        }
    }

    protected void _computeCutRegions(Vector regions, FilterNodeView targetView) {
        FilterNodeView orView;
        FilterNodeView andView = targetView.getAndNodeView();
        if (andView != null) {
            FilterNodeView[] parentArray = andView.getParentViews();
            if (parentArray.length > 1 && andView.y != targetView.y) {
                regions.addElement(new CutRegion(targetView));
            }
            this._computeCutRegions(regions, andView);
        }
        if ((orView = targetView.getOrNodeView()) != null) {
            this._computeCutRegions(regions, orView);
        }
    }

    protected void _computeTerminatorDropRegions(Vector regions, FilterNodeView sourceView, FilterNodeView targetView) {
        FilterNodeView andView;
        FilterNodeView orView;
        if (targetView == null) {
            FilterNodeView parentView = sourceView;
            do {
                FilterNodeView[] parentArray;
                if ((parentArray = parentView.getParentViews()).length < 1) {
                    return;
                }
                targetView = parentView;
                parentView = parentArray[0];
            } while (!targetView.getNode().equals(parentView.getNode().getOr()));
            targetView = parentView.getAndNodeView();
        }
        if (targetView == null) {
            return;
        }
        regions.addElement(new TerminatorRegion(targetView));
        for (orView = targetView; orView != null && orView.getOrNodeView() != null; orView = orView.getOrNodeView()) {
        }
        if (!targetView.equals(orView)) {
            andView = orView.getAndNodeView();
            if (andView != null) {
                this._computeTerminatorDropRegions(regions, sourceView, andView);
            }
        } else {
            andView = targetView.getAndNodeView();
            if (andView != null) {
                this._computeTerminatorDropRegions(regions, sourceView, andView);
            }
        }
    }

    private FilterNodeView internalNodeHitTest(FilterNodeView testNode, Point point) {
        this.m_nodeHitLocation = -1;
        if (testNode == null) {
            return null;
        }
        FilterNodeView node = null;
        Insets insets = this.getInsets();
        int x = point.x - insets.left;
        int y = point.y - insets.top;
        if (testNode.getBounds().contains(x, y)) {
            this.m_nodeHitLocation = 2;
            return testNode;
        }
        Terminator terminator = testNode.getTerminator();
        if (terminator != null && terminator.getBounds().contains(x, y)) {
            this.m_nodeHitLocation = 0;
            return testNode;
        }
        node = testNode.getAndNodeView();
        if (node != null && (node = this.internalNodeHitTest(node, point)) != null) {
            return node;
        }
        return this.internalNodeHitTest(testNode.getOrNodeView(), point);
    }

    private boolean mouseDown(MouseEvent e) {
        FilterNodeView oldNode = null;
        Point p = e.getPoint();
        FilterNodeView node = this.internalNodeHitTest(this.getRoot(), p);
        if (node == null) {
            int cPipesCut = 0;
            for (int index = 0; index < this.m_cutRegions.size(); ++index) {
                CutRegion region = (CutRegion)this.m_cutRegions.elementAt(index);
                if (!region.contains(p)) continue;
                region.getTargetView().getNode().setAnd(null);
                region.getTargetView().addTerminator();
                ++cPipesCut;
            }
            if (cPipesCut > 0) {
                this.firePropertyChanges();
                this.update();
            }
            return false;
        }
        this.m_fReadyToDrag = true;
        this.m_dragPoint = p;
        this.setSelectedNode(node);
        if (e.getClickCount() == 2) {
            this.onAction();
            return false;
        }
        if (this.m_nodeHitLocation == 2) {
            this.m_dropRegions = new Vector();
            this._computeDropRegions(this.m_dropRegions, this.getRoot(), node, this.getRoot());
        } else if (this.m_nodeHitLocation == 0) {
            this.m_terminatorDropRegions = new Vector();
            this._computeTerminatorDropRegions(this.m_terminatorDropRegions, node, null);
            if (this.m_terminatorDropRegions.size() < 1) {
                this.m_fReadyToDrag = false;
            }
        }
        if (this.m_nodeHitLocation == 1 || this.m_nodeHitLocation != 2 || (oldNode = this.getSelectedNode()) != node) {
            // empty if block
        }
        this.repaint();
        return false;
    }

    protected void moveLeft() {
        FilterNodeView[] parentArray = this.getSelectedNode().getParentViews();
        if (parentArray.length == 0) {
            return;
        }
        FilterNodeView selectedParent = parentArray[0];
        for (int index = 1; index < parentArray.length; ++index) {
            FilterNodeView thisView = parentArray[index];
            if (thisView.y == selectedParent.y) {
                selectedParent = thisView;
                break;
            }
            if (thisView.y >= selectedParent.y) continue;
            selectedParent = thisView;
        }
        this.setSelectedNode(selectedParent);
        this.makeNodeVisible(this.getSelectedNode());
    }

    protected void moveUp() {
        FilterNodeView selectedNode = this.getSelectedNode();
        FilterNodeView[] parentArray = selectedNode.getParentViews();
        FilterNodeView selectedParent = null;
        if (parentArray.length == 0) {
            return;
        }
        for (int index = 0; index < parentArray.length; ++index) {
            FilterNodeView parent = parentArray[index];
            if (parent.x != selectedNode.x || parent.y > selectedNode.y || selectedParent != null && parent.y <= selectedParent.y) continue;
            selectedParent = parent;
        }
        if (selectedParent != null) {
            this.setSelectedNode(selectedParent);
            this.makeNodeVisible(this.getSelectedNode());
        }
    }

    private synchronized void pageDown() {
        if (this.m_scrollPane != null) {
            int position = this.m_scrollPane.getVerticalScrollBar().getValue();
            Dimension viewPortSize = this.m_scrollPane.getViewport().getSize();
            this.m_scrollPane.getVerticalScrollBar().setValue(position + viewPortSize.height);
        }
    }

    private synchronized void pageUp() {
        if (this.m_scrollPane != null) {
            int position = this.m_scrollPane.getVerticalScrollBar().getValue();
            Dimension viewPortSize = this.m_scrollPane.getViewport().getSize();
            this.m_scrollPane.getVerticalScrollBar().setValue(position - viewPortSize.height);
        }
    }

    private void makeNodeVisible(FilterNodeView nodeView) {
        boolean fPositionChanged = false;
        if (nodeView == null) {
            return;
        }
        this.resizeForNodes();
        this.m_scrollPane.validate();
        if (nodeView.x > 0 && this.m_scrollPane != null) {
            int scrollX = this.m_scrollPane.getHorizontalScrollBar().getValue();
            int scrollY = this.m_scrollPane.getVerticalScrollBar().getValue();
            Dimension viewPortSize = this.m_scrollPane.getViewport().getSize();
            int change = scrollX + viewPortSize.width - (nodeView.x + nodeView.width + 20);
            if (change < 0) {
                this.m_scrollPane.getHorizontalScrollBar().setValue(scrollX - change);
                fPositionChanged = true;
            } else {
                change = scrollX - nodeView.x + 20;
                if (change > 0) {
                    this.m_scrollPane.getHorizontalScrollBar().setValue(scrollX - change);
                    fPositionChanged = true;
                }
            }
            change = scrollY + viewPortSize.height - (nodeView.y + nodeView.height + 20);
            if (change < 0) {
                this.m_scrollPane.getVerticalScrollBar().setValue(scrollY - change);
                fPositionChanged = true;
            } else {
                change = scrollY - nodeView.y + 20;
                if (change > 0) {
                    this.m_scrollPane.getVerticalScrollBar().setValue(scrollY - change);
                    fPositionChanged = true;
                }
            }
        }
        if (fPositionChanged) {
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return m_preferredSize;
    }

    private void resizeForNodes() {
        if (this.m_scrollPane != null) {
            Dimension newSize;
            int maxWidth = 0;
            int maxHeight = 0;
            for (int index = 0; index < this.m_views.size(); ++index) {
                FilterNodeView node = this.m_views.elementAt(index);
                Rectangle bounds = node.getBounds();
                if (bounds.x + bounds.width > maxWidth) {
                    maxWidth = bounds.x + bounds.width;
                }
                if (bounds.y + bounds.height <= maxHeight) continue;
                maxHeight = bounds.y + bounds.height;
            }
            m_preferredSize = newSize = new Dimension(maxWidth + 60, maxHeight + 20);
            this.revalidate();
        }
    }

    private void _selectNextOrItem() {
        FilterNodeView selectedView = this.getSelectedNode();
        if (selectedView == null) {
            return;
        }
        FilterNode orNode = selectedView.getNode().getOr();
        if (orNode != null) {
            this.setSelectedNode(this.getNodeView(orNode));
            this.makeNodeVisible(this.getSelectedNode());
        }
    }

    private void _selectNextAndItem() {
        FilterNodeView selectedView = this.getSelectedNode();
        if (selectedView == null) {
            return;
        }
        FilterNode andNode = selectedView.getNode().getAnd();
        if (andNode != null) {
            this.setSelectedNode(this.getNodeView(andNode));
            this.makeNodeVisible(this.getSelectedNode());
        }
    }

    public void setDataFlowAnalysisEnable(boolean state) {
        FilterNodeView nodeView;
        boolean bOldValue = this.m_dataFlowAnalysisState;
        this.m_dataFlowAnalysisState = state;
        if (this.m_dataFlowAnalysisState) {
            this.m_totalRowCount = this.getRowCount(this.getTotalCountStringQuery());
            this.m_resultRowCount = this.getRowCount(this.getResultCountStringQuery());
        } else {
            this.m_totalRowCount = 0L;
            this.m_resultRowCount = 0L;
        }
        FilterNode[] nodeArray = this.m_model.getNodesArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeView = this.getNodeView(nodeArray[i]);
            nodeView.updateDataFlowAnalysisInformation();
        }
        for (int j = 0; j < nodeArray.length; ++j) {
            nodeView = this.getNodeView(nodeArray[j]);
            nodeView.updateMessageColorInfo();
        }
        this.repaint();
    }

    public boolean is3DEnabled() {
        return this.m_dataFlowAnalysisState;
    }

    static {
        m_cutImage = null;
        bundle = new QueryResource(FilterTreeView.class);
        m_preferredSize = new Dimension(300, 125);
    }

    public class AutoScrollTimerThread
    extends Thread {
        long m_delay = 40L;
        int m_type;

        AutoScrollTimerThread(int type) {
            this.m_type = type;
        }

        public void setScrollType(int type) {
            this.m_type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    AutoScrollTimerThread.sleep(this.m_delay);
                }
                catch (InterruptedException e) {
                    break;
                }
                FilterTreeView filterTreeView = FilterTreeView.this;
                synchronized (filterTreeView) {
                    int newX = FilterTreeView.this.m_scrollPane.getHorizontalScrollBar().getValue();
                    int newY = FilterTreeView.this.m_scrollPane.getVerticalScrollBar().getValue();
                    if ((this.m_type & 1) == 1) {
                        newX -= 10;
                    }
                    if ((this.m_type & 2) == 2) {
                        newX += 10;
                    }
                    if ((this.m_type & 4) == 4) {
                        newY -= 10;
                    }
                    if ((this.m_type & 8) == 8) {
                        newY += 10;
                    }
                    FilterTreeView.this.m_scrollPane.getHorizontalScrollBar().setValue(newX);
                    FilterTreeView.this.m_scrollPane.getVerticalScrollBar().setValue(newY);
                }
            }
        }
    }

    public class ScrollListener
    implements PropertyChangeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            FilterTreeView filterTreeView = FilterTreeView.this;
            synchronized (filterTreeView) {
                if (e.getPropertyName().equals("verticalPosition")) {
                    int delta = (Integer)e.getNewValue() - (Integer)e.getOldValue();
                    if (FilterTreeView.this.m_fReadyToDrag) {
                        FilterTreeView.this.m_dragPoint.y -= delta;
                    }
                } else if (e.getPropertyName().equals("horizontalPosition")) {
                    int delta = (Integer)e.getNewValue() - (Integer)e.getOldValue();
                    if (FilterTreeView.this.m_fReadyToDrag) {
                        FilterTreeView.this.m_dragPoint.x -= delta;
                    }
                }
            }
        }
    }
}

