/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.models.FilterNode;
import com.sas.query.models.FilterTree;
import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.FilterEditDialog;
import com.sas.query.visuals.FilterTreeView;
import com.sas.query.visuals.ImageHandler;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.Part;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.Terminator;
import com.sas.query.visuals.WindowUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Window;
import java.util.Vector;
import javax.swing.ImageIcon;

public class FilterNodeView
extends Part
implements Cloneable {
    protected static QueryResource bundle = new QueryResource(FilterNodeView.class);
    protected static final int AND = 1;
    protected static final int OR = 2;
    protected static final int INTERLINE_SPACE = 1;
    protected static final int LEFT_MARGIN = 6;
    protected static final int RIGHT_MARGIN = 6;
    protected static final int FOCUS_BORDER_WIDTH = 2;
    protected static final int INTER_NODE_AND_SPACE = Math.max(bundle.getInt("filternode.INTER_NODE_AND_SPACE.num.notrans"), 32);
    protected static final int INTER_NODE_OR_SPACE = Math.max(bundle.getInt("filternode.INTER_NODE_OR_SPACE.num.notrans"), 20);
    protected static final String AND_DISPLAY_STRING = bundle.getString("filternode.AND.STRING.notrans");
    protected static final String OR_DISPLAY_STRING = bundle.getString("filternode.OR.STRING.notrans");
    protected static final String ELIPSIS_STRING = "...";
    public static final int PIPE_SIZE = 3;
    public static final int VERTICAL_PIPE_OFFSET = 27;
    public static final int MAXIMUM_WIDTH = 240;
    public static final int MAXIMUM_DEPTH = 11;
    protected static int INTER_NODE_AND_SPACE_DIVISOR = 6;
    protected FilterNode m_node;
    protected int m_lineHeight = 0;
    protected int m_ascent;
    protected int m_elipsisLength;
    protected int m_limitStringLength;
    protected Terminator m_terminator = null;
    protected Object m_hashObject = new Object();
    protected FilterTreeView m_treeView;
    protected Color dark;
    protected Color light;
    protected Color midLight;
    protected String m_countMessage;
    protected int m_depthOfNode = 1;
    protected String m_nodeErrorMessage;
    protected long m_nodeRecordCount;
    protected Color m_countMessageColor;

    public FilterNodeView(FilterTreeView parent, FilterNode node) {
        super(parent);
        this.m_treeView = parent;
        this.setNode(node);
        this.x = 0;
        this.y = 0;
        this.getPreferredSize();
        this.dark = new Color(0x868686);
        this.light = new Color(0xCBCBCB);
        this.midLight = new Color(0xD0D0D0);
    }

    @Override
    public Object clone() throws OutOfMemoryError {
        FilterNodeView newView = null;
        try {
            newView = (FilterNodeView)super.clone();
            newView.m_node = (FilterNode)this.getNode().clone();
        }
        catch (CloneNotSupportedException e) {
            if (newView == null) {
                newView = new FilterNodeView(this.m_treeView, null);
            }
            newView.m_node = null;
        }
        newView.m_lineHeight = this.m_lineHeight;
        newView.m_ascent = this.m_ascent;
        newView.width = this.width;
        newView.height = this.height;
        newView.x = this.x;
        newView.y = this.y;
        newView.setParent(this.getParent());
        newView.m_hashObject = new Object();
        newView.m_terminator = null;
        newView.dark = this.dark;
        newView.light = this.light;
        newView.midLight = this.midLight;
        newView.m_treeView = this.m_treeView;
        return newView;
    }

    @Override
    public int hashCode() {
        return this.m_hashObject.hashCode();
    }

    public void setSelected(boolean selected) {
        this.getNode().setSelected(selected);
    }

    public boolean isSelected() {
        return this.getNode().isSelected();
    }

    public void setNode(FilterNode node) {
        this.m_node = node;
    }

    public FilterNode getNode() {
        return this.m_node;
    }

    public FilterTreeView getTreeView() {
        return this.m_treeView;
    }

    protected FilterNodeView getNodeView(FilterNode node) {
        if (node == null) {
            return null;
        }
        return this.m_treeView.getNodeView(node);
    }

    protected FilterNodeView getNodeView() {
        FilterNode node = this.getNode();
        if (node == null) {
            return null;
        }
        return this.m_treeView.getNodeView(node);
    }

    protected FilterNodeView getAndNodeView() {
        FilterNode node = this.getNode().getAnd();
        if (node == null) {
            return null;
        }
        return this.m_treeView.getNodeView(node);
    }

    protected FilterNodeView getOrNodeView() {
        FilterNode node = this.getNode().getOr();
        if (node == null) {
            return null;
        }
        return this.m_treeView.getNodeView(node);
    }

    public Terminator getTerminator() {
        return this.m_terminator;
    }

    public void removeTerminator() {
        this.m_terminator = null;
    }

    public void addTerminator() {
        this.m_terminator = new Terminator(this, this.x + this.width + 16, this.y);
    }

    public String toString(Object data) {
        if (data instanceof Image) {
            return null;
        }
        return data.toString();
    }

    public Image toImage(Object data) {
        if (data instanceof Image) {
            return (Image)data;
        }
        return null;
    }

    public long getNodeRecordCount() {
        return this.m_nodeRecordCount;
    }

    public FilterNodeView[] getParentViews() {
        FilterNodeView[] parentViews = new FilterNodeView[]{};
        FilterNode node = this.getNode();
        FilterNode[] parentNodes = node.getParentNodes();
        if (parentNodes != null && parentNodes.length > 0) {
            parentViews = new FilterNodeView[parentNodes.length];
            for (int index = 0; index < parentNodes.length; ++index) {
                parentViews[index] = this.getNodeView(parentNodes[index]);
            }
        }
        return parentViews;
    }

    public Vector getNodeViewParents(FilterNode node) {
        Vector nodeViewParents = new Vector();
        if (node.getAndParents() != null) {
            for (int i = 0; i < node.getAndParents().size(); ++i) {
                nodeViewParents.addElement(node.getAndParents().elementAt(i));
            }
        }
        if (node.getOrParent() != null) {
            FilterNode oldestORParent = node;
            while (oldestORParent.getOrParent() != null) {
                oldestORParent = oldestORParent.getOrParent();
            }
            if (oldestORParent.getAndParents() != null) {
                for (int j = 0; j < oldestORParent.getAndParents().size(); ++j) {
                    nodeViewParents.addElement(oldestORParent.getAndParents().elementAt(j));
                }
            }
        }
        return nodeViewParents;
    }

    public Vector getNodeViewChildren(FilterNode node) {
        Vector<FilterNode> nodeViewChildren = new Vector<FilterNode>();
        if (node.getAnd() != null) {
            nodeViewChildren.addElement(node.getAnd());
        }
        FilterNode ORNode = node.getAnd();
        try {
            while (ORNode.getOr() != null) {
                nodeViewChildren.addElement(ORNode.getOr());
                ORNode = ORNode.getOr();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return nodeViewChildren;
    }

    public String getNodeCountError() {
        FilterNode node = this.getNode();
        String errorMessage = null;
        long zeroCount = 0L;
        Vector nodeViewAndParentsList = this.getNodeViewParents(node);
        if (nodeViewAndParentsList != null) {
            for (int i = 0; i < nodeViewAndParentsList.size(); ++i) {
                if (this.getTreeView().getNodeView((FilterNode)nodeViewAndParentsList.elementAt(i)).getNodeRecordCount() != this.getTreeView().getNodeView(node).getNodeRecordCount() || !this.isNodeReceivingRecords(node)) continue;
                errorMessage = bundle.messageString("Message.Node.NoRecordsBlockedError.txt");
            }
        }
        if (this.getTreeView().getTotalRowCount() == this.getNodeRecordCount()) {
            errorMessage = bundle.messageString("Message.Node.NoRecordsBlockedError.txt");
        }
        if (this.getNodeRecordCount() == zeroCount && this.isNodeReceivingRecords(node)) {
            errorMessage = bundle.messageString("Message.Node.AllRecordsBlockedError.txt");
        }
        return errorMessage;
    }

    public boolean isNodeReceivingRecords(FilterNode node) {
        boolean nodeIsReceivingRecords = false;
        long zeroCount = 0L;
        Vector parents = this.getNodeViewParents(node);
        if (parents != null) {
            for (int i = 0; i < parents.size(); ++i) {
                if (this.getTreeView().getNodeView((FilterNode)parents.elementAt(i)).getNodeRecordCount() == zeroCount) continue;
                nodeIsReceivingRecords = true;
            }
        }
        if (this.getTreeView().getTotalRowCount() != zeroCount) {
            nodeIsReceivingRecords = true;
        }
        return nodeIsReceivingRecords;
    }

    public void setCountMessageColor(Color color) {
        this.m_countMessageColor = color;
    }

    public Color getCountMessageColor() {
        return this.m_countMessageColor;
    }

    public void onAction() {
        if (!this.getTreeView().isProcessingNodeAction()) {
            this.getTreeView().startProcessingNodeAction();
            FilterEditDialog limitDialog = new FilterEditDialog(this.getTreeView().getQuery(), WindowUtil.getParentFrame(this.m_treeView), this.getNode());
            WindowUtil.centerOver(limitDialog, this.getParent());
            Component focus = this.getFocusOwner();
            limitDialog.setVisible(true);
            this.getTreeView().getQuery().isValidSql();
            if (focus != null) {
                focus.requestFocus();
            }
            this.reComputePreferredSize();
            ((FilterTreeView)this.getParent()).update();
            this.getTreeView().endProcessingNodeAction();
            this.getTreeView().getQuery().getMessageHandler().firePropertyChanges();
            MessageUtil.displayMessages(this.getTreeView().getQuery().getMessageHandler());
        }
    }

    protected Component getFocusOwner() {
        Container window;
        for (window = this.getParent(); window != null && !(window instanceof Window); window = window.getParent()) {
        }
        return window == null ? this.getParent() : ((Window)window).getFocusOwner();
    }

    public void reComputePreferredSize() {
        this.m_lineHeight = 0;
        this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        FilterNode node = this.getNode();
        if (node != null && this.m_lineHeight == 0) {
            if (this.getParent().getGraphics() == null) {
                return super.getPreferredSize();
            }
            FontMetrics fontmetrics = this.getParent().getGraphics().getFontMetrics();
            this.m_ascent = fontmetrics.getAscent();
            this.m_lineHeight = fontmetrics.getAscent() + fontmetrics.getDescent() + 1;
            this.m_elipsisLength = fontmetrics.stringWidth(ELIPSIS_STRING);
            this.m_limitStringLength = 0;
            if (node.getLimitString() != null) {
                this.width = this.m_limitStringLength = fontmetrics.stringWidth(node.getLimitString());
            }
            this.width = this.width + 6 + 6;
            if (this.width > 240) {
                this.width = 240;
            } else {
                int remainder = this.width % 16;
                if (remainder != 0) {
                    this.width += 16 - remainder;
                }
            }
            this.height = this.m_lineHeight * 3;
            if (this.m_terminator != null) {
                this.addTerminator();
            }
        }
        return super.getPreferredSize();
    }

    public void repositionNode(FilterTreeView tree, FilterNodeView parent, int parentRelation, int maxX, int maxY) {
        FilterNodeView view;
        FilterNode modelNode = this.getNode();
        if (parent == null) {
            this.x = INTER_NODE_AND_SPACE;
            this.y = INTER_NODE_OR_SPACE * 2;
        } else if (parentRelation == 1) {
            int oldX = this.x;
            this.x = parent.x + parent.width + INTER_NODE_AND_SPACE;
            if (oldX > this.x) {
                this.x = oldX;
            }
            this.y = this.y != 0 ? this.y : parent.y;
        } else {
            this.x = parent.x;
            this.y = parent.y + parent.height + INTER_NODE_OR_SPACE;
        }
        maxX = this.x > maxX ? this.x : maxX;
        maxY = this.y > maxY ? this.y : maxY;
        boolean fMatchingY = false;
        if (modelNode.getAnd() != null) {
            this.m_terminator = null;
            view = this.getNodeView(modelNode.getAnd());
            view.repositionNode(tree, this, 1, maxX, maxY);
            if (this.y == this.getAndNodeView().y) {
                fMatchingY = true;
            }
            if (this.getAndNodeView() != null && this.getAndNodeView().y > this.y) {
                this.y = this.getAndNodeView().y;
            }
            this._verifyPathIsClearToChild(tree, this.getAndNodeView());
        } else {
            this.addTerminator();
        }
        if (this.getAndNodeView() != null && this.y == this.getAndNodeView().y) {
            fMatchingY = true;
        }
        this._verifyPositionOfNodeIsClear(tree);
        if (fMatchingY && this.y != this.getAndNodeView().y) {
            FilterNodeView[] parentArray;
            FilterNodeView nextAndNode;
            FilterNodeView previousView = this;
            int previousY = nextAndNode.y;
            for (nextAndNode = this.getAndNodeView(); nextAndNode != null && previousView.equals((parentArray = nextAndNode.getParentViews())[0]); nextAndNode = nextAndNode.getAndNodeView()) {
                previousY = nextAndNode.y;
                nextAndNode.y = this.y;
                if (nextAndNode.getTerminator() != null) {
                    nextAndNode.addTerminator();
                    break;
                }
                previousView = nextAndNode;
                if (previousY == nextAndNode.y) continue;
                break;
            }
        }
        if ((view = this.getOrNodeView()) != null) {
            view.repositionNode(tree, this, 2, maxX, maxY);
        }
    }

    protected void _verifyPositionOfNodeIsClear(FilterTreeView tree) {
        Vector nodeList = new Vector();
        Rectangle thisRect = this.getBounds();
        thisRect.x -= INTER_NODE_AND_SPACE - 1;
        thisRect.y -= INTER_NODE_OR_SPACE - 1;
        thisRect.width += INTER_NODE_AND_SPACE * 2 - 2;
        thisRect.height += INTER_NODE_OR_SPACE * 2 - 2;
        if (this.m_terminator != null) {
            thisRect.width += this.m_terminator.width;
        }
        boolean fPositionUnchanged = false;
        FilterTree treeModel = tree.getModel();
        treeModel.getNodesVector(nodeList, tree.getRoot().getNode());
        while (!fPositionUnchanged) {
            fPositionUnchanged = true;
            for (int index = 0; index < nodeList.size(); ++index) {
                FilterNode node = (FilterNode)nodeList.elementAt(index);
                Rectangle otherRect = this.getNodeView(node).getBounds();
                if (node.equals(this.getNode()) || otherRect.x == 0) continue;
                Terminator otherTerminator = this.getNodeView(node).getTerminator();
                if (otherTerminator != null) {
                    otherRect.width += otherTerminator.width;
                } else if (this.getNodeView(node).getAndNodeView() != null) {
                    FilterNodeView child = this.getNodeView(node).getAndNodeView();
                    int startX = this.x + this.width + 1;
                    int endX = child.x - 1;
                    int midpointX = endX - INTER_NODE_AND_SPACE / 3 * 2 - 1;
                    otherRect.width += midpointX - startX;
                }
                if (!thisRect.intersects(otherRect)) continue;
                this.translate(0, this.height + INTER_NODE_OR_SPACE);
                thisRect.translate(0, this.height + INTER_NODE_OR_SPACE);
                fPositionUnchanged = false;
                if (this.m_terminator == null) continue;
                this.addTerminator();
            }
        }
    }

    protected void _verifyPathIsClearToChild(FilterTreeView tree, FilterNodeView child) {
        Vector nodeList = new Vector();
        boolean fPositionUnchanged = false;
        int startX = this.x + this.width + 1;
        int startY = this.y + 27;
        int endX = child.x - 1;
        int endY = child.y + 27;
        int midpointX = endX - INTER_NODE_AND_SPACE / 3 * 2;
        Rectangle startRect = new Rectangle(startX, startY, midpointX - startX, 3);
        Rectangle upwardRect = new Rectangle(midpointX, endY, 3, startY - endY);
        FilterTree treeModel = tree.getModel();
        treeModel.getNodesVector(nodeList, tree.getRoot().getNode());
        while (!fPositionUnchanged) {
            fPositionUnchanged = true;
            for (int index = 0; index < nodeList.size(); ++index) {
                FilterNode node = (FilterNode)nodeList.elementAt(index);
                Rectangle otherRect = this.getNodeView(node).getBounds();
                if (node.equals(this.getNode()) || otherRect.x == 0) continue;
                Terminator otherTerminator = this.getNodeView(node).getTerminator();
                if (otherTerminator != null) {
                    otherRect.width += otherTerminator.width;
                } else if (this.getNodeView(node).getAndNodeView() != null) {
                    // empty if block
                }
                if (startRect.intersects(otherRect)) {
                    this.translate(0, this.height + INTER_NODE_OR_SPACE);
                    startRect.translate(0, this.height + INTER_NODE_OR_SPACE);
                    upwardRect.translate(0, this.height + INTER_NODE_OR_SPACE);
                    fPositionUnchanged = false;
                }
                if (!upwardRect.intersects(otherRect)) continue;
                child.translate(otherRect.x + otherRect.width - upwardRect.x + INTER_NODE_OR_SPACE / 2, 0);
                child.repositionNode(tree, this, 1, 0, 0);
            }
        }
    }

    public void updateDataFlowAnalysisInformation() {
        FilterNode modelNode = this.getNode();
        this.m_countMessage = null;
        this.m_nodeErrorMessage = null;
        this.m_nodeRecordCount = 0L;
        this.setCountMessageColor(Color.black);
        if (!this.getTreeView().is3DEnabled()) {
            this.m_depthOfNode = 1;
            return;
        }
        boolean bNeedToReexecute = true;
        if (bNeedToReexecute) {
            this.m_nodeRecordCount = this.getTreeView().getRowCount(this.getTreeView().getNodeCountStringQuery(modelNode));
            this.m_countMessage = bundle.messageString("Message.Node.Count.fmt.txt", new Long(this.m_nodeRecordCount));
            this.m_depthOfNode = Math.round((float)this.m_nodeRecordCount * 11.0f / (float)this.getTreeView().getTotalRowCount());
            ++this.m_depthOfNode;
            this.m_nodeErrorMessage = this.getNodeCountError();
            if (this.m_nodeErrorMessage != null) {
                this.setCountMessageColor(Color.red);
                this.width = this.getWidthToAccomodateErrorString(this.m_nodeErrorMessage);
                this.getTreeView().update();
                if (this.m_terminator != null) {
                    this.addTerminator();
                }
            }
        }
    }

    public void updateMessageColorInfo() {
        FilterNode modelNode = this.getNode();
        String errorMessage = this.getNodeCountError();
        if (errorMessage != null) {
            this.setCountMessageColor(Color.red);
            return;
        }
        this.setCountMessageColor(Color.black);
        Vector nodesChildren = this.getNodeViewChildren(modelNode);
        for (int j = 0; j < nodesChildren.size(); ++j) {
            FilterNode child = (FilterNode)nodesChildren.elementAt(j);
            if (this.getNodeRecordCount() != this.getTreeView().getNodeView(child).getNodeRecordCount()) continue;
            this.setCountMessageColor(Color.red);
        }
    }

    public int getWidthToAccomodateErrorString(String message) {
        int newWidth = this.width;
        if (message != null) {
            FontMetrics fontmetrics = this.getParent().getGraphics().getFontMetrics(DrawUtil.getSmallFont());
            ImageIcon xIcon = ImageHandler.getImageIcon(bundle, "xIcon");
            if (xIcon != null && fontmetrics.stringWidth(message) + xIcon.getIconWidth() + 6 >= this.width) {
                newWidth = fontmetrics.stringWidth(message) + xIcon.getIconWidth() + 9;
                if (newWidth > 240) {
                    newWidth = 240;
                } else {
                    int remainder = newWidth % 16;
                    if (remainder != 0) {
                        newWidth += 16 - remainder;
                    }
                }
            }
        }
        return newWidth;
    }

    @Override
    protected void paintView(Graphics g) {
        FilterNode modelNode = this.getNode();
        if (modelNode == null) {
            return;
        }
        Rectangle rect = this.getBounds();
        DrawUtil.drawRoundedBoxWithDepthAndRecordCount(this.getTreeView(), g, SystemColor.window, this.light, this.dark, this.x, this.y, this.width, this.height, this.m_depthOfNode, this.m_countMessage, this.m_nodeErrorMessage, this.getCountMessageColor());
        if (this.isSelected()) {
            g.setColor(SystemColor.textText);
            DrawUtil.drawFocusRect(g, this.x + 6, this.y + 6, this.width - 13, this.height - 13);
        }
        Graphics stringG = g.create();
        Shape clip = stringG.getClip();
        Rectangle newClip = new Rectangle(rect.x, rect.y, rect.width - 8, rect.height);
        stringG.clipRect(newClip.x, newClip.y, newClip.width, newClip.height);
        stringG.setColor(SystemColor.textText);
        if (modelNode.getLimitString() != null) {
            stringG.drawString(modelNode.getLimitString(), this.x + 6, this.y + this.m_lineHeight + this.m_ascent + 1 + 1);
            if (6 + this.m_limitStringLength > rect.width - 8) {
                int elipsisStartX = rect.x + rect.width - (8 + this.m_elipsisLength);
                int elipsisStartY = this.y + this.m_lineHeight + this.m_ascent + 1 + 1;
                stringG.setColor(SystemColor.window);
                stringG.fillRect(elipsisStartX, elipsisStartY - this.m_lineHeight, this.m_elipsisLength, this.m_lineHeight);
                stringG.setColor(SystemColor.textText);
                stringG.drawString(ELIPSIS_STRING, elipsisStartX, elipsisStartY);
            }
        }
        stringG.setClip(clip);
        stringG.dispose();
        if (this.getAndNodeView() != null) {
            boolean bNeedAndTee = false;
            FilterNode andChild = this.getAndNodeView().getNode();
            if (andChild != null && andChild.getAndParents().size() > 2) {
                bNeedAndTee = true;
                Vector parents = andChild.getAndParents();
                for (int index = 0; index < parents.size(); ++index) {
                    FilterNode node = (FilterNode)parents.elementAt(index);
                    if (node != this.getNode() || index != parents.size() - 1 && index >= 2) continue;
                    bNeedAndTee = false;
                    break;
                }
            }
            DrawUtil.drawPipe(this.getTreeView(), g, this.getBounds(), this.getAndNodeView().getBounds(), bNeedAndTee);
            if (rect.y == this.getAndNodeView().y || this.getAndNodeView().x - (rect.x + rect.width) > INTER_NODE_AND_SPACE) {
                g.setColor(SystemColor.control.darker());
                if (this.getTreeView().is3DEnabled()) {
                    INTER_NODE_AND_SPACE_DIVISOR = 5;
                }
                g.drawString(AND_DISPLAY_STRING, rect.x + rect.width + INTER_NODE_AND_SPACE / INTER_NODE_AND_SPACE_DIVISOR, rect.y + this.m_lineHeight);
            }
        }
        if (this.getOrNodeView() != null) {
            DrawUtil.drawPipe(this.getTreeView(), g, this.getBounds(), this.getOrNodeView().getBounds(), this.getNode().getOrParent() != null || this == this.getTreeView().getRoot());
            g.setColor(SystemColor.control.darker());
            int xORLocation = rect.x + INTER_NODE_AND_SPACE;
            if (this.getTreeView().is3DEnabled()) {
                xORLocation = rect.x - 5;
            }
            g.drawString(OR_DISPLAY_STRING, xORLocation, rect.y + rect.height + (this.getOrNodeView().y - (rect.y + rect.height)) / 2 + (this.m_lineHeight - 1) / 3);
        }
        if (this.m_terminator != null) {
            this.m_terminator.paintView(g, this);
        }
    }

    public static void paintPipe(Graphics g, Color background, Rectangle parentRect, Rectangle childRect) {
        Color dark = background.darker().darker();
        Color light = background.brighter();
        Color midLight = new Color(0xD0D0D0);
        int startX = parentRect.x + parentRect.width + 1;
        int startY = parentRect.y + 27;
        int endX = childRect.x - 1;
        int endY = childRect.y + 27;
        int pipeSize = 3;
        if (startY < endY) {
            startX = parentRect.x - INTER_NODE_AND_SPACE / 3;
            g.setColor(dark);
            g.drawLine(startX + pipeSize, startY + pipeSize, startX + pipeSize, endY - 1);
            g.drawLine(startX + 1, endY + pipeSize, endX, endY + pipeSize);
            g.setColor(light);
            g.drawLine(startX, startY + pipeSize, startX, endY + pipeSize - 1);
            g.drawLine(startX + pipeSize + 1, endY, endX, endY);
            g.setColor(midLight);
            g.fillRect(startX + 1, startY + 1, pipeSize - 1, endY - startY);
            g.fillRect(startX + 1, endY + 1, endX - startX + 2, pipeSize - 1);
        } else if (startY > endY) {
            int midpointX = endX - INTER_NODE_AND_SPACE / 3 * 2;
            g.setColor(midLight);
            g.fillRect(startX - 1, startY, midpointX - startX + 2, pipeSize);
            g.fillRect(midpointX + 1, endY + 1, pipeSize - 1, startY - endY + pipeSize - 1);
            g.setColor(light);
            g.drawLine(startX, startY, midpointX, startY);
            g.drawLine(midpointX, startY, midpointX, endY + pipeSize);
            g.setColor(dark);
            g.drawLine(startX, startY + pipeSize, midpointX + pipeSize - 1, startY + pipeSize);
            g.drawLine(midpointX + pipeSize, startY + pipeSize - 1, midpointX + pipeSize, endY + pipeSize);
        } else {
            g.setColor(midLight);
            g.fillRect(startX - 1, startY, endX - startX + 3, pipeSize);
            g.setColor(light);
            g.drawLine(startX, startY, endX, endY);
            g.setColor(SystemColor.control.darker());
            if (endX - startX > INTER_NODE_AND_SPACE - 3) {
                g.drawString(AND_DISPLAY_STRING, startX + 3, startY - 2);
            }
            g.setColor(dark);
            g.drawLine(startX, startY + pipeSize, endX, endY + pipeSize);
        }
    }
}

