/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionConstants;
import com.sas.query.datasources.FunctionList;
import com.sas.query.datasources.FunctionParameter;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.ConstantExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.ExpressionList;
import com.sas.query.models.FilterNode;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.visuals.DataBaseUIRequest;
import com.sas.query.visuals.ExpressionEditPanel;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelperConstants;
import com.sas.query.visuals.SqlTextPanel;
import com.sas.query.visuals.SqlTextPanelPlus;
import com.sas.query.visuals.WindowUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FilterEditDialog
extends JDialog
implements ExpressionConstants,
FunctionConstants,
SqlTextHelperConstants {
    Query m_query;
    FilterNode m_nodeModel;
    boolean m_bReturnActionIsOK = false;
    Expression m_expression = null;
    boolean m_editMode = false;
    String m_sSQLBeforeEdit;
    boolean m_bWindowMapped = false;
    FunctionList m_validConditionals = null;
    boolean m_bIncludeNulls = false;
    boolean m_distinctValuesButtonVisible = false;
    boolean m_thirdParmVisible = false;
    boolean processingValueChanges = false;
    boolean ignoreNextOperatorChange = false;
    ListSelectionListener m_listSelectionListener = null;
    static int editGrowthAmountX = 250;
    static int editGrowthAmountY = 60;
    static int querySupportsDistinctValsQueries = -1;
    protected JPanel panelRHSWidgets;
    protected JButton bedit;
    protected JButton bdistinct;
    protected JButton bhelp;
    protected JCheckBox cnot;
    protected JCheckBox cincludenulls;
    protected JList ldata;
    protected SqlTextPanel evalue;
    protected SqlTextPanel evalue2;
    protected JButton bOK;
    protected SqlTextPanel ecolumnname;
    protected JLabel edummy;
    protected JButton bcancel;
    protected JComboBox coperator;
    protected ExpressionEditPanel expressionEditorPanel;
    protected JScrollPane ldataPane;
    protected boolean m_forceEditMode = false;
    protected HelperListener m_helperListener;
    protected EscapeKeyListener anEscapeKeyListener;
    protected SymAction lSymAction;
    protected SymItem lSymItem;
    protected AppCloser m_appCloser;
    static QueryResource bundle = new QueryResource(FilterEditDialog.class);
    static final int VALUE_REMOVED = 1;
    static final int VALUE_ADDED = 2;

    private void makeHelperFields() {
        this.evalue = new SqlTextPanelPlus(1);
        this.evalue2 = new SqlTextPanelPlus(1);
        this.ecolumnname = new SqlTextPanelPlus(1);
        this.evalue.setBehavior(512);
        this.evalue2.setBehavior(512);
        this.ecolumnname.setBehavior(2560);
    }

    public FilterEditDialog(Query query, Frame parentFrame, FilterNode nodeModel) {
        this(query, parentFrame, nodeModel, true);
    }

    public FilterEditDialog(Query query, Frame parentFrame, FilterNode nodeModel, boolean asIs) {
        super(parentFrame, " ", true);
        this.setResizable(true);
        this.m_query = query;
        this.m_nodeModel = nodeModel;
        this.m_expression = null;
        this.setDefaultCloseOperation(2);
        if (nodeModel != null) {
            this.m_expression = nodeModel.getNodeData();
        }
        if (this.m_expression == null) {
            ExpressionList expressionList = new ExpressionList();
            ColumnExpression toAdd = new ColumnExpression(nodeModel.getColumn());
            expressionList.addElement(toAdd);
            if (this.getValidConditionals().size() < 1) {
                this.m_query.getMessageHandler().addError(bundle, "FilterEditDialog.noValidConditionals.txt");
                return;
            }
            this.m_expression = new CompoundExpression(this.getValidConditionals().elementAt(0), expressionList);
            if (!asIs) {
                asIs = true;
            }
        } else {
            try {
                this.m_expression = (Expression)this.m_expression.clone();
                if (!asIs) {
                    ExpressionList expressionList = new ExpressionList();
                    expressionList.addElement(this.m_expression);
                    if (this.getValidConditionals().size() < 1) {
                        this.m_query.getMessageHandler().addError(bundle, "FilterEditDialog.noValidConditionals.txt");
                    } else {
                        this.m_expression = new CompoundExpression(this.getValidConditionals().elementAt(0), expressionList);
                    }
                }
            }
            catch (Throwable e) {
                this.m_query.getMessageHandler().addInternalError(bundle.getString("CommonUI.CloneException.txt") + e);
            }
        }
        if (CompoundExpression.isWrappedWithOrIsNull(this.m_expression, this.m_query)) {
            this.setExpression(CompoundExpression.unwrapIfHasOrIsNull(this.m_expression, this.m_query));
            this.setWrapgui(true);
        } else {
            this.setExpression(this.m_expression);
            this.setWrapgui(false);
        }
        this.init();
    }

    public boolean isReturnActionOK() {
        return this.m_bReturnActionIsOK;
    }

    private void setForceEdit(boolean val) {
        this.m_forceEditMode = val;
    }

    private boolean getForceEdit() {
        return this.m_forceEditMode;
    }

    private void setWrapgui(boolean newVal) {
        this.m_bIncludeNulls = newVal;
    }

    private boolean getWrapgui() {
        return this.m_bIncludeNulls;
    }

    private Expression getWrappedExpression() {
        if (this.isEdited()) {
            this.setWrapgui(false);
        }
        if (this.getWrapgui()) {
            return CompoundExpression.wrapWithOrIsNull(this.m_expression, this.m_query);
        }
        return this.m_expression;
    }

    private Expression getExpression() {
        return this.m_expression;
    }

    private void setExpression(Expression expression) {
        this.m_expression = expression;
    }

    protected boolean isEdited() {
        if (this.getForceEdit()) {
            return true;
        }
        if (!(this.m_expression instanceof CompoundExpression)) {
            return true;
        }
        CompoundExpression ce = (CompoundExpression)this.m_expression;
        return ce.getCurrentFunction().getFunctionType() == 64;
    }

    protected boolean isCompound() {
        return !this.isEdited();
    }

    protected CompoundExpression getCompound() {
        return (CompoundExpression)this.m_expression;
    }

    protected UnparsedExpression getUnparsed() {
        return (UnparsedExpression)this.m_expression;
    }

    private FunctionList getValidConditionals() {
        if (this.m_validConditionals == null) {
            if (this.m_nodeModel.getColumn() != null) {
                this.m_validConditionals = this.m_query.getDataSourceFunctions().getSubset(null, this.m_nodeModel.getColumn().getDataType(), 32768);
                if (!this.m_nodeModel.getColumn().isNullable()) {
                    this.m_validConditionals.removeByName("ISNULL");
                }
            } else {
                this.m_validConditionals = this.m_query.getDataSourceFunctions().getSubsetByReturnType(32768).getSubsetByPrimaryParmType(4095);
            }
        }
        this.m_validConditionals = this.m_validConditionals.removeByType(64);
        return this.m_validConditionals;
    }

    private Function getCurrentConditional() {
        return this.getCompound().getCurrentFunction();
    }

    private ExpressionList getRHSParameters() {
        if (this.isEdited()) {
            return new ExpressionList();
        }
        ExpressionList currentParms = this.getCompound().getParameters();
        ExpressionList x = new ExpressionList(currentParms.size() + 1);
        for (int i = 1; i < currentParms.size(); ++i) {
            x.addElement(currentParms.elementAt(i));
        }
        return x;
    }

    private Expression getLHSParameter() {
        Expression retExp = null;
        ExpressionList currentParms = this.getCompound().getParameters();
        if (currentParms.size() > 0) {
            retExp = currentParms.elementAt(0);
        }
        return retExp;
    }

    private Expression getRHSParameter(int i) {
        Expression retExp = null;
        ExpressionList currentParms = this.getCompound().getParameters();
        if (currentParms.size() > i + 1) {
            retExp = currentParms.elementAt(i + 1);
        }
        return retExp;
    }

    private void clearRHSParameters() {
        Expression leftParm = this.getLHSParameter();
        this.getCompound().clearParms();
        if (leftParm != null) {
            this.addRHSParameter(leftParm);
        }
    }

    private void addRHSParameter(Expression e) {
        this.getCompound().addParameter(e);
    }

    private boolean setCurrentConditional(Function newOp) {
        if (this.coperator.getSelectedItem() != newOp) {
            this.coperator.setSelectedItem(newOp);
            this.getCompound().setCurrentFunction(newOp);
        }
        return this.coperator.getSelectedItem() == newOp;
    }

    private void setOperatorForKeyPressed(char pressedChar) {
        Function newOp = this.m_query.getConditionalByShortCut(pressedChar);
        if (newOp != this.getCurrentConditional() && newOp != null) {
            this.setCurrentConditional(newOp);
        }
    }

    @Override
    public void dispose() {
        this.removeAllListeners();
        this.removeAll();
        super.dispose();
    }

    private void addAllListeners() {
        this.lSymAction = new SymAction();
        this.bdistinct.addActionListener(this.lSymAction);
        this.bOK.addActionListener(this.lSymAction);
        this.bcancel.addActionListener(this.lSymAction);
        this.bedit.addActionListener(this.lSymAction);
        this.lSymItem = new SymItem();
        this.coperator.addItemListener(this.lSymItem);
        this.m_listSelectionListener = new ListSelListener();
        this.ldata.addListSelectionListener(this.m_listSelectionListener);
        this.cincludenulls.addItemListener(this.lSymItem);
        this.cnot.addItemListener(this.lSymItem);
        this.anEscapeKeyListener = new EscapeKeyListener();
        this.coperator.addKeyListener(this.anEscapeKeyListener);
        this.ldata.addKeyListener(this.anEscapeKeyListener);
        this.evalue.addKeyListener(this.anEscapeKeyListener);
        this.evalue.getWidget().addKeyListener(this.anEscapeKeyListener);
        this.evalue2.addKeyListener(this.anEscapeKeyListener);
        this.evalue2.getWidget().addKeyListener(this.anEscapeKeyListener);
        this.cnot.addKeyListener(this.anEscapeKeyListener);
        this.cincludenulls.addKeyListener(this.anEscapeKeyListener);
        this.ecolumnname.addKeyListener(this.anEscapeKeyListener);
        this.ecolumnname.getWidget().addKeyListener(this.anEscapeKeyListener);
        this.bOK.addKeyListener(this.anEscapeKeyListener);
        this.bcancel.addKeyListener(this.anEscapeKeyListener);
        this.bdistinct.addKeyListener(this.anEscapeKeyListener);
        this.m_helperListener = new HelperListener();
        this.evalue.getHelper().addPropertyChangeListener(this.m_helperListener);
        this.evalue2.getHelper().addPropertyChangeListener(this.m_helperListener);
        this.ecolumnname.getHelper().addPropertyChangeListener(this.m_helperListener);
        this.m_appCloser = new AppCloser();
        this.addWindowListener(this.m_appCloser);
    }

    private void removeAllListeners() {
        if (this.m_helperListener != null) {
            this.evalue.getHelper().removePropertyChangeListener(this.m_helperListener);
            this.evalue2.getHelper().removePropertyChangeListener(this.m_helperListener);
            this.ecolumnname.getHelper().removePropertyChangeListener(this.m_helperListener);
            this.m_helperListener = null;
        }
        if (this.anEscapeKeyListener != null) {
            this.coperator.removeKeyListener(this.anEscapeKeyListener);
            this.ldata.removeKeyListener(this.anEscapeKeyListener);
            this.evalue.removeKeyListener(this.anEscapeKeyListener);
            this.evalue.getWidget().removeKeyListener(this.anEscapeKeyListener);
            this.evalue2.removeKeyListener(this.anEscapeKeyListener);
            this.evalue2.getWidget().removeKeyListener(this.anEscapeKeyListener);
            this.cnot.removeKeyListener(this.anEscapeKeyListener);
            this.cincludenulls.removeKeyListener(this.anEscapeKeyListener);
            this.ecolumnname.removeKeyListener(this.anEscapeKeyListener);
            this.ecolumnname.getWidget().removeKeyListener(this.anEscapeKeyListener);
            this.bOK.removeKeyListener(this.anEscapeKeyListener);
            this.bcancel.removeKeyListener(this.anEscapeKeyListener);
            this.bdistinct.removeKeyListener(this.anEscapeKeyListener);
            this.anEscapeKeyListener = null;
        }
        if (this.lSymAction != null) {
            this.bdistinct.removeActionListener(this.lSymAction);
            this.bOK.removeActionListener(this.lSymAction);
            this.bcancel.removeActionListener(this.lSymAction);
            this.bedit.removeActionListener(this.lSymAction);
            this.lSymAction = null;
        }
        if (this.lSymItem != null) {
            this.coperator.removeItemListener(this.lSymItem);
            this.cincludenulls.removeItemListener(this.lSymItem);
            this.cnot.removeItemListener(this.lSymItem);
            this.lSymItem = null;
        }
        if (this.m_appCloser != null) {
            this.removeWindowListener(this.m_appCloser);
            this.m_appCloser = null;
        }
        if (this.expressionEditorPanel != null) {
            this.expressionEditorPanel.removeAllListeners();
            this.getContentPane().remove(this.expressionEditorPanel);
            this.expressionEditorPanel = null;
        }
        this.m_query = null;
        this.m_nodeModel = null;
        this.m_expression = null;
        this.panelRHSWidgets = null;
        this.bedit = null;
        this.bdistinct = null;
        this.bhelp = null;
        this.cnot = null;
        this.cincludenulls = null;
        this.ldata = null;
        this.evalue = null;
        this.evalue2 = null;
        this.bOK = null;
        this.ecolumnname = null;
        this.edummy = null;
        this.bcancel = null;
        this.coperator = null;
        this.ldataPane = null;
    }

    private synchronized void init() {
        this.m_query.enableHelpKey(this.getContentPane(), "Dialog.FilterEdit");
        this.setVisible(false);
        this.setSize(this.getInsets().left + this.getInsets().right + 440, this.getInsets().top + this.getInsets().bottom + 295);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.makeHelperFields();
        this.ecolumnname.clearBehavior(16);
        this.ecolumnname.setBehavior(2048);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(14, 5, 5, 5);
        gridBagLayout.setConstraints(this.ecolumnname, gbc);
        this.getContentPane().add(this.ecolumnname);
        this.cnot = new JCheckBox(bundle.getString("FilterEditDialog.notCheckBoxLabel.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 10, 5, -4);
        gbc.anchor = 13;
        gridBagLayout.setConstraints(this.cnot, gbc);
        this.getContentPane().add(this.cnot);
        this.coperator = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 4, 4, 4);
        gridBagLayout.setConstraints(this.coperator, gbc);
        this.getContentPane().add(this.coperator);
        this.coperator.setRenderer(new MyComboRenderer());
        this.panelRHSWidgets = new JPanel();
        GridBagLayout rhsLayout = new GridBagLayout();
        this.panelRHSWidgets.setLayout(rhsLayout);
        this.evalue.clearBehavior(16);
        GridBagConstraints evalue1gbc = new GridBagConstraints();
        evalue1gbc.gridx = 0;
        evalue1gbc.gridy = 0;
        evalue1gbc.anchor = 17;
        evalue1gbc.weighty = 1.0;
        evalue1gbc.weightx = 1.0;
        evalue1gbc.fill = 1;
        rhsLayout.setConstraints(this.evalue, evalue1gbc);
        this.panelRHSWidgets.add(this.evalue);
        this.evalue2.clearBehavior(16);
        GridBagConstraints evalue2gbc = new GridBagConstraints();
        evalue2gbc.gridx = 1;
        evalue2gbc.gridy = 0;
        evalue2gbc.weightx = 1.0;
        evalue2gbc.weighty = 1.0;
        evalue2gbc.anchor = 13;
        evalue2gbc.fill = 1;
        rhsLayout.setConstraints(this.evalue2, evalue2gbc);
        this.panelRHSWidgets.add(this.evalue2);
        this.evalue2.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 10, 5);
        gridBagLayout.setConstraints(this.panelRHSWidgets, gbc);
        this.getContentPane().add(this.panelRHSWidgets);
        this.bdistinct = new JButton();
        this.bdistinct.setActionCommand("button");
        this.bdistinct.setText(bundle.getString("FilterEditDialog.distinctValuesButtonLabel.txt"));
        this.bdistinct.setToolTipText(bundle.getString("FilterEditDialog.DistinctValuesTooltip.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 14, 5, 5);
        gridBagLayout.setConstraints(this.bdistinct, gbc);
        this.getContentPane().add(this.bdistinct);
        this.ldata = new JList();
        this.ldata.setModel(new DefaultListModel());
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 4;
        gbc.gridheight = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.ldataPane = new JScrollPane(this.ldata, 20, 30);
        WindowUtil.fixupJScrollPane(this.ldataPane);
        gridBagLayout.setConstraints(this.ldataPane, gbc);
        this.getContentPane().add(this.ldataPane);
        this.bedit = new JButton();
        this.bedit.setActionCommand("button");
        this.bedit.setText(bundle.getString("FilterEditDialog.editSQLButtonLabel.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 14, 5, 5);
        gridBagLayout.setConstraints(this.bedit, gbc);
        this.getContentPane().add(this.bedit);
        this.edummy = new JLabel(" ", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(16, 5, 5, 5);
        gridBagLayout.setConstraints(this.edummy, gbc);
        this.edummy.setEnabled(false);
        this.getContentPane().add(this.edummy);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.gridheight = 8;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(4, 5, 5, 5);
        this.expressionEditorPanel = new ExpressionEditPanel(new UnparsedExpression(""), this.m_query);
        gridBagLayout.setConstraints(this.expressionEditorPanel, gbc);
        this.expressionEditorPanel.setVisible(false);
        this.getContentPane().add(this.expressionEditorPanel);
        this.cincludenulls = new JCheckBox(bundle.getString("FilterEditDialog.includeNullsCheckBoxLabel.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 8;
        gbc.gridwidth = 6;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 10, 5);
        gridBagLayout.setConstraints(this.cincludenulls, gbc);
        this.getContentPane().add(this.cincludenulls);
        this.bOK = new JButton();
        this.bOK.setActionCommand("button");
        this.bOK.setText(bundle.getString("Common.OK.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(14, 5, 5, 14);
        gridBagLayout.setConstraints(this.bOK, gbc);
        this.getContentPane().add(this.bOK);
        this.bcancel = new JButton();
        this.bcancel.setActionCommand("button");
        this.bcancel.setText(bundle.getString("Common.Cancel.txt"));
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 14);
        gridBagLayout.setConstraints(this.bcancel, gbc);
        this.getContentPane().add(this.bcancel);
        this.bhelp = new JButton();
        boolean bHelpIsAvailable = this.m_query.enableHelpButton(this.bhelp, "Dialog.FilterEdit");
        if (bHelpIsAvailable) {
            this.bhelp.setText(bundle.getString("Common.Help.txt"));
            gbc = new GridBagConstraints();
            gbc.gridx = 6;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 5, 14);
            gridBagLayout.setConstraints(this.bhelp, gbc);
            this.getContentPane().add(this.bhelp);
        } else {
            this.bhelp = null;
        }
        this.setTitle("");
        this.configureWindow();
        this.setTitle(bundle.getString("FilterEditDialog.Title.txt"));
        this.addAllListeners();
        this.evalue.getWidget().requestDefaultFocus();
        this.evalue.getWidget().requestFocus();
    }

    public void configureWindow() {
        if (this.isCompound()) {
            this.ecolumnname.setParentExpression((CompoundExpression)this.m_expression, 0, this.m_query);
            this.evalue.setParentExpression((CompoundExpression)this.m_expression, 1, this.m_query);
            this.evalue2.setParentExpression((CompoundExpression)this.m_expression, 2, this.m_query);
            this.ecolumnname.attachToParent();
            FunctionList condList = this.getValidConditionals();
            condList.sortByName();
            try {
                Function equalsFun = condList.getSubsetByName("=").elementAt(0);
                Function inFun = condList.getSubsetByName("IN").elementAt(0);
                int equalsIndex = condList.indexOf(equalsFun);
                int inIndex = condList.indexOf(inFun);
                if (equalsIndex + 1 != inIndex) {
                    condList.removeElementAt(inIndex);
                    condList.insertElementAt(inFun, equalsIndex + 1);
                }
            }
            catch (Throwable equalsFun) {
                // empty catch block
            }
            for (int index = 0; index < condList.size(); ++index) {
                this.coperator.addItem(condList.elementAt(index));
            }
            boolean success = this.setCurrentConditional(this.getCompound().getCurrentFunction());
            if (success) {
                this.setForceEdit(false);
                int numMaxParmDefs = ((CompoundExpression)this.m_expression).getCurrentFunction().getMaxParmDefs();
                if (this.getRHSParameter(0) == null || numMaxParmDefs < 2) {
                    if (numMaxParmDefs < 2) {
                        this.conditionOneParmOnly();
                    } else {
                        int expType = this.ecolumnname.getExpectedType();
                        this.evalue.setExpectedType(expType);
                        String primeContents = new FunctionParameter("", "", expType).generateTemplate().toString();
                        this.evalue.setExpression(new UnparsedExpression(primeContents));
                        String tooltip = this.m_query.getSqlLogic().getFormatExample(expType);
                        if (tooltip != null) {
                            this.evalue.getWidget().setToolTipText(tooltip);
                        }
                    }
                } else {
                    this.evalue.attachToParent();
                    if (!this.evalue.isCommaList() && numMaxParmDefs > 2) {
                        this.evalue2.attachToParent();
                    }
                }
            } else {
                this.setForceEdit(true);
            }
        }
        if (this.isEdited()) {
            this.tweakForEditOnlyDisplay();
            this.displayEditedExpression();
        } else {
            this.displayCompoundExpression();
        }
        this.m_bWindowMapped = true;
    }

    private void tweakForEditOnlyDisplay() {
        this.bdistinct.setVisible(false);
        this.edummy.setVisible(false);
        GridBagLayout g = (GridBagLayout)this.getContentPane().getLayout();
        GridBagConstraints con = g.getConstraints(this.expressionEditorPanel);
        con.insets.left = 14;
        g.setConstraints(this.expressionEditorPanel, con);
        Dimension d = this.getSize();
        this.setSize(d.width + editGrowthAmountX, d.height + editGrowthAmountY);
    }

    private void conditionOneParmOnly() {
        this.evalue.setVisible(false);
        this.bdistinct.setVisible(false);
        this.ldataPane.setVisible(false);
        this.conditionThirdParmWidget(false);
    }

    private void conditionNOTGuiOption() {
        if (this.isCompound() && this.getCompound().isNOTable()) {
            this.cnot.setSelected(((CompoundExpression)this.m_expression).isLogicalNegation());
            this.cnot.setVisible(true);
        } else {
            this.cnot.setVisible(false);
            this.cnot.setSelected(false);
            if (this.isCompound()) {
                this.getCompound().setLogicalNegation(false);
            }
        }
    }

    private void conditionAddNullGuiOption() {
        if (this.getCompound().canNullsBeIncluded()) {
            this.cincludenulls.setSelected(this.getWrapgui());
            this.cincludenulls.setVisible(true);
        } else {
            this.setWrapgui(false);
            this.cincludenulls.setVisible(false);
            this.cincludenulls.setSelected(this.getWrapgui());
        }
    }

    private void displayCompoundExpression() {
        WindowUtil.busyOn(this);
        try {
            if (querySupportsDistinctValsQueries == -1) {
                querySupportsDistinctValsQueries = QueryConfiguration.getConfigurationBoolean("Queries.DistinctValues.Enabled.notrans", true) ? 1 : 0;
            }
            boolean enableDistinctValues = true;
            if (querySupportsDistinctValsQueries == 0) {
                enableDistinctValues = false;
            }
            this.m_distinctValuesButtonVisible = enableDistinctValues;
            enableDistinctValues = this.shouldEnableDistinctVals();
            this.bedit.setText(bundle.getString("FilterEditDialog.editSQLButtonLabel.txt"));
            this.bdistinct.setVisible(this.m_distinctValuesButtonVisible);
            this.bdistinct.setEnabled(enableDistinctValues);
            this.setCurrentConditional(this.getCompound().getCurrentFunction());
            this.coperator.setVisible(true);
            this.panelRHSWidgets.setVisible(true);
            this.evalue.setVisible(true);
            this.ecolumnname.setVisible(true);
            this.conditionNOTGuiOption();
            this.conditionAddNullGuiOption();
            this.ldataPane.setVisible(true);
            this.expressionEditorPanel.setVisible(false);
            this.m_editMode = false;
            this.evalue.getWidget().requestFocus();
            this.updateGUI();
        }
        catch (Throwable t) {
            WindowUtil.busyOff(this);
            this.m_query.getMessageHandler().addInternalError(t);
        }
        WindowUtil.busyOff(this);
    }

    private void displayEditedExpression() {
        WindowUtil.busyOn(this);
        try {
            this.bedit.setText(bundle.getString("FilterEditDialog.cancelEditSQLButtonLabel.txt"));
            this.bdistinct.setEnabled(false);
            this.panelRHSWidgets.setVisible(false);
            this.coperator.setVisible(false);
            this.ldataPane.setVisible(false);
            this.cnot.setVisible(false);
            this.cincludenulls.setVisible(false);
            this.ecolumnname.setVisible(false);
            this.m_sSQLBeforeEdit = this.getWrappedExpression().generateSQL(this.m_query.getSqlLogic(), this.ecolumnname.hasBehavior(2048) ? 2 : 1);
            this.expressionEditorPanel.setText(this.m_sSQLBeforeEdit);
            this.expressionEditorPanel.setVisible(true);
            if (this.isEdited()) {
                this.bedit.setVisible(false);
            }
            this.m_editMode = true;
            this.updateGUI();
        }
        catch (Throwable t) {
            WindowUtil.busyOff(this);
            this.m_query.getMessageHandler().addInternalError(t);
        }
        WindowUtil.busyOff(this);
    }

    private void displayDistinctValues() {
        this.bdistinct.setEnabled(false);
        this.ldata.setEnabled(false);
        this.ldata.setBackground(SystemColor.window);
        WindowUtil.busyOn(this);
        try {
            ((DefaultListModel)this.ldata.getModel()).clear();
            ColumnExpression ce = (ColumnExpression)this.ecolumnname.getExpression();
            Vector vData = (Vector)new DataBaseUIRequest(this.m_query, this, bundle.getString("FilterEditDialog.gettingDistinctValues.txt")).exec(ce, "getDistinctValues");
            this.checkForErrors();
            if (vData != null) {
                Enumeration e = vData.elements();
                while (e.hasMoreElements()) {
                    String elementToAdd = (String)e.nextElement();
                    if (elementToAdd.trim().length() == 0) {
                        elementToAdd = "'" + elementToAdd + "'";
                    }
                    ((DefaultListModel)this.ldata.getModel()).addElement(elementToAdd);
                }
                this.updateListSelections();
                this.ldata.setEnabled(true);
                this.bdistinct.setEnabled(true);
            }
        }
        catch (Throwable t) {
            WindowUtil.busyOff(this);
            this.m_query.getMessageHandler().addInternalError(t);
        }
        WindowUtil.busyOff(this);
    }

    private void updateListSelections() {
        if (this.m_listSelectionListener != null) {
            this.ldata.removeListSelectionListener(this.m_listSelectionListener);
        }
        ExpressionList parameterList = this.getRHSParameters();
        this.clearListSels();
        block0: for (int index = 0; index < parameterList.size(); ++index) {
            Expression parameter = parameterList.elementAt(index);
            for (int i = this.ldata.getModel().getSize() - 1; i >= 0; --i) {
                if (parameter == null || !parameter.getDisplayString().equals(this.ldata.getModel().getElementAt(i).toString().trim()) || this.ldata.isSelectedIndex(i)) continue;
                this.ldata.addSelectionInterval(i, i);
                continue block0;
            }
        }
        if (this.m_listSelectionListener != null) {
            this.ldata.addListSelectionListener(this.m_listSelectionListener);
        }
    }

    private void updateGUI() {
        if (this.isCompound()) {
            if (this.getCurrentConditional().getMaxParms() > 1 && this.getCurrentConditional().getParmDef(1).isCommaList()) {
                this.ldata.setSelectionMode(2);
                this.conditionThirdParmWidget(false);
            } else if (this.getCurrentConditional().getMaxParmDefs() == 1) {
                this.conditionOneParmOnly();
                this.clearRHSParameters();
            } else {
                this.clearListSels();
                this.ldata.setSelectionMode(0);
                if (this.getCurrentConditional().getMaxParmDefs() == 3) {
                    this.conditionThirdParmWidget(true);
                } else {
                    this.conditionThirdParmWidget(false);
                }
            }
        }
        this.updateListSelections();
        this.validate();
    }

    private void clearListSels() {
        this.ldata.clearSelection();
    }

    void coperator_ItemStateChanged(ItemEvent event) {
        Function newOp;
        if (event.getStateChange() == 2) {
            return;
        }
        Function previousOp = this.getCurrentConditional();
        if (previousOp == (newOp = (Function)event.getItem())) {
            return;
        }
        this.getCompound().setCurrentFunction(newOp);
        this.nukeLeftOverExpressions();
        this.evalue.recomputeDisplay();
        this.evalue2.recomputeDisplay();
        this.displayCompoundExpression();
    }

    void nukeLeftOverExpressions() {
        int numMaxParms = this.getCompound().getCurrentFunction().getMaxParms();
        ExpressionList currentParms = this.getCompound().getParameters();
        int i = numMaxParms;
        while (i < currentParms.size()) {
            currentParms.removeElementAt(numMaxParms);
        }
    }

    private void textArea1_TextValueChanged() {
    }

    void manageBetweenFieldValues(Expression newExp) {
        if (this.evalue.isContentReplaceable() && this.evalue2.isContentReplaceable()) {
            this.evalue2.setExpression(this.evalue.getExpression());
            this.evalue.setExpression(newExp);
        } else if (this.evalue.isContentReplaceable()) {
            this.evalue.setExpression(newExp);
        } else if (this.evalue2.isContentReplaceable()) {
            this.evalue2.setExpression(newExp);
        } else {
            Expression newLeft = this.evalue2.getExpression();
            this.evalue.setExpression(newLeft);
            this.evalue2.setExpression(newExp);
        }
    }

    void bdistinct_Action(ActionEvent event) {
        this.displayDistinctValues();
    }

    private void conditionThirdParmWidget(boolean yesorno) {
        this.m_thirdParmVisible = yesorno;
        if (yesorno) {
            this.evalue2.setVisible(true);
            this.evalue2.attachToParent();
            this.evalue.recomputeDisplay();
            this.validate();
        } else {
            if (this.evalue2.isShowing()) {
                this.evalue2.setVisible(false);
                this.evalue2.detachFromParent();
            }
            this.validate();
            this.evalue.recomputeDisplay();
        }
    }

    void bOK_Action(ActionEvent event) {
        if (this.checkForErrors()) {
            return;
        }
        this.m_bReturnActionIsOK = true;
        if (this.m_editMode) {
            this.setExpression(this.expressionEditorPanel.getExpression());
            this.m_nodeModel.setNodeData(this.getWrappedExpression());
            this.dispose();
        } else if (this.getCompound().isValid(this.m_query)) {
            this.m_nodeModel.setNodeData(this.getWrappedExpression());
            this.dispose();
        } else {
            this.m_bReturnActionIsOK = false;
            this.m_query.getMessageHandler().addError(bundle, "FilterEditDialog.invalidExpr.txt");
            this.checkForErrors();
        }
    }

    void bcancel_Action(ActionEvent event) {
        this.dispose();
    }

    void bedit_Action(ActionEvent event) {
        if (!this.m_editMode) {
            Dimension d = this.getSize();
            this.setSize(d.width + editGrowthAmountX, d.height + editGrowthAmountY);
            this.displayEditedExpression();
            this.invalidate();
            this.doLayout();
        } else {
            Dimension d = this.getSize();
            this.setSize(d.width - editGrowthAmountX, d.height - editGrowthAmountY);
            this.displayCompoundExpression();
            this.invalidate();
            this.doLayout();
        }
        this.fixPositionOnScreen();
    }

    protected void fixPositionOnScreen() {
        Point myLoc = this.getLocationOnScreen();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Point myNewLoc = new Point(myLoc);
        Dimension mySize = this.getSize();
        int myXextent = myLoc.x + mySize.width;
        int myYextent = myLoc.y + mySize.height;
        if (myXextent > screenSize.width) {
            myNewLoc.x -= myXextent - screenSize.width;
        }
        if (myYextent > screenSize.height) {
            myNewLoc.y -= myYextent - screenSize.height;
        }
        if (!myLoc.equals(myNewLoc)) {
            this.setLocation(myNewLoc);
        }
    }

    public boolean checkForErrors() {
        return MessageUtil.displayMessagesAndCheckForErrors(this.m_query.getMessageHandler());
    }

    void mapListSelectionChangesToModel(int action, Expression newExp) {
        if (action == 1) {
            this.evalue.deleteExpression(newExp);
        } else if (!this.evalue.isCommaList()) {
            if (this.m_thirdParmVisible) {
                this.manageBetweenFieldValues(newExp);
            } else {
                this.evalue.setExpression(newExp);
            }
        } else {
            this.evalue.addExpressionToCurrentText(newExp);
        }
    }

    boolean shouldEnableDistinctVals() {
        boolean enableIt = this.m_editMode ? false : (!(this.ecolumnname.getExpression() instanceof ColumnExpression) ? false : ((ColumnExpression)this.ecolumnname.getExpression()).supportsDistinctValues());
        return enableIt;
    }

    class MyComboRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyComboRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(((Function)value).getNiceFunctionName());
            this.setBackground(isSelected ? SystemColor.textHighlight : SystemColor.window);
            this.setForeground(isSelected ? SystemColor.textHighlightText : SystemColor.textText);
            return this;
        }
    }

    public class HelperListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("HelperExpressionChanged")) {
                FilterEditDialog.this.updateListSelections();
                FilterEditDialog.this.bdistinct.setEnabled(FilterEditDialog.this.shouldEnableDistinctVals());
            }
        }
    }

    class ListSelListener
    implements ListSelectionListener {
        ListSelListener() {
        }

        private boolean valIn(int val, int[] arr) {
            if (arr == null) {
                return false;
            }
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] != val) continue;
                return true;
            }
            return false;
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            int i;
            boolean deletedValue = false;
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (FilterEditDialog.this.processingValueChanges) {
                return;
            }
            FilterEditDialog.this.processingValueChanges = true;
            int[] currentSels = FilterEditDialog.this.ldata.getSelectedIndices();
            ExpressionList parms = ((CompoundExpression)FilterEditDialog.this.m_expression).getParameters();
            Vector<Integer> realPrevSels = new Vector<Integer>();
            DefaultListModel mod = (DefaultListModel)FilterEditDialog.this.ldata.getModel();
            for (i = 1; i < parms.size(); ++i) {
                for (int j = 0; j < mod.getSize(); ++j) {
                    if (parms.elementAt(i) == null || !parms.elementAt(i).toString().equals(mod.elementAt(j).toString())) continue;
                    realPrevSels.addElement(new Integer(j));
                }
            }
            int[] previousSels = new int[realPrevSels.size()];
            for (int k = 0; k < realPrevSels.size(); ++k) {
                previousSels[k] = (Integer)realPrevSels.elementAt(k);
            }
            for (i = 0; i < previousSels.length; ++i) {
                if (!this.valIn(previousSels[i], currentSels)) continue;
                FilterEditDialog.this.mapListSelectionChangesToModel(1, new ConstantExpression(FilterEditDialog.this.ldata.getModel().getElementAt(previousSels[i]).toString(), FilterEditDialog.this.m_nodeModel.getColumn().getDataType()));
                deletedValue = true;
            }
            for (i = 0; i < currentSels.length; ++i) {
                if (this.valIn(currentSels[i], previousSels)) continue;
                FilterEditDialog.this.mapListSelectionChangesToModel(2, new ConstantExpression(FilterEditDialog.this.ldata.getModel().getElementAt(currentSels[i]).toString(), FilterEditDialog.this.ecolumnname.getHelper().getExpectedType()));
            }
            if (deletedValue) {
                FilterEditDialog.this.evalue.recomputeDisplay();
            }
            FilterEditDialog.this.updateGUI();
            FilterEditDialog.this.processingValueChanges = false;
        }
    }

    class EscapeKeyListener
    extends KeyAdapter {
        EscapeKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (event.getKeyChar() == '\u001b') {
                FilterEditDialog.this.bcancel_Action(null);
                return;
            }
            if (event.getKeyChar() == '\n' && event.getSource() != FilterEditDialog.this.coperator) {
                FilterEditDialog.this.bOK_Action(null);
                return;
            }
        }
    }

    protected class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            FilterEditDialog.this.bcancel_Action(null);
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == FilterEditDialog.this.coperator) {
                FilterEditDialog.this.coperator_ItemStateChanged(event);
            } else if (object == FilterEditDialog.this.cnot) {
                FilterEditDialog.this.getCompound().setLogicalNegation(FilterEditDialog.this.cnot.isSelected());
            } else if (object == FilterEditDialog.this.cincludenulls) {
                FilterEditDialog.this.setWrapgui(FilterEditDialog.this.cincludenulls.isSelected());
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == FilterEditDialog.this.bdistinct) {
                FilterEditDialog.this.bdistinct_Action(event);
            } else if (object == FilterEditDialog.this.evalue) {
                FilterEditDialog.this.bOK_Action(event);
            } else if (object == FilterEditDialog.this.ecolumnname) {
                FilterEditDialog.this.bOK_Action(event);
            } else if (object == FilterEditDialog.this.bOK) {
                FilterEditDialog.this.bOK_Action(event);
            } else if (object == FilterEditDialog.this.bcancel) {
                FilterEditDialog.this.bcancel_Action(event);
            } else if (object == FilterEditDialog.this.bedit) {
                FilterEditDialog.this.bedit_Action(event);
            }
        }
    }
}

