/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.models.ConstantExpression;
import com.sas.query.visuals.ButtonBar;
import com.sas.query.visuals.ExpressionEditDistinctValsPanel;
import com.sas.query.visuals.ExpressionEditFunctionsPanel;
import com.sas.query.visuals.ExpressionEditReferencesPanel;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

class ExpressionEditTabPanel
extends JPanel
implements PropertyChangeListener {
    protected JTabbedPane tabber;
    protected JPanel functionTab;
    protected JPanel referenceTab;
    protected JPanel distinctTab;
    protected JButton addFunction;
    protected JButton wrapWithFunction;
    protected JButton addReference;
    protected JButton addValue;
    protected SqlTextHelper m_helper;
    protected ExpressionEditDistinctValsPanel m_distinctValuesPanel;
    protected ExpressionEditReferencesPanel m_referencesPanel;
    protected ExpressionEditFunctionsPanel m_functionPanelSimple;
    protected ButtonBar functionButtonPanel;
    protected ButtonBar buttonPanel2;
    protected ButtonBar buttonPanel3;
    protected SymAction aList;
    protected static QueryResource bundle = new QueryResource(ExpressionEditTabPanel.class);

    ExpressionEditTabPanel(SqlTextHelper helper) {
        this.m_helper = helper;
        this.tabber = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add("Center", this.tabber);
        Insets in = new Insets(5, 2, 0, 15);
        Vector<Serializable> buttons = new Vector<Serializable>();
        this.addFunction = new JButton(bundle.getString("Common.Insert.txt"));
        this.addFunction.setEnabled(false);
        this.wrapWithFunction = new JButton(bundle.getString("Common.Wrap.txt"));
        this.wrapWithFunction.setEnabled(false);
        buttons.addElement(new Integer(18));
        buttons.addElement(this.addFunction);
        buttons.addElement(this.wrapWithFunction);
        this.functionButtonPanel = new ButtonBar(3, buttons, in, false);
        buttons.removeAllElements();
        this.addReference = new JButton(bundle.getString("Common.Insert.txt"));
        this.addReference.setEnabled(false);
        buttons.addElement(new Integer(18));
        buttons.addElement(this.addReference);
        this.buttonPanel2 = new ButtonBar(3, buttons, in, false);
        buttons.removeAllElements();
        this.addValue = new JButton(bundle.getString("Common.Insert.txt"));
        this.addValue.setEnabled(false);
        buttons.addElement(new Integer(18));
        buttons.addElement(this.addValue);
        this.buttonPanel3 = new ButtonBar(3, buttons, in, false);
        this.functionTab = new JPanel();
        this.functionTab.setLayout(new BorderLayout());
        Vector<JButton> activateComponents = new Vector<JButton>();
        activateComponents.addElement(this.addFunction);
        this.m_functionPanelSimple = new ExpressionEditFunctionsPanel(helper, activateComponents);
        this.functionTab.add("Center", this.m_functionPanelSimple);
        this.functionTab.add("East", this.functionButtonPanel);
        this.functionTab.validate();
        this.tabber.addTab(bundle.getString("ExpressionEditTabPanel.functionsLabel.txt"), this.functionTab);
        this.referenceTab = new JPanel();
        this.referenceTab.setLayout(new BorderLayout());
        this.m_referencesPanel = new ExpressionEditReferencesPanel(helper, this.addReference);
        this.referenceTab.add(this.m_referencesPanel);
        this.referenceTab.add("East", this.buttonPanel2);
        this.referenceTab.validate();
        this.tabber.addTab(bundle.getString("ExpressionEditTabPanel.columnsLabel.txt"), this.referenceTab);
        this.distinctTab = new JPanel();
        this.distinctTab.setLayout(new BorderLayout());
        this.m_distinctValuesPanel = new ExpressionEditDistinctValsPanel(helper, this.addValue);
        this.distinctTab.add(this.m_distinctValuesPanel);
        this.distinctTab.add("East", this.buttonPanel3);
        this.distinctTab.validate();
        this.tabber.addTab(bundle.getString("ExpressionEditTabPanel.distinctValuesLabel.txt"), this.distinctTab);
        this.tabber.validate();
        this.addAllListeners();
        this.tabSelected(this.tabber.getSelectedComponent());
    }

    public void addAllListeners() {
        this.tabber.addPropertyChangeListener(this);
        this.m_helper.addPropertyChangeListener(this);
        this.m_distinctValuesPanel.addPropertyChangeListener(this);
        this.m_referencesPanel.addPropertyChangeListener(this);
        this.m_functionPanelSimple.addPropertyChangeListener(this);
        this.aList = new SymAction();
        this.addFunction.addActionListener(this.aList);
        this.wrapWithFunction.addActionListener(this.aList);
        this.addReference.addActionListener(this.aList);
        this.addValue.addActionListener(this.aList);
    }

    public void removeAllListeners() {
        this.tabber.removePropertyChangeListener(this);
        this.m_helper.removePropertyChangeListener(this);
        this.m_distinctValuesPanel.removePropertyChangeListener(this);
        this.m_referencesPanel.removePropertyChangeListener(this);
        this.m_functionPanelSimple.removePropertyChangeListener(this);
        this.m_distinctValuesPanel.removeAllListeners();
        this.m_referencesPanel.removeAllListeners();
        this.m_functionPanelSimple.removeAllListeners();
        if (this.aList != null) {
            this.addFunction.removeActionListener(this.aList);
            this.wrapWithFunction.removeActionListener(this.aList);
            this.addReference.removeActionListener(this.aList);
            this.addValue.removeActionListener(this.aList);
            this.aList = null;
        }
        this.removeAll();
        this.functionTab.removeAll();
        this.referenceTab.removeAll();
        this.distinctTab.removeAll();
        this.functionTab = null;
        this.referenceTab = null;
        this.distinctTab = null;
        this.functionButtonPanel.removeAllListeners();
        this.buttonPanel2.removeAllListeners();
        this.buttonPanel3.removeAllListeners();
        this.m_distinctValuesPanel = null;
        this.m_referencesPanel = null;
        this.m_functionPanelSimple = null;
        this.tabber = null;
        this.addFunction = null;
        this.wrapWithFunction = null;
        this.addReference = null;
        this.addValue = null;
        this.m_helper = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent p) {
        if (!p.getPropertyName().equals("NewCurrentToken")) {
            if (p.getPropertyName().equals("newItem")) {
                this.addValue();
            } else if (p.getPropertyName().equals("newFunction")) {
                this.addFunction();
            } else if (p.getPropertyName().equals("newColumn")) {
                this.addReference();
            } else if (p.getPropertyName().equals("functionSelectionChanged")) {
                if (this.m_functionPanelSimple.getSelectedFunction() != null && this.m_helper.getSelectedText().length() > 0) {
                    if (this.m_functionPanelSimple.getSelectedFunction().getMaxParms() > 0) {
                        this.wrapWithFunction.setEnabled(true);
                    } else {
                        this.wrapWithFunction.setEnabled(false);
                    }
                } else {
                    this.wrapWithFunction.setEnabled(false);
                }
            } else if (p.getPropertyName().equals("selectionChanged")) {
                String cursel = (String)p.getNewValue();
                if (cursel == null) {
                    cursel = this.m_helper.getSelectedText();
                }
                if (cursel != null && cursel.length() > 0) {
                    if (this.m_functionPanelSimple.getSelectedFunction() != null) {
                        this.wrapWithFunction.setEnabled(true);
                    } else {
                        this.wrapWithFunction.setEnabled(false);
                    }
                } else {
                    this.wrapWithFunction.setEnabled(false);
                }
            }
        }
    }

    public void tabSelected(Component newTab) {
    }

    public void addFunction() {
        if (this.m_functionPanelSimple.getSelectedFunction() != null) {
            this.m_helper.popMenuCallbackFunction(this.m_functionPanelSimple.getSelectedFunction());
            this.m_helper.getWidget().requestFocus();
        }
    }

    public void wrapWithFunction() {
        if (this.m_functionPanelSimple.getSelectedFunction() != null) {
            this.m_helper.popMenuCallbackWrapWithFunction(this.m_functionPanelSimple.getSelectedFunction());
            this.m_helper.getWidget().requestFocus();
        }
    }

    public void addReference() {
        if (this.m_referencesPanel.getSelectedColumn() != null) {
            this.m_helper.popMenuCallbackOtherColumn("", this.m_referencesPanel.getSelectedColumn());
            this.m_helper.getWidget().requestFocus();
        }
    }

    public void addValue() {
        ConstantExpression constExp = new ConstantExpression(this.m_distinctValuesPanel.getCurrentValue(), this.m_distinctValuesPanel.getCurrentColumn().getDataType(), false);
        this.m_helper.popMenuCallbackAddValue(constExp);
        this.m_helper.getWidget().requestFocus();
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ExpressionEditTabPanel.this.tabber) {
                ExpressionEditTabPanel.this.tabSelected(ExpressionEditTabPanel.this.tabber.getSelectedComponent());
            } else if (object == ExpressionEditTabPanel.this.addFunction) {
                ExpressionEditTabPanel.this.addFunction();
            } else if (object == ExpressionEditTabPanel.this.addReference) {
                ExpressionEditTabPanel.this.addReference();
            } else if (object == ExpressionEditTabPanel.this.addValue) {
                ExpressionEditTabPanel.this.addValue();
            } else if (object == ExpressionEditTabPanel.this.wrapWithFunction) {
                ExpressionEditTabPanel.this.wrapWithFunction();
            }
        }
    }
}

