/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.models.Column;
import com.sas.query.models.ColumnList;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.visuals.FlatSplitPane;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelper;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExpressionEditReferencesPanel
extends JPanel
implements ExpressionConstants {
    protected JList tablesList;
    protected Vector tablesListList = new Vector();
    protected JList columnsList;
    protected Vector columnsListList = new Vector();
    protected JLabel tablesLabel;
    protected JLabel columnsLabel;
    protected JTextField columnDescription;
    protected Component m_actionTrigger;
    protected SqlTextHelper m_drivenSqlHelper;
    protected TableList m_ReferableTables;
    protected ColumnList m_ReferableColumns;
    protected ListSelListener m_selListener;
    protected MouseListener m_mouseListener;
    protected SymFocus m_aSymFocus;
    protected FlatSplitPane splitter;
    protected JPanel left;
    protected JPanel right;
    protected JScrollPane scrollPane;
    static QueryResource bundle = new QueryResource(ExpressionEditReferencesPanel.class);

    public ExpressionEditReferencesPanel() {
        this(null, null);
    }

    public ExpressionEditReferencesPanel(SqlTextHelper drivenSqlHelper, Component actionTrigger) {
        this.m_drivenSqlHelper = drivenSqlHelper;
        this.m_actionTrigger = actionTrigger;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.splitter = new FlatSplitPane(1);
        this.left = new JPanel(new BorderLayout(0, 0));
        this.tablesLabel = new JLabel(bundle.getString("ExpressionEditReferencesPanel.tablesLabel.txt"));
        this.tablesLabel.setFont(new Font("Dialog", 0, 12));
        this.left.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.left.add("North", this.tablesLabel);
        this.tablesList = new JList();
        this.scrollPane = new JScrollPane(this.tablesList);
        this.tablesList.setSelectionMode(0);
        WindowUtil.fixupJScrollPane(this.scrollPane);
        this.left.add("Center", this.scrollPane);
        this.splitter.getSplitter().setLeftComponent(this.left);
        this.right = new JPanel(new BorderLayout(0, 0));
        this.columnsLabel = new JLabel(bundle.getString("ExpressionEditReferencesPanel.columnsLabel.txt"));
        this.columnsLabel.setFont(new Font("Dialog", 0, 12));
        this.right.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 4));
        this.right.add("North", this.columnsLabel);
        this.columnsList = new JList(){

            @Override
            public String getToolTipText(MouseEvent e) {
                JList colList = (JList)e.getSource();
                int index = colList.locationToIndex(e.getPoint());
                if (index < 0 || index >= ExpressionEditReferencesPanel.this.m_ReferableColumns.size()) {
                    return null;
                }
                Column c = ExpressionEditReferencesPanel.this.m_ReferableColumns.elementAt(index);
                if (c.getLabel() != c.getName()) {
                    return c.getLabel();
                }
                return null;
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.columnsList);
        this.columnsList.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.columnsList);
        WindowUtil.fixupJScrollPane(this.scrollPane);
        this.right.add("Center", this.scrollPane);
        this.splitter.getSplitter().setRightComponent(this.right);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 5, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.splitter, gbc);
        this.add(this.splitter);
        this.splitter.getSplitter().setDividerLocation(160);
        this.columnDescription = new JTextField();
        this.columnDescription.setText("");
        this.columnDescription.setBorder(BorderFactory.createEmptyBorder());
        this.columnDescription.setEditable(false);
        this.columnDescription.setEnabled(true);
        this.columnDescription.setBackground(SystemColor.control);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 5, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.columnDescription, gbc);
        this.add(this.columnDescription);
        this.noTableSelected();
        this.m_ReferableTables = this.m_drivenSqlHelper.getQuery().getReferableTables();
        this.tablesListList.removeAllElements();
        for (int i = 0; i < this.m_ReferableTables.size(); ++i) {
            this.tablesListList.addElement(this.m_ReferableTables.elementAt(i).getDisplayName());
        }
        this.tablesList.setModel(new SimpleListModel(this.tablesListList));
        this.columnsList.setModel(new SimpleListModel(this.columnsListList));
        if (this.m_ReferableTables.size() > 0) {
            this.tablesList.setSelectedIndex(0);
            this.tableSelected();
        }
        this.addAllListeners();
    }

    public void addAllListeners() {
        this.m_aSymFocus = new SymFocus();
        this.addFocusListener(this.m_aSymFocus);
        this.m_selListener = new ListSelListener();
        this.tablesList.addListSelectionListener(this.m_selListener);
        this.columnsList.addListSelectionListener(this.m_selListener);
        this.m_mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && (index = ExpressionEditReferencesPanel.this.columnsList.locationToIndex(e.getPoint())) > -1) {
                    ExpressionEditReferencesPanel.this.firePropertyChange("newColumn", null, null);
                }
            }
        };
        this.columnsList.addMouseListener(this.m_mouseListener);
    }

    public void removeAllListeners() {
        if (this.m_selListener != null) {
            this.tablesList.removeListSelectionListener(this.m_selListener);
            this.columnsList.removeListSelectionListener(this.m_selListener);
            this.m_selListener = null;
        }
        if (this.m_mouseListener != null) {
            this.columnsList.removeMouseListener(this.m_mouseListener);
            this.m_mouseListener = null;
        }
        if (this.m_aSymFocus != null) {
            this.removeFocusListener(this.m_aSymFocus);
            this.m_aSymFocus = null;
        }
        this.tablesList = null;
        this.tablesListList = null;
        this.columnsList = null;
        this.columnsListList = null;
        this.tablesLabel = null;
        this.columnDescription = null;
        this.m_actionTrigger = null;
        this.m_drivenSqlHelper = null;
        this.m_ReferableTables = null;
        this.m_ReferableColumns = null;
        this.removeAll();
        this.splitter.removeAllListeners();
        this.splitter = null;
        this.left.removeAll();
        this.left = null;
        this.right.removeAll();
        this.right = null;
        this.scrollPane.removeAll();
        this.scrollPane = null;
    }

    private void tableSelected() {
        this.noTableSelected();
        this.m_ReferableColumns = this.m_drivenSqlHelper.getQuery().getReferableColumns(this.m_ReferableTables.elementAt(this.tablesList.getSelectedIndex()));
        this.columnsListList.removeAllElements();
        for (int i = 0; i < this.m_ReferableColumns.size(); ++i) {
            this.columnsListList.addElement(this.m_ReferableColumns.elementAt(i).getName());
        }
        this.columnsList.setSelectedIndex(-1);
        ((SimpleListModel)this.columnsList.getModel()).fireChange(this.columnsList);
        this.conditionColumnListTrigger();
    }

    private void conditionColumnListTrigger() {
        int currentSel = this.columnsList.getSelectedIndex();
        if (currentSel < 0 || currentSel > this.columnsListList.size() - 1) {
            this.disableActionTrigger();
        } else {
            this.enableActionTrigger();
        }
    }

    private void noTableSelected() {
        this.disableActionTrigger();
        this.columnsList.removeAll();
        this.m_ReferableColumns = null;
    }

    public Column getSelectedColumn() {
        if (this.columnsList.getSelectedIndex() == -1) {
            return null;
        }
        return this.m_ReferableColumns.elementAt(this.columnsList.getSelectedIndex());
    }

    public Table getSelectedTable() {
        if (this.tablesList.getSelectedIndex() == -1) {
            return null;
        }
        return this.m_ReferableTables.elementAt(this.tablesList.getSelectedIndex());
    }

    public void enableActionTrigger() {
        this.m_actionTrigger.setEnabled(true);
        String tmp = ExpressionEditReferencesPanel.describeColumn(this.getSelectedColumn());
        tmp = tmp.trim();
        this.columnDescription.setEditable(true);
        this.columnDescription.setText(tmp);
        this.columnDescription.setEditable(false);
        this.columnDescription.setToolTipText(tmp);
        this.columnDescription.setCaretPosition(0);
    }

    public static String describeColumn(Column col) {
        String label = "'" + col.getLabel() + "'";
        int indexofnull = label.indexOf(0);
        if (indexofnull > -1) {
            label = label.substring(0, indexofnull);
        }
        String type = Expression.getExpectedTypeStringHuman(col.getDataType());
        String lengthString = "";
        if (col.getLength() > 1 && col.getDataType() != 16 && col.getDataType() != 16 && col.getDataType() != 32 && col.getDataType() != 64 && col.getDataType() != 256 && col.getDataType() != 128) {
            int len = col.getLength();
            lengthString = new Integer(len).toString();
        }
        boolean isNullable = col.isNullable();
        String message = null;
        message = isNullable ? (lengthString.length() > 0 ? bundle.messageString("ExpressionEditReferencesPanel.colDescLenNullable.fmt.txt", label, type, lengthString) : bundle.messageString("ExpressionEditReferencesPanel.colDescNoLenNullable.fmt.txt", label, type)) : (lengthString.length() > 0 ? bundle.messageString("ExpressionEditReferencesPanel.colDescLenNoNull.fmt.txt", label, type, lengthString) : bundle.messageString("ExpressionEditReferencesPanel.colDescNoLenNoNull.fmt.txt", label, type));
        return message;
    }

    public void disableActionTrigger() {
        this.m_actionTrigger.setEnabled(false);
        this.columnDescription.setText("");
        this.columnDescription.setToolTipText("");
    }

    void ExpressionEditReferencesPanel_FocusLost(FocusEvent event) {
    }

    protected class SimpleListModel
    extends AbstractListModel {
        protected Vector m_vector;

        SimpleListModel(Vector vect) {
            this.m_vector = vect;
        }

        public void fireChange(JList me) {
            this.fireContentsChanged(me, 0, this.getSize() - 1);
        }

        @Override
        public int getSize() {
            return this.m_vector.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.m_vector.elementAt(index);
        }
    }

    class ListSelListener
    implements ListSelectionListener {
        ListSelListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            JList source = (JList)event.getSource();
            int currentSel = source.getSelectedIndex();
            if (source == ExpressionEditReferencesPanel.this.columnsList) {
                ExpressionEditReferencesPanel.this.conditionColumnListTrigger();
            } else if (source == ExpressionEditReferencesPanel.this.tablesList) {
                if (currentSel < 0) {
                    ExpressionEditReferencesPanel.this.noTableSelected();
                } else {
                    ExpressionEditReferencesPanel.this.tableSelected();
                }
            }
        }
    }

    class SymFocus
    extends FocusAdapter {
        SymFocus() {
        }

        @Override
        public void focusLost(FocusEvent event) {
            Object object = event.getSource();
            if (object == ExpressionEditReferencesPanel.this) {
                ExpressionEditReferencesPanel.this.ExpressionEditReferencesPanel_FocusLost(event);
            }
        }
    }
}

